/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.meta;

import com.oracle.graal.pointsto.AnalysisPolicy;
import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.ObjectScanner;
import com.oracle.graal.pointsto.api.HostVM;
import com.oracle.graal.pointsto.constraints.UnsupportedFeatureException;
import com.oracle.graal.pointsto.heap.HeapSnapshotVerifier;
import com.oracle.graal.pointsto.heap.HostedValuesProvider;
import com.oracle.graal.pointsto.heap.ImageHeapConstant;
import com.oracle.graal.pointsto.heap.ImageHeapScanner;
import com.oracle.graal.pointsto.heap.ImageLayerLoader;
import com.oracle.graal.pointsto.heap.ImageLayerWriter;
import com.oracle.graal.pointsto.infrastructure.OriginalClassProvider;
import com.oracle.graal.pointsto.infrastructure.ResolvedSignature;
import com.oracle.graal.pointsto.infrastructure.SubstitutionProcessor;
import com.oracle.graal.pointsto.infrastructure.Universe;
import com.oracle.graal.pointsto.infrastructure.WrappedConstantPool;
import com.oracle.graal.pointsto.infrastructure.WrappedJavaType;
import com.oracle.graal.pointsto.meta.AnalysisElement;
import com.oracle.graal.pointsto.meta.AnalysisFactory;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.util.AnalysisError;
import com.oracle.graal.pointsto.util.ConcurrentLightHashSet;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import jdk.graal.compiler.api.replacements.SnippetReflectionProvider;
import jdk.graal.compiler.core.common.SuppressFBWarnings;
import jdk.vm.ci.code.BytecodePosition;
import jdk.vm.ci.common.JVMCIError;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.ConstantPool;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaField;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Signature;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.impl.AnnotationExtractor;
import org.graalvm.word.WordBase;

public class AnalysisUniverse
implements Universe {
    protected final HostVM hostVM;
    private static final int ESTIMATED_FIELDS_PER_TYPE = 3;
    public static final int ESTIMATED_NUMBER_OF_TYPES = 2000;
    static final int ESTIMATED_METHODS_PER_TYPE = 15;
    static final int ESTIMATED_EMBEDDED_ROOTS = 500;
    private final ConcurrentMap<ResolvedJavaType, Object> types = new ConcurrentHashMap<ResolvedJavaType, Object>(2000);
    private final ConcurrentMap<ResolvedJavaField, AnalysisField> fields = new ConcurrentHashMap<ResolvedJavaField, AnalysisField>(6000);
    private final ConcurrentMap<ResolvedJavaMethod, AnalysisMethod> methods = new ConcurrentHashMap<ResolvedJavaMethod, AnalysisMethod>(30000);
    private final ConcurrentMap<ResolvedSignature<AnalysisType>, ResolvedSignature<AnalysisType>> uniqueSignatures = new ConcurrentHashMap<ResolvedSignature<AnalysisType>, ResolvedSignature<AnalysisType>>();
    private final ConcurrentMap<ConstantPool, WrappedConstantPool> constantPools = new ConcurrentHashMap<ConstantPool, WrappedConstantPool>(2000);
    private final ConcurrentHashMap<Constant, Object> embeddedRoots = new ConcurrentHashMap(500);
    private final ConcurrentMap<AnalysisField, Boolean> unsafeAccessedStaticFields = new ConcurrentHashMap<AnalysisField, Boolean>();
    private boolean sealed;
    private volatile AnalysisType[] typesById = new AnalysisType[2000];
    final AtomicInteger nextTypeId = new AtomicInteger(1);
    final AtomicInteger nextMethodId = new AtomicInteger(1);
    final AtomicInteger nextFieldId = new AtomicInteger(1);
    protected final SubstitutionProcessor substitutions;
    private Function<Object, Object>[] objectReplacers;
    private Function<Object, ImageHeapConstant>[] objectToConstantReplacers;
    private SubstitutionProcessor[] featureSubstitutions;
    private SubstitutionProcessor[] featureNativeSubstitutions;
    private final MetaAccessProvider originalMetaAccess;
    private final AnalysisFactory analysisFactory;
    private final AnnotationExtractor annotationExtractor;
    private final AtomicInteger numReachableTypes = new AtomicInteger();
    private AnalysisType objectClass;
    private AnalysisType cloneableClass;
    private final JavaKind wordKind;
    private AnalysisPolicy analysisPolicy;
    private ImageHeapScanner heapScanner;
    private ImageLayerWriter imageLayerWriter;
    private ImageLayerLoader imageLayerLoader;
    private HeapSnapshotVerifier heapVerifier;
    private BigBang bb;
    private Feature.DuringAnalysisAccess concurrentAnalysisAccess;
    private final Map<AnalysisMethod, Set<AnalysisElement.MethodOverrideReachableNotification>> methodOverrideReachableNotifications = new ConcurrentHashMap<AnalysisMethod, Set<AnalysisElement.MethodOverrideReachableNotification>>();

    public JavaKind getWordKind() {
        return this.wordKind;
    }

    public AnalysisUniverse(HostVM hostVM, JavaKind wordKind, AnalysisPolicy analysisPolicy, SubstitutionProcessor substitutions, MetaAccessProvider originalMetaAccess, AnalysisFactory analysisFactory, AnnotationExtractor annotationExtractor) {
        this.hostVM = hostVM;
        this.wordKind = wordKind;
        this.analysisPolicy = analysisPolicy;
        this.substitutions = substitutions;
        this.originalMetaAccess = originalMetaAccess;
        this.analysisFactory = analysisFactory;
        this.annotationExtractor = annotationExtractor;
        this.sealed = false;
        this.objectReplacers = new Function[0];
        this.objectToConstantReplacers = new Function[0];
        this.featureSubstitutions = new SubstitutionProcessor[0];
        this.featureNativeSubstitutions = new SubstitutionProcessor[0];
    }

    @Override
    public HostVM hostVM() {
        return this.hostVM;
    }

    protected AnnotationExtractor getAnnotationExtractor() {
        return this.annotationExtractor;
    }

    public int getNextTypeId() {
        return this.nextTypeId.get();
    }

    public int getNextMethodId() {
        return this.nextMethodId.get();
    }

    public int getNextFieldId() {
        return this.nextFieldId.get();
    }

    public void seal() {
        this.sealed = true;
    }

    public boolean sealed() {
        return this.sealed;
    }

    public AnalysisType optionalLookup(ResolvedJavaType type) {
        ResolvedJavaType actualType = this.substitutions.lookup(type);
        Object claim = this.types.get(actualType);
        if (claim instanceof AnalysisType) {
            return (AnalysisType)claim;
        }
        return null;
    }

    @Override
    public AnalysisType lookup(JavaType type) {
        JavaType result = this.lookupAllowUnresolved(type);
        if (result == null) {
            return null;
        }
        if (result instanceof ResolvedJavaType) {
            return (AnalysisType)result;
        }
        throw new UnsupportedFeatureException("Unresolved type found. Probably there are some compilation or classpath problems. " + type.toJavaName(true));
    }

    @Override
    public JavaType lookupAllowUnresolved(JavaType rawType) {
        if (rawType == null) {
            return null;
        }
        if (!(rawType instanceof ResolvedJavaType)) {
            return rawType;
        }
        assert (!(rawType instanceof AnalysisType)) : "lookupAllowUnresolved does not support analysis types.";
        ResolvedJavaType hostType = (ResolvedJavaType)rawType;
        ResolvedJavaType type = this.substitutions.lookup(hostType);
        AnalysisType result = this.optionalLookup(type);
        if (result == null) {
            result = this.createType(type);
            if (this.hostVM.useBaseLayer()) {
                this.imageLayerLoader.initializeBaseLayerType(result);
            }
        }
        assert (this.typesById[result.getId()].equals(result)) : result;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"ES_COMPARING_STRINGS_WITH_EQ"}, justification="Bug in findbugs")
    private AnalysisType createType(ResolvedJavaType type) {
        String claim;
        block21: {
            Object result;
            if (!this.hostVM.platformSupported((AnnotatedElement)type)) {
                throw new UnsupportedFeatureException("Type is not available in this platform: " + type.toJavaName(true));
            }
            if (this.sealed && !type.isArray()) {
                throw AnalysisError.typeNotFound(type);
            }
            this.hostVM.checkType(type, this);
            claim = Thread.currentThread().getName();
            block6: while (true) {
                if ((result = this.types.putIfAbsent(type, claim)) instanceof AnalysisType) {
                    return (AnalysisType)result;
                }
                if (result == null) break block21;
                do {
                    if ((result = this.types.get(type)) == null) continue block6;
                    if (result != claim) continue;
                    throw JVMCIError.shouldNotReachHere((String)"Deadlock creating new types");
                } while (!(result instanceof AnalysisType));
                break;
            }
            return (AnalysisType)result;
        }
        try {
            JavaKind storageKind = this.originalMetaAccess.lookupJavaType(WordBase.class).isAssignableFrom(OriginalClassProvider.getOriginalType((JavaType)type)) ? this.wordKind : type.getJavaKind();
            AnalysisType newValue = this.analysisFactory.createType(this, type, storageKind, this.objectClass, this.cloneableClass);
            AnalysisUniverse analysisUniverse = this;
            synchronized (analysisUniverse) {
                if (newValue.getId() >= this.typesById.length) {
                    this.typesById = Arrays.copyOf(this.typesById, this.typesById.length * 2);
                }
                assert (this.typesById[newValue.getId()] == null);
                this.typesById[newValue.getId()] = newValue;
                if (this.objectClass == null && newValue.isJavaLangObject()) {
                    this.objectClass = newValue;
                } else if (this.cloneableClass == null && newValue.toJavaName(true).equals(Cloneable.class.getName())) {
                    this.cloneableClass = newValue;
                }
            }
            if (this.hostVM.useBaseLayer() && this.imageLayerLoader.hasDynamicHubIdentityHashCode(newValue.getId())) {
                this.hostVM.registerType(newValue, this.imageLayerLoader.getDynamicHubIdentityHashCode(newValue.getId()));
            } else {
                this.hostVM.registerType(newValue);
            }
            if (this.bb != null) {
                newValue.registerAsAssignable(this.bb);
            }
            Object oldValue = this.types.put(type, newValue);
            assert (oldValue == claim) : String.valueOf(oldValue) + " != " + String.valueOf(claim);
            claim = null;
            AnalysisType analysisType = newValue;
            return analysisType;
        }
        finally {
            if (claim != null) {
                this.types.remove(type, claim);
            }
        }
    }

    @Override
    public AnalysisField lookup(JavaField field) {
        JavaField result = this.lookupAllowUnresolved(field);
        if (result == null) {
            return null;
        }
        if (result instanceof ResolvedJavaField) {
            return (AnalysisField)result;
        }
        throw new UnsupportedFeatureException("Unresolved field found. Probably there are some compilation or classpath problems. " + field.format("%H.%n"));
    }

    @Override
    public JavaField lookupAllowUnresolved(JavaField rawField) {
        if (rawField == null) {
            return null;
        }
        if (!(rawField instanceof ResolvedJavaField)) {
            return rawField;
        }
        assert (!(rawField instanceof AnalysisField)) : rawField;
        ResolvedJavaField field = (ResolvedJavaField)rawField;
        AnalysisField result = (AnalysisField)this.fields.get(field = this.substitutions.lookup(field));
        if (result == null) {
            result = this.createField(field);
        }
        return result;
    }

    private AnalysisField createField(ResolvedJavaField field) {
        if (!this.hostVM.platformSupported((AnnotatedElement)field)) {
            throw new UnsupportedFeatureException("Field is not available in this platform: " + field.format("%H.%n"));
        }
        if (this.sealed) {
            return null;
        }
        AnalysisField newValue = this.analysisFactory.createField(this, field);
        AnalysisField result = this.fields.computeIfAbsent(field, f -> {
            if (newValue.isInBaseLayer()) {
                this.getImageLayerLoader().addBaseLayerField(newValue);
            }
            return newValue;
        });
        if (result.equals(newValue) && newValue.isInBaseLayer()) {
            this.getImageLayerLoader().initializeBaseLayerField(newValue);
        }
        return result;
    }

    @Override
    public AnalysisMethod lookup(JavaMethod method) {
        JavaMethod result = this.lookupAllowUnresolved(method);
        if (result == null) {
            return null;
        }
        if (result instanceof ResolvedJavaMethod) {
            return (AnalysisMethod)result;
        }
        throw new UnsupportedFeatureException("Unresolved method found: " + (method != null ? method.format("%H.%n(%p)") : "null") + ". Probably there are some compilation or classpath problems. ");
    }

    @Override
    public JavaMethod lookupAllowUnresolved(JavaMethod rawMethod) {
        if (rawMethod == null) {
            return null;
        }
        if (!(rawMethod instanceof ResolvedJavaMethod)) {
            return rawMethod;
        }
        assert (!(rawMethod instanceof AnalysisMethod)) : rawMethod;
        ResolvedJavaMethod method = (ResolvedJavaMethod)rawMethod;
        AnalysisMethod result = (AnalysisMethod)this.methods.get(method = this.substitutions.lookup(method));
        if (result == null) {
            result = this.createMethod(method);
        }
        return result;
    }

    private AnalysisMethod createMethod(ResolvedJavaMethod method) {
        if (!this.hostVM.platformSupported((AnnotatedElement)method)) {
            throw new UnsupportedFeatureException("Method " + method.format("%H.%n(%p) is not available in this platform."));
        }
        if (this.sealed) {
            return null;
        }
        AnalysisMethod newValue = this.analysisFactory.createMethod(this, method);
        AnalysisMethod result = this.methods.computeIfAbsent(method, m -> {
            if (newValue.isInBaseLayer()) {
                this.getImageLayerLoader().addBaseLayerMethod(newValue);
            }
            return newValue;
        });
        if (result.equals(newValue)) {
            if (newValue.isInBaseLayer()) {
                this.getImageLayerLoader().initializeBaseLayerMethod(newValue);
            }
            AnalysisUniverse.prepareMethodImplementations(newValue);
        }
        return result;
    }

    private static void prepareMethodImplementations(AnalysisMethod method) {
        if (!method.canBeStaticallyBound() && !method.isConstructor()) {
            ConcurrentLightHashSet.addElement(method.declaringClass, AnalysisType.overrideableMethodsUpdater, method);
            for (AnalysisType subtype : method.declaringClass.getAllSubtypes()) {
                AnalysisMethod override = subtype.resolveConcreteMethod(method, null);
                if (override == null || override.equals(method)) continue;
                ConcurrentLightHashSet.addElement(method, AnalysisMethod.allImplementationsUpdater, override);
            }
        }
    }

    public AnalysisMethod[] lookup(JavaMethod[] inputs) {
        ArrayList<AnalysisMethod> result = new ArrayList<AnalysisMethod>(inputs.length);
        for (JavaMethod method : inputs) {
            AnalysisMethod aMethod;
            if (!this.hostVM.platformSupported((AnnotatedElement)((ResolvedJavaMethod)method)) || (aMethod = this.lookup(method)) == null) continue;
            result.add(aMethod);
        }
        return result.toArray(new AnalysisMethod[result.size()]);
    }

    public ResolvedSignature<AnalysisType> lookup(Signature signature, ResolvedJavaType defaultAccessingClass) {
        assert (!(defaultAccessingClass instanceof WrappedJavaType)) : defaultAccessingClass;
        ResolvedJavaType[] paramTypes = new AnalysisType[signature.getParameterCount(false)];
        for (int i = 0; i < paramTypes.length; ++i) {
            paramTypes[i] = this.lookup((JavaType)this.resolveSignatureType(signature.getParameterType(i, defaultAccessingClass), defaultAccessingClass));
        }
        AnalysisType returnType = this.lookup((JavaType)this.resolveSignatureType(signature.getReturnType(defaultAccessingClass), defaultAccessingClass));
        ResolvedSignature key = ResolvedSignature.fromArray((ResolvedJavaType[])paramTypes, (ResolvedJavaType)returnType);
        return this.uniqueSignatures.computeIfAbsent(key, k -> k);
    }

    private ResolvedJavaType resolveSignatureType(JavaType type, ResolvedJavaType defaultAccessingClass) {
        if (type instanceof ResolvedJavaType) {
            ResolvedJavaType resolvedType = (ResolvedJavaType)type;
            return resolvedType;
        }
        try {
            return type.resolve(defaultAccessingClass);
        }
        catch (LinkageError e) {
            return this.objectType().getWrapped();
        }
    }

    @Override
    public WrappedConstantPool lookup(ConstantPool constantPool, ResolvedJavaType defaultAccessingClass) {
        assert (!(constantPool instanceof WrappedConstantPool)) : constantPool;
        assert (!(defaultAccessingClass instanceof WrappedJavaType)) : defaultAccessingClass;
        WrappedConstantPool result = (WrappedConstantPool)this.constantPools.get(constantPool);
        if (result == null) {
            WrappedConstantPool newValue = new WrappedConstantPool(this, constantPool, defaultAccessingClass);
            WrappedConstantPool oldValue = this.constantPools.putIfAbsent(constantPool, newValue);
            result = oldValue != null ? oldValue : newValue;
        }
        return result;
    }

    @Override
    public JavaConstant lookup(JavaConstant constant) {
        if (constant == null || constant.isNull() || constant.getJavaKind().isPrimitive()) {
            return constant;
        }
        return this.heapScanner.createImageHeapConstant(this.getHostedValuesProvider().interceptHosted(constant), ObjectScanner.OtherReason.UNKNOWN);
    }

    public boolean isTypeCreated(int typeId) {
        return this.typesById.length > typeId && this.typesById[typeId] != null;
    }

    public List<AnalysisType> getTypes() {
        return Arrays.asList(this.typesById).subList(0, this.getNextTypeId()).stream().filter(Objects::nonNull).toList();
    }

    public AnalysisType getType(int typeId) {
        AnalysisType result = this.typesById[typeId];
        assert (result.getId() == typeId) : result;
        return result;
    }

    public Collection<AnalysisField> getFields() {
        return this.fields.values();
    }

    public AnalysisField getField(ResolvedJavaField resolvedJavaField) {
        return (AnalysisField)this.fields.get(resolvedJavaField);
    }

    public Collection<AnalysisMethod> getMethods() {
        return this.methods.values();
    }

    public AnalysisMethod getMethod(ResolvedJavaMethod resolvedJavaMethod) {
        return (AnalysisMethod)this.methods.get(resolvedJavaMethod);
    }

    public static List<AnalysisMethod> getCallTreeRoots(AnalysisUniverse universe) {
        ArrayList<AnalysisMethod> roots = new ArrayList<AnalysisMethod>();
        for (AnalysisMethod m : universe.getMethods()) {
            if (m.isDirectRootMethod() && m.isSimplyImplementationInvoked()) {
                roots.add(m);
            }
            if (!m.isVirtualRootMethod()) continue;
            for (AnalysisMethod impl : m.collectMethodImplementations(false)) {
                AnalysisError.guarantee(impl.isImplementationInvoked());
                roots.add(impl);
            }
        }
        return roots;
    }

    public Map<Constant, Object> getEmbeddedRoots() {
        return this.embeddedRoots;
    }

    public void registerEmbeddedRoot(JavaConstant root, BytecodePosition position) {
        this.heapScanner.scanEmbeddedRoot(root, position);
        this.embeddedRoots.put((Constant)root, position);
    }

    public void registerUnsafeAccessedStaticField(AnalysisField field) {
        this.unsafeAccessedStaticFields.put(field, true);
    }

    public Set<AnalysisField> getUnsafeAccessedStaticFields() {
        return this.unsafeAccessedStaticFields.keySet();
    }

    public void registerObjectReplacer(Function<Object, Object> replacer) {
        assert (replacer != null);
        this.objectReplacers = Arrays.copyOf(this.objectReplacers, this.objectReplacers.length + 1);
        this.objectReplacers[this.objectReplacers.length - 1] = replacer;
    }

    public void registerObjectToConstantReplacer(Function<Object, ImageHeapConstant> replacer) {
        assert (replacer != null);
        this.objectToConstantReplacers = Arrays.copyOf(this.objectToConstantReplacers, this.objectToConstantReplacers.length + 1);
        this.objectToConstantReplacers[this.objectToConstantReplacers.length - 1] = replacer;
    }

    public void registerFeatureSubstitution(SubstitutionProcessor substitution) {
        SubstitutionProcessor[] subs = this.featureSubstitutions;
        subs = Arrays.copyOf(subs, subs.length + 1);
        subs[subs.length - 1] = substitution;
        this.featureSubstitutions = subs;
    }

    public SubstitutionProcessor[] getFeatureSubstitutions() {
        return this.featureSubstitutions;
    }

    public void registerFeatureNativeSubstitution(SubstitutionProcessor substitution) {
        SubstitutionProcessor[] nativeSubs = this.featureNativeSubstitutions;
        nativeSubs = Arrays.copyOf(nativeSubs, nativeSubs.length + 1);
        nativeSubs[nativeSubs.length - 1] = substitution;
        this.featureNativeSubstitutions = nativeSubs;
    }

    public SubstitutionProcessor[] getFeatureNativeSubstitutions() {
        return this.featureNativeSubstitutions;
    }

    public Object replaceObject(Object source) {
        return this.replaceObject0(source, false);
    }

    public JavaConstant replaceObjectWithConstant(Object source) {
        return this.replaceObjectWithConstant(source, this.getHostedValuesProvider()::forObject);
    }

    public JavaConstant replaceObjectWithConstant(Object source, Function<Object, JavaConstant> converter) {
        assert (!(source instanceof ImageHeapConstant)) : source;
        Object replacedObject = this.replaceObject0(source, true);
        if (replacedObject instanceof ImageHeapConstant) {
            ImageHeapConstant constant = (ImageHeapConstant)replacedObject;
            return constant;
        }
        return converter.apply(replacedObject);
    }

    private Object replaceObject0(Object source, boolean allowObjectToConstantReplacement) {
        if (source == null) {
            return null;
        }
        Object destination = source;
        for (Function<Object, Object> replacer : this.objectReplacers) {
            destination = replacer.apply(destination);
        }
        ImageHeapConstant ihc = null;
        for (Function<Object, ImageHeapConstant> replacer : this.objectToConstantReplacers) {
            ImageHeapConstant result = replacer.apply(destination);
            if (result == null) continue;
            AnalysisError.guarantee(allowObjectToConstantReplacement, "Object to constant replacement has been triggered from an unsupported location", new Object[0]);
            AnalysisError.guarantee(ihc == null, "Multiple object to constant replacers have been trigger on a single object %s %s %s", destination, ihc, result);
            ihc = result;
        }
        return ihc == null ? destination : ihc;
    }

    public void registerOverrideReachabilityNotification(AnalysisMethod declaredMethod, AnalysisElement.MethodOverrideReachableNotification notification) {
        this.methodOverrideReachableNotifications.computeIfAbsent(declaredMethod, m -> ConcurrentHashMap.newKeySet()).add(notification);
    }

    public void runAtFixedPoint() {
        for (Map.Entry<AnalysisMethod, Set<AnalysisElement.MethodOverrideReachableNotification>> entry : this.methodOverrideReachableNotifications.entrySet()) {
            AnalysisMethod method = entry.getKey();
            for (AnalysisMethod override : method.collectMethodImplementations(true)) {
                for (AnalysisElement.MethodOverrideReachableNotification notification : entry.getValue()) {
                    notification.notifyCallback(this, override);
                }
            }
        }
    }

    public static Set<AnalysisType> reachableSubtypes(AnalysisType baseType) {
        Set<AnalysisType> result = baseType.getAllSubtypes();
        result.removeIf(t -> !t.isReachable());
        return result;
    }

    @Override
    public SnippetReflectionProvider getSnippetReflection() {
        return this.bb.getSnippetReflectionProvider();
    }

    @Override
    public AnalysisType objectType() {
        return this.objectClass;
    }

    public void onFieldAccessed(AnalysisField field) {
        this.bb.onFieldAccessed(field);
    }

    public void onTypeInstantiated(AnalysisType type) {
        this.hostVM.onTypeInstantiated(this.bb, type);
        this.bb.onTypeInstantiated(type);
    }

    public void onTypeReachable(AnalysisType type) {
        this.hostVM.onTypeReachable(this.bb, type);
        if (this.bb != null) {
            this.bb.onTypeReachable(type);
        }
    }

    public void initializeMetaData(AnalysisType type) {
        this.bb.initializeMetaData(type);
    }

    public SubstitutionProcessor getSubstitutions() {
        return this.substitutions;
    }

    public AnalysisPolicy analysisPolicy() {
        return this.analysisPolicy;
    }

    public MetaAccessProvider getOriginalMetaAccess() {
        return this.originalMetaAccess;
    }

    public void setBigBang(BigBang bb) {
        this.bb = bb;
    }

    public BigBang getBigbang() {
        return this.bb;
    }

    public void setConcurrentAnalysisAccess(Feature.DuringAnalysisAccess access) {
        this.concurrentAnalysisAccess = access;
    }

    public Feature.DuringAnalysisAccess getConcurrentAnalysisAccess() {
        return this.concurrentAnalysisAccess;
    }

    public void setHeapScanner(ImageHeapScanner heapScanner) {
        this.heapScanner = heapScanner;
    }

    public ImageHeapScanner getHeapScanner() {
        return this.heapScanner;
    }

    public void setImageLayerWriter(ImageLayerWriter imageLayerWriter) {
        this.imageLayerWriter = imageLayerWriter;
    }

    public ImageLayerWriter getImageLayerWriter() {
        return this.imageLayerWriter;
    }

    public void setImageLayerLoader(ImageLayerLoader imageLayerLoader) {
        this.imageLayerLoader = imageLayerLoader;
    }

    public ImageLayerLoader getImageLayerLoader() {
        return this.imageLayerLoader;
    }

    public HostedValuesProvider getHostedValuesProvider() {
        return this.heapScanner.getHostedValuesProvider();
    }

    public void setHeapVerifier(HeapSnapshotVerifier heapVerifier) {
        this.heapVerifier = heapVerifier;
    }

    public HeapSnapshotVerifier getHeapVerifier() {
        return this.heapVerifier;
    }

    public void notifyReachableType() {
        this.numReachableTypes.incrementAndGet();
    }

    public int getReachableTypes() {
        return this.numReachableTypes.get();
    }

    public void setStartTypeId(int startTid) {
        this.typesById = new AnalysisType[startTid];
        AnalysisUniverse.setStartId(this.nextTypeId, startTid, 1);
    }

    public void setStartMethodId(int startMid) {
        AnalysisUniverse.setStartId(this.nextMethodId, startMid, 1);
    }

    public void setStartFieldId(int startFid) {
        AnalysisUniverse.setStartId(this.nextFieldId, startFid, 1);
    }

    private static void setStartId(AtomicInteger nextId, int startFid, int expectedStartValue) {
        if (nextId.compareAndExchange(expectedStartValue, startFid) != expectedStartValue) {
            throw AnalysisError.shouldNotReachHere("An id was assigned before the start id was set.");
        }
    }

    public int computeNextTypeId() {
        return this.nextTypeId.getAndIncrement();
    }

    public int computeNextMethodId() {
        return this.nextMethodId.getAndIncrement();
    }

    public int computeNextFieldId() {
        return this.nextFieldId.getAndIncrement();
    }
}

