/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.flow;

import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.typestate.TypeState;
import jdk.vm.ci.code.BytecodePosition;

public class FilterTypeFlow
extends TypeFlow<BytecodePosition> {
    private final boolean isExact;
    private final boolean isAssignable;
    private final boolean includeNull;
    private final AnalysisType filterType;

    public FilterTypeFlow(BytecodePosition position, AnalysisType filterType, boolean isExact, boolean isAssignable, boolean includeNull) {
        super(position, isAssignable ? filterType : null);
        this.isExact = isExact;
        this.isAssignable = isAssignable;
        this.includeNull = includeNull;
        this.filterType = filterType;
    }

    public FilterTypeFlow(MethodFlowsGraph methodFlows, FilterTypeFlow original) {
        super(original, methodFlows);
        this.isExact = original.isExact;
        this.isAssignable = original.isAssignable;
        this.includeNull = original.includeNull;
        this.filterType = original.filterType;
    }

    @Override
    public TypeFlow<BytecodePosition> copy(PointsToAnalysis bb, MethodFlowsGraph methodFlows) {
        return new FilterTypeFlow(methodFlows, this);
    }

    @Override
    public TypeState filter(PointsToAnalysis bb, TypeState update) {
        TypeState result = this.isExact ? (this.isAssignable ? TypeState.forIntersection(bb, update, TypeState.forExactType(bb, this.filterType, this.includeNull)) : TypeState.forSubtraction(bb, update, TypeState.forExactType(bb, this.filterType, !this.includeNull))) : (this.isAssignable ? TypeState.forIntersection(bb, update, this.filterType.getAssignableTypes(this.includeNull)) : TypeState.forSubtraction(bb, update, this.filterType.getAssignableTypes(!this.includeNull)));
        return result;
    }

    @Override
    public void addPredicated(PointsToAnalysis bb, TypeFlow<?> predicatedFlow) {
        if (this.isAssignable && this.isSaturated()) {
            this.filterType.getTypeFlow(bb, this.includeNull).addPredicated(bb, predicatedFlow);
            return;
        }
        super.addPredicated(bb, predicatedFlow);
    }

    @Override
    protected void onInputSaturated(PointsToAnalysis bb, TypeFlow<?> input) {
        if (bb.isClosed(this.filterType)) {
            if (this.isAssignable) {
                if (!this.setSaturated()) {
                    return;
                }
                this.swapOut(bb, this.filterType.getTypeFlow(bb, this.includeNull));
            } else {
                super.onInputSaturated(bb, input);
            }
        } else {
            super.onInputSaturated(bb, input);
        }
    }

    @Override
    protected void notifyUseOfSaturation(PointsToAnalysis bb, TypeFlow<?> use) {
        if (bb.isClosed(this.filterType)) {
            if (this.isAssignable) {
                this.swapAtUse(bb, this.filterType.getTypeFlow(bb, this.includeNull), use);
            } else {
                super.notifyUseOfSaturation(bb, use);
            }
        } else {
            super.notifyUseOfSaturation(bb, use);
        }
    }

    @Override
    protected void notifyObserverOfSaturation(PointsToAnalysis bb, TypeFlow<?> observer) {
        if (bb.isClosed(this.filterType)) {
            if (this.isAssignable) {
                this.swapAtObserver(bb, this.filterType.getTypeFlow(bb, this.includeNull), observer);
            } else {
                super.notifyObserverOfSaturation(bb, observer);
            }
        } else {
            super.notifyObserverOfSaturation(bb, observer);
        }
    }

    public boolean isExact() {
        return this.isExact;
    }

    public boolean isAssignable() {
        return this.isAssignable;
    }

    public boolean includeNull() {
        return this.includeNull;
    }

    @Override
    public String toString() {
        return "FilterTypeFlow<" + String.valueOf(this.filterType) + ", isAssignable: " + this.isAssignable + ", includeNull: " + this.includeNull + ">";
    }
}

