/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.flow;

import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.flow.BooleanCheckTypeFlow;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.typestate.TypeState;
import jdk.vm.ci.code.BytecodePosition;

public class BooleanNullCheckTypeFlow
extends BooleanCheckTypeFlow {
    public BooleanNullCheckTypeFlow(BytecodePosition source, AnalysisType inputType) {
        super(source, inputType);
    }

    private BooleanNullCheckTypeFlow(MethodFlowsGraph methodFlows, BooleanNullCheckTypeFlow original) {
        super(original, methodFlows);
    }

    @Override
    public TypeFlow<BytecodePosition> copy(PointsToAnalysis bb, MethodFlowsGraph methodFlows) {
        return new BooleanNullCheckTypeFlow(methodFlows, this);
    }

    @Override
    public TypeState filter(PointsToAnalysis bb, TypeState newState) {
        boolean hasNull = newState.canBeNull();
        boolean hasTypes = newState.typesCount() > 0;
        return BooleanNullCheckTypeFlow.convertToBoolean(hasNull, hasTypes);
    }
}

