/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.configure.config;

import com.oracle.svm.configure.ConfigurationBase;
import com.oracle.svm.configure.config.ConfigurationType;
import com.oracle.svm.configure.config.ParserConfigurationAdapter;
import com.oracle.svm.core.configure.ConditionalElement;
import com.oracle.svm.core.configure.ConfigurationConditionResolver;
import com.oracle.svm.core.configure.ConfigurationParser;
import com.oracle.svm.core.configure.ConfigurationTypeDescriptor;
import com.oracle.svm.core.configure.NamedConfigurationTypeDescriptor;
import com.oracle.svm.core.configure.ReflectionConfigurationParser;
import com.oracle.svm.core.configure.ReflectionConfigurationParserDelegate;
import com.oracle.svm.core.util.VMError;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import jdk.graal.compiler.util.json.JsonWriter;
import org.graalvm.nativeimage.impl.UnresolvedConfigurationCondition;

public final class TypeConfiguration
extends ConfigurationBase<TypeConfiguration, Predicate> {
    private final ConcurrentMap<ConditionalElement<ConfigurationTypeDescriptor>, ConfigurationType> types = new ConcurrentHashMap<ConditionalElement<ConfigurationTypeDescriptor>, ConfigurationType>();
    private final String combinedFileKey;

    public TypeConfiguration(String combinedFileKey) {
        this.combinedFileKey = combinedFileKey;
    }

    public TypeConfiguration(TypeConfiguration other) {
        other.types.forEach((key, value) -> this.types.put((ConditionalElement<ConfigurationTypeDescriptor>)key, new ConfigurationType((ConfigurationType)value)));
        this.combinedFileKey = other.combinedFileKey;
    }

    @Override
    public TypeConfiguration copy() {
        return new TypeConfiguration(this);
    }

    @Override
    protected void merge(TypeConfiguration other) {
        other.types.forEach((key, value) -> this.types.compute((ConditionalElement<ConfigurationTypeDescriptor>)key, (k, v) -> {
            if (v != null) {
                return ConfigurationType.copyAndMerge(v, value);
            }
            return value;
        }));
    }

    @Override
    public void subtract(TypeConfiguration other) {
        other.types.forEach((key, type) -> this.types.computeIfPresent((ConditionalElement<ConfigurationTypeDescriptor>)key, (k, v) -> ConfigurationType.copyAndSubtract(v, type)));
    }

    @Override
    protected void intersect(TypeConfiguration other) {
        this.types.forEach((key, type) -> {
            ConfigurationType intersectedType = (ConfigurationType)other.types.get(key);
            if (intersectedType != null) {
                this.types.compute((ConditionalElement<ConfigurationTypeDescriptor>)key, (k, v) -> ConfigurationType.copyAndIntersect(type, intersectedType));
            } else {
                this.types.remove(key);
            }
        });
    }

    @Override
    protected void removeIf(Predicate predicate) {
        this.types.entrySet().removeIf((? super E entry) -> predicate.testIncludedType((ConditionalElement<ConfigurationTypeDescriptor>)((ConditionalElement)entry.getKey()), (ConfigurationType)entry.getValue()));
    }

    public ConfigurationType get(UnresolvedConfigurationCondition condition, ConfigurationTypeDescriptor typeDescriptor) {
        return (ConfigurationType)this.types.get(new ConditionalElement(condition, (Object)typeDescriptor));
    }

    public void add(ConfigurationType type) {
        ConfigurationType previous = this.types.putIfAbsent((ConditionalElement<ConfigurationTypeDescriptor>)new ConditionalElement(type.getCondition(), (Object)type.getTypeDescriptor()), type);
        if (previous != null && previous != type) {
            VMError.shouldNotReachHere((String)("Cannot replace existing type " + String.valueOf(previous) + " with " + String.valueOf(type)));
        }
    }

    public void addOrMerge(ConfigurationType type) {
        this.types.compute((ConditionalElement<ConfigurationTypeDescriptor>)new ConditionalElement(type.getCondition(), (Object)type.getTypeDescriptor()), (key, value) -> {
            if (value == null) {
                return type;
            }
            value.mergeFrom(type);
            return value;
        });
    }

    public ConfigurationType getOrCreateType(UnresolvedConfigurationCondition condition, String qualifiedForNameString) {
        return this.getOrCreateType(condition, (ConfigurationTypeDescriptor)new NamedConfigurationTypeDescriptor(qualifiedForNameString));
    }

    public ConfigurationType getOrCreateType(UnresolvedConfigurationCondition condition, ConfigurationTypeDescriptor typeDescriptor) {
        return this.types.computeIfAbsent((ConditionalElement<ConfigurationTypeDescriptor>)new ConditionalElement(condition, (Object)typeDescriptor), p -> new ConfigurationType(p.condition(), (ConfigurationTypeDescriptor)p.element(), true));
    }

    @Override
    public void mergeConditional(UnresolvedConfigurationCondition condition, TypeConfiguration other) {
        other.types.forEach((key, value) -> this.addOrMerge(new ConfigurationType((ConfigurationType)value, condition)));
    }

    public void printJson(JsonWriter writer) throws IOException {
        ArrayList typesList = new ArrayList(this.types.values());
        typesList.sort(Comparator.comparing(ConfigurationType::getTypeDescriptor).thenComparing(ConfigurationType::getCondition));
        writer.append('[').indent();
        String prefix = "";
        for (ConfigurationType type : typesList) {
            writer.append(prefix).newline();
            type.printJson(writer);
            prefix = ",";
        }
        writer.unindent().newline().append(']');
    }

    @Override
    public ConfigurationParser createParser(boolean strictMetadata) {
        return ReflectionConfigurationParser.create((String)this.combinedFileKey, (boolean)strictMetadata, (ConfigurationConditionResolver)ConfigurationConditionResolver.identityResolver(), (ReflectionConfigurationParserDelegate)new ParserConfigurationAdapter(this), (boolean)true, (boolean)false, (boolean)false);
    }

    @Override
    public boolean isEmpty() {
        return this.types.isEmpty();
    }

    @Override
    public boolean supportsCombinedFile() {
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeConfiguration that = (TypeConfiguration)o;
        return this.types.equals(that.types);
    }

    public int hashCode() {
        return Objects.hash(this.types);
    }

    public static interface Predicate {
        public boolean testIncludedType(ConditionalElement<ConfigurationTypeDescriptor> var1, ConfigurationType var2);
    }
}

