/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.profiling.framework.collection;

import com.oracle.svm.enterprise.profiling.framework.collection.CallingContext;
import com.oracle.svm.enterprise.profiling.framework.collection.CodePosition;
import com.oracle.svm.enterprise.profiling.framework.collection.MethodBCITable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.IntSupplier;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.MapCursor;

public final class CallingContextForest {
    private final EconomicMap<Integer, SlimNode> trees = EconomicMap.create();
    private final MethodBCITable methodBCITable;
    private final Lock lock = new Lock();

    public CallingContextForest() {
        this.methodBCITable = new MethodBCITable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addIfAbsent(CallingContext callingContext, Payload payload, IntSupplier intSupplier) {
        Lock lock = this.lock;
        synchronized (lock) {
            SlimNode slimNode = this.findOrCreate(callingContext);
            return slimNode.addPayloadIfAbsent(payload, intSupplier);
        }
    }

    private SlimNode findOrCreate(CallingContext callingContext) {
        CodePosition codePosition = callingContext.head();
        int n2 = this.methodBCITable.getOrCreate(codePosition);
        SlimNode slimNode = (SlimNode)this.trees.get((Object)n2);
        if (slimNode == null) {
            slimNode = new SlimNode(n2);
            this.trees.put((Object)slimNode.methodBCIIndex, (Object)slimNode);
        }
        CallingContext callingContext2 = callingContext.tail();
        while (!callingContext2.isEmpty()) {
            slimNode = slimNode.findOrCreateCaller(callingContext2.head(), this.methodBCITable);
            callingContext2 = callingContext2.tail();
        }
        return slimNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Lock lock = this.lock;
        synchronized (lock) {
            this.trees.clear();
            this.methodBCITable.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compress() {
        Lock lock = this.lock;
        synchronized (lock) {
            this.methodBCITable.compress();
        }
    }

    public BestFit findBestFit(CallingContext callingContext) {
        Integer n2 = this.methodBCITable.get(callingContext.head());
        if (n2 == null) {
            return null;
        }
        SlimNode slimNode = (SlimNode)this.trees.get((Object)n2);
        if (slimNode == null) {
            return null;
        }
        return slimNode.findBestFit(callingContext.tail(), this.methodBCITable, new ArrayList<Cursor>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEach(ConsumerWithContext consumerWithContext) {
        Lock lock = this.lock;
        synchronized (lock) {
            MapCursor mapCursor = this.trees.getEntries();
            while (mapCursor.advance()) {
                SlimNode slimNode = (SlimNode)mapCursor.getValue();
                slimNode.forEach(consumerWithContext, CallingContext.empty(), this.methodBCITable);
            }
        }
    }

    public MethodBCITable methodBCITable() {
        return this.methodBCITable;
    }

    private static final class Lock {
        private Lock() {
        }
    }

    static final class SlimNode
    implements Cursor {
        final int methodBCIIndex;
        Object callers;
        Object payload;

        private SlimNode(int n2) {
            this.methodBCIIndex = n2;
            this.callers = null;
            this.payload = null;
        }

        SlimNode findOrCreateCaller(CodePosition codePosition, MethodBCITable methodBCITable) {
            if (this.callers == null) {
                return this.findOrCreateCallerWhenEmpty(codePosition, methodBCITable);
            }
            Object object = this.callers;
            if (object instanceof SlimNode[]) {
                SlimNode[] slimNodeArray = (SlimNode[])object;
                return this.findOrCreateCallerWhenManyCallers(codePosition, methodBCITable, slimNodeArray);
            }
            assert (this.callers instanceof SlimNode) : "Can only be a SlimNode instance";
            return this.findOrCreateCallerWhenSingleCaller(codePosition, methodBCITable);
        }

        private SlimNode findOrCreateCallerWhenSingleCaller(CodePosition codePosition, MethodBCITable methodBCITable) {
            SlimNode slimNode = (SlimNode)this.callers;
            if (slimNode.sameCodePositionAs(codePosition, methodBCITable)) {
                return slimNode;
            }
            SlimNode slimNode2 = new SlimNode(methodBCITable.getOrCreate(codePosition));
            SlimNode[] slimNodeArray = new SlimNode[]{slimNode, slimNode2};
            this.callers = slimNodeArray;
            return slimNode2;
        }

        private SlimNode findOrCreateCallerWhenManyCallers(CodePosition codePosition, MethodBCITable methodBCITable, SlimNode[] slimNodeArray) {
            for (SlimNode slimNode : slimNodeArray) {
                if (!slimNode.sameCodePositionAs(codePosition, methodBCITable)) continue;
                return slimNode;
            }
            SlimNode slimNode = new SlimNode(methodBCITable.getOrCreate(codePosition));
            SlimNode[] slimNodeArray2 = Arrays.copyOf(slimNodeArray, slimNodeArray.length + 1);
            slimNodeArray2[slimNodeArray2.length - 1] = slimNode;
            this.callers = slimNodeArray2;
            return slimNode;
        }

        private SlimNode findOrCreateCallerWhenEmpty(CodePosition codePosition, MethodBCITable methodBCITable) {
            SlimNode slimNode = new SlimNode(methodBCITable.getOrCreate(codePosition));
            this.callers = slimNode;
            return slimNode;
        }

        public boolean sameCodePositionAs(CodePosition codePosition, MethodBCITable methodBCITable) {
            return methodBCITable.methodID(this.methodBCIIndex) == codePosition.methodID() && methodBCITable.bci(this.methodBCIIndex) == codePosition.bci();
        }

        @Override
        public void forEachPayload(PayloadConsumer payloadConsumer) {
            Payload[] payloadArray;
            if (this.payload == null) {
                return;
            }
            Payload[] payloadArray2 = this.payload;
            if (payloadArray2 instanceof Payload) {
                payloadArray = payloadArray2;
                payloadConsumer.accept((Payload)payloadArray);
            }
            if ((payloadArray2 = this.payload) instanceof Payload[]) {
                for (Payload payload : payloadArray = (Payload[])payloadArray2) {
                    payloadConsumer.accept(payload);
                }
            }
        }

        @Override
        public void forEachPayloadWithCallers(PayloadConsumer payloadConsumer) {
            this.forEachPayload(payloadConsumer);
            this.forEachCaller(payloadConsumer);
        }

        private void forEachCaller(PayloadConsumer payloadConsumer) {
            Object object = this.callers;
            if (object instanceof SlimNode) {
                SlimNode slimNode = (SlimNode)object;
                slimNode.forEachPayloadWithCallers(payloadConsumer);
            } else {
                Object object2 = this.callers;
                if (object2 instanceof SlimNode[]) {
                    SlimNode[] slimNodeArray;
                    for (SlimNode slimNode : slimNodeArray = (SlimNode[])object2) {
                        slimNode.forEachPayloadWithCallers(payloadConsumer);
                    }
                }
            }
        }

        public boolean isEmpty() {
            return this.payload == null;
        }

        private int addPayloadIfAbsent(Payload payload, IntSupplier intSupplier) {
            if (this.payload == null) {
                this.payload = payload;
            } else {
                Object object = this.payload;
                if (object instanceof Payload) {
                    Payload payload2 = (Payload)object;
                    if (payload2.equals(payload)) {
                        return payload2.value;
                    }
                    Payload[] payloadArray = new Payload[]{payload2, payload};
                    this.payload = payloadArray;
                } else {
                    Object object2 = this.payload;
                    if (object2 instanceof Payload[]) {
                        Payload[] payloadArray;
                        for (Payload payload3 : payloadArray = (Payload[])object2) {
                            if (!payload3.equals(payload)) continue;
                            return payload3.value;
                        }
                        Payload[] payloadArray2 = new Payload[payloadArray.length + 1];
                        System.arraycopy(payloadArray, 0, payloadArray2, 0, payloadArray.length);
                        payloadArray2[payloadArray2.length - 1] = payload;
                        this.payload = payloadArray2;
                    }
                }
            }
            payload.value = intSupplier.getAsInt();
            return payload.value;
        }

        private void forEach(ConsumerWithContext consumerWithContext, CallingContext callingContext, MethodBCITable methodBCITable) {
            CallingContext callingContext2 = CallingContext.withCaller(callingContext, methodBCITable.codePosition(this.methodBCIIndex));
            if (!this.isEmpty()) {
                consumerWithContext.accept(this, callingContext2);
            }
            if (this.callers == null) {
                return;
            }
            SlimNode[] slimNodeArray = this.callers;
            if (slimNodeArray instanceof SlimNode) {
                SlimNode slimNode = (SlimNode)slimNodeArray;
                slimNode.forEach(consumerWithContext, callingContext2, methodBCITable);
            } else {
                assert (this.callers instanceof SlimNode[]) : "Can only be an array of SlimNode";
                for (SlimNode slimNode : (SlimNode[])this.callers) {
                    slimNode.forEach(consumerWithContext, callingContext2, methodBCITable);
                }
            }
        }

        private BestFit findBestFit(CallingContext callingContext, MethodBCITable methodBCITable, List<Cursor> list) {
            SlimNode[] slimNodeArray;
            if (callingContext.isEmpty()) {
                return new BestFit(this, true, list);
            }
            CodePosition codePosition = callingContext.head();
            Integer n2 = methodBCITable.get(codePosition);
            if (n2 == null) {
                return new BestFit(this, false, list);
            }
            SlimNode[] slimNodeArray2 = this.callers;
            if (slimNodeArray2 instanceof SlimNode) {
                slimNodeArray = slimNodeArray2;
                if (slimNodeArray.methodBCIIndex == n2) {
                    list.add(this);
                    return slimNodeArray.findBestFit(callingContext.tail(), methodBCITable, list);
                }
            }
            if ((slimNodeArray2 = this.callers) instanceof SlimNode[]) {
                for (SlimNode slimNode : slimNodeArray = (SlimNode[])slimNodeArray2) {
                    if (slimNode.methodBCIIndex != n2) continue;
                    list.add(this);
                    return slimNode.findBestFit(callingContext.tail(), methodBCITable, list);
                }
            }
            return new BestFit(this, false, list);
        }
    }

    public static abstract class Payload {
        private int value = -1;

        protected Payload() {
        }

        public abstract String key();

        public int value() {
            return this.value;
        }

        protected abstract boolean sameAs(Payload var1);

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof Payload)) {
                return false;
            }
            Payload payload = (Payload)object;
            return this.sameAs(payload);
        }

        public int hashCode() {
            return this.value;
        }
    }

    public record BestFit(Cursor cursor, boolean fullyMatchedCallingContext, List<Cursor> calleeContext) {
    }

    @FunctionalInterface
    public static interface ConsumerWithContext {
        public void accept(Cursor var1, CallingContext var2);
    }

    public static interface Cursor {
        public void forEachPayload(PayloadConsumer var1);

        public void forEachPayloadWithCallers(PayloadConsumer var1);
    }

    @FunctionalInterface
    public static interface PayloadConsumer {
        public void accept(Payload var1);
    }
}

