/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.profiling.framework;

import com.oracle.graal.nodes.enterprise.l;
import com.oracle.graal.phases.pathspec.collection.f;
import com.oracle.svm.core.ReservedRegisters;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.c.CGlobalData;
import com.oracle.svm.core.c.CGlobalDataFactory;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.graal.code.CGlobalDataInfo;
import com.oracle.svm.core.graal.nodes.CGlobalDataLoadAddressNode;
import com.oracle.svm.core.graal.nodes.ReadReservedRegisterFloatingNode;
import com.oracle.svm.core.snippets.SnippetRuntime;
import com.oracle.svm.core.snippets.SubstrateForeignCallTarget;
import com.oracle.svm.enterprise.core.annotate.a;
import com.oracle.svm.hosted.ByteFormattingUtil;
import com.oracle.svm.hosted.c.CGlobalDataFeature;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import jdk.graal.compiler.api.replacements.Fold;
import jdk.graal.compiler.core.common.spi.ForeignCallDescriptor;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.NamedLocationIdentity;
import jdk.graal.compiler.nodes.PauseNode;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.FloatingNode;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import jdk.graal.compiler.nodes.memory.SideEffectFreeWriteNode;
import jdk.graal.compiler.nodes.memory.address.AddressNode;
import jdk.graal.compiler.nodes.memory.address.OffsetAddressNode;
import jdk.vm.ci.code.CodeUtil;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.c.function.CFunction;
import org.graalvm.nativeimage.c.function.CLibrary;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CLongPointer;
import org.graalvm.word.ComparableWord;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.SignedWord;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public abstract class InstrumentationData {
    public static final LocationIdentity PROFILING_LOCATION = NamedLocationIdentity.mutable((String)"PROFILING_LOCATION");
    public static final SnippetRuntime.SubstrateForeignCallDescriptor ALLOCATE_COUNTERS_MEMORY = SnippetRuntime.findForeignCall(ProfilingRuntimeCalls.class, (String)"allocateCountersMemory", (ForeignCallDescriptor.CallSideEffect)ForeignCallDescriptor.CallSideEffect.HAS_SIDE_EFFECT, (LocationIdentity[])new LocationIdentity[]{PROFILING_LOCATION});
    private static final SnippetRuntime.SubstrateForeignCallDescriptor[] FOREIGN_CALLS = new SnippetRuntime.SubstrateForeignCallDescriptor[]{ALLOCATE_COUNTERS_MEMORY};
    private static final String COUNTERS_ALLOCATION_FAILED_MESSAGE = "Failed to allocate the memory the size of %s needed for the profiling run. Try reducing the current value of " + f.a.vE.getName() + " and compile the program again.\u0000";
    public static final long POINTER_TO_MEMORY_START_INITIALIZING_MARKER_VALUE = -1L;
    private static final int NUMBER_OF_COUNTER_COMPONENTS_INITIAL_VALUE = 0;
    private static final String COUNTER_MEMORY_START_C_DATA_SYMBOL = "native-image-profiling-memory-start";
    private static final String COUNTER_MEMORY_SIZE_C_DATA_SYMBOL = "native-image-profiling-memory-size";
    protected final Storage storage;

    @Fold
    public static InstrumentationData singleton() {
        return (InstrumentationData)ImageSingletons.lookup(InstrumentationData.class);
    }

    InstrumentationData(Storage storage) {
        this.storage = storage;
    }

    public Storage storage() {
        return this.storage;
    }

    public boolean isTypeNonInstrumentable(String string) {
        return string.startsWith(InstrumentationData.class.getPackageName());
    }

    public final int reserveUniqueCounterIDSlots(int n2) {
        return this.storage.reserveUniqueCounterIDSlots(n2);
    }

    public SnippetRuntime.SubstrateForeignCallDescriptor[] foreignCalls() {
        return FOREIGN_CALLS;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected void onCounterMemoryAllocated(PointerBase pointerBase) {
    }

    public static abstract class Storage {
        @Fold
        public static Storage singleton() {
            return (Storage)ImageSingletons.lookup(Storage.class);
        }

        public abstract int reserveUniqueCounterIDSlots(int var1);

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public abstract CounterWordSize counterWordSize();

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public abstract long stripID();

        protected abstract long computeCountersMemorySize();

        protected abstract int stripsPerCounter();

        protected abstract int readInt(long var1, int var3, int var4);

        protected abstract long readLong(long var1, int var3, int var4);

        protected abstract boolean casInt(long var1, int var3, int var4, int var5, int var6);

        protected abstract void sideEffectFreeWriteLong(long var1, int var3, int var4, long var5);

        protected abstract void sideEffectFreeWriteInt(long var1, int var3, int var4, int var5);

        protected abstract void reset();
    }

    public static class ProfilingRuntimeCalls {
        @a
        @SubstrateForeignCallTarget(stubCallingConvention=false)
        @Uninterruptible(reason="This method must not have a stack-overflow check as it is used before the thread register is assigned.")
        public static void allocateCountersMemory() {
            SignedWord signedWord;
            Pointer pointer = (Pointer)OffHeapStorage.singleton().pointerToMemoryStart().get();
            ComparableWord comparableWord = (ComparableWord)pointer.readWordVolatile(0, PROFILING_LOCATION);
            if (comparableWord.notEqual((ComparableWord)(signedWord = WordFactory.signed((long)-1L))) && pointer.logicCompareAndSwapWord(0, (WordBase)WordFactory.nullPointer(), (WordBase)signedWord, PROFILING_LOCATION)) {
                long l2 = ((CLongPointer)OffHeapStorage.singleton().getProfilingCountersMemorySize().get()).read();
                PointerBase pointerBase = UninstrumentedLibC.calloc(WordFactory.unsigned((int)1), WordFactory.unsigned((long)l2));
                if (pointerBase.isNull()) {
                    UninstrumentedLibC.exitWithMessage(3, (CCharPointer)OffHeapStorage.singleton().getAllocationFailedErrorMessage().get());
                }
                InstrumentationData.singleton().onCounterMemoryAllocated(pointerBase);
                pointer.writeWordVolatile(0, (WordBase)pointerBase);
            } else {
                while (signedWord.equal((SignedWord)pointer.readWordVolatile(0, PROFILING_LOCATION))) {
                    PauseNode.pause();
                }
            }
        }

        private static class UninstrumentedLibC {
            private UninstrumentedLibC() {
            }

            @CLibrary(value="libchelper", requireStatic=true)
            @CFunction(transition=CFunction.Transition.NO_TRANSITION)
            static native UnsignedWord exitWithMessage(int var0, CCharPointer var1);

            @CFunction(transition=CFunction.Transition.NO_TRANSITION)
            static native PointerBase calloc(UnsignedWord var0, UnsignedWord var1);
        }
    }

    public static final class OffHeapStorage
    extends Storage {
        public static final long KNUTH_MULTIPLIER = 2654435769L;
        public static final int COUNTER_COMPONENTS_PER_STRIP_GROUP = 64;
        public static final int COUNTER_COMPONENTS_PER_STRIP_GROUP_LOG2 = CodeUtil.log2((int)64);
        private final CGlobalData<Pointer> pointerToMemoryStart;
        private final CGlobalData<CLongPointer> profilingCountersMemorySize;
        private final CGlobalData<CCharPointer> allocationFailedErrorMessage;
        private final int stripsPerCounter;
        private final int stripsPerCounterLog2;
        private final CounterWordSize counterWordSize;
        private final boolean useRDPID;
        private final AtomicInteger totalNumberOfReservedCounterComponents = new AtomicInteger(0);

        public OffHeapStorage(boolean bl2, int n2, CounterWordSize counterWordSize) {
            this.stripsPerCounter = n2;
            this.stripsPerCounterLog2 = CodeUtil.log2((int)this.stripsPerCounter);
            this.counterWordSize = counterWordSize;
            this.useRDPID = bl2;
            this.pointerToMemoryStart = CGlobalDataFactory.createWord((String)InstrumentationData.COUNTER_MEMORY_START_C_DATA_SYMBOL);
            this.profilingCountersMemorySize = this.initializeProfilingCountersMemorySize();
            this.allocationFailedErrorMessage = CGlobalDataFactory.createBytes(this.getAllocationFailedErrorMessageSupplier());
        }

        private CGlobalData<CLongPointer> initializeProfilingCountersMemorySize() {
            int n2 = 8;
            return CGlobalDataFactory.createBytes(() -> ByteBuffer.allocate(n2).order(ConfigurationValues.getTarget().arch.getByteOrder()).putLong(this.computeCountersMemorySize()).array(), (String)InstrumentationData.COUNTER_MEMORY_SIZE_C_DATA_SYMBOL);
        }

        private Supplier<byte[]> getAllocationFailedErrorMessageSupplier() {
            return () -> String.format(COUNTERS_ALLOCATION_FAILED_MESSAGE, ByteFormattingUtil.bytesToHuman((long)this.computeCountersMemorySize())).getBytes(StandardCharsets.US_ASCII);
        }

        @Override
        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        protected long readLong(long l2, int n2, int n3) {
            Pointer pointer = OffHeapStorage.memoryStart();
            long l3 = this.byteOffsetFromCounterMemoryStart(l2, n2, n3);
            return pointer.readLong((WordBase)WordFactory.unsigned((long)l3), PROFILING_LOCATION);
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        private static Pointer memoryStart() {
            Pointer pointer = (Pointer)OffHeapStorage.singleton().pointerToMemoryStart.get();
            return (Pointer)WordFactory.pointer((long)pointer.readLong(0, PROFILING_LOCATION));
        }

        @Override
        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        protected void sideEffectFreeWriteLong(long l2, int n2, int n3, long l3) {
            Pointer pointer = OffHeapStorage.memoryStart();
            long l4 = this.byteOffsetFromCounterMemoryStart(l2, n2, n3);
            SideEffectFreeWrite64Bit.write(pointer.rawValue() + l4, l3);
        }

        @Override
        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        protected int readInt(long l2, int n2, int n3) {
            Pointer pointer = OffHeapStorage.memoryStart();
            long l3 = this.byteOffsetFromCounterMemoryStart(l2, n2, n3);
            return pointer.readInt((WordBase)WordFactory.unsigned((long)l3), PROFILING_LOCATION);
        }

        @Override
        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        protected void sideEffectFreeWriteInt(long l2, int n2, int n3, int n4) {
            Pointer pointer = OffHeapStorage.memoryStart();
            long l3 = this.byteOffsetFromCounterMemoryStart(l2, n2, n3);
            SideEffectFreeWrite32Bit.write(pointer.rawValue() + l3, n4);
        }

        @Override
        protected void reset() {
            int n2 = this.totalNumberOfReservedCounterComponents.get();
            for (int i2 = 0; i2 < this.stripsPerCounter(); ++i2) {
                for (int i3 = 0; i3 < n2; ++i3) {
                    if (this.counterWordSize == CounterWordSize.Bits64) {
                        this.sideEffectFreeWriteLong(i2, i3, 0, 0L);
                    }
                    if (this.counterWordSize != CounterWordSize.Bits32) continue;
                    this.sideEffectFreeWriteInt(i2, i3, 0, 0);
                }
            }
        }

        @Override
        public int reserveUniqueCounterIDSlots(int n2) {
            if (n2 < 0) {
                GraalError.shouldNotReachHere((String)"Number of components per counter cannot be negative.");
            }
            while (true) {
                int n3 = this.totalNumberOfReservedCounterComponents.get();
                try {
                    int n4 = Math.addExact(n3, n2);
                    if (!this.totalNumberOfReservedCounterComponents.compareAndSet(n3, n4)) continue;
                    return n3;
                }
                catch (ArithmeticException arithmeticException) {
                    GraalError.shouldNotReachHere((Throwable)arithmeticException, (String)"Exceeded maximum number of instrumentation counters.");
                    continue;
                }
                break;
            }
        }

        @Fold
        public CGlobalData<Pointer> pointerToMemoryStart() {
            return this.pointerToMemoryStart;
        }

        @Fold
        public CGlobalData<CLongPointer> getProfilingCountersMemorySize() {
            return this.profilingCountersMemorySize;
        }

        @Fold
        public CGlobalData<CCharPointer> getAllocationFailedErrorMessage() {
            return this.allocationFailedErrorMessage;
        }

        @Override
        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        protected boolean casInt(long l2, int n2, int n3, int n4, int n5) {
            Pointer pointer = OffHeapStorage.memoryStart();
            long l3 = this.byteOffsetFromCounterMemoryStart(l2, n2, n3);
            return pointer.logicCompareAndSwapInt((WordBase)WordFactory.pointer((long)l3), n4, n5, PROFILING_LOCATION);
        }

        @Fold
        public static OffHeapStorage singleton() {
            return (OffHeapStorage)ImageSingletons.lookup(Storage.class);
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public long byteOffsetFromCounterMemoryStart(long l2, int n2, int n3) {
            int n4 = OffHeapStorage.singleton().counterWordSize().byteCountLog2();
            int n5 = this.stripsPerCounterLog2;
            int n6 = (n2 << n4) + n3 >>> COUNTER_COMPONENTS_PER_STRIP_GROUP_LOG2 + n4;
            int n7 = 1 << COUNTER_COMPONENTS_PER_STRIP_GROUP_LOG2 + n5 + n4;
            int n8 = 1 << COUNTER_COMPONENTS_PER_STRIP_GROUP_LOG2 + n4;
            int n9 = (n2 << n4) + n3 & (1 << COUNTER_COMPONENTS_PER_STRIP_GROUP_LOG2 + n4) - 1;
            long l3 = (long)n6 * (long)n7 + l2 * (long)n8 + (long)n9;
            return l3;
        }

        @Fold
        public FloatingNode profilingMemoryBaseNode() {
            CGlobalDataInfo cGlobalDataInfo = CGlobalDataFeature.singleton().registerAsAccessedOrGet(this.pointerToMemoryStart);
            assert (cGlobalDataInfo != null) : "The info should be set for the profiles.";
            return new CGlobalDataLoadAddressNode(cGlobalDataInfo);
        }

        public void registerSymbolsAsReachable() {
            CGlobalDataFeature cGlobalDataFeature = CGlobalDataFeature.singleton();
            cGlobalDataFeature.registerAsAccessedOrGet(this.pointerToMemoryStart);
            cGlobalDataFeature.registerAsAccessedOrGet(this.profilingCountersMemorySize);
        }

        @Override
        protected long computeCountersMemorySize() {
            int n2 = this.totalNumberOfReservedCounterComponents.get();
            int n3 = n2 / 64 + 1;
            long l2 = (long)n3 * 64L * (long)this.stripsPerCounter;
            return l2 * (long)this.counterWordSize().byteCount();
        }

        @Override
        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public CounterWordSize counterWordSize() {
            return this.counterWordSize;
        }

        @Override
        protected int stripsPerCounter() {
            return this.stripsPerCounter;
        }

        @Override
        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public long stripID() {
            long l2;
            OffHeapStorage offHeapStorage = OffHeapStorage.singleton();
            if (offHeapStorage.useRDPID) {
                l2 = l.getProcID();
            } else {
                int n2 = ReadIsolateThread.read();
                l2 = (long)n2 * 2654435769L >> 32 - offHeapStorage.stripsPerCounterLog2;
            }
            return l2 & (long)(offHeapStorage.stripsPerCounter - 1);
        }

        @Node.NodeIntrinsicFactory
        public static class ReadIsolateThread {
            @Node.NodeIntrinsic(value=ReadIsolateThread.class)
            public static native int read();

            public static boolean intrinsify(GraphBuilderContext graphBuilderContext) {
                graphBuilderContext.addPush(JavaKind.Int, (ValueNode)new ReadReservedRegisterFloatingNode(ReservedRegisters.singleton().getThreadRegister()));
                return true;
            }
        }
    }

    public static final class CounterWordSize
    extends Enum<CounterWordSize> {
        public static final /* enum */ CounterWordSize Bits32 = new CounterWordSize(JavaKind.Int);
        public static final /* enum */ CounterWordSize Bits64 = new CounterWordSize(JavaKind.Long);
        private final int byteCount;
        private final int byteCountLog2;
        private final JavaKind kind;
        private static final /* synthetic */ CounterWordSize[] $VALUES;

        public static CounterWordSize[] values() {
            return (CounterWordSize[])$VALUES.clone();
        }

        public static CounterWordSize valueOf(String string) {
            return Enum.valueOf(CounterWordSize.class, string);
        }

        private CounterWordSize(JavaKind javaKind) {
            assert (javaKind.isNumericInteger()) : "Kind must be an integer.";
            this.kind = javaKind;
            this.byteCount = javaKind.getByteCount();
            assert (CodeUtil.isPowerOf2((int)this.byteCount)) : "Byte count must be power of 2.";
            this.byteCountLog2 = CodeUtil.log2((int)this.byteCount);
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public int byteCount() {
            return this.byteCount;
        }

        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public int byteCountLog2() {
            return this.byteCountLog2;
        }

        public JavaKind kind() {
            return this.kind;
        }

        private static /* synthetic */ CounterWordSize[] $values() {
            return new CounterWordSize[]{Bits32, Bits64};
        }

        static {
            $VALUES = CounterWordSize.$values();
        }
    }

    @Node.NodeIntrinsicFactory
    public static class SideEffectFreeWrite64Bit {
        @Node.NodeIntrinsic(value=SideEffectFreeWrite64Bit.class)
        public static native void write(long var0, long var2);

        public static boolean intrinsify(GraphBuilderContext graphBuilderContext, ValueNode valueNode, ValueNode valueNode2) {
            graphBuilderContext.add((Node)SideEffectFreeWriteNode.createWithoutSideEffect((AddressNode)OffsetAddressNode.create((ValueNode)valueNode), (LocationIdentity)PROFILING_LOCATION, (ValueNode)valueNode2));
            return true;
        }
    }

    @Node.NodeIntrinsicFactory
    public static class SideEffectFreeWrite32Bit {
        @Node.NodeIntrinsic(value=SideEffectFreeWrite32Bit.class)
        public static native void write(long var0, int var2);

        public static boolean intrinsify(GraphBuilderContext graphBuilderContext, ValueNode valueNode, ValueNode valueNode2) {
            graphBuilderContext.add((Node)SideEffectFreeWriteNode.createWithoutSideEffect((AddressNode)OffsetAddressNode.create((ValueNode)valueNode), (LocationIdentity)PROFILING_LOCATION, (ValueNode)valueNode2));
            return true;
        }
    }
}

