/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.hosted.pgo.features;

import com.oracle.graal.phases.preciseinline.priorityinline.PriorityInliningPhase;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.option.APIOption;
import com.oracle.svm.core.option.AccumulatingLocatableMultiOptionValue;
import com.oracle.svm.core.option.BundleMember;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.HostedOptionValues;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.enterprise.core.bc;
import com.oracle.svm.enterprise.hosted.ml.features.provider.a;
import com.oracle.svm.enterprise.hosted.pgo.b;
import com.oracle.svm.enterprise.hosted.pgo.phases.PGOApplyProfilesPhase;
import com.oracle.svm.enterprise.hosted.pgo.profiles.PGOProfilesLookup;
import com.oracle.svm.enterprise.hosted.pgo.profiles.a;
import com.oracle.svm.enterprise.hosted.pgo.profiles.c;
import com.oracle.svm.enterprise.hosted.profiling.features.ProfilingFeature;
import com.oracle.svm.enterprise.hosted.profilingframework.d;
import com.oracle.svm.enterprise.profiling.collect.e;
import com.oracle.svm.enterprise.profiling.framework.Metadata;
import com.oracle.svm.enterprise.profiling.framework.PGOData;
import com.oracle.svm.enterprise.profiling.framework.ProfileDumper;
import com.oracle.svm.enterprise.profiling.loaders.IprofContent;
import com.oracle.svm.enterprise.profiling.profiles.ProfilingRuntimeProfile;
import com.oracle.svm.hosted.FeatureImpl;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import jdk.graal.compiler.core.common.GraalOptions;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.hotspot.CompilerConfigurationFactory;
import jdk.graal.compiler.nodes.ProfileData;
import jdk.graal.compiler.options.OptionKey;
import jdk.graal.compiler.options.OptionValues;
import jdk.vm.ci.meta.JavaType;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.UnmodifiableEconomicMap;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
public class PGOFeature
implements InternalFeature {
    private static final long DEFAULT_PROFILES_NORMALIZATION_VALUE = 1000000000000000L;
    private static final long DEFAULT_CACHED_PROFILES_NORMALIZATION_VALUE = 100000000000000L;
    private static final String PGO_OPTIMIZED_QUALIFIER = "PGO optimized";
    private List<e> collectedProfiles;
    private List<e> collectedAdoptedProfiles;
    private static final Map<String, String> excludeToIprofKeyMap = new HashMap<String, String>();

    private static void validatePGOExcludeProfiles(HostedOptionKey<String> hostedOptionKey) {
        if (hostedOptionKey.getValue() == null) {
            return;
        }
        UserError.guarantee((boolean)PGOFeature.isPGOEnabled(), (String)"'%s' require either '%s' or '%s'.", (Object[])new Object[]{SubstrateOptionsParser.commandArgument(a.PGOExcludeProfiles, (String)"MASK"), SubstrateOptionsParser.commandArgument(a.PGOEnabled, (String)"PROFILES"), SubstrateOptionsParser.commandArgument(a.AdoptedPGOEnabled, (String)"ADOPTED_PROFILES")});
    }

    public static boolean isPGOEnabled() {
        return PGOFeature.isPGOEnabled(HostedOptionValues.singleton().getMap());
    }

    public static boolean isPGOEnabled(UnmodifiableEconomicMap<OptionKey<?>, Object> unmodifiableEconomicMap) {
        return unmodifiableEconomicMap.containsKey(a.PGOEnabled) || unmodifiableEconomicMap.containsKey(a.AdoptedPGOEnabled);
    }

    public static boolean isUserCollectedPGOEnabled() {
        return a.PGOEnabled.hasBeenSet();
    }

    private static void validatePGOOption(HostedOptionKey<AccumulatingLocatableMultiOptionValue.Paths> hostedOptionKey) {
        PGOFeature.validateMutuallyExclusivePGOOptions();
        UserError.guarantee((!SubstrateOptions.Optimize.hasBeenSet() || SubstrateOptions.isMaximumOptimizationLevel() ? 1 : 0) != 0, (String)"Optimization level cannot be changed via '%s' when '%s' is used. Native Image enables all optimizations for PGO builds.", (Object[])new Object[]{SubstrateOptionsParser.commandArgument((OptionKey)SubstrateOptions.Optimize, (String)((String)SubstrateOptions.Optimize.getValue())), SubstrateOptionsParser.commandArgument(hostedOptionKey, (String)((AccumulatingLocatableMultiOptionValue.Paths)hostedOptionKey.getValue()).toString())});
    }

    public static void validateMutuallyExclusivePGOOptions() {
        UserError.guarantee((!PGOFeature.isPGOEnabled() || (Boolean)ProfilingFeature.Options.ProfilingEnabled.getValue() == false ? 1 : 0) != 0, (String)"'%s' and '%s' cannot be used with '%s' at the same time.", (Object[])new Object[]{SubstrateOptionsParser.commandArgument(a.PGOEnabled, (String)((AccumulatingLocatableMultiOptionValue.Paths)a.PGOEnabled.getValue()).toString()), SubstrateOptionsParser.commandArgument(a.AdoptedPGOEnabled, (String)((AccumulatingLocatableMultiOptionValue.Paths)a.AdoptedPGOEnabled.getValue()).toString()), SubstrateOptionsParser.commandArgument(ProfilingFeature.Options.ProfilingEnabled, (String)"+")});
    }

    public boolean isInConfiguration(Feature.IsInConfigurationAccess isInConfigurationAccess) {
        return PGOFeature.isPGOEnabled();
    }

    public void afterRegistration(Feature.AfterRegistrationAccess afterRegistrationAccess) {
        com.oracle.svm.enterprise.hosted.pgo.loaders.a a2 = new com.oracle.svm.enterprise.hosted.pgo.loaders.a();
        if (a.PGOEnabled.hasBeenSet() && (((Boolean)ProfilingFeature.Options.UseOldProfilingFramework.getValue()).booleanValue() || ((Boolean)a.PGOTraceProfileComparison.getValue()).booleanValue())) {
            this.collectedProfiles = a2.parseProfiles(PGOFeature.getProfilePaths());
        }
        if (a.AdoptedPGOEnabled.hasBeenSet()) {
            List list = ((AccumulatingLocatableMultiOptionValue.Paths)a.AdoptedPGOEnabled.getValue()).values();
            assert (!list.isEmpty());
            this.collectedAdoptedProfiles = a2.parseProfiles(list);
        }
    }

    public static List<Path> getProfilePaths() {
        if (!a.PGOEnabled.hasBeenSet()) {
            return null;
        }
        List<Path> list = ((AccumulatingLocatableMultiOptionValue.Paths)a.PGOEnabled.getValue()).values();
        if (list.isEmpty()) {
            list = Collections.singletonList(Path.of("default.iprof", new String[0]));
        }
        return list;
    }

    public void afterAnalysis(Feature.AfterAnalysisAccess afterAnalysisAccess) {
        AnalysisUniverse analysisUniverse = ((FeatureImpl.AfterAnalysisAccessImpl)afterAnalysisAccess).getUniverse();
        List<AnalysisType> list = analysisUniverse.getTypes().stream().filter(b::c).toList();
        if (((Boolean)ProfilingFeature.Options.UseOldProfilingFramework.getValue()).booleanValue()) {
            Map<String, AnalysisType> map = list.stream().collect(Collectors.toMap(JavaType::toClassName, analysisType -> analysisType));
            Map<String, AnalysisMethod> map2 = analysisUniverse.getMethods().stream().collect(Collectors.toMap(analysisMethod -> Integer.toString(analysisMethod.getId()), analysisMethod -> analysisMethod));
            this.legacyLoadProfiles(map, map2);
        } else {
            this.loadProfiles(analysisUniverse, list);
        }
    }

    private PGOProfilesLookup getLegacyCollectedProfiles(AnalysisUniverse analysisUniverse, List<AnalysisType> list) {
        Map<String, AnalysisType> map = list.stream().collect(Collectors.toMap(JavaType::toClassName, Function.identity(), this::merge));
        Map<String, AnalysisMethod> map2 = analysisUniverse.getMethods().stream().collect(Collectors.toMap(analysisMethod -> Integer.toString(analysisMethod.getId()), analysisMethod -> analysisMethod));
        c c2 = null;
        if (this.collectedProfiles != null) {
            c2 = (c)new com.oracle.svm.enterprise.hosted.pgo.loaders.a(map, map2).loadProfile(this.collectedProfiles, (Long)a.PGOProfilesNormalizationValue.getValue(), ProfileData.ProfileSource.PROFILED);
            this.collectedProfiles = null;
        }
        return c2;
    }

    private void loadProfiles(AnalysisUniverse analysisUniverse, List<AnalysisType> list) {
        ProfileData.ProfileSource profileSource = ProfileData.ProfileSource.PROFILED;
        List<Path> list2 = PGOFeature.getProfilePaths();
        if (list2 == null) {
            list2 = new ArrayList<Path>();
        }
        if (list2.isEmpty() && a.AdoptedPGOEnabled.hasBeenSet()) {
            profileSource = ProfileData.ProfileSource.ADOPTED;
            list2.addAll(((AccumulatingLocatableMultiOptionValue.Paths)a.AdoptedPGOEnabled.getValue()).values());
        }
        if (list2.isEmpty()) {
            return;
        }
        ArrayList<IprofContent> arrayList = new ArrayList<IprofContent>();
        for (Path object2 : list2) {
            arrayList.add(IprofContent.parseFromIprof(object2, string -> UserError.abort((String)string, (Object[])new Object[0]), (Boolean)a.PGOIgnoreVersionCheck.getValue(), PGOFeature.parsePGOExcludeProfiles((String)a.PGOExcludeProfiles.getValue())));
        }
        a.c c2 = new a.c();
        PGOData.Builder builder = new PGOData.Builder(arrayList);
        PGOData pGOData = builder.setUniverseTypesAndMethods(list, analysisUniverse.getMethods(), c2.go(), c2.gp()).setSource(profileSource).setUnmatchedEntriesConsumer((l2, l3) -> PGOApplyProfilesPhase.a.a(l3 - l2, l3)).trackUnmatchedTypes(c2.gq()).setPrintDroppedContexts((Boolean)a.PGOPrintProfileQualityDetails.getValue()).build();
        com.oracle.svm.enterprise.hosted.pgo.profiles.a a2 = new com.oracle.svm.enterprise.hosted.pgo.profiles.a(pGOData, c2);
        a2 = (Boolean)a.PGOTraceProfileComparison.getValue() != false ? new a.a(this.getLegacyCollectedProfiles(analysisUniverse, list), a2) : a2;
        ImageSingletons.add(PGOProfilesLookup.class, (Object)a2);
        PGOFeature.dumpToTempFile(pGOData);
    }

    private static List<String> parsePGOExcludeProfiles(String string) {
        if (string == null) {
            return Collections.emptyList();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string2 : string.split(",")) {
            String string3 = excludeToIprofKeyMap.get(string2);
            if (string3 == null) continue;
            arrayList.add(string3);
        }
        return arrayList;
    }

    private static void dumpToTempFile(ProfileDumper.DumpableData dumpableData) {
        if (!a.PGODumpLoadedIprofPath.hasBeenSet()) {
            return;
        }
        String string = (String)a.PGODumpLoadedIprofPath.getValue();
        ImageSingletons.add(Metadata.class, (Object)dumpableData.metadata());
        ProfileDumper profileDumper = (Boolean)d.a.ProfileInstanceOfTypes.getValue() != false ? new ProfileDumper.Experimental.WithInstanceOfProfiles(dumpableData, Function.identity(), (Boolean)ProfileDumper.Options.ProfilesIncludeException.getValue()) : ProfileDumper.createDefault(dumpableData, Function.identity(), (Boolean)ProfileDumper.Options.ProfilesIncludeException.getValue());
        ProfileDumper.dumpToFile(profileDumper, Path.of(string, new String[0]), (Boolean)ProfilingRuntimeProfile.Options.ProfilingDumpVerbose.getValue());
    }

    private static String getClassLoaderName(AnalysisType analysisType) {
        Class clazz = analysisType.getJavaClass();
        ClassLoader classLoader = clazz.getClassLoader();
        return classLoader == null ? "null" : classLoader.getName();
    }

    private AnalysisType merge(AnalysisType analysisType, AnalysisType analysisType2) {
        if (!analysisType.getJavaClass().getModule().isNamed()) {
            return analysisType;
        }
        GraalError.guarantee((!analysisType2.getJavaClass().getModule().isNamed() ? 1 : 0) != 0, (String)"type %s loaded by %s and %s is in an unnamed module", (Object)analysisType.toJavaName(), (Object)PGOFeature.getClassLoaderName(analysisType), (Object)PGOFeature.getClassLoaderName(analysisType2));
        return analysisType2;
    }

    public void afterCompilation(Feature.AfterCompilationAccess afterCompilationAccess) {
        ((PGOProfilesLookup)ImageSingletons.lookup(PGOProfilesLookup.class)).clear();
    }

    private void legacyLoadProfiles(Map<String, AnalysisType> map, Map<String, AnalysisMethod> map2) {
        c c2 = null;
        com.oracle.svm.enterprise.hosted.pgo.loaders.a a2 = new com.oracle.svm.enterprise.hosted.pgo.loaders.a(map, map2);
        if (this.collectedProfiles != null) {
            c2 = (c)a2.loadProfile(this.collectedProfiles, (Long)a.PGOProfilesNormalizationValue.getValue(), ProfileData.ProfileSource.PROFILED);
            this.collectedProfiles = null;
        }
        c c3 = null;
        if (this.collectedAdoptedProfiles != null) {
            c3 = (c)a2.loadProfile(this.collectedAdoptedProfiles, (Long)a.PGOAdoptedProfilesNormalizationValue.getValue(), ProfileData.ProfileSource.ADOPTED);
            this.collectedAdoptedProfiles = null;
        }
        assert (c2 != null || c3 != null);
        ImageSingletons.add(PGOProfilesLookup.class, (Object)new com.oracle.svm.enterprise.hosted.pgo.profiles.b(c2, c3, (String)a.PGOExcludeProfiles.getValue()));
    }

    static {
        excludeToIprofKeyMap.put("CALL_COUNT", "callCountProfiles");
        excludeToIprofKeyMap.put("VIRTUAL_INVOKE", "virtualInvokeProfiles");
        excludeToIprofKeyMap.put("CONDITIONAL", "conditionalProfiles");
        excludeToIprofKeyMap.put("MONITOR", "monitorProfiles");
        excludeToIprofKeyMap.put("SAMPLER", "samplingProfiles");
    }

    public static class a {
        @APIOption(name={"pgo"}, defaultValue={"default.iprof"})
        @BundleMember(role=BundleMember.Role.Input)
        static final HostedOptionKey<AccumulatingLocatableMultiOptionValue.Paths> PGOEnabled = new HostedOptionKey<AccumulatingLocatableMultiOptionValue.Paths>(AccumulatingLocatableMultiOptionValue.Paths.buildWithCommaDelimiter(), PGOFeature::validatePGOOption){

            public void update(EconomicMap<OptionKey<?>, Object> economicMap, Object object) {
                super.update(economicMap, object);
                SubstrateOptions.Optimize.update(economicMap, (Object)String.valueOf(SubstrateOptions.OptimizationLevel.O3.getOptionSwitch()));
                bc.AOTPriorityInline.update(economicMap, (Object)true);
                GraalOptions.TrackNodeSourcePosition.update(economicMap, (Object)true);
                PGOContextSensitivityEnabled.update(economicMap, (Object)true);
                com.oracle.svm.enterprise.hosted.cai.b.ContextAwareInlining.update(economicMap, (Object)true);
                a.b.MLProfileInference.update(economicMap, (Object)false);
                CompilerConfigurationFactory.setNativeImageLocationQualifier((String)PGOFeature.PGO_OPTIMIZED_QUALIFIER);
            }
        };
        @BundleMember(role=BundleMember.Role.Input)
        static final HostedOptionKey<AccumulatingLocatableMultiOptionValue.Paths> AdoptedPGOEnabled = new HostedOptionKey<AccumulatingLocatableMultiOptionValue.Paths>(AccumulatingLocatableMultiOptionValue.Paths.buildWithCommaDelimiter()){

            public AccumulatingLocatableMultiOptionValue.Paths f(UnmodifiableEconomicMap<OptionKey<?>, Object> unmodifiableEconomicMap) {
                if (unmodifiableEconomicMap.containsKey((Object)this)) {
                    return (AccumulatingLocatableMultiOptionValue.Paths)unmodifiableEconomicMap.get((Object)this);
                }
                Path path = Paths.get(System.getProperty("java.home"), new String[0]);
                Path path2 = path.resolve(Paths.get("lib", "svm", "adopted_profiles", "jdk_profile.iprof"));
                if (path2.toFile().exists()) {
                    return AccumulatingLocatableMultiOptionValue.Paths.buildWithDefaults((Path[])new Path[]{path2});
                }
                return AccumulatingLocatableMultiOptionValue.Paths.buildWithCommaDelimiter();
            }

            public AccumulatingLocatableMultiOptionValue.Paths d(OptionValues optionValues) {
                return this.f(optionValues.getMap());
            }

            protected void a(EconomicMap<OptionKey<?>, Object> economicMap, AccumulatingLocatableMultiOptionValue.Paths paths, AccumulatingLocatableMultiOptionValue.Paths paths2) {
                com.oracle.svm.enterprise.hosted.cai.b.ContextAwareInlining.update(economicMap, (Object)false);
                bc.AOTPriorityInline.update(economicMap, (Object)true);
                GraalOptions.TrackNodeSourcePosition.update(economicMap, (Object)true);
            }

            protected /* synthetic */ void onValueUpdate(EconomicMap economicMap, Object object, Object object2) {
                this.a(economicMap, (AccumulatingLocatableMultiOptionValue.Paths)object, (AccumulatingLocatableMultiOptionValue.Paths)object2);
            }

            public /* synthetic */ Object getValueOrDefault(UnmodifiableEconomicMap unmodifiableEconomicMap) {
                return this.f(unmodifiableEconomicMap);
            }

            public /* synthetic */ Object getValue(OptionValues optionValues) {
                return this.d(optionValues);
            }
        };
        public static final HostedOptionKey<Boolean> PGOContextSensitivityEnabled = new HostedOptionKey<Boolean>(Boolean.valueOf(true)){

            protected void a(EconomicMap<OptionKey<?>, Object> economicMap, Boolean bl2, Boolean bl3) {
                if (bl3.booleanValue()) {
                    PriorityInliningPhase.b.zu.update(economicMap, (Object)false);
                }
            }

            protected /* synthetic */ void onValueUpdate(EconomicMap economicMap, Object object, Object object2) {
                this.a(economicMap, (Boolean)object, (Boolean)object2);
            }
        };
        static final HostedOptionKey<Long> PGOProfilesNormalizationValue = new HostedOptionKey((Object)1000000000000000L);
        static final HostedOptionKey<Long> PGOAdoptedProfilesNormalizationValue = new HostedOptionKey((Object)100000000000000L);
        public static final HostedOptionKey<Boolean> PGOEnableProfileNormalization = new HostedOptionKey((Object)false);
        public static final HostedOptionKey<Boolean> PGOPrintProfileQualityDetails = new HostedOptionKey((Object)false);
        public static final HostedOptionKey<Boolean> PGOPrintProfileQuality = new HostedOptionKey((Object)false);
        public static final HostedOptionKey<Boolean> PGOIgnoreVersionCheck = new HostedOptionKey((Object)false);
        protected static final HostedOptionKey<String> PGOExcludeProfiles = new HostedOptionKey(null, PGOFeature::validatePGOExcludeProfiles);
        protected static final HostedOptionKey<Boolean> PGOTraceProfileComparison = new HostedOptionKey((Object)false, hostedOptionKey -> {
            if (hostedOptionKey.hasBeenSet()) {
                if (!PGOFeature.isPGOEnabled()) {
                    throw UserError.abort((String)"Can't use PGOTraceProfileComparison without PGO", (Object[])new Object[0]);
                }
                if (((Boolean)ProfilingFeature.Options.UseOldProfilingFramework.getValue()).booleanValue()) {
                    throw UserError.abort((String)"Can't use PGOTraceProfileComparison old profiling framework.", (Object[])new Object[0]);
                }
            }
        });
        public static final HostedOptionKey<String> PGODumpLoadedIprofPath = new HostedOptionKey((Object)"", hostedOptionKey -> {
            if (hostedOptionKey.hasBeenSet()) {
                if (!PGOFeature.isPGOEnabled()) {
                    throw UserError.abort((String)"Can not use PGODumpLoadedIprofPath without PGO", (Object[])new Object[0]);
                }
                if (((Boolean)ProfilingFeature.Options.UseOldProfilingFramework.getValue()).booleanValue()) {
                    throw UserError.abort((String)"Can not use PGODumpLoadedIprofPath old profiling framework.", (Object[])new Object[0]);
                }
            }
        });
    }
}

