/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.hosted.ml.logging;

import com.oracle.svm.util.LogUtils;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeSourcePosition;
import jdk.graal.compiler.nodes.IfNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.cfg.HIRBlock;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.collections.Pair;

public class a {
    private static Map<Pair<ResolvedJavaMethod, IfNode>, a> sV;

    public static void fL() {
        sV = Collections.synchronizedMap(new HashMap());
    }

    public static void fM() {
        sV.clear();
    }

    public static void a(StructuredGraph structuredGraph, IfNode ifNode, double d2, double d3, long l2) {
        ResolvedJavaMethod resolvedJavaMethod = structuredGraph.method();
        Pair pair = Pair.create((Object)resolvedJavaMethod, (Object)ifNode);
        assert (!sV.containsKey(pair));
        StructuredGraph.ScheduleResult scheduleResult = structuredGraph.getLastSchedule();
        HIRBlock hIRBlock = (HIRBlock)scheduleResult.getNodeToBlockMap().get((Node)ifNode);
        sV.put((Pair<ResolvedJavaMethod, IfNode>)pair, new a(d2, d3, l2, ifNode.getNodeSourcePosition(), hIRBlock));
    }

    public static void a(ResolvedJavaMethod resolvedJavaMethod, IfNode ifNode, double d2) {
        Pair pair = Pair.create((Object)resolvedJavaMethod, (Object)ifNode);
        if (sV.containsKey(pair)) {
            sV.get(pair).b(d2);
        }
    }

    public static void c(Path path) {
        try (FileWriter fileWriter = new FileWriter(path.toString());){
            Object object;
            fileWriter.write("Declaring Class,Method Name,Node,NodeSourcePosition,Block,Block Frequency,Profiled Probability,Predicted Probability,Guarded Probability,Global Execution Frequency,Execution Count,Absolute Error,Weighted Absolute Error" + System.lineSeparator());
            long l2 = 0L;
            for (a arrayList2 : sV.values()) {
                l2 += arrayList2.fN();
            }
            for (a a2 : sV.values()) {
                a2.j(l2);
            }
            List<Map.Entry> list = sV.entrySet().stream().sorted(Comparator.comparing(entry -> ((a)entry.getValue()).fO(), Comparator.reverseOrder())).toList();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry2 = (Map.Entry)iterator.next();
                object = (Pair)entry2.getKey();
                a a3 = (a)entry2.getValue();
                fileWriter.write(a3.a((ResolvedJavaMethod)object.getLeft(), (IfNode)object.getRight()) + System.lineSeparator());
            }
            LogUtils.info((String)("Comparison of the ML predicted and dynamically collected profiles dumped to a CSV file: " + String.valueOf(path.toAbsolutePath())));
            ArrayList<Pair> arrayList = new ArrayList<Pair>();
            for (int i2 = 0; i2 < Math.min(list.size(), 10); ++i2) {
                object = ((ResolvedJavaMethod)((Pair)((Map.Entry)list.get(i2)).getKey()).getLeft()).getName();
                if (arrayList.contains(object)) continue;
                arrayList.add((Pair)object);
            }
            LogUtils.info((String)String.format("To inspect the methods with the largest prediction error, please use the following method filter: --method-filter=%s.", String.join((CharSequence)",", arrayList)));
        }
        catch (IOException iOException) {
            com.oracle.svm.enterprise.hosted.ml.features.provider.a.a(iOException.getCause(), "Error writing to CSV file: " + iOException.getMessage(), false);
        }
    }

    private static final class a {
        private final double sW;
        private final double sX;
        private double sY;
        private final long sZ;
        private double ta;
        private double tb;
        private double tc;
        private final NodeSourcePosition td;
        private final HIRBlock te;

        a(double d2, double d3, long l2, NodeSourcePosition nodeSourcePosition, HIRBlock hIRBlock) {
            this.sW = d2;
            this.sX = d3;
            this.sY = Double.NaN;
            this.sZ = l2;
            this.td = nodeSourcePosition;
            this.te = hIRBlock;
        }

        private void b(double d2) {
            this.sY = d2;
        }

        private void j(long l2) {
            this.ta = (double)this.sZ / (double)l2;
            this.tb = Math.abs(this.sX - this.sW);
            this.tc = this.tb * this.ta;
        }

        private long fN() {
            return this.sZ;
        }

        private double fO() {
            return this.tc;
        }

        private String a(ResolvedJavaMethod resolvedJavaMethod, IfNode ifNode) {
            String string = Double.isNaN(this.sY) ? "" : String.format("%.4f", this.sY);
            return String.format("\"%s\",\"%s\",%s,%s,%s,%.4f,%.4f,%.4f,%s,%.12f,%d,%.12f,%.12f", resolvedJavaMethod.getDeclaringClass().toJavaName(true), resolvedJavaMethod.getName(), ifNode, this.td.getBCI(), this.te, this.te.getRelativeFrequency(), this.sW, this.sX, string, this.ta, this.sZ, this.tb, this.tc);
        }
    }
}

