/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.hosted.ml.features;

import com.oracle.graal.compiler.enterprise.ml.features.b;
import com.oracle.svm.enterprise.hosted.ml.features.c;
import com.oracle.svm.enterprise.hosted.ml.features.e;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Field;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeSourcePosition;
import jdk.graal.compiler.nodes.IfNode;
import jdk.graal.compiler.nodes.cfg.HIRBlock;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Equivalence;

public class BlockFeatures
extends com.oracle.graal.compiler.enterprise.ml.features.c
implements com.oracle.svm.enterprise.hosted.ml.features.a {
    @b(n=1)
    private final c nodeTypes;
    @b(n=2)
    private final e csDepth;
    @b(n=3)
    private final e loopDepth;
    @b(n=4)
    private final e dominatorDepth;
    @b(n=5)
    private e assemblySize;
    @b(n=6)
    private e cpuCycles;
    @b(n=7)
    private e cpuCheap;
    @b(n=8)
    private e cpuExpensive;
    @b(n=9)
    private c blockDataFlowHistogram;
    private static final List<Field> orderedFeatures = BlockFeatures.a(BlockFeatures.class);
    private static final List<Field> orderedEncoderFeatures = BlockFeatures.b(BlockFeatures.class, List.of(c.class));
    private final HIRBlock block;
    private final int blockId;
    private final Node endNode;
    private final String blockName;
    private final ArrayList<Integer> outwardIds;
    private final List<Integer> branchesOrder;
    private final Integer blockBCI;
    private Integer isControlSplit;
    private EconomicMap<Integer, Double> label;
    private EconomicMap<Integer, Long> labelCount;

    public BlockFeatures(HIRBlock hIRBlock, String string, int n2, EconomicMap<Class<? extends Node>, Integer> economicMap, int n3, int n4, int n5, int n6, int n7, int n8, int n9, EconomicMap<Class<? extends Node>, Integer> economicMap2) {
        this.block = hIRBlock;
        this.blockName = string;
        this.blockId = n2;
        this.endNode = hIRBlock.getEndNode();
        this.nodeTypes = new c(economicMap);
        this.loopDepth = new e(n4);
        this.csDepth = new e(n3);
        this.dominatorDepth = new e(n5);
        this.assemblySize = new e(n6);
        this.cpuCycles = new e(n7);
        this.cpuCheap = new e(n8);
        this.cpuExpensive = new e(n9);
        this.blockDataFlowHistogram = new c(economicMap2);
        this.outwardIds = new ArrayList();
        for (int i2 = 0; i2 < hIRBlock.getSuccessorCount(); ++i2) {
            HIRBlock hIRBlock2 = (HIRBlock)hIRBlock.getSuccessorAt(i2);
            this.outwardIds.add(hIRBlock2.getId());
        }
        this.blockBCI = BlockFeatures.getNodeSourcePosition((Node)hIRBlock.getBeginNode());
        this.label = EconomicMap.create((Equivalence)Equivalence.DEFAULT);
        this.labelCount = EconomicMap.create((Equivalence)Equivalence.DEFAULT);
        this.isControlSplit = 0;
        this.branchesOrder = new ArrayList<Integer>();
        if (this.endNode instanceof IfNode) {
            this.branchesOrder.add(BlockFeatures.getNodeSourcePosition((Node)((IfNode)this.endNode).trueSuccessor()));
            this.branchesOrder.add(BlockFeatures.getNodeSourcePosition((Node)((IfNode)this.endNode).falseSuccessor()));
        } else {
            for (HIRBlock hIRBlock2 : this.endNode.successors()) {
                this.branchesOrder.add(BlockFeatures.getNodeSourcePosition((Node)hIRBlock2));
            }
        }
    }

    public boolean o() {
        return this.label.size() > 1;
    }

    public List<Integer> a(EconomicMap<String, List<String>> economicMap) {
        return super.a(orderedFeatures, economicMap);
    }

    public a getGraphMLFeaturesMetadata() {
        return new a(this.blockId, this.blockBCI, this.isControlSplit, this.outwardIds, this.branchesOrder, this.endNode);
    }

    public void a(com.oracle.graal.compiler.enterprise.ml.features.serialization.a a2) {
        this.a(BlockFeatures.class, a2);
    }

    protected List<Field> p() {
        return BlockFeatures.a(BlockFeatures.class, List.of("blockId", "blockName", "blockBCI", "outwardIds", "label", "labelCount", "isControlSplit", "branchesOrder", "orderedFeatures", "orderedEncoderFeatures"));
    }

    @Override
    public void setLabel(EconomicMap<Integer, Double> economicMap, EconomicMap<Integer, Long> economicMap2) {
        this.label = economicMap;
        this.labelCount = economicMap2;
        this.isControlSplit = 1;
    }

    public HIRBlock getBlock() {
        return this.block;
    }

    public Node getEndNode() {
        return this.endNode;
    }

    public List<Integer> getBranchesOrder() {
        return this.branchesOrder;
    }

    private static int getNodeSourcePosition(Node node) {
        NodeSourcePosition nodeSourcePosition = node.getNodeSourcePosition();
        return nodeSourcePosition != null ? nodeSourcePosition.getBCI() : -1;
    }

    public c getNodeTypes() {
        return this.nodeTypes;
    }

    public e getCsDepth() {
        return this.csDepth;
    }

    public e getLoopDepth() {
        return this.loopDepth;
    }

    public e getDominatorDepth() {
        return this.dominatorDepth;
    }

    public e getAssemblySize() {
        return this.assemblySize;
    }

    public e getCpuCycles() {
        return this.cpuCycles;
    }

    public e getCpuCheap() {
        return this.cpuCheap;
    }

    public e getCpuExpensive() {
        return this.cpuExpensive;
    }

    public c getBlockDataFlowHistogram() {
        return this.blockDataFlowHistogram;
    }

    @Override
    public long getLabelCount() {
        long l2 = 0L;
        Iterator iterator = this.labelCount.getValues().iterator();
        while (iterator.hasNext()) {
            long l3 = (Long)iterator.next();
            l2 += l3;
        }
        return l2;
    }

    public static final class a
    extends Record {
        private final Integer st;
        private final Integer su;
        private final Integer sv;
        private final ArrayList<Integer> sw;
        private final List<Integer> sx;
        private final Node sy;

        public a(Integer n2, Integer n3, Integer n4, ArrayList<Integer> arrayList, List<Integer> list, Node node) {
            this.st = n2;
            this.su = n3;
            this.sv = n4;
            this.sw = arrayList;
            this.sx = list;
            this.sy = node;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "blockId;blockBCI;isControlSplit;outwardIds;branchesOrder;endNode", "st", "su", "sv", "sw", "sx", "sy"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "blockId;blockBCI;isControlSplit;outwardIds;branchesOrder;endNode", "st", "su", "sv", "sw", "sx", "sy"}, this);
        }

        @Override
        public final boolean equals(Object object) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "blockId;blockBCI;isControlSplit;outwardIds;branchesOrder;endNode", "st", "su", "sv", "sw", "sx", "sy"}, this, object);
        }

        public Integer fs() {
            return this.st;
        }

        public Integer ft() {
            return this.su;
        }

        public Integer fu() {
            return this.sv;
        }

        public ArrayList<Integer> fv() {
            return this.sw;
        }

        public List<Integer> fw() {
            return this.sx;
        }

        public Node fx() {
            return this.sy;
        }
    }
}

