/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.enterprise.gc.g1.hosted;

import com.oracle.svm.core.GCRelatedMXBeans;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.SubstrateTargetDescription;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.config.ObjectLayout;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.graal.meta.RuntimeConfiguration;
import com.oracle.svm.core.graal.meta.SubstrateForeignCallsProvider;
import com.oracle.svm.core.graal.snippets.GCAllocationSupport;
import com.oracle.svm.core.graal.snippets.NodeLoweringProvider;
import com.oracle.svm.core.graal.snippets.SubstrateAllocationSnippets;
import com.oracle.svm.core.heap.AllocationFeature;
import com.oracle.svm.core.heap.BarrierSetProvider;
import com.oracle.svm.core.heap.FillerArray;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.heap.PhysicalMemory;
import com.oracle.svm.core.image.ImageHeapLayouter;
import com.oracle.svm.core.jvmstat.PerfDataFeature;
import com.oracle.svm.core.jvmstat.PerfManager;
import com.oracle.svm.core.option.SubstrateOptionKey;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.os.CommittedMemoryProvider;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.enterprise.core.auximage.AuxiliaryImageBuilder;
import com.oracle.svm.enterprise.core.bc;
import com.oracle.svm.enterprise.gc.g1.G1PerfData;
import com.oracle.svm.enterprise.gc.g1.a;
import com.oracle.svm.enterprise.gc.g1.e;
import com.oracle.svm.enterprise.gc.g1.g;
import com.oracle.svm.enterprise.gc.g1.graal.j;
import com.oracle.svm.enterprise.gc.g1.hosted.d;
import com.oracle.svm.enterprise.gc.g1.j;
import com.oracle.svm.enterprise.gc.g1.l;
import com.oracle.svm.enterprise.gc.g1.m;
import com.oracle.svm.enterprise.gc.g1.o;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.thread.VMThreadFeature;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.options.OptionValues;
import jdk.graal.compiler.phases.util.Providers;
import jdk.graal.compiler.replacements.SnippetCounter;
import jdk.vm.ci.code.CodeUtil;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.impl.PinnedObjectSupport;

@AutomaticallyRegisteredFeature
public class b
implements InternalFeature {
    @Platforms(value={Platform.HOSTED_ONLY.class})
    public b() {
    }

    public boolean isInConfiguration(Feature.IsInConfigurationAccess isInConfigurationAccess) {
        return SubstrateOptions.useG1GC();
    }

    public List<Class<? extends Feature>> getRequiredFeatures() {
        return Arrays.asList(VMThreadFeature.class, PerfDataFeature.class, AllocationFeature.class);
    }

    public void afterRegistration(Feature.AfterRegistrationAccess afterRegistrationAccess) {
        b.dL();
        ImageSingletons.add(BarrierSetProvider.class, (Object)new com.oracle.svm.enterprise.gc.g1.graal.b());
        ImageSingletons.add(ObjectLayout.class, (Object)b.dM());
        a a2 = new a();
        ImageSingletons.add(CommittedMemoryProvider.class, (Object)((Object)a2));
        ImageSingletons.add(a.class, (Object)((Object)a2));
        ImageSingletons.add(PhysicalMemory.PhysicalMemorySupport.class, (Object)((Object)new l()));
        ImageSingletons.add(GCRelatedMXBeans.class, (Object)((Object)new o()));
    }

    public void duringSetup(Feature.DuringSetupAccess duringSetupAccess) {
        G1PerfData g1PerfData = null;
        if (ImageSingletons.contains(PerfManager.class)) {
            g1PerfData = new G1PerfData();
        }
        e e2 = new e(SubstrateOptions.getPageSize(), g1PerfData);
        ImageSingletons.add(Heap.class, (Object)((Object)e2));
        ImageSingletons.add(e.class, (Object)((Object)e2));
        ImageSingletons.add(GCAllocationSupport.class, (Object)new com.oracle.svm.enterprise.gc.g1.graal.a());
        m m2 = new m();
        ImageSingletons.add(PinnedObjectSupport.class, (Object)m2);
        ImageSingletons.add(m.class, (Object)m2);
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess beforeAnalysisAccess) {
        FeatureImpl.BeforeAnalysisAccessImpl beforeAnalysisAccessImpl = (FeatureImpl.BeforeAnalysisAccessImpl)beforeAnalysisAccess;
        com.oracle.svm.enterprise.gc.g1.hosted.a.b(beforeAnalysisAccessImpl);
        beforeAnalysisAccessImpl.registerAsUsed(FillerArray.class);
        beforeAnalysisAccessImpl.registerAsUsed(Object[].class);
        j.a(beforeAnalysisAccessImpl);
        beforeAnalysisAccess.registerReachabilityHandler(duringAnalysisAccess -> {
            throw UserError.abort((String)"The G1 garbage collector ('--gc=G1') does not support auxiliary images.", (Object[])new Object[0]);
        }, new Object[]{AuxiliaryImageBuilder.class});
    }

    public void afterAnalysis(Feature.AfterAnalysisAccess afterAnalysisAccess) {
        ImageSingletons.add(ImageHeapLayouter.class, (Object)new d());
    }

    public void beforeCompilation(Feature.BeforeCompilationAccess beforeCompilationAccess) {
        FeatureImpl.BeforeCompilationAccessImpl beforeCompilationAccessImpl = (FeatureImpl.BeforeCompilationAccessImpl)beforeCompilationAccess;
        e e2 = e.get();
        g g2 = e.getImageHeapInfo();
        beforeCompilationAccessImpl.registerAsImmutable((Object)g2);
        beforeCompilationAccessImpl.registerAsImmutable((Object)g2.dk());
        beforeCompilationAccessImpl.registerAsImmutable((Object)g2.dl());
        byte[] byArray = com.oracle.svm.enterprise.gc.g1.hosted.a.a((Feature.BeforeCompilationAccess)beforeCompilationAccessImpl);
        e2.a(byArray);
        beforeCompilationAccessImpl.registerAsImmutable((Object)byArray);
    }

    public void registerForeignCalls(SubstrateForeignCallsProvider substrateForeignCallsProvider) {
        com.oracle.svm.enterprise.gc.g1.graal.j.registerForeignCalls(substrateForeignCallsProvider);
        com.oracle.svm.enterprise.gc.g1.graal.a.registerForeignCalls(substrateForeignCallsProvider);
    }

    public void registerLowerings(RuntimeConfiguration runtimeConfiguration, OptionValues optionValues, Providers providers, Map<Class<? extends Node>, NodeLoweringProvider<?>> map, boolean bl2) {
        SubstrateAllocationSnippets substrateAllocationSnippets = (SubstrateAllocationSnippets)ImageSingletons.lookup(SubstrateAllocationSnippets.class);
        SubstrateAllocationSnippets.Templates templates = new SubstrateAllocationSnippets.Templates(optionValues, providers, substrateAllocationSnippets);
        templates.registerLowering(map);
        j.b b2 = new j.b(optionValues, SnippetCounter.Group.NullFactory, providers);
        b2.registerLowerings(map);
    }

    private static void dL() {
        UserError.guarantee((Platform.includedIn(Platform.LINUX_AMD64.class) || Platform.includedIn(Platform.LINUX_AARCH64.class) ? 1 : 0) != 0, (String)"The G1 garbage collector ('--gc=G1') is currently only supported on Linux AMD64 and AArch64.", (Object[])new Object[0]);
        UserError.guarantee((!SubstrateOptions.useSerialGC() ? 1 : 0) != 0, (String)"Only one garbage collector can be used at a time.", (Object[])new Object[0]);
        UserError.guarantee((!SubstrateOptions.useEpsilonGC() ? 1 : 0) != 0, (String)"Only one garbage collector can be used at a time.", (Object[])new Object[0]);
        b.a((SubstrateOptionKey<Boolean>)SubstrateOptions.SpawnIsolates);
        b.a((SubstrateOptionKey<Boolean>)SubstrateOptions.AllowVMInternalThreads);
        b.a((SubstrateOptionKey<Boolean>)SubstrateOptions.ConcealedOptions.UseDedicatedVMOperationThread);
        b.a((SubstrateOptionKey<Boolean>)SubstrateOptions.ConcealedOptions.AutomaticReferenceHandling);
        b.a((SubstrateOptionKey<Boolean>)SubstrateOptions.UseNullRegion);
        UserError.guarantee(((Long)bc.ReservedAuxiliaryImageBytes.getValue() == 0L ? 1 : 0) != 0, (String)"The G1 garbage collector ('--gc=G1') does not support auxiliary images.", (Object[])new Object[0]);
        UserError.guarantee((!SubstrateOptions.supportCompileInIsolates() ? 1 : 0) != 0, (String)"The G1 garbage collector ('--gc=G1') does not support isolated compilation.", (Object[])new Object[0]);
        UserError.guarantee(((Boolean)bc.ProtectionKeys.getValue() == false ? 1 : 0) != 0, (String)"The G1 garbage collector ('--gc=G1') is not compatible with %s.", (Object[])new Object[]{SubstrateOptionsParser.commandArgument(bc.ProtectionKeys, (String)"+")});
    }

    private static void a(SubstrateOptionKey<Boolean> substrateOptionKey) {
        String string = "When using the G1 garbage collector ('--gc=G1'), please note that option '%s' must be enabled.";
        UserError.guarantee((boolean)((Boolean)substrateOptionKey.getValue()), (String)string, (Object[])new Object[]{substrateOptionKey.getName()});
    }

    private static ObjectLayout dM() {
        SubstrateTargetDescription substrateTargetDescription = ConfigurationValues.getTarget();
        int n2 = b.a(substrateTargetDescription);
        int n3 = substrateTargetDescription.arch.getPlatformKind(JavaKind.Int).getSizeInBytes();
        int n4 = 8;
        int n5 = 0;
        int n6 = n5 + 2 * n2 + (Integer)SubstrateOptions.AdditionalHeaderBytes.getValue();
        int n7 = b.c(n5, n2);
        int n8 = n6;
        int n9 = n6;
        int n10 = n9 + n3;
        return new ObjectLayout(substrateTargetDescription, n2, n4, n5, n8, n9, n10, n7, ObjectLayout.IdentityHashMode.OBJECT_HEADER);
    }

    private static int c(int n2, int n3) {
        if (bc.useCompressedReferences()) {
            return n2 + n3;
        }
        assert (CodeUtil.isPowerOf2((int)n3));
        return n2 + n3 + (n3 >>> 1);
    }

    private static int a(SubstrateTargetDescription substrateTargetDescription) {
        JavaKind javaKind = JavaKind.Object;
        if (bc.useCompressedReferences()) {
            javaKind = JavaKind.Int;
        }
        return substrateTargetDescription.arch.getPlatformKind(javaKind).getSizeInBytes();
    }
}

