/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.substitute;

import com.oracle.graal.pointsto.infrastructure.OriginalFieldProvider;
import com.oracle.svm.hosted.annotation.AnnotationValue;
import com.oracle.svm.hosted.annotation.AnnotationWrapper;
import com.oracle.svm.hosted.annotation.SubstrateAnnotationExtractor;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaType;

public class AnnotatedField
implements ResolvedJavaField,
OriginalFieldProvider,
AnnotationWrapper {
    private final ResolvedJavaField original;
    private final AnnotationValue[] injectedAnnotations;

    public AnnotatedField(ResolvedJavaField original, Annotation injectedAnnotation) {
        this.original = original;
        this.injectedAnnotations = SubstrateAnnotationExtractor.prepareInjectedAnnotations(injectedAnnotation);
    }

    @Override
    public AnnotatedElement getAnnotationRoot() {
        return this.original;
    }

    @Override
    public AnnotationValue[] getInjectedAnnotations() {
        return this.injectedAnnotations;
    }

    public String getName() {
        return this.original.getName();
    }

    public JavaType getType() {
        return this.original.getType();
    }

    public int getModifiers() {
        return this.original.getModifiers();
    }

    public int getOffset() {
        return this.original.getOffset();
    }

    public boolean isInternal() {
        return this.original.isInternal();
    }

    public boolean isSynthetic() {
        return this.original.isSynthetic();
    }

    public ResolvedJavaType getDeclaringClass() {
        return this.original.getDeclaringClass();
    }

    public String toString() {
        return "AnnotatedField<original " + this.original.toString() + ", annotation: " + String.valueOf(this.injectedAnnotations[0].getType()) + ">";
    }

    public ResolvedJavaField unwrapTowardsOriginalField() {
        return this.original;
    }

    public JavaConstant getConstantValue() {
        return this.original.getConstantValue();
    }
}

