/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.reflect.serialize;

import com.oracle.svm.core.reflect.SubstrateConstructorAccessor;
import com.oracle.svm.core.reflect.serialize.SerializationRegistry;
import com.oracle.svm.core.reflect.serialize.SerializationSupport;
import com.oracle.svm.core.reflect.target.ReflectionSubstitutionSupport;
import com.oracle.svm.core.util.BasedOnJDKFile;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.ConditionalConfigurationRegistry;
import com.oracle.svm.hosted.ConfigurationTypeResolver;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.reflect.RecordUtils;
import com.oracle.svm.hosted.reflect.proxy.ProxyRegistry;
import com.oracle.svm.hosted.reflect.serialize.SerializationDenyRegistry;
import com.oracle.svm.hosted.reflect.serialize.SerializationFeature;
import com.oracle.svm.util.LogUtils;
import com.oracle.svm.util.ReflectionUtil;
import java.io.Externalizable;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import jdk.graal.compiler.serviceprovider.JavaVersionUtil;
import jdk.internal.access.JavaLangReflectAccess;
import jdk.internal.reflect.ConstructorAccessor;
import jdk.internal.reflect.ReflectionFactory;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeReflection;
import org.graalvm.nativeimage.impl.ConfigurationCondition;
import org.graalvm.nativeimage.impl.RuntimeReflectionSupport;
import org.graalvm.nativeimage.impl.RuntimeSerializationSupport;

final class SerializationBuilder
extends ConditionalConfigurationRegistry
implements RuntimeSerializationSupport<ConfigurationCondition> {
    private static final Method getConstructorAccessorMethod = ReflectionUtil.lookupMethod(Constructor.class, (String)"getConstructorAccessor", (Class[])new Class[0]);
    private static final Method getExternalizableConstructorMethod = ReflectionUtil.lookupMethod(ObjectStreamClass.class, (String)"getExternalizableConstructor", (Class[])new Class[]{Class.class});
    private Constructor<?> stubConstructor;
    private final Field descField;
    private final Method getDataLayoutMethod;
    final SerializationSupport serializationSupport;
    private final SerializationDenyRegistry denyRegistry;
    private final ConfigurationTypeResolver typeResolver;
    private final FeatureImpl.DuringSetupAccessImpl access;
    private final Method disableSerialConstructorChecks;
    private final Method superHasAccessibleConstructor;
    private final Method packageEquals;
    private boolean sealed;
    private final ProxyRegistry proxyRegistry;
    private List<Runnable> pendingConstructorRegistrations;

    SerializationBuilder(SerializationDenyRegistry serializationDenyRegistry, FeatureImpl.DuringSetupAccessImpl access, ConfigurationTypeResolver typeResolver, ProxyRegistry proxyRegistry) {
        this.access = access;
        Class<?> classDataSlotClazz = access.findClassByName("java.io.ObjectStreamClass$ClassDataSlot");
        this.descField = ReflectionUtil.lookupField(classDataSlotClazz, (String)"desc");
        this.getDataLayoutMethod = ReflectionUtil.lookupMethod(ObjectStreamClass.class, (String)"getClassDataLayout", (Class[])new Class[0]);
        this.disableSerialConstructorChecks = ReflectionUtil.lookupMethod((boolean)true, ReflectionFactory.class, (String)"disableSerialConstructorChecks", (Class[])new Class[0]);
        this.superHasAccessibleConstructor = ReflectionUtil.lookupMethod(ReflectionFactory.class, (String)"superHasAccessibleConstructor", (Class[])new Class[]{Class.class});
        this.packageEquals = ReflectionUtil.lookupMethod(ReflectionFactory.class, (String)"packageEquals", (Class[])new Class[]{Class.class, Class.class});
        this.pendingConstructorRegistrations = new ArrayList<Runnable>();
        this.denyRegistry = serializationDenyRegistry;
        this.typeResolver = typeResolver;
        this.proxyRegistry = proxyRegistry;
        this.serializationSupport = new SerializationSupport();
        ImageSingletons.add(SerializationRegistry.class, (Object)this.serializationSupport);
    }

    private void abortIfSealed() {
        UserError.guarantee(!this.sealed, "Too late to add classes for serialization. Registration must happen in a Feature before the analysis has finished.", new Object[0]);
    }

    public void registerIncludingAssociatedClasses(ConfigurationCondition condition, Class<?> clazz) {
        this.registerIncludingAssociatedClasses(condition, clazz, new HashSet());
    }

    private void registerIncludingAssociatedClasses(ConfigurationCondition condition, Class<?> clazz, Set<Class<?>> alreadyVisited) {
        if (alreadyVisited.contains(clazz)) {
            return;
        }
        alreadyVisited.add(clazz);
        String targetClassName = clazz.getName();
        if (clazz.isPrimitive()) {
            Class boxedType = JavaKind.fromJavaClass(clazz).toBoxedJavaClass();
            this.registerIncludingAssociatedClasses(condition, boxedType, alreadyVisited);
            return;
        }
        if (!Serializable.class.isAssignableFrom(clazz)) {
            return;
        }
        if (this.access.findSubclasses(clazz).size() > 1) {
            LogUtils.warning((String)"Class %s has subclasses. No classes were registered for object serialization.", (Object[])new Object[]{targetClassName});
            return;
        }
        try {
            clazz.getDeclaredMethod("writeObject", ObjectOutputStream.class);
            LogUtils.warning((String)"Class %s implements its own writeObject method for object serialization. Any serialization types it uses need to be explicitly registered.", (Object[])new Object[]{targetClassName});
            return;
        }
        catch (NoSuchMethodException boxedType) {
            this.register(condition, clazz);
            if (clazz.isArray()) {
                this.registerIncludingAssociatedClasses(condition, clazz.getComponentType(), alreadyVisited);
                return;
            }
            ObjectStreamClass osc = ObjectStreamClass.lookup(clazz);
            try {
                for (Object o : (Object[])this.getDataLayoutMethod.invoke((Object)osc, new Object[0])) {
                    ObjectStreamClass desc = (ObjectStreamClass)this.descField.get(o);
                    if (desc.equals(osc)) continue;
                    this.registerIncludingAssociatedClasses(condition, desc.forClass(), alreadyVisited);
                }
            }
            catch (ReflectiveOperationException e) {
                throw VMError.shouldNotReachHere("Cannot register serialization classes due to", e);
            }
            for (ObjectStreamField field : osc.getFields()) {
                this.registerIncludingAssociatedClasses(condition, field.getType(), alreadyVisited);
            }
            return;
        }
    }

    public void register(ConfigurationCondition condition, Class<?> ... classes) {
        for (Class<?> clazz : classes) {
            this.registerWithTargetConstructorClass(condition, clazz, null);
        }
    }

    public void registerLambdaCapturingClass(ConfigurationCondition condition, String lambdaCapturingClassName) {
        this.abortIfSealed();
        Class<?> lambdaCapturingClass = this.typeResolver.resolveType(lambdaCapturingClassName);
        if (lambdaCapturingClass == null || lambdaCapturingClass.isPrimitive() || lambdaCapturingClass.isArray()) {
            return;
        }
        if (ReflectionUtil.lookupMethod((boolean)true, lambdaCapturingClass, (String)"$deserializeLambda$", (Class[])new Class[]{SerializedLambda.class}) == null) {
            LogUtils.warning((String)"Could not register %s for lambda serialization as it does not capture any serializable lambda.", (Object[])new Object[]{lambdaCapturingClass});
            return;
        }
        this.registerConditionalConfiguration(condition, cnd -> {
            ((SerializationFeature)ImageSingletons.lookup(SerializationFeature.class)).capturingClasses.add(lambdaCapturingClass);
            RuntimeReflection.register((Class[])new Class[]{lambdaCapturingClass});
            RuntimeReflection.register((Executable[])new Executable[]{ReflectionUtil.lookupMethod((Class)lambdaCapturingClass, (String)"$deserializeLambda$", (Class[])new Class[]{SerializedLambda.class})});
            SerializationSupport.singleton().registerLambdaCapturingClass((ConfigurationCondition)cnd, lambdaCapturingClassName);
        });
    }

    public void registerProxyClass(ConfigurationCondition condition, List<String> implementedInterfaces) {
        this.registerConditionalConfiguration(condition, cnd -> {
            Class<?> proxyClass = this.proxyRegistry.createProxyClassForSerialization(implementedInterfaces);
            this.registerWithTargetConstructorClass((ConfigurationCondition)cnd, proxyClass, (Class<?>)Object.class);
        });
    }

    public void registerWithTargetConstructorClass(ConfigurationCondition condition, String targetClassName, String customTargetConstructorClassName) {
        this.abortIfSealed();
        Class<?> serializationTargetClass = this.typeResolver.resolveType(targetClassName);
        ((RuntimeReflectionSupport)ImageSingletons.lookup(RuntimeReflectionSupport.class)).registerClassLookup(condition, targetClassName);
        if (serializationTargetClass == null) {
            return;
        }
        if (customTargetConstructorClassName != null) {
            Class<?> customTargetConstructorClass = this.typeResolver.resolveType(customTargetConstructorClassName);
            if (customTargetConstructorClass == null) {
                return;
            }
            this.registerWithTargetConstructorClass(condition, serializationTargetClass, customTargetConstructorClass);
        } else {
            this.registerWithTargetConstructorClass(condition, serializationTargetClass, null);
        }
    }

    public void registerWithTargetConstructorClass(ConfigurationCondition condition, Class<?> serializationTargetClass, Class<?> customTargetConstructorClass) {
        this.abortIfSealed();
        this.registerConditionalConfiguration(condition, cnd -> {
            ((RuntimeReflectionSupport)ImageSingletons.lookup(RuntimeReflectionSupport.class)).register(condition, new Class[]{serializationTargetClass});
            if (!Serializable.class.isAssignableFrom(serializationTargetClass)) {
                return;
            }
            RuntimeReflection.register((Class[])new Class[]{ObjectOutputStream.class});
            if (this.denyRegistry.isAllowed(serializationTargetClass)) {
                if (customTargetConstructorClass != null) {
                    if (!customTargetConstructorClass.isAssignableFrom(serializationTargetClass)) {
                        LogUtils.warning((String)"The given customTargetConstructorClass %s is not a superclass of the serialization target %s.", (Object[])new Object[]{customTargetConstructorClass.getName(), serializationTargetClass});
                        return;
                    }
                    if (ReflectionUtil.lookupConstructor((boolean)true, (Class)customTargetConstructorClass, (Class[])new Class[0]) == null) {
                        LogUtils.warning((String)"The given customTargetConstructorClass %s does not declare a parameterless constructor.", (Object[])new Object[]{customTargetConstructorClass.getName()});
                        return;
                    }
                }
                this.addOrQueueConstructorAccessor((ConfigurationCondition)cnd, serializationTargetClass, customTargetConstructorClass);
                Class superclass = serializationTargetClass.getSuperclass();
                if (superclass != null) {
                    ((RuntimeReflectionSupport)ImageSingletons.lookup(RuntimeReflectionSupport.class)).registerAllDeclaredConstructorsQuery(ConfigurationCondition.alwaysTrue(), true, superclass);
                    ((RuntimeReflectionSupport)ImageSingletons.lookup(RuntimeReflectionSupport.class)).registerMethodLookup(ConfigurationCondition.alwaysTrue(), superclass, "writeReplace", new Class[0]);
                    ((RuntimeReflectionSupport)ImageSingletons.lookup(RuntimeReflectionSupport.class)).registerMethodLookup(ConfigurationCondition.alwaysTrue(), superclass, "readResolve", new Class[0]);
                }
                this.registerForSerialization((ConfigurationCondition)cnd, serializationTargetClass);
                SerializationBuilder.registerForDeserialization(cnd, serializationTargetClass);
            }
        });
    }

    private void addOrQueueConstructorAccessor(ConfigurationCondition cnd, Class<?> serializationTargetClass, Class<?> customTargetConstructorClass) {
        if (this.pendingConstructorRegistrations != null) {
            this.pendingConstructorRegistrations.add(() -> this.registerConstructorAccessor(cnd, serializationTargetClass, customTargetConstructorClass));
        } else {
            this.registerConstructorAccessor(cnd, serializationTargetClass, customTargetConstructorClass);
        }
    }

    private void registerConstructorAccessor(ConfigurationCondition cnd, Class<?> serializationTargetClass, Class<?> customTargetConstructorClass) {
        Optional.ofNullable(this.addConstructorAccessor(cnd, serializationTargetClass, customTargetConstructorClass)).map(x$0 -> ReflectionUtil.lookupConstructor((Class)x$0, (Class[])new Class[0])).ifPresent(methods -> ((RuntimeReflectionSupport)ImageSingletons.lookup(RuntimeReflectionSupport.class)).register(ConfigurationCondition.alwaysTrue(), false, new Executable[]{methods}));
    }

    void beforeAnalysis(Feature.BeforeAnalysisAccess beforeAnalysisAccess) {
        this.setAnalysisAccess(beforeAnalysisAccess);
        this.stubConstructor = this.newConstructorForSerialization(SerializationSupport.StubForAbstractClass.class, null);
        this.pendingConstructorRegistrations.forEach(Runnable::run);
        this.pendingConstructorRegistrations = null;
        this.serializationSupport.setStubConstructor(this.stubConstructor);
    }

    private static void registerQueriesForInheritableMethod(Class<?> clazz, String methodName, Class<?> ... args) {
        for (Class<?> iter = clazz; iter != null; iter = iter.getSuperclass()) {
            RuntimeReflection.registerMethodLookup(iter, (String)methodName, (Class[])args);
            Method method = ReflectionUtil.lookupMethod((boolean)true, clazz, (String)methodName, (Class[])args);
            if (method == null) continue;
            RuntimeReflection.register((Executable[])new Executable[]{method});
            break;
        }
    }

    private static void registerMethod(ConfigurationCondition cnd, Class<?> clazz, String methodName, Class<?> ... args) {
        Method method = ReflectionUtil.lookupMethod((boolean)true, clazz, (String)methodName, (Class[])args);
        if (method != null) {
            ((RuntimeReflectionSupport)ImageSingletons.lookup(RuntimeReflectionSupport.class)).register(cnd, false, new Executable[]{method});
        } else {
            RuntimeReflection.registerMethodLookup(clazz, (String)methodName, (Class[])args);
        }
    }

    private void registerForSerialization(ConfigurationCondition cnd, Class<?> serializationTargetClass) {
        if (Serializable.class.isAssignableFrom(serializationTargetClass)) {
            SerializationBuilder.registerSerializationUIDElements(serializationTargetClass, true);
            Class<?> initCl = serializationTargetClass;
            boolean initClValid = true;
            while (Serializable.class.isAssignableFrom(initCl)) {
                Class<?> prev = initCl;
                RuntimeReflection.registerAllDeclaredConstructors(initCl);
                if ((initCl = initCl.getSuperclass()) != null && (this.disableSerialConstructorChecks() || prev.isArray() || this.superHasAccessibleConstructor(prev))) continue;
                initClValid = false;
                break;
            }
            if (initClValid) {
                RuntimeReflection.registerAllDeclaredConstructors(initCl);
            }
            for (Class<?> iter = serializationTargetClass; iter != null; iter = iter.getSuperclass()) {
                Arrays.stream(iter.getDeclaredFields()).map(Field::getType).forEach(type -> {
                    RuntimeReflection.registerAllDeclaredMethods((Class)type);
                    RuntimeReflection.registerAllDeclaredFields((Class)type);
                    RuntimeReflection.registerAllDeclaredConstructors((Class)type);
                });
            }
        }
        SerializationBuilder.registerQueriesForInheritableMethod(serializationTargetClass, "writeReplace", new Class[0]);
        SerializationBuilder.registerQueriesForInheritableMethod(serializationTargetClass, "readResolve", new Class[0]);
        SerializationBuilder.registerMethod(cnd, serializationTargetClass, "writeObject", ObjectOutputStream.class);
        SerializationBuilder.registerMethod(cnd, serializationTargetClass, "readObjectNoData", new Class[0]);
        SerializationBuilder.registerMethod(cnd, serializationTargetClass, "readObject", ObjectInputStream.class);
    }

    static void registerSerializationUIDElements(Class<?> serializationTargetClass, boolean fullyRegister) {
        RuntimeReflection.registerAllDeclaredConstructors(serializationTargetClass);
        RuntimeReflection.registerAllDeclaredMethods(serializationTargetClass);
        RuntimeReflection.registerAllDeclaredFields(serializationTargetClass);
        if (fullyRegister) {
            RuntimeReflection.register((Executable[])serializationTargetClass.getDeclaredConstructors());
            RuntimeReflection.register((Executable[])serializationTargetClass.getDeclaredMethods());
            RuntimeReflection.register((Field[])serializationTargetClass.getDeclaredFields());
        }
        RuntimeReflection.registerFieldLookup(serializationTargetClass, (String)"serialPersistentFields");
    }

    public void afterAnalysis() {
        this.sealed = true;
    }

    private static void registerForDeserialization(ConfigurationCondition cnd, Class<?> serializationTargetClass) {
        ((RuntimeReflectionSupport)ImageSingletons.lookup(RuntimeReflectionSupport.class)).register(cnd, new Class[]{serializationTargetClass});
        if (serializationTargetClass.isRecord()) {
            Executable[] methods = new Executable[]{RecordUtils.getCanonicalRecordConstructor(serializationTargetClass)};
            ((RuntimeReflectionSupport)ImageSingletons.lookup(RuntimeReflectionSupport.class)).register(cnd, false, methods);
            ((RuntimeReflectionSupport)ImageSingletons.lookup(RuntimeReflectionSupport.class)).registerAllRecordComponentsQuery(cnd, serializationTargetClass);
            Executable[] methods1 = RecordUtils.getRecordComponentAccessorMethods(serializationTargetClass);
            ((RuntimeReflectionSupport)ImageSingletons.lookup(RuntimeReflectionSupport.class)).register(cnd, false, methods1);
        } else if (Externalizable.class.isAssignableFrom(serializationTargetClass)) {
            RuntimeReflection.registerConstructorLookup(serializationTargetClass, (Class[])new Class[0]);
        }
        SerializationBuilder.registerMethod(cnd, serializationTargetClass, "readObject", ObjectInputStream.class);
        SerializationBuilder.registerMethod(cnd, serializationTargetClass, "readResolve", new Class[0]);
    }

    private Constructor<?> newConstructorForSerialization(Class<?> serializationTargetClass, Constructor<?> customConstructorToCall) {
        if (JavaVersionUtil.JAVA_SPEC <= 21) {
            if (customConstructorToCall == null) {
                return ReflectionFactory.getReflectionFactory().newConstructorForSerialization(serializationTargetClass);
            }
            return ReflectionFactory.getReflectionFactory().newConstructorForSerialization(serializationTargetClass, customConstructorToCall);
        }
        Constructor<?> constructorToCall = customConstructorToCall == null ? this.getConstructorForSerialization(serializationTargetClass) : customConstructorToCall;
        ConstructorAccessor acc = SerializationBuilder.getConstructorAccessor(serializationTargetClass, constructorToCall);
        JavaLangReflectAccess langReflectAccess = (JavaLangReflectAccess)ReflectionUtil.readField(ReflectionFactory.class, (String)"langReflectAccess", (Object)ReflectionFactory.getReflectionFactory());
        Method newConstructorWithAccessor = ReflectionUtil.lookupMethod(JavaLangReflectAccess.class, (String)"newConstructorWithAccessor", (Class[])new Class[]{Constructor.class, ConstructorAccessor.class});
        return (Constructor)ReflectionUtil.invokeMethod((Method)newConstructorWithAccessor, (Object)langReflectAccess, (Object[])new Object[]{constructorToCall, acc});
    }

    private static ConstructorAccessor getConstructorAccessor(Class<?> serializationTargetClass, Constructor<?> constructorToCall) {
        return (SubstrateConstructorAccessor)ReflectionSubstitutionSupport.singleton().getOrCreateConstructorAccessor(serializationTargetClass, constructorToCall);
    }

    @BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-24+22/src/java.base/share/classes/jdk/internal/reflect/ReflectionFactory.java#L311-L332")
    private Constructor<?> getConstructorForSerialization(Class<?> cl) {
        Constructor<?> constructorToCall;
        Class<?> initCl = cl;
        while (Serializable.class.isAssignableFrom(initCl)) {
            Class<?> prev = initCl;
            if ((initCl = initCl.getSuperclass()) != null && (this.disableSerialConstructorChecks() || this.superHasAccessibleConstructor(prev))) continue;
            return null;
        }
        try {
            constructorToCall = initCl.getDeclaredConstructor(new Class[0]);
            int mods = constructorToCall.getModifiers();
            if ((mods & 2) != 0 || (mods & 5) == 0 && !this.packageEquals(cl, initCl)) {
                return null;
            }
        }
        catch (NoSuchMethodException ex) {
            return null;
        }
        return constructorToCall;
    }

    private boolean superHasAccessibleConstructor(Class<?> prev) {
        return (Boolean)ReflectionUtil.invokeMethod((Method)this.superHasAccessibleConstructor, (Object)ReflectionFactory.getReflectionFactory(), (Object[])new Object[]{prev});
    }

    private boolean disableSerialConstructorChecks() {
        if (this.disableSerialConstructorChecks == null) {
            return false;
        }
        return (Boolean)ReflectionUtil.invokeMethod((Method)this.disableSerialConstructorChecks, null, (Object[])new Object[0]);
    }

    private boolean packageEquals(Class<?> cl1, Class<?> cl2) {
        return (Boolean)ReflectionUtil.invokeMethod((Method)this.packageEquals, null, (Object[])new Object[]{cl1, cl2});
    }

    static Object getConstructorAccessor(Constructor<?> constructor) {
        return ReflectionUtil.invokeMethod((Method)getConstructorAccessorMethod, constructor, (Object[])new Object[0]);
    }

    private static Constructor<?> getExternalizableConstructor(Class<?> serializationTargetClass) {
        return (Constructor)ReflectionUtil.invokeMethod((Method)getExternalizableConstructorMethod, null, (Object[])new Object[]{serializationTargetClass});
    }

    private Class<?> addConstructorAccessor(ConfigurationCondition cnd, Class<?> serializationTargetClass, Class<?> customTargetConstructorClass) {
        Constructor<?> targetConstructor;
        this.serializationSupport.registerSerializationTargetClass(cnd, serializationTargetClass);
        if (Externalizable.class.isAssignableFrom(serializationTargetClass)) {
            try {
                Constructor<?> externalizableConstructor = SerializationBuilder.getExternalizableConstructor(serializationTargetClass);
                if (externalizableConstructor == null) {
                    externalizableConstructor = SerializationBuilder.getExternalizableConstructor(Object.class);
                }
                return externalizableConstructor.getDeclaringClass();
            }
            catch (Exception e) {
                throw VMError.shouldNotReachHere(e);
            }
        }
        if (Modifier.isAbstract(serializationTargetClass.getModifiers())) {
            VMError.guarantee(this.stubConstructor != null, "stubConstructor is null, calling this too early");
            targetConstructor = this.stubConstructor;
        } else {
            if (customTargetConstructorClass == serializationTargetClass) {
                return customTargetConstructorClass;
            }
            Constructor customConstructorToCall = null;
            if (customTargetConstructorClass != null) {
                customConstructorToCall = ReflectionUtil.lookupConstructor(customTargetConstructorClass, (Class[])new Class[0]);
            }
            if ((targetConstructor = this.newConstructorForSerialization(serializationTargetClass, customConstructorToCall)) == null) {
                targetConstructor = this.newConstructorForSerialization(Object.class, customConstructorToCall);
            }
        }
        Class<?> targetConstructorClass = targetConstructor.getDeclaringClass();
        this.serializationSupport.addConstructorAccessor(serializationTargetClass, targetConstructorClass, SerializationBuilder.getConstructorAccessor(targetConstructor));
        return targetConstructorClass;
    }
}

