/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.pltgot;

import com.oracle.objectfile.ObjectFile;
import com.oracle.svm.core.meta.SharedMethod;
import com.oracle.svm.core.pltgot.MethodAddressResolver;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.meta.HostedUniverse;
import com.oracle.svm.hosted.pltgot.MethodAddressResolutionSupport;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;

class CollectPLTGOTCallSitesResolutionSupport
implements MethodAddressResolutionSupport {
    private final MethodAddressResolutionSupport resolver;
    private final ConcurrentMap<HostedMethod, Set<HostedMethod>> callerCalleesMap;
    private final Set<HostedMethod> calleesWithUnknownCaller;

    CollectPLTGOTCallSitesResolutionSupport(MethodAddressResolutionSupport resolver) {
        this.resolver = resolver;
        this.callerCalleesMap = new ConcurrentSkipListMap<HostedMethod, Set<HostedMethod>>(HostedUniverse.METHOD_COMPARATOR);
        this.calleesWithUnknownCaller = new ConcurrentSkipListSet<HostedMethod>(HostedUniverse.METHOD_COMPARATOR);
    }

    @Override
    public boolean shouldCallViaPLTGOT(SharedMethod caller, SharedMethod callee) {
        boolean shouldCall = this.resolver.shouldCallViaPLTGOT(caller, callee);
        if (shouldCall) {
            Set callees = this.callerCalleesMap.computeIfAbsent((HostedMethod)caller, k -> ConcurrentHashMap.newKeySet());
            callees.add((HostedMethod)callee);
        }
        return shouldCall;
    }

    @Override
    public boolean shouldCallViaPLTGOT(SharedMethod callee) {
        boolean shouldCall = this.resolver.shouldCallViaPLTGOT(callee);
        if (shouldCall) {
            this.calleesWithUnknownCaller.add((HostedMethod)callee);
        }
        return shouldCall;
    }

    @Override
    public void augmentImageObjectFile(ObjectFile imageObjectFile) {
        this.resolver.augmentImageObjectFile(imageObjectFile);
    }

    @Override
    public MethodAddressResolver createMethodAddressResolver() {
        return this.resolver.createMethodAddressResolver();
    }

    public Map<HostedMethod, Set<HostedMethod>> getCallerCalleesMap() {
        return Collections.unmodifiableMap(this.callerCalleesMap);
    }

    public Set<HostedMethod> getCalleesWithUnknownCaller() {
        return Collections.unmodifiableSet(this.calleesWithUnknownCaller);
    }
}

