/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.imagelayer;

import com.oracle.graal.pointsto.heap.ImageLayerLoader;
import com.oracle.graal.pointsto.heap.ImageLayerSnapshotUtil;
import com.oracle.svm.core.BuildArtifacts;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.imagelayer.ImageLayerBuildingSupport;
import com.oracle.svm.core.option.AccumulatingLocatableMultiOptionValue;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.HostedOptionValues;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.util.ArchiveSupport;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.hosted.NativeImageGenerator;
import com.oracle.svm.hosted.c.NativeLibraries;
import com.oracle.svm.hosted.heap.SVMImageLayerLoader;
import com.oracle.svm.hosted.heap.SVMImageLayerWriter;
import com.oracle.svm.hosted.imagelayer.HostedDynamicLayerInfo;
import com.oracle.svm.hosted.imagelayer.LayerOptionsSupport;
import com.oracle.svm.hosted.imagelayer.LoadLayerArchiveSupport;
import com.oracle.svm.hosted.imagelayer.WriteLayerArchiveSupport;
import java.io.File;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import jdk.graal.compiler.core.common.SuppressFBWarnings;
import jdk.graal.compiler.options.OptionKey;
import jdk.graal.compiler.options.OptionValues;
import org.graalvm.collections.EconomicMap;
import org.graalvm.nativeimage.ImageSingletons;

public final class HostedImageLayerBuildingSupport
extends ImageLayerBuildingSupport {
    private final SVMImageLayerLoader loader;
    private final SVMImageLayerWriter writer;
    private final WriteLayerArchiveSupport writeLayerArchiveSupport;
    private final LoadLayerArchiveSupport loadLayerArchiveSupport;

    private HostedImageLayerBuildingSupport(SVMImageLayerLoader loader, SVMImageLayerWriter writer, boolean buildingImageLayer, boolean buildingInitialLayer, boolean buildingApplicationLayer, WriteLayerArchiveSupport writeLayerArchiveSupport, LoadLayerArchiveSupport loadLayerArchiveSupport) {
        super(buildingImageLayer, buildingInitialLayer, buildingApplicationLayer);
        this.loader = loader;
        this.writer = writer;
        this.writeLayerArchiveSupport = writeLayerArchiveSupport;
        this.loadLayerArchiveSupport = loadLayerArchiveSupport;
    }

    public static HostedImageLayerBuildingSupport singleton() {
        return (HostedImageLayerBuildingSupport)ImageSingletons.lookup(ImageLayerBuildingSupport.class);
    }

    public SVMImageLayerLoader getLoader() {
        return this.loader;
    }

    public SVMImageLayerWriter getWriter() {
        return this.writer;
    }

    public LoadLayerArchiveSupport getLoadLayerArchiveSupport() {
        return this.loadLayerArchiveSupport;
    }

    public void archiveLayer(String imageName) {
        this.writer.dumpFiles();
        this.writeLayerArchiveSupport.write(imageName);
    }

    public static void processLayerOptions(EconomicMap<OptionKey<?>, Object> values) {
        Path layerUseValue;
        String layerCreateValue;
        OptionValues hostedOptions = new OptionValues(values);
        if (SubstrateOptions.LayerCreate.hasBeenSet(hostedOptions) && !(layerCreateValue = (String)((AccumulatingLocatableMultiOptionValue.Strings)SubstrateOptions.LayerCreate.getValue(hostedOptions)).lastValue().orElseThrow()).isEmpty()) {
            LayerOptionsSupport.LayerOption layerOption = LayerOptionsSupport.LayerOption.parse(layerCreateValue);
            String buildLayer = SubstrateOptionsParser.commandArgument(SubstrateOptions.LayerCreate, "");
            Arrays.stream(layerOption.extendedOptions()).forEach(option -> {
                switch (option.key()) {
                    case "module": {
                        UserError.guarantee(option.value() != null, "Option %s of %s requires a module name argument, e.g., %s=module-name.", option.key(), buildLayer, option.key());
                        SubstrateOptions.IncludeAllFromModule.update(values, option.value());
                        break;
                    }
                    case "package": {
                        UserError.guarantee(option.value() != null, "Option %s of %s requires a package name argument, e.g., %s=package-name.", option.key(), buildLayer, option.key());
                        SubstrateOptions.IncludeAllFromPath.update(values, option.value());
                        break;
                    }
                    default: {
                        throw UserError.abort("Unknown option %s of %s. Use --help-extra for usage instructions.", option.key(), buildLayer);
                    }
                }
            });
            SubstrateOptions.UseBaseLayerInclusionPolicy.update(values, true);
            SubstrateOptions.ClosedTypeWorld.update(values, false);
            if (SubstrateOptions.imageLayerEnabledHandler != null) {
                SubstrateOptions.imageLayerEnabledHandler.onOptionEnabled(values);
            }
            if (SubstrateOptions.imageLayerCreateEnabledHandler != null) {
                SubstrateOptions.imageLayerCreateEnabledHandler.onOptionEnabled(values);
            }
            SubstrateOptions.UseContainerSupport.update(values, false);
        }
        if (SubstrateOptions.LayerUse.hasBeenSet(hostedOptions) && !(layerUseValue = (Path)((AccumulatingLocatableMultiOptionValue.Paths)SubstrateOptions.LayerUse.getValue(hostedOptions)).lastValue().orElseThrow()).toString().isEmpty()) {
            SubstrateOptions.ClosedTypeWorldHubLayout.update(values, false);
            SubstrateOptions.ParseRuntimeOptions.update(values, false);
            if (SubstrateOptions.imageLayerEnabledHandler != null) {
                SubstrateOptions.imageLayerEnabledHandler.onOptionEnabled(values);
            }
        }
    }

    private static boolean isLayerOptionEnabled(HostedOptionKey<? extends AccumulatingLocatableMultiOptionValue<?>> option, HostedOptionValues values) {
        if (option.hasBeenSet(values)) {
            Object lastOptionValue = ((AccumulatingLocatableMultiOptionValue)option.getValue(values)).lastValue().orElseThrow();
            return !lastOptionValue.toString().isEmpty();
        }
        return false;
    }

    public static HostedImageLayerBuildingSupport initialize(HostedOptionValues values, ImageClassLoader imageClassLoader) {
        boolean buildingFinalLayer;
        boolean buildingSharedLayer = HostedImageLayerBuildingSupport.isLayerOptionEnabled(SubstrateOptions.LayerCreate, values);
        boolean buildingExtensionLayer = HostedImageLayerBuildingSupport.isLayerOptionEnabled(SubstrateOptions.LayerUse, values);
        boolean buildingImageLayer = buildingSharedLayer || buildingExtensionLayer;
        boolean buildingInitialLayer = buildingImageLayer && !buildingExtensionLayer;
        boolean bl = buildingFinalLayer = buildingImageLayer && !buildingSharedLayer;
        if (buildingImageLayer) {
            ImageLayerBuildingSupport.openModules();
        }
        WriteLayerArchiveSupport writeLayerArchiveSupport = null;
        SVMImageLayerWriter writer = null;
        ArchiveSupport archiveSupport = new ArchiveSupport(false);
        if (buildingSharedLayer) {
            LayerOptionsSupport.LayerOption layerOption = LayerOptionsSupport.LayerOption.parse((String)((AccumulatingLocatableMultiOptionValue.Strings)SubstrateOptions.LayerCreate.getValue(values)).lastValue().orElseThrow());
            writeLayerArchiveSupport = new WriteLayerArchiveSupport(archiveSupport, layerOption.fileName());
            writer = new SVMImageLayerWriter((Boolean)SubstrateOptions.UseSharedLayerGraphs.getValue(values));
        }
        SVMImageLayerLoader loader = null;
        LoadLayerArchiveSupport loadLayerArchiveSupport = null;
        if (buildingExtensionLayer) {
            Path layerFileName = (Path)((AccumulatingLocatableMultiOptionValue.Paths)SubstrateOptions.LayerUse.getValue(values)).lastValue().orElseThrow();
            loadLayerArchiveSupport = new LoadLayerArchiveSupport(layerFileName, archiveSupport);
            ImageLayerLoader.FilePaths paths = new ImageLayerLoader.FilePaths(loadLayerArchiveSupport.getSnapshotPath(), loadLayerArchiveSupport.getSnapshotGraphsPath());
            loader = new SVMImageLayerLoader(List.of(paths), imageClassLoader);
        }
        return new HostedImageLayerBuildingSupport(loader, writer, buildingImageLayer, buildingInitialLayer, buildingFinalLayer, writeLayerArchiveSupport, loadLayerArchiveSupport);
    }

    @SuppressFBWarnings(value={"NP"}, justification="FB reports null pointer dereferencing because it doesn't see through UserError.guarantee.")
    public static void setupSharedLayerLibrary(NativeLibraries nativeLibs) {
        Path sharedLibPath = HostedImageLayerBuildingSupport.singleton().getLoadLayerArchiveSupport().getSharedLibraryPath();
        Path parent = sharedLibPath.getParent();
        VMError.guarantee(parent != null, "Shared layer library path doesn't have a parent.");
        nativeLibs.getLibraryPaths().add(parent.toString());
        Path fileName = sharedLibPath.getFileName();
        VMError.guarantee(fileName != null, "Cannot determine shared layer library file name.");
        String fullLibName = fileName.toString();
        VMError.guarantee(fullLibName.startsWith("lib") && fullLibName.endsWith(".so"), "Expecting that shared layer library file starts with lib and ends with .so. Found: %s", fullLibName);
        String libName = fullLibName.substring("lib".length(), fullLibName.length() - ".so".length());
        HostedDynamicLayerInfo.singleton().registerLibName(libName);
        nativeLibs.addDynamicNonJniLibrary(libName);
    }

    public static void setupImageLayerArtifacts(String imageName) {
        VMError.guarantee(!imageName.contains(File.separator), "Expected simple file name, found %s.", imageName);
        Path snapshotFile = NativeImageGenerator.getOutputDirectory().resolve(ImageLayerSnapshotUtil.snapshotFileName((String)imageName));
        Path snapshotFileName = HostedImageLayerBuildingSupport.getFileName(snapshotFile);
        HostedImageLayerBuildingSupport.singleton().getWriter().setSnapshotFileInfo(snapshotFile, snapshotFileName.toString(), ".json");
        BuildArtifacts.singleton().add(BuildArtifacts.ArtifactType.LAYER_SNAPSHOT, snapshotFile);
        Path graphsFile = NativeImageGenerator.getOutputDirectory().resolve(ImageLayerSnapshotUtil.snapshotGraphsFileName((String)imageName));
        Path graphsFileName = HostedImageLayerBuildingSupport.getFileName(graphsFile);
        HostedImageLayerBuildingSupport.singleton().getWriter().openGraphsOutput(graphsFile, graphsFileName.toString(), ".json");
        BuildArtifacts.singleton().add(BuildArtifacts.ArtifactType.LAYER_SNAPSHOT_GRAPHS, graphsFile);
    }

    private static Path getFileName(Path path) {
        Path fileName = path.getFileName();
        if (fileName == null) {
            throw VMError.shouldNotReachHere("Layer snapshot file(s) missing.");
        }
        return fileName;
    }
}

