/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.code.aarch64;

import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.graal.code.PatchConsumerFactory;
import com.oracle.svm.hosted.code.aarch64.AdrpAddMacroInstructionHostedPatcher;
import com.oracle.svm.hosted.code.aarch64.AdrpLdrMacroInstructionHostedPatcher;
import com.oracle.svm.hosted.code.aarch64.MovSequenceHostedPatcher;
import com.oracle.svm.hosted.code.aarch64.SingleInstructionHostedPatcher;
import java.util.function.Consumer;
import jdk.graal.compiler.asm.Assembler;
import jdk.graal.compiler.asm.aarch64.AArch64Assembler;
import jdk.graal.compiler.asm.aarch64.AArch64MacroAssembler;
import jdk.graal.compiler.code.CompilationResult;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
@Platforms(value={Platform.AARCH64.class})
public class AArch64HostedPatcherFeature
implements InternalFeature {
    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        ImageSingletons.add(PatchConsumerFactory.HostedPatchConsumerFactory.class, (Object)new PatchConsumerFactory.HostedPatchConsumerFactory(this){

            @Override
            public Consumer<Assembler.CodeAnnotation> newConsumer(final CompilationResult compilationResult) {
                return new Consumer<Assembler.CodeAnnotation>(this){

                    @Override
                    public void accept(Assembler.CodeAnnotation annotation) {
                        if (annotation instanceof AArch64Assembler.SingleInstructionAnnotation) {
                            compilationResult.addAnnotation((CompilationResult.CodeAnnotation)new SingleInstructionHostedPatcher((AArch64Assembler.SingleInstructionAnnotation)annotation));
                        } else if (annotation instanceof AArch64MacroAssembler.MovSequenceAnnotation) {
                            compilationResult.addAnnotation((CompilationResult.CodeAnnotation)new MovSequenceHostedPatcher((AArch64MacroAssembler.MovSequenceAnnotation)annotation));
                        } else if (annotation instanceof AArch64MacroAssembler.AdrpLdrMacroInstruction) {
                            compilationResult.addAnnotation((CompilationResult.CodeAnnotation)new AdrpLdrMacroInstructionHostedPatcher((AArch64MacroAssembler.AdrpLdrMacroInstruction)annotation));
                        } else if (annotation instanceof AArch64MacroAssembler.AdrpAddMacroInstruction) {
                            compilationResult.addAnnotation((CompilationResult.CodeAnnotation)new AdrpAddMacroInstructionHostedPatcher((AArch64MacroAssembler.AdrpAddMacroInstruction)annotation));
                        }
                    }
                };
            }
        });
    }
}

