/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.code;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.infrastructure.UniverseMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.meta.MethodPointer;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.code.CEntryPointCallStubSupport;
import com.oracle.svm.hosted.code.CEntryPointData;
import com.oracle.svm.hosted.meta.HostedMethod;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.function.Function;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.nativeimage.c.function.CEntryPointLiteral;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.impl.CEntryPointLiteralCodePointer;

@AutomaticallyRegisteredFeature
public class CEntryPointLiteralFeature
implements InternalFeature {
    protected UniverseMetaAccess metaAccess;
    protected BigBang bb;

    public void duringSetup(Feature.DuringSetupAccess a) {
        FeatureImpl.DuringSetupAccessImpl config = (FeatureImpl.DuringSetupAccessImpl)a;
        this.metaAccess = config.getMetaAccess();
        this.bb = config.getBigBang();
        config.registerObjectReplacer(new CEntryPointLiteralObjectReplacer());
    }

    public void beforeCompilation(Feature.BeforeCompilationAccess a) {
        FeatureImpl.CompilationAccessImpl config = (FeatureImpl.CompilationAccessImpl)a;
        this.metaAccess = config.getMetaAccess();
        this.bb = null;
    }

    class CEntryPointLiteralObjectReplacer
    implements Function<Object, Object> {
        CEntryPointLiteralObjectReplacer() {
        }

        @Override
        public Object apply(Object source) {
            if (source instanceof CEntryPointLiteralCodePointer) {
                Method reflectionMethod;
                CEntryPointLiteralCodePointer original = (CEntryPointLiteralCodePointer)source;
                try {
                    reflectionMethod = original.definingClass.getDeclaredMethod(original.methodName, original.parameterTypes);
                }
                catch (NoSuchMethodException ex) {
                    throw VMError.shouldNotReachHere("Method not found: " + original.definingClass.getName() + "." + original.methodName);
                }
                ResolvedJavaMethod javaMethod = CEntryPointLiteralFeature.this.metaAccess.lookupJavaMethod((Executable)reflectionMethod);
                if (javaMethod instanceof AnalysisMethod) {
                    AnalysisMethod aMethod = (AnalysisMethod)javaMethod;
                    CEntryPoint annotation = (CEntryPoint)aMethod.getAnnotation(CEntryPoint.class);
                    UserError.guarantee(annotation != null, "Method referenced by %s must be annotated with @%s: %s", CEntryPointLiteral.class.getSimpleName(), CEntryPoint.class.getSimpleName(), javaMethod);
                    CEntryPointCallStubSupport.singleton().registerStubForMethod(aMethod, () -> CEntryPointData.create((ResolvedJavaMethod)aMethod));
                } else if (javaMethod instanceof HostedMethod) {
                    HostedMethod hMethod = (HostedMethod)javaMethod;
                    AnalysisMethod aMethod = hMethod.getWrapped();
                    AnalysisMethod aStub = CEntryPointCallStubSupport.singleton().getStubForMethod(aMethod);
                    HostedMethod hStub = (HostedMethod)CEntryPointLiteralFeature.this.metaAccess.getUniverse().lookup((JavaMethod)aStub);
                    assert (hStub.wrapped.isEntryPoint());
                    assert (hStub.isCompiled() || hStub.wrapped.isInBaseLayer());
                    return new MethodPointer(hStub);
                }
            }
            return source;
        }
    }
}

