/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.ameta;

import com.oracle.graal.pointsto.ObjectScanner;
import com.oracle.graal.pointsto.heap.HostedValuesProvider;
import com.oracle.graal.pointsto.heap.ImageHeapArray;
import com.oracle.graal.pointsto.heap.ImageHeapConstant;
import com.oracle.graal.pointsto.heap.ImageHeapInstance;
import com.oracle.graal.pointsto.heap.ImageHeapRelocatableConstant;
import com.oracle.graal.pointsto.heap.ImageHeapScanner;
import com.oracle.graal.pointsto.infrastructure.UniverseMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.graal.pointsto.util.AnalysisError;
import com.oracle.svm.core.classinitialization.TypeReachedProvider;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.SVMHost;
import com.oracle.svm.hosted.ameta.AnalysisMethodHandleAccessProvider;
import com.oracle.svm.hosted.ameta.EmptyMemoryAccessProvider;
import com.oracle.svm.hosted.ameta.FieldValueInterceptionSupport;
import com.oracle.svm.hosted.classinitialization.ClassInitializationSupport;
import com.oracle.svm.hosted.classinitialization.SimulateClassInitializerSupport;
import com.oracle.svm.hosted.meta.RelocatableConstant;
import java.util.Objects;
import java.util.Set;
import java.util.function.ObjIntConsumer;
import jdk.graal.compiler.nodes.spi.IdentityHashCodeProvider;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MemoryAccessProvider;
import jdk.vm.ci.meta.MethodHandleAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@Platforms(value={Platform.HOSTED_ONLY.class})
public class AnalysisConstantReflectionProvider
implements ConstantReflectionProvider,
IdentityHashCodeProvider,
TypeReachedProvider {
    private final AnalysisUniverse universe;
    protected final UniverseMetaAccess metaAccess;
    private final AnalysisMethodHandleAccessProvider methodHandleAccess;
    private final ClassInitializationSupport classInitializationSupport;
    private SimulateClassInitializerSupport simulateClassInitializerSupport;
    private final FieldValueInterceptionSupport fieldValueInterceptionSupport = FieldValueInterceptionSupport.singleton();
    private static final Set<Class<?>> BOXING_CLASSES = Set.of(Boolean.class, Byte.class, Short.class, Character.class, Integer.class, Long.class, Float.class, Double.class);

    public AnalysisConstantReflectionProvider(AnalysisUniverse universe, UniverseMetaAccess metaAccess, ClassInitializationSupport classInitializationSupport) {
        this.universe = universe;
        this.metaAccess = metaAccess;
        this.methodHandleAccess = new AnalysisMethodHandleAccessProvider(universe);
        this.classInitializationSupport = classInitializationSupport;
    }

    public Boolean constantEquals(Constant x, Constant y) {
        JavaConstant constant;
        VMError.guarantee(!(x instanceof JavaConstant) || AnalysisConstantReflectionProvider.isExpectedJavaConstant(constant = (JavaConstant)x));
        VMError.guarantee(!(y instanceof JavaConstant) || AnalysisConstantReflectionProvider.isExpectedJavaConstant(constant = (JavaConstant)y));
        if (x == y) {
            return true;
        }
        return x.equals((Object)y);
    }

    public Integer identityHashCode(JavaConstant constant) {
        if (constant == null || constant.getJavaKind() != JavaKind.Object) {
            return null;
        }
        if (constant.isNull()) {
            return 0;
        }
        if (constant instanceof RelocatableConstant) {
            return null;
        }
        ImageHeapConstant imageHeapConstant = (ImageHeapConstant)constant;
        if (imageHeapConstant.hasIdentityHashCode()) {
            return imageHeapConstant.getIdentityHashCode();
        }
        Class<?> hostedObject = Objects.requireNonNull(this.universe.getSnippetReflection().asObject(Object.class, constant));
        if (hostedObject instanceof DynamicHub) {
            DynamicHub hub = (DynamicHub)((Object)hostedObject);
            hostedObject = hub.getHostedJavaClass();
        }
        return System.identityHashCode(hostedObject);
    }

    public MemoryAccessProvider getMemoryAccessProvider() {
        return EmptyMemoryAccessProvider.SINGLETON;
    }

    public JavaConstant unboxPrimitive(JavaConstant source) {
        if (!source.getJavaKind().isObject() || source.isNull()) {
            return null;
        }
        ImageHeapConstant imageHeapConstant = (ImageHeapConstant)source;
        AnalysisType type = imageHeapConstant.getType();
        if (BOXING_CLASSES.contains(type.getJavaClass())) {
            imageHeapConstant.ensureReaderInstalled();
            ResolvedJavaField[] fields = type.getInstanceFields(true);
            assert (fields.length == 1 && fields[0].getName().equals("value"));
            return ((ImageHeapInstance)imageHeapConstant).readFieldValue((AnalysisField)fields[0]);
        }
        return null;
    }

    public MethodHandleAccessProvider getMethodHandleAccess() {
        return this.methodHandleAccess;
    }

    public Integer readArrayLength(JavaConstant array) {
        if (array.getJavaKind() != JavaKind.Object || array.isNull()) {
            return null;
        }
        VMError.guarantee(array instanceof ImageHeapConstant);
        if (array instanceof ImageHeapArray) {
            ImageHeapArray heapArray = (ImageHeapArray)array;
            return heapArray.getLength();
        }
        return null;
    }

    public JavaConstant readArrayElement(JavaConstant array, int index) {
        if (array.getJavaKind() != JavaKind.Object || array.isNull()) {
            return null;
        }
        VMError.guarantee(array instanceof ImageHeapConstant);
        if (array instanceof ImageHeapArray) {
            ImageHeapArray heapArray = (ImageHeapArray)array;
            if (index < 0 || index >= heapArray.getLength()) {
                return null;
            }
            heapArray.ensureReaderInstalled();
            JavaConstant element = heapArray.readElementValue(index);
            return AnalysisConstantReflectionProvider.checkExpectedValue(element);
        }
        return null;
    }

    public void forEachArrayElement(JavaConstant array, ObjIntConsumer<JavaConstant> consumer) {
        VMError.guarantee(array instanceof ImageHeapConstant);
        if (array instanceof ImageHeapArray) {
            ImageHeapArray heapArray = (ImageHeapArray)array;
            heapArray.ensureReaderInstalled();
            for (int index = 0; index < heapArray.getLength(); ++index) {
                JavaConstant element = heapArray.readElementValue(index);
                consumer.accept(AnalysisConstantReflectionProvider.checkExpectedValue(element), index);
            }
        }
    }

    private static JavaConstant checkExpectedValue(JavaConstant value) {
        VMError.guarantee(AnalysisConstantReflectionProvider.isExpectedJavaConstant(value));
        return value;
    }

    private static boolean isExpectedJavaConstant(JavaConstant value) {
        return value.isNull() || value.getJavaKind().isPrimitive() || value instanceof RelocatableConstant || value instanceof ImageHeapConstant;
    }

    public JavaConstant readFieldValue(ResolvedJavaField field, JavaConstant receiver) {
        return this.readValue((AnalysisField)field, receiver, false, false);
    }

    public JavaConstant boxPrimitive(JavaConstant source) {
        throw VMError.intentionallyUnimplemented();
    }

    public JavaConstant readValue(AnalysisField field, JavaConstant receiver, boolean returnSimulatedValues, boolean readRelocatableValues) {
        ImageHeapInstance imageHeapInstance;
        block9: {
            block10: {
                if (field.isStatic()) break block9;
                if (!(receiver instanceof ImageHeapInstance)) break block10;
                imageHeapInstance = (ImageHeapInstance)receiver;
                if (field.getDeclaringClass().isAssignableFrom((ResolvedJavaType)imageHeapInstance.getType())) break block9;
            }
            return null;
        }
        if (receiver instanceof ImageHeapInstance && (imageHeapInstance = (ImageHeapInstance)receiver).isInBaseLayer() && imageHeapInstance.nullFieldValues()) {
            return null;
        }
        VMError.guarantee(receiver == null || receiver instanceof ImageHeapConstant, "Expected ImageHeapConstant, found: %s", receiver);
        JavaConstant value = null;
        if (returnSimulatedValues) {
            value = this.readSimulatedValue(field);
        }
        if (value == null && field.isStatic() && SimulateClassInitializerSupport.singleton().isEnabled()) {
            value = field.getDeclaringClass().getOrComputeData().readFieldValue(field);
        }
        if (value == null && receiver instanceof ImageHeapConstant) {
            ImageHeapConstant heapConstant = (ImageHeapConstant)receiver;
            heapConstant.ensureReaderInstalled();
            AnalysisError.guarantee((boolean)this.fieldValueInterceptionSupport.isValueAvailable(field), (String)"Value not yet available for %s", (Object[])new Object[]{field});
            ImageHeapInstance heapObject = (ImageHeapInstance)receiver;
            value = heapObject.readFieldValue(field);
        }
        if (value == null) {
            VMError.guarantee(!SimulateClassInitializerSupport.singleton().isEnabled());
            ImageHeapScanner heapScanner = this.universe.getHeapScanner();
            HostedValuesProvider hostedValuesProvider = this.universe.getHostedValuesProvider();
            value = heapScanner.createImageHeapConstant(hostedValuesProvider.readFieldValueWithReplacement(field, receiver), ObjectScanner.OtherReason.UNKNOWN);
        }
        if (!readRelocatableValues && value instanceof ImageHeapRelocatableConstant) {
            return null;
        }
        return value;
    }

    private JavaConstant readSimulatedValue(AnalysisField field) {
        if (!field.isStatic() || field.getDeclaringClass().isInitialized()) {
            return null;
        }
        field.getDeclaringClass().getInitializeMetaDataTask().ensureDone();
        if (this.simulateClassInitializerSupport == null) {
            this.simulateClassInitializerSupport = SimulateClassInitializerSupport.singleton();
        }
        return this.simulateClassInitializerSupport.getSimulatedFieldValue(field);
    }

    public ResolvedJavaType asJavaType(Constant constant) {
        JavaConstant javaConstant;
        if (constant instanceof JavaConstant && this.metaAccess.isInstanceOf(javaConstant = (JavaConstant)constant, Class.class)) {
            Object hostedObject = Objects.requireNonNull(this.universe.getSnippetReflection().asObject(Object.class, javaConstant));
            VMError.guarantee(!(hostedObject instanceof Class), "Must not have java.lang.Class object: %s", hostedObject);
            return this.getHostVM().lookupType((DynamicHub)hostedObject);
        }
        return null;
    }

    public JavaConstant asJavaClass(ResolvedJavaType type) {
        return this.universe.getHeapScanner().createImageHeapConstant((Object)this.getHostVM().dynamicHub(type), ObjectScanner.OtherReason.UNKNOWN);
    }

    public Constant asObjectHub(ResolvedJavaType type) {
        return this.asJavaClass(type);
    }

    public JavaConstant forString(String value) {
        if (value == null) {
            return JavaConstant.NULL_POINTER;
        }
        return this.universe.getHeapScanner().createImageHeapConstant((Object)value, ObjectScanner.OtherReason.UNKNOWN);
    }

    @Override
    public boolean initializationCheckRequired(ResolvedJavaType type) {
        return this.classInitializationSupport.requiresInitializationNodeForTypeReached(type);
    }

    private SVMHost getHostVM() {
        return (SVMHost)this.universe.hostVM();
    }
}

