/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.os;

import com.oracle.svm.core.Isolates;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.VMInspectionOptions;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.nmt.NativeMemoryTracking;
import com.oracle.svm.core.nmt.NmtCategory;
import com.oracle.svm.core.os.CommittedMemoryProvider;
import com.oracle.svm.core.os.VirtualMemoryProvider;
import com.oracle.svm.core.util.UnsignedUtils;
import com.oracle.svm.core.util.VMError;
import jdk.graal.compiler.word.Word;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

public abstract class AbstractCommittedMemoryProvider
implements CommittedMemoryProvider {
    @Uninterruptible(reason="Still being initialized.")
    protected static int protectSingleIsolateImageHeap() {
        assert (!SubstrateOptions.SpawnIsolates.getValue().booleanValue()) : "Must be handled by ImageHeapProvider when SpawnIsolates is enabled";
        Pointer heapBegin = (Pointer)Isolates.IMAGE_HEAP_BEGIN.get();
        if (Heap.getHeap().getImageHeapOffsetInAddressSpace() != 0) {
            return 8;
        }
        Word heapSize = Isolates.IMAGE_HEAP_END.get().subtract((UnsignedWord)heapBegin);
        if (VirtualMemoryProvider.get().protect((PointerBase)heapBegin, (UnsignedWord)heapSize, 1) != 0) {
            return 9;
        }
        Pointer writableBegin = (Pointer)Isolates.IMAGE_HEAP_WRITABLE_BEGIN.get();
        Word writableSize = Isolates.IMAGE_HEAP_WRITABLE_END.get().subtract((UnsignedWord)writableBegin);
        if (VirtualMemoryProvider.get().protect((PointerBase)writableBegin, (UnsignedWord)writableSize, 3) != 0) {
            return 9;
        }
        return 0;
    }

    @Override
    public Pointer allocateExecutableMemory(UnsignedWord nbytes, UnsignedWord alignment) {
        return this.allocate(nbytes, alignment, true, NmtCategory.Code);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected Pointer allocate(UnsignedWord size, UnsignedWord alignment, boolean executable, NmtCategory nmtCategory) {
        Pointer committed;
        Pointer reserved = (Pointer)WordFactory.nullPointer();
        if (!UnsignedUtils.isAMultiple(this.getGranularity(), alignment) && (reserved = VirtualMemoryProvider.get().reserve(size, alignment, executable)).isNull()) {
            return (Pointer)WordFactory.nullPointer();
        }
        int access = 3;
        if (executable) {
            access |= 8;
        }
        if ((committed = VirtualMemoryProvider.get().commit((PointerBase)reserved, size, access)).isNull()) {
            if (reserved.isNonNull()) {
                VirtualMemoryProvider.get().free((PointerBase)reserved, size);
            }
            return (Pointer)WordFactory.nullPointer();
        }
        assert (reserved.isNull() || reserved.equal((UnsignedWord)committed));
        if (VMInspectionOptions.hasNativeMemoryTrackingSupport()) {
            NativeMemoryTracking.singleton().trackReserve(size, nmtCategory);
            NativeMemoryTracking.singleton().trackCommit(size, nmtCategory);
        }
        return committed;
    }

    @Override
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void freeExecutableMemory(PointerBase start, UnsignedWord nbytes, UnsignedWord alignment) {
        AbstractCommittedMemoryProvider.free(start, nbytes, NmtCategory.Code);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected static void free(PointerBase start, UnsignedWord nbytes, NmtCategory nmtCategory) {
        int result;
        if (VMInspectionOptions.hasNativeMemoryTrackingSupport()) {
            NativeMemoryTracking.singleton().trackUncommit(nbytes, nmtCategory);
            NativeMemoryTracking.singleton().trackFree(nbytes, nmtCategory);
        }
        VMError.guarantee((result = VirtualMemoryProvider.get().free(start, nbytes)) == 0, "Error while freeing virtual memory.");
    }
}

