/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.option;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.option.APIOption;
import com.oracle.svm.core.option.OptionUtils;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import java.util.Collections;
import java.util.HashSet;
import java.util.ServiceLoader;
import java.util.Set;
import jdk.graal.compiler.api.replacements.Fold;
import jdk.graal.compiler.options.OptionDescriptors;

public enum GCOptionValue {
    SERIAL("serial"),
    EPSILON("epsilon"),
    G1("G1");

    private static Set<String> supportedValues;
    private final String optionValue;

    private GCOptionValue(String optionValue) {
        this.optionValue = optionValue;
    }

    public String getValue() {
        return this.optionValue;
    }

    @Fold
    public static synchronized Set<String> possibleValues() {
        if (supportedValues == null) {
            HashSet values = new HashSet();
            ServiceLoader<OptionDescriptors> optionDescriptors = ServiceLoader.load(OptionDescriptors.class);
            SubstrateOptionsParser.collectOptions(optionDescriptors, optionDescriptor -> {
                for (APIOption annotation : OptionUtils.getAnnotationsByType(optionDescriptor, APIOption.class)) {
                    if (!annotation.group().equals(SubstrateOptions.GCGroup.class)) continue;
                    values.add(annotation.name()[0]);
                }
            });
            supportedValues = Collections.unmodifiableSet(values);
        }
        return supportedValues;
    }

    static {
        supportedValues = null;
    }
}

