/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jfr;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.TargetElement;
import com.oracle.svm.core.container.Container;
import com.oracle.svm.core.container.OperatingSystem;
import com.oracle.svm.core.jdk.JDKLatest;
import com.oracle.svm.core.jfr.HasChunkRotationMonitorField;
import com.oracle.svm.core.jfr.HasFileDeltaChangeField;
import com.oracle.svm.core.jfr.HasJfrSupport;
import com.oracle.svm.core.jfr.JfrJavaEvents;
import com.oracle.svm.core.jfr.JfrThreadLocal;
import com.oracle.svm.core.jfr.JfrTicks;
import com.oracle.svm.core.jfr.SubstrateJVM;
import com.oracle.svm.core.jfr.Target_jdk_jfr_internal_JVM_Util;
import com.oracle.svm.core.jfr.Target_jdk_jfr_internal_event_EventConfiguration;
import com.oracle.svm.core.jfr.Target_jdk_jfr_internal_event_EventWriter;
import com.oracle.svm.core.jfr.traceid.JfrTraceId;
import com.oracle.svm.core.util.PlatformTimeUtils;
import java.util.List;
import jdk.internal.event.Event;
import jdk.jfr.internal.JVM;
import jdk.jfr.internal.LogTag;
import org.graalvm.nativeimage.ProcessProperties;

@TargetClass(value=JVM.class)
public final class Target_jdk_jfr_internal_JVM {
    @Alias
    @TargetElement(onlyWith={HasChunkRotationMonitorField.class})
    static Object CHUNK_ROTATION_MONITOR;
    @Alias
    @TargetElement(onlyWith={HasFileDeltaChangeField.class})
    static Object FILE_DELTA_CHANGE;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    @TargetElement(onlyWith={JDKLatest.class})
    private static volatile boolean nativeOK;

    @Substitute
    private static void registerNatives() {
    }

    @Substitute
    @TargetElement(onlyWith={JDKLatest.class})
    public static void markChunkFinal() {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        SubstrateJVM.get().markChunkFinal();
    }

    @Substitute
    @TargetElement(onlyWith={JDKLatest.class})
    public static void beginRecording() {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        SubstrateJVM.get().beginRecording();
    }

    @Substitute
    @Uninterruptible(reason="Needed for calling SubstrateJVM.isRecording().")
    @TargetElement(onlyWith={JDKLatest.class})
    public static boolean isRecording() {
        if (!HasJfrSupport.get()) {
            return false;
        }
        return SubstrateJVM.get().isRecording();
    }

    @Substitute
    @TargetElement(onlyWith={JDKLatest.class})
    public static void endRecording() {
        if (!HasJfrSupport.get()) {
            return;
        }
        SubstrateJVM.get().endRecording();
    }

    @Substitute
    public static long counterTime() {
        return JfrTicks.elapsedTicks();
    }

    @Substitute
    @TargetElement(onlyWith={JDKLatest.class})
    public static boolean emitEvent(long eventTypeId, long timestamp, long when) {
        return false;
    }

    @Substitute
    @TargetElement(onlyWith={JDKLatest.class})
    public static List<Class<? extends Event>> getAllEventClasses() {
        return JfrJavaEvents.getAllEventClasses();
    }

    @Substitute
    @TargetElement(onlyWith={JDKLatest.class})
    public static long getUnloadedEventClassCount() {
        return 0L;
    }

    @Substitute
    @Uninterruptible(reason="Needed for SubstrateJVM.getClassId().")
    public static long getClassId(Class<?> clazz) {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        return SubstrateJVM.get().getClassId(clazz);
    }

    @Substitute
    @TargetElement(onlyWith={JDKLatest.class})
    public static String getPid() {
        long id = ProcessProperties.getProcessID();
        return String.valueOf(id);
    }

    @Substitute
    @Uninterruptible(reason="Needed for SubstrateJVM.getStackTraceId().")
    @TargetElement(onlyWith={JDKLatest.class})
    public static long getStackTraceId(int skipCount, long stackFilterId) {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        return SubstrateJVM.get().getStackTraceId(skipCount);
    }

    @Substitute
    @TargetElement(onlyWith={JDKLatest.class})
    public static long registerStackFilter(String[] classes, String[] methods) {
        throw new UnsupportedOperationException("JFR stack filters are not supported at the moment.");
    }

    @Substitute
    @TargetElement(onlyWith={JDKLatest.class})
    public static void unregisterStackFilter(long stackFilterId) {
    }

    @Substitute
    @TargetElement(onlyWith={JDKLatest.class})
    public static void setMiscellaneous(long eventTypeId, long value) {
    }

    @Substitute
    @TargetElement(onlyWith={JDKLatest.class})
    public static long getThreadId(Thread t) {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        return SubstrateJVM.getThreadId(t);
    }

    @Substitute
    @TargetElement(onlyWith={JDKLatest.class})
    public static long getTicksFrequency() {
        return JfrTicks.getTicksFrequency();
    }

    @Substitute
    @TargetElement(onlyWith={JDKLatest.class})
    public static long nanosNow() {
        return PlatformTimeUtils.singleton().nanosNow();
    }

    @Substitute
    public static void log(int tagSetId, int level, String message) {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        SubstrateJVM.get().log(tagSetId, level, message);
    }

    @Substitute
    public static void logEvent(int level, String[] lines, boolean system) {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        SubstrateJVM.get().logEvent(level, lines, system);
    }

    @Substitute
    public static void subscribeLogLevel(LogTag lt, int tagSetId) {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        SubstrateJVM.get().subscribeLogLevel(lt, tagSetId);
    }

    @Substitute
    @TargetElement(onlyWith={JDKLatest.class})
    public static synchronized void retransformClasses(Class<?>[] classes) {
    }

    @Substitute
    @TargetElement(onlyWith={JDKLatest.class})
    public static void setEnabled(long eventTypeId, boolean enabled) {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        SubstrateJVM.get().setEnabled(eventTypeId, enabled);
    }

    @Substitute
    @TargetElement(onlyWith={JDKLatest.class})
    public static void setFileNotification(long delta) {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        SubstrateJVM.get().setFileNotification(delta);
    }

    @Substitute
    @TargetElement(onlyWith={JDKLatest.class})
    public static void setGlobalBufferCount(long count) throws IllegalArgumentException, IllegalStateException {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        SubstrateJVM.get().setGlobalBufferCount(count);
    }

    @Substitute
    @TargetElement(onlyWith={JDKLatest.class})
    public static void setGlobalBufferSize(long size) throws IllegalArgumentException {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        SubstrateJVM.get().setGlobalBufferSize(size);
    }

    @Substitute
    @TargetElement(onlyWith={JDKLatest.class})
    public static void setMemorySize(long size) throws IllegalArgumentException {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        SubstrateJVM.get().setMemorySize(size);
    }

    @Substitute
    @TargetElement(onlyWith={JDKLatest.class})
    public static void setMethodSamplingPeriod(long type, long intervalMillis) {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        SubstrateJVM.get().setMethodSamplingInterval(type, intervalMillis);
    }

    @Substitute
    @TargetElement(onlyWith={JDKLatest.class})
    public static void setOutput(String file) {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        SubstrateJVM.get().setOutput(file);
    }

    @Substitute
    @TargetElement(onlyWith={JDKLatest.class})
    public static void setForceInstrumentation(boolean force) {
    }

    @Substitute
    @TargetElement(onlyWith={JDKLatest.class})
    public static void setCompressedIntegers(boolean compressed) throws IllegalStateException {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        SubstrateJVM.get().setCompressedIntegers(compressed);
    }

    @Substitute
    @TargetElement(onlyWith={JDKLatest.class})
    public static void setStackDepth(int depth) throws IllegalArgumentException, IllegalStateException {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        SubstrateJVM.get().setStackDepth(depth);
    }

    @Substitute
    @TargetElement(onlyWith={JDKLatest.class})
    public static void setStackTraceEnabled(long eventTypeId, boolean enabled) {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        SubstrateJVM.get().setStackTraceEnabled(eventTypeId, enabled);
    }

    @Substitute
    @TargetElement(onlyWith={JDKLatest.class})
    public static void setThreadBufferSize(long size) throws IllegalArgumentException, IllegalStateException {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        SubstrateJVM.get().setThreadBufferSize(size);
    }

    @Substitute
    @TargetElement(onlyWith={JDKLatest.class})
    public static boolean setThreshold(long eventTypeId, long ticks) {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        return SubstrateJVM.get().setThreshold(eventTypeId, ticks);
    }

    @Substitute
    @TargetElement(onlyWith={JDKLatest.class})
    public static void storeMetadataDescriptor(byte[] bytes) {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        SubstrateJVM.get().storeMetadataDescriptor(bytes);
    }

    @Substitute
    @TargetElement(onlyWith={JDKLatest.class})
    public static boolean getAllowedToDoEventRetransforms() {
        return false;
    }

    @Substitute
    @TargetElement(onlyWith={JDKLatest.class})
    private static boolean createJFR(boolean simulateFailure) throws IllegalStateException {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        return SubstrateJVM.get().createJFR(simulateFailure);
    }

    @Substitute
    @TargetElement(onlyWith={JDKLatest.class})
    private static boolean destroyJFR() {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        return SubstrateJVM.get().destroyJFR();
    }

    @Substitute
    @TargetElement(onlyWith={JDKLatest.class})
    public static boolean isAvailable() {
        return HasJfrSupport.get();
    }

    @Substitute
    @TargetElement(onlyWith={JDKLatest.class})
    public static double getTimeConversionFactor() {
        return 1.0;
    }

    @Substitute
    @TargetElement(onlyWith={JDKLatest.class})
    public static long getTypeId(Class<?> clazz) {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        return JfrTraceId.getTraceId(clazz);
    }

    @Substitute
    public static Target_jdk_jfr_internal_event_EventWriter getEventWriter() {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        return SubstrateJVM.get().getEventWriter();
    }

    @Substitute
    public static Target_jdk_jfr_internal_event_EventWriter newEventWriter() {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        return SubstrateJVM.get().newEventWriter();
    }

    @Substitute
    public static void flush(Target_jdk_jfr_internal_event_EventWriter writer, int uncommittedSize, int requestedSize) {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        SubstrateJVM.get().flush(writer, uncommittedSize, requestedSize);
    }

    @Substitute
    @TargetElement(onlyWith={JDKLatest.class})
    public static void flush() {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        SubstrateJVM.get().flush();
    }

    @Substitute
    public static long commit(long nextPosition) {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        return SubstrateJVM.get().commit(nextPosition);
    }

    @Substitute
    @TargetElement(onlyWith={JDKLatest.class})
    public static void setRepositoryLocation(String dirText) {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        SubstrateJVM.get().setRepositoryLocation(dirText);
    }

    @Substitute
    @TargetElement(onlyWith={JDKLatest.class})
    public static void setDumpPath(String dumpPathText) {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        SubstrateJVM.get().setDumpPath(dumpPathText);
    }

    @Substitute
    @TargetElement(onlyWith={JDKLatest.class})
    public static String getDumpPath() {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        return SubstrateJVM.get().getDumpPath();
    }

    @Substitute
    @TargetElement(onlyWith={JDKLatest.class})
    public static void abort(String errorMsg) {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        SubstrateJVM.get().abort(errorMsg);
    }

    @Substitute
    public static boolean addStringConstant(long id, String s) {
        return false;
    }

    @Substitute
    @TargetElement(onlyWith={JDKLatest.class})
    public static void uncaughtException(Thread thread, Throwable t) {
    }

    @Substitute
    @TargetElement(onlyWith={JDKLatest.class})
    public static boolean setCutoff(long eventTypeId, long cutoffTicks) {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        return SubstrateJVM.get().setCutoff(eventTypeId, cutoffTicks);
    }

    @Substitute
    @TargetElement(onlyWith={JDKLatest.class})
    public static boolean setThrottle(long eventTypeId, long eventSampleSize, long periodMs) {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        return SubstrateJVM.get().setThrottle(eventTypeId, eventSampleSize, periodMs);
    }

    @Substitute
    @TargetElement(onlyWith={JDKLatest.class})
    public static void emitOldObjectSamples(long cutoff, boolean emitAll, boolean skipBFS) {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        SubstrateJVM.get().emitOldObjectSamples(cutoff, emitAll, skipBFS);
    }

    @Substitute
    @TargetElement(onlyWith={JDKLatest.class})
    public static boolean shouldRotateDisk() {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        return SubstrateJVM.get().shouldRotateDisk();
    }

    @Substitute
    @TargetElement(onlyWith={JDKLatest.class})
    public static void include(Thread thread) {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        JfrThreadLocal.setExcluded(thread, false);
    }

    @Substitute
    @TargetElement(onlyWith={JDKLatest.class})
    public static void exclude(Thread thread) {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        JfrThreadLocal.setExcluded(thread, true);
    }

    @Substitute
    @TargetElement(onlyWith={JDKLatest.class})
    public static boolean isExcluded(Thread thread) {
        if (!HasJfrSupport.get()) {
            return true;
        }
        return JfrThreadLocal.isThreadExcluded(thread);
    }

    @Substitute
    @TargetElement(onlyWith={JDKLatest.class})
    public static boolean isExcluded(Class<? extends Event> eventClass) {
        return !HasJfrSupport.get();
    }

    @Substitute
    @TargetElement(onlyWith={JDKLatest.class})
    public static boolean isInstrumented(Class<? extends Event> eventClass) {
        return HasJfrSupport.get();
    }

    @Substitute
    @TargetElement(onlyWith={JDKLatest.class})
    public static long getChunkStartNanos() {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        return SubstrateJVM.get().getChunkStartNanos();
    }

    @Substitute
    @TargetElement(onlyWith={JDKLatest.class})
    public static boolean setConfiguration(Class<? extends Event> eventClass, Target_jdk_jfr_internal_event_EventConfiguration configuration) {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        return SubstrateJVM.get().setConfiguration(eventClass, configuration);
    }

    @Substitute
    @TargetElement(onlyWith={JDKLatest.class})
    public static Object getConfiguration(Class<? extends Event> eventClass) {
        if (!HasJfrSupport.get()) {
            throw Target_jdk_jfr_internal_JVM_Util.jfrNotSupportedException();
        }
        return SubstrateJVM.get().getConfiguration(eventClass);
    }

    @Substitute
    @TargetElement(onlyWith={JDKLatest.class})
    public static long getTypeId(String name) {
        return -1L;
    }

    @Substitute
    @TargetElement(onlyWith={JDKLatest.class})
    public static boolean isContainerized() {
        return Container.singleton().isContainerized();
    }

    @Substitute
    @TargetElement(onlyWith={JDKLatest.class})
    public static long hostTotalMemory() {
        return OperatingSystem.singleton().getPhysicalMemorySize().rawValue();
    }

    @Substitute
    @TargetElement(onlyWith={JDKLatest.class})
    public static long hostTotalSwapMemory() {
        return -1L;
    }
}

