/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.annotate.TargetElement;
import com.oracle.svm.core.jdk.Target_javax_crypto_JceSecurity_WeakIdentityWrapper;
import com.oracle.svm.core.util.BasedOnJDKFile;
import com.oracle.svm.core.util.VMError;
import java.lang.ref.ReferenceQueue;
import java.net.URL;
import java.security.Provider;
import java.util.Map;
import java.util.WeakHashMap;

@TargetClass(className="javax.crypto.JceSecurity")
@BasedOnJDKFile(value="https://github.com/openjdk/jdk/blob/jdk-24+27/src/java.base/share/classes/javax/crypto/JceSecurity.java.template")
final class Target_javax_crypto_JceSecurity {
    @Alias
    private static Object PROVIDER_VERIFIED;
    @Alias
    private static Map<Object, Object> verificationResults;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.Reset)
    private static Map<Provider, Object> verifyingProviders;
    @Alias
    @RecomputeFieldValue(kind=RecomputeFieldValue.Kind.FromAlias)
    private static Map<Class<?>, URL> codeBaseCacheRef;
    @Alias
    @TargetElement
    private static ReferenceQueue<Object> queue;

    Target_javax_crypto_JceSecurity() {
    }

    @Substitute
    static Exception getVerificationResult(Provider p) {
        Target_javax_crypto_JceSecurity_WeakIdentityWrapper key = new Target_javax_crypto_JceSecurity_WeakIdentityWrapper(p, queue);
        Object o = verificationResults.get(key);
        if (o == PROVIDER_VERIFIED) {
            return null;
        }
        if (o != null) {
            return (Exception)o;
        }
        throw VMError.unsupportedFeature("Trying to verify a provider that was not registered at build time: " + String.valueOf(p) + ". All providers must be registered and verified in the Native Image builder. ");
    }

    static {
        codeBaseCacheRef = new WeakHashMap();
    }
}

