/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.imagelayer;

import com.oracle.svm.core.c.CGlobalData;
import com.oracle.svm.core.layeredimagesingleton.LayeredImageSingleton;
import jdk.graal.compiler.api.replacements.Fold;
import jdk.graal.compiler.word.Word;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.c.type.WordPointer;
import org.graalvm.word.Pointer;

public abstract class ImageLayerSection
implements LayeredImageSingleton {
    protected final CGlobalData<Pointer> initialSectionStart;
    protected final CGlobalData<WordPointer> cachedImageFDs;
    protected final CGlobalData<WordPointer> cachedImageHeapOffsets;
    protected final CGlobalData<WordPointer> cachedImageHeapRelocations;
    protected final CGlobalData<Word> heapRelativeRelocations;

    protected ImageLayerSection(CGlobalData<Pointer> initialSectionStart, CGlobalData<WordPointer> cachedImageFDs, CGlobalData<WordPointer> cachedImageHeapOffsets, CGlobalData<WordPointer> cachedImageHeapRelocations, CGlobalData<Word> heapRelativeRelocations) {
        this.initialSectionStart = initialSectionStart;
        this.cachedImageFDs = cachedImageFDs;
        this.cachedImageHeapOffsets = cachedImageHeapOffsets;
        this.cachedImageHeapRelocations = cachedImageHeapRelocations;
        this.heapRelativeRelocations = heapRelativeRelocations;
    }

    private static ImageLayerSection singleton() {
        return (ImageLayerSection)ImageSingletons.lookup(ImageLayerSection.class);
    }

    @Fold
    public static int getEntryOffset(SectionEntries entry) {
        return ImageLayerSection.singleton().getEntryOffsetInternal(entry);
    }

    @Fold
    public static CGlobalData<Pointer> getInitialLayerSection() {
        return ImageLayerSection.singleton().initialSectionStart;
    }

    @Fold
    public static CGlobalData<WordPointer> getCachedImageFDs() {
        return ImageLayerSection.singleton().cachedImageFDs;
    }

    @Fold
    public static CGlobalData<WordPointer> getCachedImageHeapOffsets() {
        return ImageLayerSection.singleton().cachedImageHeapOffsets;
    }

    @Fold
    public static CGlobalData<WordPointer> getCachedImageHeapRelocations() {
        return ImageLayerSection.singleton().cachedImageHeapRelocations;
    }

    @Fold
    public static CGlobalData<Word> getHeapRelativeRelocationsStart() {
        return ImageLayerSection.singleton().heapRelativeRelocations;
    }

    protected abstract int getEntryOffsetInternal(SectionEntries var1);

    public static enum SectionEntries {
        HEAP_BEGIN,
        HEAP_END,
        HEAP_RELOCATABLE_BEGIN,
        HEAP_RELOCATABLE_END,
        HEAP_ANY_RELOCATABLE_POINTER,
        HEAP_WRITEABLE_BEGIN,
        HEAP_WRITEABLE_END,
        HEAP_WRITEABLE_PATCHED_BEGIN,
        HEAP_WRITEABLE_PATCHED_END,
        NEXT_SECTION;

    }
}

