/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.heap.dump;

import com.oracle.svm.core.config.ConfigurationValues;
import jdk.graal.compiler.core.common.NumUtil;

public enum HProfType {
    NORMAL_OBJECT(2, 0),
    BOOLEAN(4, 1),
    CHAR(5, 2),
    FLOAT(6, 4),
    DOUBLE(7, 8),
    BYTE(8, 1),
    SHORT(9, 2),
    INT(10, 4),
    LONG(11, 8);

    private static final HProfType[] TYPES;
    private final byte value;
    private final int size;

    private HProfType(int value, int size) {
        this.value = NumUtil.safeToUByte((int)value);
        this.size = size;
    }

    public static HProfType get(byte value) {
        return TYPES[value];
    }

    public byte getValue() {
        return this.value;
    }

    public int getSize() {
        if (this.size == 0) {
            return ConfigurationValues.getTarget().wordSize;
        }
        return this.size;
    }

    static {
        TYPES = HProfType.values();
    }
}

