/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge.remset;

import com.oracle.svm.core.AlwaysInline;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.genscavenge.AlignedHeapChunk;
import com.oracle.svm.core.genscavenge.GreyToBlackObjectVisitor;
import com.oracle.svm.core.genscavenge.Space;
import com.oracle.svm.core.genscavenge.UnalignedHeapChunk;
import com.oracle.svm.core.heap.BarrierSetProvider;
import com.oracle.svm.core.image.ImageHeapObject;
import com.oracle.svm.core.util.HostedByteBufferPointer;
import java.util.List;
import jdk.graal.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.UnsignedWord;

public interface RememberedSet
extends BarrierSetProvider {
    @Fold
    public static RememberedSet get() {
        return (RememberedSet)ImageSingletons.lookup(RememberedSet.class);
    }

    public UnsignedWord getHeaderSizeOfAlignedChunk();

    public UnsignedWord getHeaderSizeOfUnalignedChunk();

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void enableRememberedSetForAlignedChunk(HostedByteBufferPointer var1, int var2, List<ImageHeapObject> var3);

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public void enableRememberedSetForUnalignedChunk(HostedByteBufferPointer var1);

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void enableRememberedSetForChunk(AlignedHeapChunk.AlignedHeader var1);

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void enableRememberedSetForChunk(UnalignedHeapChunk.UnalignedHeader var1);

    @AlwaysInline(value="GC performance")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void enableRememberedSetForObject(AlignedHeapChunk.AlignedHeader var1, Object var2, UnsignedWord var3);

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void clearRememberedSet(AlignedHeapChunk.AlignedHeader var1);

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void clearRememberedSet(UnalignedHeapChunk.UnalignedHeader var1);

    @AlwaysInline(value="GC performance")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public boolean hasRememberedSet(UnsignedWord var1);

    @AlwaysInline(value="GC performance")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void dirtyCardForAlignedObject(Object var1, boolean var2);

    @AlwaysInline(value="GC performance")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void dirtyCardForUnalignedObject(Object var1, boolean var2);

    @AlwaysInline(value="GC performance")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void dirtyCardIfNecessary(Object var1, Object var2);

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void walkDirtyObjects(AlignedHeapChunk.AlignedHeader var1, GreyToBlackObjectVisitor var2, boolean var3);

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void walkDirtyObjects(UnalignedHeapChunk.UnalignedHeader var1, GreyToBlackObjectVisitor var2, boolean var3);

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public void walkDirtyObjects(Space var1, GreyToBlackObjectVisitor var2, boolean var3);

    public boolean verify(AlignedHeapChunk.AlignedHeader var1);

    public boolean verify(UnalignedHeapChunk.UnalignedHeader var1);

    public boolean verify(UnalignedHeapChunk.UnalignedHeader var1, UnalignedHeapChunk.UnalignedHeader var2);
}

