/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge.remset;

import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.genscavenge.AlignedHeapChunk;
import com.oracle.svm.core.genscavenge.HeapChunk;
import com.oracle.svm.core.genscavenge.remset.AlignedChunkRememberedSet;
import jdk.graal.compiler.api.replacements.Fold;
import org.graalvm.word.Pointer;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordBase;

public final class BrickTable {
    private static final int ENTRY_SIZE_BYTES = 2;
    private static final int BYTES_COVERED_BY_ENTRY = 1024;

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static UnsignedWord getIndex(AlignedHeapChunk.AlignedHeader chunk, Pointer pointer) {
        Pointer objectsStart = AlignedHeapChunk.getObjectsStart(chunk);
        UnsignedWord index = pointer.subtract((UnsignedWord)objectsStart).unsignedDivide(1024);
        assert (index.aboveOrEqual(0) && index.belowThan(BrickTable.getLength())) : "index out of range";
        return index;
    }

    @Fold
    public static UnsignedWord getLength() {
        UnsignedWord bytesCovered = AlignedHeapChunk.getUsableSizeForObjects();
        UnsignedWord length = bytesCovered.add(1023).unsignedDivide(1024);
        assert (length.multiply(2).belowOrEqual(AlignedChunkRememberedSet.getCardTableSize())) : "brick table size does not match card table size";
        return length;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static Pointer getEntry(AlignedHeapChunk.AlignedHeader chunk, UnsignedWord index) {
        short entry = BrickTable.getBrickTableStart(chunk).readShort((WordBase)index.multiply(2));
        int offset = (entry & 0xFFFF) * ConfigurationValues.getObjectLayout().getAlignment();
        return HeapChunk.asPointer(chunk).add(offset);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void setEntry(AlignedHeapChunk.AlignedHeader chunk, UnsignedWord index, Pointer pointer) {
        Pointer offset = pointer.subtract((UnsignedWord)HeapChunk.asPointer(chunk));
        int alignment = ConfigurationValues.getObjectLayout().getAlignment();
        short entry = (short)offset.unsignedDivide(alignment).rawValue();
        BrickTable.getBrickTableStart(chunk).writeShort((WordBase)index.multiply(2), entry);
        assert (BrickTable.getEntry(chunk, index).equal((UnsignedWord)pointer));
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    private static Pointer getBrickTableStart(AlignedHeapChunk.AlignedHeader chunk) {
        return AlignedChunkRememberedSet.getCardTableStart(chunk);
    }

    private BrickTable() {
    }
}

