/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.genscavenge;

import com.oracle.svm.core.AlwaysInline;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.genscavenge.AlignedHeapChunk;
import com.oracle.svm.core.genscavenge.HeapChunk;
import com.oracle.svm.core.genscavenge.Space;
import com.oracle.svm.core.genscavenge.UnalignedHeapChunk;
import com.oracle.svm.core.heap.ObjectVisitor;
import com.oracle.svm.core.log.Log;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

abstract class Generation {
    private final String name;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    Generation(String name) {
        this.name = name;
    }

    public abstract boolean walkObjects(ObjectVisitor var1);

    public String getName() {
        return this.name;
    }

    public abstract void logUsage(Log var1);

    public abstract void logChunks(Log var1);

    @AlwaysInline(value="GC performance")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected abstract Object promoteAlignedObject(Object var1, AlignedHeapChunk.AlignedHeader var2, Space var3);

    @AlwaysInline(value="GC performance")
    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    protected abstract Object promoteUnalignedObject(Object var1, UnalignedHeapChunk.UnalignedHeader var2, Space var3);

    protected abstract boolean promotePinnedObject(Object var1, HeapChunk.Header<?> var2, boolean var3, Space var4);

    void checkSanityBeforeCollection() {
    }

    void checkSanityAfterCollection() {
    }
}

