/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.deopt;

import com.oracle.svm.core.BuildPhaseProvider;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.deopt.DeoptimizationCanaryFeature;
import com.oracle.svm.core.heap.UnknownPrimitiveField;
import jdk.graal.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.function.CFunctionPointer;

public class DeoptimizationSupport {
    @UnknownPrimitiveField(availability=BuildPhaseProvider.ReadyForCompilation.class)
    private CFunctionPointer deoptStubPointer;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public DeoptimizationSupport() {
    }

    @Fold
    public static boolean enabled() {
        return ImageSingletons.contains(DeoptimizationCanaryFeature.class);
    }

    @Fold
    static DeoptimizationSupport get() {
        return (DeoptimizationSupport)ImageSingletons.lookup(DeoptimizationSupport.class);
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static void setDeoptStubPointer(CFunctionPointer deoptStub) {
        assert (DeoptimizationSupport.get().deoptStubPointer == null) : "multiple deopt stub methods registered";
        DeoptimizationSupport.get().deoptStubPointer = deoptStub;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static CFunctionPointer getDeoptStubPointer() {
        CFunctionPointer ptr = DeoptimizationSupport.get().deoptStubPointer;
        assert (ptr.rawValue() != 0L);
        return ptr;
    }
}

