/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core;

import com.oracle.svm.core.IsolateArguments;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.c.CGlobalData;
import com.oracle.svm.core.c.CGlobalDataFactory;
import com.oracle.svm.core.os.CommittedMemoryProvider;
import com.oracle.svm.core.util.TimeUtils;
import com.oracle.svm.core.util.VMError;
import jdk.graal.compiler.nodes.NamedLocationIdentity;
import jdk.graal.compiler.word.Word;
import org.graalvm.nativeimage.Isolate;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.type.WordPointer;
import org.graalvm.word.Pointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public class Isolates {
    public static final String IMAGE_HEAP_BEGIN_SYMBOL_NAME = "__svm_heap_begin";
    public static final String IMAGE_HEAP_END_SYMBOL_NAME = "__svm_heap_end";
    public static final String IMAGE_HEAP_RELOCATABLE_BEGIN_SYMBOL_NAME = "__svm_heap_relocatable_begin";
    public static final String IMAGE_HEAP_RELOCATABLE_END_SYMBOL_NAME = "__svm_heap_relocatable_end";
    public static final String IMAGE_HEAP_A_RELOCATABLE_POINTER_SYMBOL_NAME = "__svm_a_relocatable_pointer";
    public static final String IMAGE_HEAP_WRITABLE_BEGIN_SYMBOL_NAME = "__svm_heap_writable_begin";
    public static final String IMAGE_HEAP_WRITABLE_END_SYMBOL_NAME = "__svm_heap_writable_end";
    public static final String IMAGE_HEAP_WRITABLE_PATCHED_BEGIN_SYMBOL_NAME = "__svm_heap_writable_patched_begin";
    public static final String IMAGE_HEAP_WRITABLE_PATCHED_END_SYMBOL_NAME = "__svm_heap_writable_patched_end";
    public static final CGlobalData<Word> IMAGE_HEAP_BEGIN = CGlobalDataFactory.forSymbol("__svm_heap_begin");
    public static final CGlobalData<Word> IMAGE_HEAP_END = CGlobalDataFactory.forSymbol("__svm_heap_end");
    public static final CGlobalData<Word> IMAGE_HEAP_RELOCATABLE_BEGIN = CGlobalDataFactory.forSymbol("__svm_heap_relocatable_begin");
    public static final CGlobalData<Word> IMAGE_HEAP_RELOCATABLE_END = CGlobalDataFactory.forSymbol("__svm_heap_relocatable_end");
    public static final CGlobalData<Word> IMAGE_HEAP_A_RELOCATABLE_POINTER = CGlobalDataFactory.forSymbol("__svm_a_relocatable_pointer");
    public static final CGlobalData<Word> IMAGE_HEAP_WRITABLE_BEGIN = CGlobalDataFactory.forSymbol("__svm_heap_writable_begin");
    public static final CGlobalData<Word> IMAGE_HEAP_WRITABLE_END = CGlobalDataFactory.forSymbol("__svm_heap_writable_end");
    public static final CGlobalData<Word> IMAGE_HEAP_WRITABLE_PATCHED_BEGIN = CGlobalDataFactory.forSymbol("__svm_heap_writable_patched_begin");
    public static final CGlobalData<Word> IMAGE_HEAP_WRITABLE_PATCHED_END = CGlobalDataFactory.forSymbol("__svm_heap_writable_patched_end");
    public static final CGlobalData<Pointer> ISOLATE_COUNTER = CGlobalDataFactory.createWord((WordBase)WordFactory.unsigned((int)1));
    private static final CGlobalData<Pointer> SINGLE_ISOLATE_ALREADY_CREATED = CGlobalDataFactory.createWord();
    private static long startTimeNanos;
    private static long initDoneTimeMillis;
    private static long isolateId;

    public static boolean isCurrentFirst() {
        VMError.guarantee(isolateId >= 0L);
        return isolateId == 0L;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static void assignIsolateId(boolean isFirstIsolate) {
        if (isFirstIsolate) {
            isolateId = 0L;
        } else {
            long nextId;
            long currentId;
            Pointer currentIdPointer = ISOLATE_COUNTER.get();
            while (!currentIdPointer.logicCompareAndSwapLong(0, currentId = currentIdPointer.readLong(0), nextId = currentId + 1L, NamedLocationIdentity.OFF_HEAP_LOCATION)) {
            }
            isolateId = currentId;
            VMError.guarantee(isolateId > 0L);
        }
    }

    public static void assignStartTime() {
        assert (startTimeNanos == 0L) : startTimeNanos;
        assert (initDoneTimeMillis == 0L) : initDoneTimeMillis;
        startTimeNanos = System.nanoTime();
        initDoneTimeMillis = TimeUtils.currentTimeMillis();
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static long getInitDoneTimeMillis() {
        assert (initDoneTimeMillis != 0L);
        return initDoneTimeMillis;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static long getUptimeMillis() {
        assert (startTimeNanos != 0L);
        return TimeUtils.millisSinceNanos(startTimeNanos);
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static long getStartTimeNanos() {
        assert (startTimeNanos != 0L);
        return startTimeNanos;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static long getIsolateId() {
        assert (isolateId >= 0L);
        return isolateId;
    }

    @Uninterruptible(reason="Thread state not yet set up.")
    public static int checkIsolate(Isolate isolate) {
        return isolate.isNull() ? 2 : 0;
    }

    @Uninterruptible(reason="Thread state not yet set up.")
    public static int create(WordPointer isolatePointer, IsolateArguments arguments) {
        if (!SubstrateOptions.SpawnIsolates.getValue().booleanValue() && !SINGLE_ISOLATE_ALREADY_CREATED.get().logicCompareAndSwapWord(0, WordFactory.zero(), (WordBase)WordFactory.signed((int)1), NamedLocationIdentity.OFF_HEAP_LOCATION)) {
            return 33;
        }
        WordPointer heapBasePointer = (WordPointer)StackValue.get(WordPointer.class);
        int result = CommittedMemoryProvider.get().initialize(heapBasePointer, arguments);
        if (result != 0) {
            return result;
        }
        Isolate isolate = (Isolate)heapBasePointer.read();
        result = Isolates.checkIsolate(isolate);
        if (result != 0) {
            isolatePointer.write((WordBase)WordFactory.nullPointer());
            return result;
        }
        isolatePointer.write((WordBase)isolate);
        return 0;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    public static PointerBase getHeapBase(Isolate isolate) {
        return isolate;
    }

    static {
        isolateId = -1L;
    }
}

