/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jipher.pki.internal;

import java.security.AccessController;
import java.security.PrivilegedAction;

public class Debug {
    private static Debug NONE = new Debug(null){

        @Override
        public void println(String msg) {
        }

        @Override
        public void println(Printer p) {
        }
    };
    private String typeName;

    private Debug(String type) {
        this.typeName = type;
    }

    public static Debug getInstance(String type) {
        String debugVal = System.getSecurityManager() == null ? System.getProperty("java.security.debug") : (String)AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                return System.getProperty("java.security.debug");
            }
        });
        if (debugVal != null && (debugVal.toLowerCase().contains(type.toLowerCase()) || debugVal.toLowerCase().contains("all"))) {
            return new Debug(type);
        }
        return NONE;
    }

    public void println(Printer p) {
        this.println(p.print());
    }

    public void println(String msg) {
        System.err.print(this.typeName + ":");
        System.err.println(msg);
    }

    public static interface Printer {
        public String print();
    }
}

