/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.aotjs.codegen;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.svm.aotjs.functionintrinsics.a;
import com.oracle.svm.common.meta.MultiMethod;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.hosted.FeatureImpl;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.debug.GraalError;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.extended.BytecodeExceptionNode;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
public final class t
implements InternalFeature {
    private final HashMap<String, Method> iK = t.c(a.class);
    private final HashSet<Method> iL = new HashSet();
    private final HashSet<AnalysisMethod> iM = new HashSet();

    private static HashMap<String, Method> c(Class<?> clazz) {
        HashMap<String, Method> hashMap = new HashMap<String, Method>();
        for (Method method : clazz.getDeclaredMethods()) {
            hashMap.put(method.getName(), method);
        }
        return hashMap;
    }

    private boolean bC() {
        return this.iL.size() == this.iK.size();
    }

    public static String a(BytecodeExceptionNode.BytecodeExceptionKind bytecodeExceptionKind) {
        return switch (bytecodeExceptionKind) {
            case BytecodeExceptionNode.BytecodeExceptionKind.ARRAY_STORE -> "createNewArrayStoreExceptionWithArgs";
            case BytecodeExceptionNode.BytecodeExceptionKind.NEGATIVE_ARRAY_SIZE -> "createNegativeArraySizeException";
            case BytecodeExceptionNode.BytecodeExceptionKind.CLASS_CAST -> "createNewClassCastExceptionWithArgs";
            case BytecodeExceptionNode.BytecodeExceptionKind.DIVISION_BY_ZERO -> "createNewDivisionByZeroException";
            case BytecodeExceptionNode.BytecodeExceptionKind.INTEGER_EXACT_OVERFLOW, BytecodeExceptionNode.BytecodeExceptionKind.LONG_EXACT_OVERFLOW -> "createNewArithmeticException";
            case BytecodeExceptionNode.BytecodeExceptionKind.NULL_POINTER -> "createNewNullPointerException";
            case BytecodeExceptionNode.BytecodeExceptionKind.OUT_OF_BOUNDS -> "createNewOutOfBoundsExceptionWithArgs";
            case BytecodeExceptionNode.BytecodeExceptionKind.INTRINSIC_OUT_OF_BOUNDS -> "createNewOutOfBoundsException";
            case BytecodeExceptionNode.BytecodeExceptionKind.INCOMPATIBLE_CLASS_CHANGE -> "createNewIncompatibleClassChangeError";
            case BytecodeExceptionNode.BytecodeExceptionKind.ILLEGAL_ARGUMENT_EXCEPTION_NEGATIVE_LENGTH -> "createNewNegativeLengthException";
            case BytecodeExceptionNode.BytecodeExceptionKind.ILLEGAL_ARGUMENT_EXCEPTION_ARGUMENT_IS_NOT_AN_ARRAY -> "createNewArgumentIsNotArrayException";
            case BytecodeExceptionNode.BytecodeExceptionKind.ASSERTION_ERROR_OBJECT -> "createNewAssertionErrorObject";
            case BytecodeExceptionNode.BytecodeExceptionKind.ASSERTION_ERROR_NULLARY -> "createNewAssertionErrorNullary";
            default -> throw GraalError.shouldNotReachHereUnexpectedValue((Object)bytecodeExceptionKind);
        };
    }

    private Method b(BytecodeExceptionNode.BytecodeExceptionKind bytecodeExceptionKind) {
        return this.iK.get(t.a(bytecodeExceptionKind));
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        this.iL.clear();
        this.iM.clear();
        Method[] methodArray = new Method[]{this.iK.get("checkNullPointer"), this.iK.get("checkArrayBound")};
        FeatureImpl.BeforeAnalysisAccessImpl beforeAnalysisAccessImpl = (FeatureImpl.BeforeAnalysisAccessImpl)access;
        AnalysisMetaAccess analysisMetaAccess = beforeAnalysisAccessImpl.getMetaAccess();
        for (Method method : methodArray) {
            AnalysisMethod analysisMethod = analysisMetaAccess.lookupJavaMethod((Executable)method);
            beforeAnalysisAccessImpl.registerAsRoot(analysisMethod, true, "Web image runtime check outlining support, registered in " + String.valueOf(t.class), new MultiMethod.MultiMethodKey[0]);
        }
    }

    public void duringAnalysis(Feature.DuringAnalysisAccess access) {
        if (this.bC()) {
            return;
        }
        FeatureImpl.DuringAnalysisAccessImpl duringAnalysisAccessImpl = (FeatureImpl.DuringAnalysisAccessImpl)access;
        BigBang bigBang = duringAnalysisAccessImpl.getBigBang();
        AnalysisUniverse analysisUniverse = bigBang.getUniverse();
        for (AnalysisMethod analysisMethod : analysisUniverse.getMethods()) {
            if (!analysisMethod.isReachable() || this.iM.contains(analysisMethod)) continue;
            this.iM.add(analysisMethod);
            StructuredGraph structuredGraph = analysisMethod.decodeAnalyzedGraph(DebugContext.forCurrentThread(), null);
            if (structuredGraph == null) continue;
            for (BytecodeExceptionNode bytecodeExceptionNode : structuredGraph.getNodes().filter(BytecodeExceptionNode.class)) {
                this.a(duringAnalysisAccessImpl, bytecodeExceptionNode.getExceptionKind(), (List<ValueNode>)bytecodeExceptionNode.getArguments());
                if (!this.bC()) continue;
                return;
            }
        }
    }

    private void a(FeatureImpl.DuringAnalysisAccessImpl duringAnalysisAccessImpl, BytecodeExceptionNode.BytecodeExceptionKind bytecodeExceptionKind, List<ValueNode> list) {
        Method method = this.b(bytecodeExceptionKind);
        if (list.size() != method.getParameterCount()) {
            throw new GraalError("Unexpected number of arguments for %s. Expected %d, got %d", new Object[]{bytecodeExceptionKind, method.getParameterCount(), list.size()});
        }
        AnalysisMethod analysisMethod = duringAnalysisAccessImpl.getMetaAccess().lookupJavaMethod((Executable)method);
        boolean bl = this.iL.add(method);
        if (bl && !analysisMethod.isInvoked()) {
            duringAnalysisAccessImpl.registerAsRoot(analysisMethod, false, "Web image implicit exception support, registered in " + String.valueOf(t.class), new MultiMethod.MultiMethodKey[0]);
            duringAnalysisAccessImpl.requireAnalysisIteration();
        }
    }
}

