/*
 * Decompiled with CFR 0.152.
 */
package jdk.graal.compiler.options.processor;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import jdk.graal.compiler.processor.AbstractProcessor;

@SupportedAnnotationTypes(value={"jdk.graal.compiler.options.Option"})
public class OptionProcessor
extends AbstractProcessor {
    private static final String OPTION_CLASS_NAME = "jdk.graal.compiler.options.Option";
    private static final String OPTION_KEY_CLASS_NAME = "jdk.graal.compiler.options.OptionKey";
    private static final String OPTION_TYPE_CLASS_NAME = "jdk.graal.compiler.options.OptionType";
    private static final String OPTION_STABILITY_CLASS_NAME = "jdk.graal.compiler.options.OptionStability";
    private static final String OPTION_TYPE_GROUP_NAME = "jdk.graal.compiler.options.OptionGroup";
    private static final String OPTION_DESCRIPTOR_CLASS_NAME = "jdk.graal.compiler.options.OptionDescriptor";
    private static final String OPTION_DESCRIPTORS_CLASS_NAME = "jdk.graal.compiler.options.OptionDescriptors";
    private final Set<Element> processed = new HashSet<Element>();
    private TypeMirror optionTypeMirror;
    private TypeMirror optionKeyTypeMirror;

    private void processElement(Element element, OptionsInfo info) {
        char firstChar;
        if (!element.getModifiers().contains((Object)Modifier.STATIC)) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Option field must be static", element);
            return;
        }
        if (element.getModifiers().contains((Object)Modifier.PRIVATE)) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Option field cannot be private", element);
            return;
        }
        AnnotationMirror annotation = this.getAnnotation(element, this.optionTypeMirror);
        assert (annotation != null);
        assert (element instanceof VariableElement);
        assert (element.getKind() == ElementKind.FIELD);
        VariableElement field = (VariableElement)element;
        String fieldName = field.getSimpleName().toString();
        Types types = this.processingEnv.getTypeUtils();
        TypeMirror fieldType = field.asType();
        if (fieldType.getKind() != TypeKind.DECLARED) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Option field must be of type jdk.graal.compiler.options.OptionKey", element);
            return;
        }
        DeclaredType declaredFieldType = (DeclaredType)fieldType;
        if (!types.isSubtype(fieldType, types.erasure(this.optionKeyTypeMirror))) {
            String msg = String.format("Option field type %s is not a subclass of %s", fieldType, this.optionKeyTypeMirror);
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg, element);
            return;
        }
        if (!field.getModifiers().contains((Object)Modifier.STATIC)) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Option field must be static", element);
            return;
        }
        if (field.getModifiers().contains((Object)Modifier.PRIVATE)) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Option field cannot be private", element);
            return;
        }
        String prefix = this.resolveOptionPrefix(element.getEnclosingElement());
        Object optionName = OptionProcessor.getAnnotationValue(annotation, "name", String.class);
        if (((String)optionName).equals("")) {
            optionName = fieldName;
        }
        if (!Character.isUpperCase(((String)optionName).charAt(0))) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Option name must start with an upper case letter", element);
            return;
        }
        if (!prefix.isEmpty()) {
            optionName = prefix + (String)optionName;
        }
        DeclaredType declaredOptionKeyType = declaredFieldType;
        while (!types.isSameType(types.erasure(declaredOptionKeyType), types.erasure(this.optionKeyTypeMirror))) {
            List<? extends TypeMirror> directSupertypes = types.directSupertypes(declaredFieldType);
            assert (!directSupertypes.isEmpty());
            declaredOptionKeyType = (DeclaredType)directSupertypes.get(0);
        }
        assert (!declaredOptionKeyType.getTypeArguments().isEmpty());
        String optionType = declaredOptionKeyType.getTypeArguments().get(0).toString();
        if (optionType.startsWith("java.lang.")) {
            optionType = optionType.substring("java.lang.".length());
        }
        if (optionType.contains("<")) {
            optionType = optionType.substring(0, optionType.indexOf("<"));
        }
        Object declaringClass = "";
        String separator = "";
        Set<Element> originatingElementsList = info.originatingElements;
        originatingElementsList.add(field);
        PackageElement enclosingPackage = null;
        for (Element enclosing = element.getEnclosingElement(); enclosing != null; enclosing = enclosing.getEnclosingElement()) {
            if (enclosing.getKind() == ElementKind.CLASS || enclosing.getKind() == ElementKind.INTERFACE || enclosing.getKind() == ElementKind.ENUM) {
                if (enclosing.getModifiers().contains((Object)Modifier.PRIVATE)) {
                    String msg = String.format("Option field cannot be declared in a private %s %s", enclosing.getKind().name().toLowerCase(), enclosing);
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg, element);
                    return;
                }
            } else {
                if (enclosing.getKind() == ElementKind.PACKAGE) {
                    enclosingPackage = (PackageElement)enclosing;
                    break;
                }
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Unexpected enclosing element kind: " + String.valueOf((Object)enclosing.getKind()), element);
                return;
            }
            originatingElementsList.add(enclosing);
            declaringClass = String.valueOf(enclosing.getSimpleName()) + separator + (String)declaringClass;
            separator = ".";
        }
        if (enclosingPackage == null || enclosingPackage.isUnnamed()) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Option field cannot be declared in the unnamed package", element);
            return;
        }
        List<String> helpValue = OptionProcessor.getAnnotationValueList(annotation, "help", String.class);
        String help = "";
        List<Object> extraHelp = new ArrayList();
        if (helpValue.size() == 1) {
            help = helpValue.get(0);
            if (help.startsWith("file:")) {
                String path = help.substring("file:".length());
                Filer filer = this.processingEnv.getFiler();
                try {
                    FileObject file;
                    try {
                        file = filer.getResource(StandardLocation.SOURCE_PATH, enclosingPackage.getQualifiedName(), path);
                    }
                    catch (IOException | IllegalArgumentException e) {
                        file = filer.getResource(StandardLocation.CLASS_OUTPUT, enclosingPackage.getQualifiedName(), path);
                    }
                    try (BufferedReader br = new BufferedReader(new InputStreamReader(file.openInputStream()));){
                        help = br.readLine();
                        if (help == null) {
                            help = "";
                        }
                        String line = br.readLine();
                        while (line != null) {
                            extraHelp.add(line);
                            line = br.readLine();
                        }
                    }
                }
                catch (IOException e) {
                    String msg = String.format("Error reading %s containing the help text for option field: %s", path, e);
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg, element);
                    return;
                }
            }
        } else if (helpValue.size() > 1) {
            help = helpValue.get(0);
            extraHelp = helpValue.subList(1, helpValue.size());
        }
        if (help.length() != 0 && !Character.isUpperCase(firstChar = help.charAt(0))) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Option help text must start with an upper case letter", element);
            return;
        }
        String stability = OptionProcessor.getAnnotationValue(annotation, "stability", VariableElement.class).getSimpleName().toString();
        if (stability.equals("STABLE") && help.length() == 0) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "A stable option must have non-empty help text", element);
            return;
        }
        String optionTypeName = OptionProcessor.getAnnotationValue(annotation, "type", VariableElement.class).getSimpleName().toString();
        if (!optionTypeName.equals("Debug") && help.length() == 0) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Non debug options must always have a option help text " + (String)optionName);
        }
        boolean deprecated = OptionProcessor.getAnnotationValue(annotation, "deprecated", Boolean.class);
        String deprecationMessage = OptionProcessor.getAnnotationValue(annotation, "deprecationMessage", String.class);
        info.options.add(new OptionInfo((String)optionName, optionTypeName, help, extraHelp, optionType, (String)declaringClass, field.getSimpleName().toString(), stability, deprecated, deprecationMessage));
    }

    private String resolveOptionPrefix(Element optionType) {
        TypeMirror optionGroupType = this.processingEnv.getElementUtils().getTypeElement(OPTION_TYPE_GROUP_NAME).asType();
        AnnotationMirror optionGroup = this.getAnnotation(optionType, optionGroupType);
        String prefix = optionGroup == null ? "" : OptionProcessor.getAnnotationValue(optionGroup, "prefix", String.class);
        return prefix;
    }

    public static void createOptionsDescriptorsFile(ProcessingEnvironment processingEnv, OptionsInfo info) {
        Element[] originatingElements = info.originatingElements.toArray(new Element[info.originatingElements.size()]);
        String optionsDescriptorsClassName = info.registerAsService ? info.className + "_" + OptionProcessor.getSimpleName(OPTION_DESCRIPTORS_CLASS_NAME) : info.className + OptionProcessor.getSimpleName(OPTION_DESCRIPTORS_CLASS_NAME);
        Filer filer = processingEnv.getFiler();
        try (PrintWriter out = OptionProcessor.createSourceFile(info.packageName, optionsDescriptorsClassName, filer, originatingElements);){
            out.println("// CheckStyle: stop header check");
            out.println("// CheckStyle: stop line length check");
            out.println("// GENERATED CONTENT - DO NOT EDIT");
            out.println("// Source: " + info.className + ".java");
            out.println("package " + info.packageName + ";");
            out.println("");
            out.println("import java.util.*;");
            out.println("import " + OptionProcessor.getPackageName(OPTION_DESCRIPTORS_CLASS_NAME) + ".*;");
            out.println("import jdk.graal.compiler.options.OptionType;");
            out.println("import jdk.graal.compiler.options.OptionStability;");
            out.println("");
            Object implementsClause = info.registerAsService ? " implements " + OptionProcessor.getSimpleName(OPTION_DESCRIPTORS_CLASS_NAME) : "";
            implementsClause = info.registerAsService ? " implements " + OptionProcessor.getSimpleName(OPTION_DESCRIPTORS_CLASS_NAME) : " implements Iterable<" + OptionProcessor.getSimpleName(OPTION_DESCRIPTOR_CLASS_NAME) + ">";
            out.println("public class " + optionsDescriptorsClassName + (String)implementsClause + " {");
            String desc = OptionProcessor.getSimpleName(OPTION_DESCRIPTOR_CLASS_NAME);
            Collections.sort(info.options);
            if (info.registerAsService) {
                out.println("    @Override");
            } else {
                out.println("    static {");
                out.println("        for (" + OptionProcessor.getSimpleName(OPTION_DESCRIPTOR_CLASS_NAME) + " d : new " + optionsDescriptorsClassName + "()) {");
                out.println("            // consume all options once to ensure that option key descriptors are set");
                out.println("            // this is necessary if the option descriptors are not consumed as services");
                out.println("            assert d.getOptionKey().getDescriptor() != null;");
                out.println("        }");
                out.println("    }");
            }
            out.println("    public OptionDescriptor get(String value) {");
            out.println("        switch (value) {");
            out.println("        // CheckStyle: stop line length check");
            for (OptionInfo option : info.options) {
                String name = option.name;
                String optionField = option.declaringClass + "." + option.field;
                out.println("        case \"" + name + "\": {");
                String optionType = option.optionType;
                String type = option.type;
                String help = option.help;
                List<String> extraHelp = option.extraHelp;
                String declaringClass = option.declaringClass;
                String fieldName = option.field;
                String stability = option.stability;
                boolean deprecated = option.deprecated;
                String deprecationMessage = option.deprecationMessage;
                out.printf("            return " + desc + ".create(\n", new Object[0]);
                out.printf("                /*name*/ \"%s\",\n", name);
                out.printf("                /*optionType*/ %s.%s,\n", OptionProcessor.getSimpleName(OPTION_TYPE_CLASS_NAME), optionType);
                out.printf("                /*optionValueType*/ %s.class,\n", type);
                out.printf("                /*help*/ \"%s\",\n", help);
                if (extraHelp.size() != 0) {
                    out.printf("                /*extraHelp*/ new String[] {\n", new Object[0]);
                    for (String line : extraHelp) {
                        out.printf("                         \"%s\",\n", line.replace("\\", "\\\\").replace("\"", "\\\""));
                    }
                    out.printf("                              },\n", new Object[0]);
                }
                out.printf("                /*declaringClass*/ %s.class,\n", declaringClass);
                out.printf("                /*fieldName*/ \"%s\",\n", fieldName);
                out.printf("                /*option*/ %s,\n", optionField);
                out.printf("                /*stability*/ %s.%s,\n", OptionProcessor.getSimpleName(OPTION_STABILITY_CLASS_NAME), stability);
                out.printf("                /*deprecated*/ %b,\n", deprecated);
                out.printf("                /*deprecationMessage*/ \"%s\");\n", deprecationMessage);
                out.println("        }");
            }
            out.println("        // CheckStyle: resume line length check");
            out.println("        }");
            out.println("        return null;");
            out.println("    }");
            out.println();
            out.println("    @Override");
            out.println("    public Iterator<" + desc + "> iterator() {");
            out.println("        return new Iterator<" + (processingEnv.getSourceVersion().compareTo(SourceVersion.RELEASE_8) <= 0 ? desc : "") + ">() {");
            out.println("            int i = 0;");
            out.println("            @Override");
            out.println("            public boolean hasNext() {");
            out.println("                return i < " + info.options.size() + ";");
            out.println("            }");
            out.println("            @Override");
            out.println("            public OptionDescriptor next() {");
            out.println("                switch (i++) {");
            for (int i = 0; i < info.options.size(); ++i) {
                OptionInfo option;
                option = info.options.get(i);
                out.println("                    case " + i + ": return get(\"" + option.name + "\");");
            }
            out.println("                }");
            out.println("                throw new NoSuchElementException();");
            out.println("            }");
            out.println("        };");
            out.println("    }");
            out.println("}");
        }
    }

    private static Element topDeclaringType(Element element) {
        Element enclosing = element.getEnclosingElement();
        if (enclosing == null || enclosing.getKind() == ElementKind.PACKAGE) {
            return element;
        }
        return OptionProcessor.topDeclaringType(enclosing);
    }

    @Override
    public boolean doProcess(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver()) {
            return true;
        }
        TypeElement optionTypeElement = this.getTypeElement(OPTION_CLASS_NAME);
        this.optionTypeMirror = optionTypeElement.asType();
        this.optionKeyTypeMirror = this.getTypeElement(OPTION_KEY_CLASS_NAME).asType();
        HashMap<Element, OptionsInfo> map = new HashMap<Element, OptionsInfo>();
        for (Element element : roundEnv.getElementsAnnotatedWith(optionTypeElement)) {
            if (this.processed.contains(element)) continue;
            this.processed.add(element);
            Element topDeclaringType = OptionProcessor.topDeclaringType(element);
            OptionsInfo options = (OptionsInfo)map.get(topDeclaringType);
            if (options == null) {
                String pkg = ((PackageElement)topDeclaringType.getEnclosingElement()).getQualifiedName().toString();
                String topDeclaringClass = topDeclaringType.getSimpleName().toString();
                options = new OptionsInfo(pkg, topDeclaringClass, this.isRegisterAsService(topDeclaringType));
                map.put(topDeclaringType, options);
            }
            if (!element.getEnclosingElement().getSimpleName().toString().endsWith("Options")) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Option declaring classes must have a name that ends with 'Options'", element.getEnclosingElement());
            }
            this.processElement(element, options);
        }
        boolean ok = true;
        HashMap<String, OptionInfo> hashMap = new HashMap<String, OptionInfo>();
        for (Map.Entry e : map.entrySet()) {
            OptionsInfo info = (OptionsInfo)e.getValue();
            for (OptionInfo option : info.options) {
                OptionInfo conflict = hashMap.put(option.name, option);
                if (conflict == null) continue;
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Duplicate option names for " + String.valueOf(option) + " and " + String.valueOf(conflict), (Element)e.getKey());
                ok = false;
            }
        }
        if (ok) {
            for (OptionsInfo info : map.values()) {
                OptionProcessor.createOptionsDescriptorsFile(this.processingEnv, info);
            }
        }
        return true;
    }

    private boolean isRegisterAsService(Element declaringOptionType) {
        TypeMirror optionGroupType = this.processingEnv.getElementUtils().getTypeElement(OPTION_TYPE_GROUP_NAME).asType();
        AnnotationMirror group = this.getAnnotation(declaringOptionType, optionGroupType);
        if (group == null) {
            return true;
        }
        return OptionProcessor.getAnnotationValue(group, "registerAsService", Boolean.class);
    }

    public static class OptionsInfo {
        public final String packageName;
        public final String className;
        public final List<OptionInfo> options = new ArrayList<OptionInfo>();
        public final Set<Element> originatingElements = new HashSet<Element>();
        public final boolean registerAsService;

        public OptionsInfo(String packageName, String className, boolean registerAsService) {
            this.packageName = packageName;
            this.className = className;
            this.registerAsService = registerAsService;
        }
    }

    public static class OptionInfo
    implements Comparable<OptionInfo> {
        public final String name;
        public final String optionType;
        public final String help;
        public final List<String> extraHelp;
        public final String type;
        public final String declaringClass;
        public final String field;
        public final String stability;
        public final boolean deprecated;
        public final String deprecationMessage;

        public OptionInfo(String name, String optionType, String help, List<String> extraHelp, String type, String declaringClass, String field, String stability, boolean deprecated, String deprecationMessage) {
            this.name = name;
            this.optionType = optionType;
            this.help = help;
            this.extraHelp = extraHelp;
            this.type = type;
            this.declaringClass = declaringClass;
            this.field = field;
            this.stability = stability;
            this.deprecated = deprecated;
            this.deprecationMessage = deprecationMessage;
        }

        @Override
        public int compareTo(OptionInfo other) {
            return this.name.compareTo(other.name);
        }

        public String toString() {
            return this.declaringClass + "." + this.field;
        }
    }
}

