/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.results;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.api.PointstoOptions;
import com.oracle.graal.pointsto.flow.AnalysisParsedGraph;
import com.oracle.graal.pointsto.flow.InvokeTypeFlow;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.flow.MethodTypeFlow;
import com.oracle.graal.pointsto.flow.PrimitiveFilterTypeFlow;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.heap.ImageHeapConstant;
import com.oracle.graal.pointsto.infrastructure.Universe;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.PointsToAnalysisMethod;
import com.oracle.graal.pointsto.results.StrengthenGraphsCounters;
import com.oracle.graal.pointsto.typestate.PrimitiveConstantTypeState;
import com.oracle.graal.pointsto.typestate.TypeState;
import com.oracle.graal.pointsto.util.AnalysisError;
import com.oracle.svm.core.annotate.Delete;
import com.oracle.svm.util.ImageBuildStatistics;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import jdk.graal.compiler.core.common.type.AbstractObjectStamp;
import jdk.graal.compiler.core.common.type.IntegerStamp;
import jdk.graal.compiler.core.common.type.ObjectStamp;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.core.common.type.TypeReference;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.debug.DebugHandlersFactory;
import jdk.graal.compiler.graph.Graph;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.graph.NodeBitMap;
import jdk.graal.compiler.graph.NodeInputList;
import jdk.graal.compiler.graph.NodeMap;
import jdk.graal.compiler.nodeinfo.InputType;
import jdk.graal.compiler.nodes.AbstractBeginNode;
import jdk.graal.compiler.nodes.CallTargetNode;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.ControlSplitNode;
import jdk.graal.compiler.nodes.EncodedGraph;
import jdk.graal.compiler.nodes.FixedGuardNode;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.FixedWithNextNode;
import jdk.graal.compiler.nodes.FrameState;
import jdk.graal.compiler.nodes.GraphEncoder;
import jdk.graal.compiler.nodes.GraphState;
import jdk.graal.compiler.nodes.IfNode;
import jdk.graal.compiler.nodes.Invoke;
import jdk.graal.compiler.nodes.InvokeWithExceptionNode;
import jdk.graal.compiler.nodes.LogicConstantNode;
import jdk.graal.compiler.nodes.LogicNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.ParameterNode;
import jdk.graal.compiler.nodes.PhiNode;
import jdk.graal.compiler.nodes.PiNode;
import jdk.graal.compiler.nodes.StartNode;
import jdk.graal.compiler.nodes.StateSplit;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.extended.AnchoringNode;
import jdk.graal.compiler.nodes.extended.BytecodeExceptionNode;
import jdk.graal.compiler.nodes.extended.FieldOffsetProvider;
import jdk.graal.compiler.nodes.extended.ValueAnchorNode;
import jdk.graal.compiler.nodes.java.ClassIsAssignableFromNode;
import jdk.graal.compiler.nodes.java.InstanceOfNode;
import jdk.graal.compiler.nodes.java.LoadFieldNode;
import jdk.graal.compiler.nodes.java.LoadIndexedNode;
import jdk.graal.compiler.nodes.java.MethodCallTargetNode;
import jdk.graal.compiler.nodes.spi.CoreProviders;
import jdk.graal.compiler.nodes.spi.LimitedValueProxy;
import jdk.graal.compiler.nodes.spi.SimplifierTool;
import jdk.graal.compiler.nodes.util.GraphUtil;
import jdk.graal.compiler.options.OptionKey;
import jdk.graal.compiler.phases.BasePhase;
import jdk.graal.compiler.phases.common.CanonicalizerPhase;
import jdk.graal.compiler.phases.common.inlining.InliningUtil;
import jdk.graal.compiler.printer.GraalDebugHandlersFactory;
import jdk.graal.compiler.replacements.nodes.MacroNode;
import jdk.vm.ci.code.Architecture;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.JavaMethodProfile;
import jdk.vm.ci.meta.JavaTypeProfile;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.PrimitiveConstant;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.TriState;
import org.graalvm.collections.EconomicSet;
import org.graalvm.collections.MapCursor;
import org.graalvm.nativeimage.AnnotationAccess;

public abstract class StrengthenGraphs {
    protected final BigBang bb;
    protected final Universe converter;
    private final Map<JavaTypeProfile, JavaTypeProfile> cachedTypeProfiles = new ConcurrentHashMap<JavaTypeProfile, JavaTypeProfile>();
    private final Map<CachedJavaMethodProfile, CachedJavaMethodProfile> cachedMethodProfiles = new ConcurrentHashMap<CachedJavaMethodProfile, CachedJavaMethodProfile>();
    private final int analysisSizeCutoff;
    private final boolean strengthenGraphWithConstants;
    private final StrengthenGraphsCounters beforeCounters;
    private final StrengthenGraphsCounters afterCounters;
    private final boolean isClosedTypeWorld;

    public StrengthenGraphs(BigBang bb, Universe converter) {
        this.bb = bb;
        this.converter = converter;
        this.analysisSizeCutoff = (Integer)PointstoOptions.AnalysisSizeCutoff.getValue(bb.getOptions());
        this.strengthenGraphWithConstants = (Boolean)Options.StrengthenGraphWithConstants.getValue(bb.getOptions());
        if (((Boolean)ImageBuildStatistics.Options.CollectImageBuildStatistics.getValue(bb.getOptions())).booleanValue()) {
            this.beforeCounters = new StrengthenGraphsCounters(ImageBuildStatistics.CheckCountLocation.BEFORE_STRENGTHEN_GRAPHS);
            this.afterCounters = new StrengthenGraphsCounters(ImageBuildStatistics.CheckCountLocation.AFTER_STRENGTHEN_GRAPHS);
            StrengthenGraphs.reportNeverNullInstanceFields(bb);
        } else {
            this.beforeCounters = null;
            this.afterCounters = null;
        }
        this.isClosedTypeWorld = converter.hostVM().isClosedTypeWorld();
    }

    private static void reportNeverNullInstanceFields(BigBang bb) {
        int neverNull = 0;
        int canBeNull = 0;
        for (AnalysisField field : bb.getUniverse().getFields()) {
            if (field.isStatic() || !field.isReachable() || field.getType().getStorageKind() != JavaKind.Object) continue;
            if (field.getSinkFlow().isSaturated() || field.getSinkFlow().getState().canBeNull()) {
                ++canBeNull;
                continue;
            }
            ++neverNull;
        }
        ImageBuildStatistics imageBuildStats = ImageBuildStatistics.counters();
        imageBuildStats.insert("instancefield_neverNull").addAndGet(neverNull);
        imageBuildStats.insert("instancefield_canBeNull").addAndGet(canBeNull);
    }

    public final void applyResults(AnalysisMethod method) {
        PointsToAnalysisMethod ptaMethod;
        Iterable nodeReferences = method instanceof PointsToAnalysisMethod && (ptaMethod = (PointsToAnalysisMethod)method).getTypeFlow().flowsGraphCreated() ? ptaMethod.getTypeFlow().getMethodFlowsGraph().getNodeFlows().getKeys() : null;
        DebugContext debug = new DebugContext.Builder(this.bb.getOptions(), (DebugHandlersFactory)new GraalDebugHandlersFactory(this.bb.getSnippetReflectionProvider())).build();
        StructuredGraph graph = method.decodeAnalyzedGraph(debug, nodeReferences);
        if (graph == null) {
            return;
        }
        if (method.analyzedInPriorLayer()) {
            this.useSharedLayerGraph(method);
            return;
        }
        graph.resetDebug(debug);
        if (this.beforeCounters != null) {
            this.beforeCounters.collect(graph);
        }
        try (DebugContext.Scope s = debug.scope((Object)"StrengthenGraphs", (Object)graph);
             DebugContext.Activation a = debug.activate();){
            new AnalysisStrengthenGraphsPhase(this, method, graph).apply(graph, (Object)this.bb.getProviders(method));
        }
        catch (Throwable ex) {
            debug.handle(ex);
        }
        if (this.afterCounters != null) {
            this.afterCounters.collect(graph);
        }
        this.postStrengthenGraphs(graph, method);
        method.setAnalyzedGraph(GraphEncoder.encodeSingleGraph((StructuredGraph)graph, (Architecture)AnalysisParsedGraph.HOST_ARCHITECTURE));
        this.persistStrengthenGraph(method);
        if (nodeReferences != null) {
            for (EncodedGraph.EncodedNodeReference nodeReference : nodeReferences) {
                nodeReference.clear();
            }
        }
    }

    protected abstract void postStrengthenGraphs(StructuredGraph var1, AnalysisMethod var2);

    protected abstract void useSharedLayerGraph(AnalysisMethod var1);

    protected abstract void persistStrengthenGraph(AnalysisMethod var1);

    protected abstract AnalysisType getSingleImplementorType(AnalysisType var1);

    protected abstract AnalysisType getStrengthenStampType(AnalysisType var1);

    protected abstract FixedNode createUnreachable(StructuredGraph var1, CoreProviders var2, Supplier<String> var3);

    protected abstract FixedNode createInvokeWithNullReceiverReplacement(StructuredGraph var1);

    protected abstract void setInvokeProfiles(Invoke var1, JavaTypeProfile var2, JavaMethodProfile var3);

    protected abstract String getTypeName(AnalysisType var1);

    protected abstract boolean simplifyDelegate(Node var1, SimplifierTool var2);

    private static String getQualifiedName(StructuredGraph graph) {
        return ((AnalysisMethod)graph.method()).getQualifiedName();
    }

    protected JavaTypeProfile makeTypeProfile(TypeState typeState, boolean injectNotRecordedProbability) {
        if (typeState == null || this.analysisSizeCutoff != -1 && typeState.typesCount() > this.analysisSizeCutoff) {
            return null;
        }
        JavaTypeProfile created = this.createTypeProfile(typeState, injectNotRecordedProbability);
        JavaTypeProfile existing = this.cachedTypeProfiles.putIfAbsent(created, created);
        return existing != null ? existing : created;
    }

    private JavaTypeProfile createTypeProfile(TypeState typeState, boolean injectNotRecordedProbability) {
        double probability = 1.0 / (double)(typeState.typesCount() + (injectNotRecordedProbability ? 1 : 0));
        Stream<AnalysisType> stream = typeState.typesStream(this.bb);
        if (this.converter != null) {
            stream = stream.map(this.converter::lookup).sorted(this.converter.hostVM().getTypeComparator());
        }
        JavaTypeProfile.ProfiledType[] pitems = (JavaTypeProfile.ProfiledType[])stream.map(type -> new JavaTypeProfile.ProfiledType(type, probability)).toArray(JavaTypeProfile.ProfiledType[]::new);
        return new JavaTypeProfile(TriState.get((boolean)typeState.canBeNull()), injectNotRecordedProbability ? probability : 0.0, pitems);
    }

    protected JavaMethodProfile makeMethodProfile(Collection<AnalysisMethod> callees, boolean injectNotRecordedProbability) {
        if (this.analysisSizeCutoff != -1 && callees.size() > this.analysisSizeCutoff) {
            return null;
        }
        CachedJavaMethodProfile created = this.createMethodProfile(callees, injectNotRecordedProbability);
        CachedJavaMethodProfile existing = this.cachedMethodProfiles.putIfAbsent(created, created);
        return existing != null ? existing.profile : created.profile;
    }

    private CachedJavaMethodProfile createMethodProfile(Collection<AnalysisMethod> callees, boolean injectNotRecordedProbability) {
        JavaMethodProfile.ProfiledMethod[] pitems = new JavaMethodProfile.ProfiledMethod[callees.size()];
        int hashCode = 0;
        double probability = 1.0 / (double)(pitems.length + (injectNotRecordedProbability ? 1 : 0));
        int idx = 0;
        for (AnalysisMethod aMethod : callees) {
            AnalysisMethod convertedMethod = this.converter == null ? aMethod : this.converter.lookup((JavaMethod)aMethod);
            pitems[idx++] = new JavaMethodProfile.ProfiledMethod((ResolvedJavaMethod)convertedMethod, probability);
            hashCode = hashCode * 31 + convertedMethod.hashCode();
        }
        return new CachedJavaMethodProfile(new JavaMethodProfile(injectNotRecordedProbability ? probability : 0.0, pitems), hashCode);
    }

    public static class Options {
        public static final OptionKey<Boolean> StrengthenGraphWithConstants = new OptionKey((Object)true);
    }

    public class AnalysisStrengthenGraphsPhase
    extends BasePhase<CoreProviders> {
        final CanonicalizerPhase phase;

        AnalysisStrengthenGraphsPhase(StrengthenGraphs this$0, AnalysisMethod method, StructuredGraph graph) {
            this.phase = CanonicalizerPhase.create().copyWithCustomSimplification((CanonicalizerPhase.CustomSimplification)this$0.new StrengthenSimplifier(method, graph));
        }

        public Optional<BasePhase.NotApplicable> notApplicableTo(GraphState graphState) {
            return this.phase.notApplicableTo(graphState);
        }

        protected void run(StructuredGraph graph, CoreProviders context) {
            this.phase.apply(graph, (Object)context);
        }

        public CharSequence getName() {
            return "AnalysisStrengthenGraphs";
        }
    }

    record CachedJavaMethodProfile(JavaMethodProfile profile, int hash) {
        @Override
        public int hashCode() {
            return this.hash;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof CachedJavaMethodProfile) {
                CachedJavaMethodProfile other = (CachedJavaMethodProfile)obj;
                return this.profile.equals((Object)other.profile);
            }
            return false;
        }
    }

    class StrengthenSimplifier
    implements CanonicalizerPhase.CustomSimplification {
        private final StructuredGraph graph;
        private final MethodTypeFlow methodFlow;
        private final NodeBitMap createdPiNodes;
        private final TypeFlow<?>[] parameterFlows;
        private final NodeMap<TypeFlow<?>> nodeFlows;
        private final boolean allowConstantFolding;
        private final boolean allowOptimizeReturnParameter;
        private final EconomicSet<ValueNode> unreachableValues = EconomicSet.create();
        private final Function<AnalysisType, ResolvedJavaType> toTargetFunction;
        private static final int MAX_TYPES_OPTIMISTIC_PROFILES = 100;

        StrengthenSimplifier(AnalysisMethod method, StructuredGraph graph) {
            PointsToAnalysisMethod ptaMethod;
            this.graph = graph;
            this.createdPiNodes = new NodeBitMap((Graph)graph);
            if (method instanceof PointsToAnalysisMethod && (ptaMethod = (PointsToAnalysisMethod)method).getTypeFlow().flowsGraphCreated()) {
                this.methodFlow = ptaMethod.getTypeFlow();
                MethodFlowsGraph originalFlows = this.methodFlow.getMethodFlowsGraph();
                this.parameterFlows = originalFlows.getParameters();
                this.nodeFlows = new NodeMap((Graph)graph);
                MapCursor cursor = originalFlows.getNodeFlows().getEntries();
                while (cursor.advance()) {
                    Node node = ((EncodedGraph.EncodedNodeReference)cursor.getKey()).getNode();
                    assert (this.nodeFlows.get(node) == null) : "overwriting existing entry for " + String.valueOf(node);
                    this.nodeFlows.put(node, (Object)((TypeFlow)cursor.getValue()));
                }
                this.allowConstantFolding = StrengthenGraphs.this.strengthenGraphWithConstants && StrengthenGraphs.this.bb.getHostVM().allowConstantFolding(method);
                this.allowOptimizeReturnParameter = method.isOriginalMethod() && ((PointsToAnalysis)StrengthenGraphs.this.bb).optimizeReturnedParameter();
            } else {
                this.methodFlow = null;
                this.parameterFlows = null;
                this.nodeFlows = null;
                this.allowConstantFolding = false;
                this.allowOptimizeReturnParameter = false;
            }
            this.toTargetFunction = StrengthenGraphs.this.bb.getHostVM().getStrengthenGraphsToTargetFunction(method.getMultiMethodKey());
        }

        protected TypeFlow<?> getNodeFlow(Node node) {
            return this.nodeFlows == null || this.nodeFlows.isNew(node) ? null : (TypeFlow)this.nodeFlows.get(node);
        }

        /*
         * Enabled aggressive block sorting
         */
        public void simplify(Node n, SimplifierTool tool) {
            ValueNode node;
            if (n instanceof ValueNode && !(n instanceof LimitedValueProxy) && !(n instanceof PhiNode) && !(n instanceof MacroNode)) {
                node = (ValueNode)n;
                node.inferStamp();
                this.updateStampInPlace(node, this.strengthenStamp(node.stamp(NodeView.DEFAULT)), tool);
            }
            if (StrengthenGraphs.this.simplifyDelegate(n, tool)) {
                return;
            }
            if (n instanceof ParameterNode) {
                node = (ParameterNode)n;
                if (this.parameterFlows != null) {
                    StartNode anchorPoint = this.graph.start();
                    Object newStampOrConstant = this.strengthenStampFromTypeFlow(node, this.parameterFlows[node.index()], (FixedWithNextNode)anchorPoint, tool);
                    this.updateStampUsingPiNode(node, newStampOrConstant, (FixedWithNextNode)anchorPoint, tool);
                    return;
                }
            }
            if (n instanceof LoadFieldNode) {
                LoadFieldNode node2 = (LoadFieldNode)n;
                Object fieldNewStampOrConstant = this.strengthenStampFromTypeFlow((ValueNode)node2, ((AnalysisField)node2.field()).getSinkFlow(), (FixedWithNextNode)node2, tool);
                if (fieldNewStampOrConstant instanceof JavaConstant) {
                    ConstantNode replacement = ConstantNode.forConstant((JavaConstant)((JavaConstant)fieldNewStampOrConstant), (MetaAccessProvider)StrengthenGraphs.this.bb.getMetaAccess(), (StructuredGraph)this.graph);
                    this.graph.replaceFixedWithFloating((FixedWithNextNode)node2, (ValueNode)replacement);
                    tool.addToWorkList((Node)replacement);
                    return;
                }
                this.updateStampInPlace((ValueNode)node2, (Stamp)fieldNewStampOrConstant, tool);
                Object nodeNewStampOrConstant = this.strengthenStampFromTypeFlow((ValueNode)node2, this.getNodeFlow((Node)node2), (FixedWithNextNode)node2, tool);
                this.updateStampUsingPiNode((ValueNode)node2, nodeNewStampOrConstant, (FixedWithNextNode)node2, tool);
                return;
            }
            if (n instanceof LoadIndexedNode) {
                LoadIndexedNode node3 = (LoadIndexedNode)n;
                Object newStampOrConstant = this.strengthenStampFromTypeFlow((ValueNode)node3, this.getNodeFlow((Node)node3), (FixedWithNextNode)node3, tool);
                this.updateStampUsingPiNode((ValueNode)node3, newStampOrConstant, (FixedWithNextNode)node3, tool);
                return;
            }
            if (n instanceof Invoke) {
                Invoke invoke = (Invoke)n;
                if (!(invoke.callTarget() instanceof MethodCallTargetNode)) return;
                this.handleInvoke(invoke, tool);
                return;
            }
            if (n instanceof IfNode) {
                IfNode node4 = (IfNode)n;
                boolean trueUnreachable = this.isUnreachable((Node)node4.trueSuccessor());
                boolean falseUnreachable = this.isUnreachable((Node)node4.falseSuccessor());
                if (trueUnreachable && falseUnreachable) {
                    this.makeUnreachable((FixedNode)node4, (CoreProviders)tool, () -> "method " + StrengthenGraphs.getQualifiedName(this.graph) + ", node " + String.valueOf(node4) + ": both successors of IfNode are unreachable");
                    return;
                }
                if (!trueUnreachable) {
                    if (!falseUnreachable) return;
                }
                AbstractBeginNode killedBegin = node4.successor(trueUnreachable);
                AbstractBeginNode survivingBegin = node4.successor(!trueUnreachable);
                if (survivingBegin.hasUsages()) {
                    ValueAnchorNode anchor = (ValueAnchorNode)this.graph.add((Node)new ValueAnchorNode());
                    this.graph.addAfterFixed((FixedWithNextNode)survivingBegin, (FixedNode)anchor);
                    survivingBegin.replaceAtUsages((Node)anchor, new InputType[]{InputType.Guard, InputType.Anchor});
                }
                this.graph.removeSplit((ControlSplitNode)node4, survivingBegin);
                GraphUtil.killCFG((FixedNode)killedBegin);
                return;
            }
            if (n instanceof FixedGuardNode) {
                FixedGuardNode node5 = (FixedGuardNode)n;
                if (!this.isUnreachable((Node)node5)) return;
                node5.setCondition((LogicNode)LogicConstantNode.tautology((Graph)this.graph), true);
                tool.addToWorkList((Node)node5);
                return;
            }
            if (n instanceof InstanceOfNode) {
                InstanceOfNode node6 = (InstanceOfNode)n;
                ObjectStamp oldStamp = node6.getCheckedStamp();
                Stamp newStamp = this.strengthenStamp((Stamp)oldStamp);
                if (newStamp == null) return;
                LogicNode replacement = (LogicNode)this.graph.addOrUniqueWithInputs((Node)InstanceOfNode.createHelper((ObjectStamp)((ObjectStamp)oldStamp.improveWith(newStamp)), (ValueNode)node6.getValue(), (JavaTypeProfile)node6.profile(), (AnchoringNode)node6.getAnchor()));
                node6.replaceAndDelete((Node)replacement);
                tool.addToWorkList((Node)replacement);
                return;
            }
            if (n instanceof ClassIsAssignableFromNode) {
                ClassIsAssignableFromNode node7 = (ClassIsAssignableFromNode)n;
                AnalysisType nonReachableType = this.asConstantNonReachableType(node7.getThisClass(), (CoreProviders)tool);
                if (nonReachableType == null) return;
                node7.replaceAndDelete((Node)LogicConstantNode.contradiction((Graph)this.graph));
                return;
            }
            if (n instanceof BytecodeExceptionNode) {
                BytecodeExceptionNode node8 = (BytecodeExceptionNode)n;
                if (node8.getExceptionKind() != BytecodeExceptionNode.BytecodeExceptionKind.CLASS_CAST) return;
                AnalysisType nonReachableType = this.asConstantNonReachableType((ValueNode)node8.getArguments().get(1), (CoreProviders)tool);
                if (nonReachableType == null) return;
                node8.getArguments().set(1, (Object)ConstantNode.forConstant((JavaConstant)tool.getConstantReflection().forString(StrengthenGraphs.this.getTypeName(nonReachableType)), (MetaAccessProvider)tool.getMetaAccess(), (StructuredGraph)this.graph));
                return;
            }
            if (!(n instanceof FrameState)) {
                if (!(n instanceof PiNode)) return;
                PiNode node9 = (PiNode)n;
                Stamp oldStamp = node9.piStamp();
                Stamp newStamp = this.strengthenStamp(oldStamp);
                if (newStamp == null) return;
                node9.strengthenPiStamp(oldStamp.improveWith(newStamp));
                tool.addToWorkList((Node)node9);
                return;
            }
            FrameState node10 = (FrameState)n;
            int i = 0;
            while (i < node10.values().size()) {
                FieldOffsetProvider fieldOffsetProvider;
                Node node11;
                ImageHeapConstant imageHeapConstant;
                ConstantNode constantNode;
                Node node12 = node10.values().get(i);
                if (node12 instanceof ConstantNode && (node12 = (constantNode = (ConstantNode)node12).getValue()) instanceof ImageHeapConstant && !(imageHeapConstant = (ImageHeapConstant)node12).isReachable()) {
                    node10.values().set(i, (Object)ConstantNode.defaultForKind((JavaKind)JavaKind.Object, (StructuredGraph)this.graph));
                }
                if ((node11 = node10.values().get(i)) instanceof FieldOffsetProvider && !((AnalysisField)(fieldOffsetProvider = (FieldOffsetProvider)node11).getField()).isUnsafeAccessed()) {
                    node10.values().set(i, (Object)ConstantNode.forIntegerKind((JavaKind)fieldOffsetProvider.asNode().getStackKind(), (long)-559607546L, (StructuredGraph)this.graph));
                }
                ++i;
            }
        }

        private AnalysisType asConstantNonReachableType(ValueNode value, CoreProviders providers) {
            AnalysisType expectedType;
            if (value != null && value.isConstant() && (expectedType = (AnalysisType)providers.getConstantReflection().asJavaType(value.asConstant())) != null && !expectedType.isReachable()) {
                return expectedType;
            }
            return null;
        }

        private void handleInvoke(Invoke invoke, SimplifierTool tool) {
            TypeState typeState;
            Object newStampOrConstant;
            FixedNode node = invoke.asFixedNode();
            MethodCallTargetNode callTarget = (MethodCallTargetNode)invoke.callTarget();
            AnalysisMethod targetMethod = (AnalysisMethod)callTarget.targetMethod();
            if (callTarget.invokeKind().isDirect() && !targetMethod.isSimplyImplementationInvoked()) {
                this.unreachableInvoke(invoke, tool);
                return;
            }
            InvokeTypeFlow invokeFlow = (InvokeTypeFlow)this.getNodeFlow((Node)node);
            if (invokeFlow == null) {
                return;
            }
            Collection<AnalysisMethod> callees = invokeFlow.getOriginalCallees();
            if (callees.isEmpty()) {
                if (StrengthenGraphs.this.isClosedTypeWorld) {
                    this.unreachableInvoke(invoke, tool);
                }
                return;
            }
            assert (invokeFlow.isFlowEnabled()) : "Disabled invoke should have no callees: " + String.valueOf(invokeFlow) + ", in method " + StrengthenGraphs.getQualifiedName(this.graph);
            FixedWithNextNode beforeInvoke = (FixedWithNextNode)invoke.predecessor();
            NodeInputList arguments = callTarget.arguments();
            for (int i = 0; i < arguments.size(); ++i) {
                ValueNode pi;
                ValueNode argument = (ValueNode)arguments.get(i);
                newStampOrConstant = this.strengthenStampFromTypeFlow(argument, invokeFlow.getActualParameters()[i], beforeInvoke, tool);
                if (node.isDeleted()) {
                    return;
                }
                if (i == 0 && invoke.getInvokeKind() != CallTargetNode.InvokeKind.Static) {
                    boolean nullReceiver = false;
                    if (argument instanceof ConstantNode) {
                        ConstantNode constantNode = (ConstantNode)argument;
                        nullReceiver = constantNode.getValue().isDefaultForKind();
                    }
                    if (!nullReceiver && newStampOrConstant instanceof ObjectStamp) {
                        ObjectStamp stamp = (ObjectStamp)newStampOrConstant;
                        nullReceiver = stamp.alwaysNull();
                    }
                    if (!nullReceiver && newStampOrConstant instanceof Constant) {
                        Constant constantValue = (Constant)newStampOrConstant;
                        nullReceiver = constantValue.isDefaultForKind();
                    }
                    if (nullReceiver) {
                        this.invokeWithNullReceiver(invoke);
                        return;
                    }
                }
                if (newStampOrConstant == null || (pi = this.insertPi(argument, newStampOrConstant, beforeInvoke)) == null || pi == argument) continue;
                callTarget.replaceAllInputs((Node)argument, (Node)pi);
            }
            if (callTarget.invokeKind().isDirect()) {
                if (callees.size() == 1) {
                    AnalysisMethod singleCallee = callees.iterator().next();
                    assert (targetMethod.equals(singleCallee)) : "Direct invoke target mismatch: " + String.valueOf(targetMethod) + " != " + String.valueOf(singleCallee) + ". Called from " + this.graph.method().format("%H.%n");
                }
            } else if (AnnotationAccess.isAnnotationPresent((AnnotatedElement)targetMethod, Delete.class)) {
                AnalysisError.guarantee(callees.size() == 1, "@Delete methods should have a single callee.", new Object[0]);
                AnalysisMethod singleCallee = callees.iterator().next();
                this.devirtualizeInvoke(singleCallee, invoke);
            } else if (targetMethod.canBeStaticallyBound() || StrengthenGraphs.this.isClosedTypeWorld) {
                if (callees.size() == 1) {
                    AnalysisMethod singleCallee = callees.iterator().next();
                    this.devirtualizeInvoke(singleCallee, invoke);
                } else {
                    TypeState receiverTypeState = null;
                    if (invokeFlow.getTargetMethod().hasReceiver() && !this.methodFlow.isSaturated((PointsToAnalysis)StrengthenGraphs.this.bb, invokeFlow.getReceiver())) {
                        receiverTypeState = this.methodFlow.foldTypeFlow((PointsToAnalysis)StrengthenGraphs.this.bb, invokeFlow.getReceiver());
                    }
                    this.assignInvokeProfiles(invoke, invokeFlow, callees, receiverTypeState, false);
                }
            } else {
                TypeState receiverTypeState = null;
                if (invokeFlow.getTargetMethod().hasReceiver()) {
                    receiverTypeState = this.methodFlow.isSaturated((PointsToAnalysis)StrengthenGraphs.this.bb, invokeFlow) ? targetMethod.getDeclaringClass().getTypeFlow(StrengthenGraphs.this.bb, false).getState() : this.methodFlow.foldTypeFlow((PointsToAnalysis)StrengthenGraphs.this.bb, invokeFlow.getReceiver());
                }
                if (receiverTypeState != null && receiverTypeState.typesCount() <= 100) {
                    this.assignInvokeProfiles(invoke, invokeFlow, callees, receiverTypeState, true);
                }
            }
            if (this.allowOptimizeReturnParameter) {
                this.optimizeReturnedParameter(callees, (NodeInputList<ValueNode>)arguments, node, tool);
            }
            FixedWithNextNode anchorPointAfterInvoke = (FixedWithNextNode)(invoke instanceof InvokeWithExceptionNode ? invoke.next() : invoke);
            TypeFlow<?> nodeFlow = invokeFlow.getResult();
            if (nodeFlow != null && node.getStackKind() == JavaKind.Void && !this.methodFlow.isSaturated((PointsToAnalysis)StrengthenGraphs.this.bb, nodeFlow) && (typeState = this.methodFlow.foldTypeFlow((PointsToAnalysis)StrengthenGraphs.this.bb, nodeFlow)).isEmpty() && this.unreachableValues.add((Object)node)) {
                this.makeUnreachable(anchorPointAfterInvoke.next(), (CoreProviders)tool, () -> "method " + StrengthenGraphs.getQualifiedName(this.graph) + ", node " + String.valueOf(node) + ": return from void method was proven unreachable");
            }
            newStampOrConstant = this.strengthenStampFromTypeFlow((ValueNode)node, nodeFlow, anchorPointAfterInvoke, tool);
            this.updateStampUsingPiNode((ValueNode)node, newStampOrConstant, anchorPointAfterInvoke, tool);
        }

        private void assignInvokeProfiles(Invoke invoke, InvokeTypeFlow invokeFlow, Collection<AnalysisMethod> callees, TypeState receiverTypeState, boolean assumeNotRecorded) {
            JavaTypeProfile typeProfile = StrengthenGraphs.this.makeTypeProfile(receiverTypeState, assumeNotRecorded);
            JavaMethodProfile methodProfile = StrengthenGraphs.this.makeMethodProfile(callees, assumeNotRecorded);
            assert (typeProfile == null || typeProfile.getTypes().length > 1 || assumeNotRecorded) : "Should devirtualize with typeProfile=" + String.valueOf(typeProfile) + " and methodProfile=" + String.valueOf(methodProfile) + " and callees" + String.valueOf(callees) + " invoke " + String.valueOf(invokeFlow) + " " + String.valueOf(invokeFlow.getReceiver()) + " in method " + StrengthenGraphs.getQualifiedName(this.graph);
            assert (methodProfile == null || methodProfile.getMethods().length > 1 || assumeNotRecorded) : "Should devirtualize with typeProfile=" + String.valueOf(typeProfile) + " and methodProfile=" + String.valueOf(methodProfile) + " and callees" + String.valueOf(callees) + " invoke " + String.valueOf(invokeFlow) + " " + String.valueOf(invokeFlow.getReceiver()) + " in method " + StrengthenGraphs.getQualifiedName(this.graph);
            StrengthenGraphs.this.setInvokeProfiles(invoke, typeProfile, methodProfile);
        }

        private void optimizeReturnedParameter(Collection<AnalysisMethod> callees, NodeInputList<ValueNode> arguments, FixedNode invoke, SimplifierTool tool) {
            int returnedParameterIndex = -1;
            for (AnalysisMethod callee : callees) {
                if (callee.hasNeverInlineDirective()) {
                    return;
                }
                int returnedCalleeParameterIndex = PointsToAnalysis.assertPointsToAnalysisMethod(callee).getTypeFlow().getReturnedParameterIndex();
                if (returnedCalleeParameterIndex == -1) {
                    return;
                }
                if (returnedParameterIndex == -1) {
                    returnedParameterIndex = returnedCalleeParameterIndex;
                    continue;
                }
                if (returnedParameterIndex == returnedCalleeParameterIndex) continue;
                return;
            }
            assert (returnedParameterIndex != -1) : callees;
            ValueNode returnedActualParameter = (ValueNode)arguments.get(returnedParameterIndex);
            tool.addToWorkList((Iterable)invoke.usages());
            invoke.replaceAtUsages((Node)returnedActualParameter);
        }

        protected void invokeWithNullReceiver(Invoke invoke) {
            FixedNode replacement = StrengthenGraphs.this.createInvokeWithNullReceiverReplacement(this.graph);
            ((FixedWithNextNode)invoke.predecessor()).setNext(replacement);
            GraphUtil.killCFG((FixedNode)invoke.asFixedNode());
        }

        private void unreachableInvoke(Invoke invoke, SimplifierTool tool) {
            if (invoke.getInvokeKind() != CallTargetNode.InvokeKind.Static) {
                InliningUtil.nonNullReceiver((Invoke)invoke);
            }
            this.makeUnreachable(invoke.asFixedNode(), (CoreProviders)tool, () -> "method " + StrengthenGraphs.getQualifiedName(this.graph) + ", node " + String.valueOf(invoke) + ": empty list of callees for call to " + ((AnalysisMethod)invoke.callTarget().targetMethod()).getQualifiedName());
        }

        private void devirtualizeInvoke(AnalysisMethod singleCallee, Invoke invoke) {
            if (((Boolean)ImageBuildStatistics.Options.CollectImageBuildStatistics.getValue(this.graph.getOptions())).booleanValue()) {
                ImageBuildStatistics.counters().incDevirtualizedInvokeCounter();
            }
            ObjectStamp anchoredReceiverStamp = StampFactory.object((TypeReference)TypeReference.createWithoutAssumptions((ResolvedJavaType)singleCallee.getDeclaringClass()));
            ValueNode piReceiver = this.insertPi(invoke.getReceiver(), anchoredReceiverStamp, (FixedWithNextNode)invoke.asNode().predecessor());
            if (piReceiver != null) {
                invoke.callTarget().replaceFirstInput((Node)invoke.getReceiver(), (Node)piReceiver);
            }
            assert (invoke.getInvokeKind().isIndirect()) : invoke;
            invoke.callTarget().setInvokeKind(CallTargetNode.InvokeKind.Special);
            invoke.callTarget().setTargetMethod((ResolvedJavaMethod)singleCallee);
        }

        private boolean isUnreachable(Node branch) {
            TypeFlow<?> branchFlow = this.getNodeFlow(branch);
            if (branchFlow != null && !this.methodFlow.isSaturated((PointsToAnalysis)StrengthenGraphs.this.bb, branchFlow)) {
                if (!branchFlow.isFlowEnabled()) {
                    return true;
                }
                TypeState typeState = this.methodFlow.foldTypeFlow((PointsToAnalysis)StrengthenGraphs.this.bb, branchFlow);
                if (branchFlow.isPrimitiveFlow()) assert (branchFlow instanceof PrimitiveFilterTypeFlow) : "Unexpected type of primitive flow encountered as branch predicate: " + String.valueOf(branchFlow);
                return typeState.isEmpty();
            }
            return false;
        }

        private void updateStampInPlace(ValueNode node, Stamp newStamp, SimplifierTool tool) {
            Stamp computedStamp;
            Stamp oldStamp;
            if (newStamp != null && !(oldStamp = node.stamp(NodeView.DEFAULT)).equals(computedStamp = oldStamp.improveWith(newStamp))) {
                node.setStamp(newStamp);
                tool.addToWorkList((Iterable)node.usages());
            }
        }

        private void updateStampUsingPiNode(ValueNode node, Object newStampOrConstant, FixedWithNextNode anchorPoint, SimplifierTool tool) {
            ValueNode pi;
            if (newStampOrConstant != null && node.hasUsages() && !this.createdPiNodes.isMarked((Node)node) && (pi = this.insertPi(node, newStampOrConstant, anchorPoint)) != null) {
                this.createdPiNodes.mark((Node)node);
                if (pi.isConstant()) {
                    node.replaceAtUsages((Node)pi);
                } else {
                    FrameState anchorState = node instanceof StateSplit ? ((StateSplit)node).stateAfter() : this.graph.start().stateAfter();
                    node.replaceAtUsages((Node)pi, usage -> usage != pi && usage != anchorState);
                }
                tool.addToWorkList((Iterable)pi.usages());
            }
        }

        private ValueNode insertPi(ValueNode input, Object newStampOrConstant, FixedWithNextNode anchorPoint) {
            Stamp computedStamp;
            if (newStampOrConstant instanceof JavaConstant) {
                JavaConstant constant = (JavaConstant)newStampOrConstant;
                if (input.isConstant()) {
                    assert (StrengthenGraphs.this.bb.getConstantReflectionProvider().constantEquals(input.asConstant(), (Constant)constant).booleanValue()) : String.valueOf(input.asConstant()) + ", " + String.valueOf(constant);
                    return null;
                }
                return ConstantNode.forConstant((JavaConstant)constant, (MetaAccessProvider)StrengthenGraphs.this.bb.getMetaAccess(), (StructuredGraph)this.graph);
            }
            Stamp piStamp = (Stamp)newStampOrConstant;
            Stamp oldStamp = input.stamp(NodeView.DEFAULT);
            if (oldStamp.equals(computedStamp = oldStamp.improveWith(piStamp))) {
                return null;
            }
            ValueAnchorNode anchor = (ValueAnchorNode)this.graph.add((Node)new ValueAnchorNode());
            this.graph.addAfterFixed(anchorPoint, (FixedNode)anchor);
            return (ValueNode)this.graph.unique((Node)new PiNode(input, piStamp, (ValueNode)anchor));
        }

        private Object strengthenStampFromTypeFlow(ValueNode node, TypeFlow<?> nodeFlow, FixedWithNextNode anchorPoint, SimplifierTool tool) {
            JavaConstant constantValue;
            TypeState nodeTypeState;
            if (nodeFlow == null || !((PointsToAnalysis)StrengthenGraphs.this.bb).isSupportedJavaKind(node.getStackKind())) {
                return null;
            }
            if (this.methodFlow.isSaturated((PointsToAnalysis)StrengthenGraphs.this.bb, nodeFlow)) {
                return null;
            }
            if (this.unreachableValues.contains((Object)node)) {
                return null;
            }
            boolean hasUsages = node.usages().filter(n -> !(n instanceof FrameState)).isNotEmpty();
            TypeState typeState = nodeTypeState = nodeFlow.isFlowEnabled() ? this.methodFlow.foldTypeFlow((PointsToAnalysis)StrengthenGraphs.this.bb, nodeFlow) : TypeState.forEmpty();
            if (hasUsages && this.allowConstantFolding && !nodeTypeState.canBeNull() && (constantValue = nodeTypeState.asConstant()) != null) {
                return constantValue;
            }
            node.inferStamp();
            Stamp s = node.stamp(NodeView.DEFAULT);
            if (s.isIntegerStamp() || nodeTypeState.isPrimitive()) {
                return this.getIntegerStamp(node, (IntegerStamp)s, anchorPoint, nodeTypeState, tool);
            }
            ObjectStamp oldStamp = (ObjectStamp)s;
            AnalysisType oldType = (AnalysisType)oldStamp.type();
            boolean nonNull = oldStamp.nonNull() || !nodeTypeState.canBeNull();
            ArrayList<AnalysisType> typeStateTypes = new ArrayList<AnalysisType>(nodeTypeState.typesCount());
            for (AnalysisType typeStateType2 : nodeTypeState.types(StrengthenGraphs.this.bb)) {
                if (oldType != null && !(oldStamp.isExactType() ? oldType.equals(typeStateType2) : oldType.isJavaLangObject() || oldType.isAssignableFrom(typeStateType2))) continue;
                typeStateTypes.add(typeStateType2);
            }
            if (typeStateTypes.size() == 0) {
                if (nonNull) {
                    this.makeUnreachable(anchorPoint.next(), (CoreProviders)tool, () -> "method " + StrengthenGraphs.getQualifiedName(this.graph) + ", node " + String.valueOf(node) + ": empty object type state when strengthening oldStamp " + String.valueOf(oldStamp));
                    this.unreachableValues.add((Object)node);
                    return null;
                }
                return hasUsages ? StampFactory.alwaysNull() : null;
            }
            if (!hasUsages) {
                return null;
            }
            if (typeStateTypes.size() == 1) {
                ResolvedJavaType targetType;
                AnalysisType exactType = (AnalysisType)typeStateTypes.get(0);
                assert (StrengthenGraphs.this.getSingleImplementorType(exactType) == null || exactType.equals(StrengthenGraphs.this.getSingleImplementorType(exactType))) : "exactType=" + String.valueOf(exactType) + ", singleImplementor=" + String.valueOf(StrengthenGraphs.this.getSingleImplementorType(exactType));
                assert (exactType.equals(StrengthenGraphs.this.getStrengthenStampType(exactType))) : exactType;
                if (!(oldStamp.isExactType() && exactType.equals(oldType) || (targetType = this.toTargetFunction.apply(exactType)) == null)) {
                    TypeReference typeRef = TypeReference.createExactTrusted((ResolvedJavaType)targetType);
                    return StampFactory.object((TypeReference)typeRef, (boolean)nonNull);
                }
            } else if (!oldStamp.isExactType()) {
                ResolvedJavaType targetType;
                assert (typeStateTypes.size() > 1) : typeStateTypes;
                AnalysisType baseType = (AnalysisType)typeStateTypes.get(0);
                for (int i = 1; i < typeStateTypes.size() && !baseType.isJavaLangObject(); ++i) {
                    baseType = baseType.findLeastCommonAncestor((ResolvedJavaType)typeStateTypes.get(i));
                }
                if (oldType != null && !oldType.isAssignableFrom(baseType)) {
                    baseType = oldType;
                }
                assert (StrengthenGraphs.this.getSingleImplementorType(baseType) == null || baseType.equals(StrengthenGraphs.this.getSingleImplementorType(baseType))) : "baseType=" + String.valueOf(baseType) + ", singleImplementor=" + String.valueOf(StrengthenGraphs.this.getSingleImplementorType(baseType));
                AnalysisType newType = StrengthenGraphs.this.getStrengthenStampType(baseType);
                assert (typeStateTypes.stream().map(typeStateType -> newType.isAssignableFrom((ResolvedJavaType)typeStateType)).reduce(Boolean::logicalAnd).get().booleanValue()) : typeStateTypes;
                if (!(newType.equals(oldType) || oldType == null && newType.isJavaLangObject() || (targetType = this.toTargetFunction.apply(newType)) == null)) {
                    TypeReference typeRef = TypeReference.createTrustedWithoutAssumptions((ResolvedJavaType)targetType);
                    return StampFactory.object((TypeReference)typeRef, (boolean)nonNull);
                }
            }
            if (nonNull != oldStamp.nonNull()) {
                assert (nonNull) : oldStamp;
                return oldStamp.asNonNull();
            }
            return null;
        }

        private IntegerStamp getIntegerStamp(ValueNode node, IntegerStamp originalStamp, FixedWithNextNode anchorPoint, TypeState nodeTypeState, SimplifierTool tool) {
            assert (StrengthenGraphs.this.bb.trackPrimitiveValues()) : String.valueOf(nodeTypeState) + "," + String.valueOf(node) + " in " + String.valueOf(node.graph());
            assert (nodeTypeState != null && (nodeTypeState.isEmpty() || nodeTypeState.isPrimitive())) : String.valueOf(nodeTypeState) + "," + String.valueOf(node) + " in " + String.valueOf(node.graph());
            if (nodeTypeState.isEmpty()) {
                this.makeUnreachable(anchorPoint.next(), (CoreProviders)tool, () -> "method " + StrengthenGraphs.getQualifiedName(this.graph) + ", node " + String.valueOf(node) + ": empty primitive type state when strengthening oldStamp " + String.valueOf(originalStamp));
                this.unreachableValues.add((Object)node);
                return null;
            }
            if (nodeTypeState instanceof PrimitiveConstantTypeState) {
                PrimitiveConstantTypeState constantTypeState = (PrimitiveConstantTypeState)nodeTypeState;
                long constantValue = constantTypeState.getValue();
                if (node instanceof ConstantNode) {
                    ConstantNode constant = (ConstantNode)node;
                    Constant value = constant.getValue();
                    assert (value instanceof PrimitiveConstant) : "Node " + String.valueOf(value) + " should be a primitive constant when extracting an integer stamp, method " + String.valueOf(node.graph().method());
                    assert (((PrimitiveConstant)value).asLong() == constantValue) : "The actual value of node: " + String.valueOf(value) + " is different than the value " + constantValue + " computed by points-to analysis, method in " + String.valueOf(node.graph().method());
                } else {
                    return IntegerStamp.createConstant((int)originalStamp.getBits(), (long)constantValue);
                }
            }
            return null;
        }

        private void makeUnreachable(FixedNode node, CoreProviders providers, Supplier<String> message) {
            FixedNode unreachableNode = StrengthenGraphs.this.createUnreachable(this.graph, providers, message);
            ((FixedWithNextNode)node.predecessor()).setNext(unreachableNode);
            GraphUtil.killCFG((FixedNode)node);
        }

        private Stamp strengthenStamp(Stamp s) {
            Stamp newStamp;
            ResolvedJavaType targetType;
            if (!(s instanceof AbstractObjectStamp)) {
                return null;
            }
            AbstractObjectStamp stamp = (AbstractObjectStamp)s;
            AnalysisType originalType = (AnalysisType)stamp.type();
            if (originalType == null) {
                return null;
            }
            if (!originalType.isReachable()) {
                if (stamp.nonNull()) {
                    return StampFactory.empty((JavaKind)JavaKind.Object);
                }
                return StampFactory.alwaysNull();
            }
            AnalysisType singleImplementorType = StrengthenGraphs.this.getSingleImplementorType(originalType);
            if (!(singleImplementorType == null || stamp.isExactType() && singleImplementorType.equals(originalType) || (targetType = this.toTargetFunction.apply(singleImplementorType)) == null)) {
                TypeReference typeRef = TypeReference.createExactTrusted((ResolvedJavaType)targetType);
                return StampFactory.object((TypeReference)typeRef, (boolean)stamp.nonNull());
            }
            AnalysisType strengthenType = StrengthenGraphs.this.getStrengthenStampType(originalType);
            if (originalType.equals(strengthenType)) {
                return null;
            }
            if (strengthenType == null) {
                newStamp = stamp.nonNull() ? StampFactory.empty((JavaKind)JavaKind.Object) : StampFactory.alwaysNull();
            } else if (stamp.isExactType()) {
                newStamp = StampFactory.empty((JavaKind)JavaKind.Object);
            } else {
                ResolvedJavaType targetType2 = this.toTargetFunction.apply(strengthenType);
                if (targetType2 == null) {
                    return null;
                }
                TypeReference typeRef = TypeReference.createTrustedWithoutAssumptions((ResolvedJavaType)targetType2);
                newStamp = StampFactory.object((TypeReference)typeRef, (boolean)stamp.nonNull());
            }
            return newStamp;
        }
    }
}

