/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.flow;

import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.flow.PrimitiveFlow;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.typestate.TypeState;
import jdk.vm.ci.code.BytecodePosition;

public final class AnyPrimitiveSourceTypeFlow
extends TypeFlow<BytecodePosition>
implements PrimitiveFlow {
    public AnyPrimitiveSourceTypeFlow(BytecodePosition source, AnalysisType type) {
        super(source, type, TypeState.anyPrimitiveState());
    }

    private AnyPrimitiveSourceTypeFlow(MethodFlowsGraph methodFlows, AnyPrimitiveSourceTypeFlow original) {
        super(original, methodFlows, TypeState.anyPrimitiveState());
    }

    @Override
    public TypeFlow<BytecodePosition> copy(PointsToAnalysis bb, MethodFlowsGraph methodFlows) {
        assert (this.isLocal()) : "Global flow should never be cloned: " + String.valueOf(this);
        return new AnyPrimitiveSourceTypeFlow(methodFlows, this);
    }

    private boolean isLocal() {
        return this.source != null;
    }

    @Override
    public boolean canSaturate(PointsToAnalysis bb) {
        return this.isLocal();
    }
}

