/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.driver;

import com.oracle.svm.driver.NativeImage;
import com.oracle.svm.util.LogUtils;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;

class DefaultOptionHandler
extends NativeImage.OptionHandler<NativeImage> {
    private static final String requireValidJarFileMessage = "-jar requires a valid jarfile";
    private static final String newStyleClasspathOptionName = "--class-path";
    static final String addModulesOption = "--add-modules";
    static final String limitModulesOption = "--limit-modules";
    private static final String moduleSetModifierOptionErrorMessage = " requires modules to be specified";
    static final String ADD_ENV_VAR_OPTION = "-E";
    private static final String noServerOption = "--no-server";

    DefaultOptionHandler(NativeImage nativeImage) {
        super(nativeImage);
    }

    @Override
    public boolean consume(NativeImage.ArgumentQueue args) {
        String headArg;
        switch (headArg = args.peek()) {
            case "-cp": 
            case "-classpath": 
            case "--class-path": {
                args.poll();
                String cpArgs = args.poll();
                if (cpArgs == null) {
                    NativeImage.showError(headArg + " requires class path specification");
                }
                this.processClasspathArgs(cpArgs);
                return true;
            }
            case "-p": 
            case "--module-path": {
                args.poll();
                String mpArgs = args.poll();
                if (mpArgs == null) {
                    NativeImage.showError(headArg + " requires module path specification");
                }
                this.processModulePathArgs(mpArgs);
                return true;
            }
            case "-m": 
            case "--module": {
                String[] mainClassModuleArgParts;
                args.poll();
                String mainClassModuleArg = args.poll();
                if (mainClassModuleArg == null) {
                    NativeImage.showError(headArg + " requires module name");
                }
                if ((mainClassModuleArgParts = mainClassModuleArg.split("/", 2)).length > 1) {
                    this.nativeImage.addPlainImageBuilderArg(this.nativeImage.oHClass + mainClassModuleArgParts[1], "driver");
                }
                this.nativeImage.addPlainImageBuilderArg(this.nativeImage.oHModule + mainClassModuleArgParts[0], "driver");
                this.nativeImage.setModuleOptionMode(true);
                return true;
            }
            case "--add-modules": {
                args.poll();
                String addModulesArgs = args.poll();
                if (addModulesArgs == null) {
                    NativeImage.showError(headArg + moduleSetModifierOptionErrorMessage);
                }
                this.nativeImage.addAddedModules(addModulesArgs);
                return true;
            }
            case "--limit-modules": {
                args.poll();
                String limitModulesArgs = args.poll();
                if (limitModulesArgs == null) {
                    NativeImage.showError(headArg + moduleSetModifierOptionErrorMessage);
                }
                this.nativeImage.addLimitedModules(limitModulesArgs);
                return true;
            }
            case "-jar": {
                args.poll();
                String jarFilePathStr = args.poll();
                if (jarFilePathStr == null) {
                    NativeImage.showError(requireValidJarFileMessage);
                }
                this.handleJarFileArg(this.nativeImage.canonicalize(Paths.get(jarFilePathStr, new String[0])));
                this.nativeImage.setJarOptionMode(true);
                return true;
            }
            case "--diagnostics-mode": {
                args.poll();
                this.nativeImage.enableDiagnostics();
                this.nativeImage.addPlainImageBuilderArg("-H:+DiagnosticsMode");
                this.nativeImage.addPlainImageBuilderArg("-H:DiagnosticsDir=" + String.valueOf(this.nativeImage.diagnosticsDir));
                System.out.println("# Diagnostics mode enabled: image-build reports are saved to " + String.valueOf(this.nativeImage.diagnosticsDir));
                return true;
            }
            case "--no-server": {
                args.poll();
                LogUtils.warning((String)("Ignoring server-mode native-image argument " + headArg + "."));
                return true;
            }
            case "--enable-preview": {
                args.poll();
                this.nativeImage.addCustomJavaArgs("--enable-preview");
                return true;
            }
        }
        String singleArgClasspathPrefix = "--class-path=";
        if (headArg.startsWith(singleArgClasspathPrefix)) {
            String cpArgs = args.poll().substring(singleArgClasspathPrefix.length());
            if (cpArgs.isEmpty()) {
                NativeImage.showError(headArg + " requires class path specification");
            }
            this.processClasspathArgs(cpArgs);
            return true;
        }
        if (headArg.startsWith("-H:")) {
            args.poll();
            this.nativeImage.addPlainImageBuilderArg(headArg, args.argumentOrigin);
            return true;
        }
        if (headArg.startsWith("-R:")) {
            args.poll();
            this.nativeImage.addPlainImageBuilderArg(headArg);
            return true;
        }
        String javaArgsPrefix = "-D";
        if (headArg.startsWith(javaArgsPrefix)) {
            args.poll();
            this.nativeImage.addCustomJavaArgs(headArg);
            return true;
        }
        String optionKeyPrefix = "-V";
        if (headArg.startsWith(optionKeyPrefix)) {
            args.poll();
            String keyValueStr = headArg.substring(optionKeyPrefix.length());
            String[] keyValue = keyValueStr.split("=");
            if (keyValue.length != 2) {
                throw NativeImage.showError("Use " + optionKeyPrefix + "<key>=<value>");
            }
            this.nativeImage.addOptionKeyValue(keyValue[0], keyValue[1]);
            return true;
        }
        if (headArg.startsWith(ADD_ENV_VAR_OPTION)) {
            args.poll();
            String envVarSetting = headArg.substring(ADD_ENV_VAR_OPTION.length());
            String[] keyValue = envVarSetting.split("=", 2);
            String valueDefinedOrInherited = keyValue.length > 1 ? keyValue[1] : null;
            this.nativeImage.imageBuilderEnvironment.put(keyValue[0], valueDefinedOrInherited);
            return true;
        }
        if (headArg.startsWith("-J")) {
            args.poll();
            if (headArg.equals("-J")) {
                NativeImage.showError("The -J option should not be followed by a space");
            } else {
                this.nativeImage.addCustomJavaArgs(headArg.substring(2));
            }
            return true;
        }
        if (headArg.startsWith("--add-modules=")) {
            args.poll();
            String addModulesArgs = headArg.substring(addModulesOption.length() + 1);
            if (addModulesArgs.isEmpty()) {
                NativeImage.showError(headArg + moduleSetModifierOptionErrorMessage);
            }
            this.nativeImage.addAddedModules(addModulesArgs);
            return true;
        }
        if (headArg.startsWith("--limit-modules=")) {
            args.poll();
            String limitModulesArgs = headArg.substring(limitModulesOption.length() + 1);
            if (limitModulesArgs.isEmpty()) {
                NativeImage.showError(headArg + moduleSetModifierOptionErrorMessage);
            }
            this.nativeImage.addLimitedModules(limitModulesArgs);
            return true;
        }
        return false;
    }

    private void processClasspathArgs(String cpArgs) {
        for (String cp : cpArgs.split(File.pathSeparator, Integer.MAX_VALUE)) {
            String cpEntry = cp.isEmpty() ? "." : cp;
            this.nativeImage.addCustomImageClasspath(cpEntry);
        }
    }

    private void processModulePathArgs(String mpArgs) {
        for (String mpEntry : mpArgs.split(File.pathSeparator, Integer.MAX_VALUE)) {
            this.nativeImage.addImageModulePath(Paths.get(mpEntry, new String[0]), false, true);
        }
    }

    private void handleJarFileArg(Path jarFilePath) {
        String jarSuffix;
        String jarFileName;
        String jarFileNameBase;
        if (Files.isDirectory(jarFilePath, new LinkOption[0])) {
            NativeImage.showError(String.valueOf(jarFilePath) + " is a directory. (-jar requires a valid jarfile)");
        }
        if (!(jarFileNameBase = (jarFileName = jarFilePath.getFileName().toString()).endsWith(jarSuffix = ".jar") ? jarFileName.substring(0, jarFileName.length() - jarSuffix.length()) : jarFileName).isEmpty()) {
            String origin = "manifest from " + String.valueOf(jarFilePath.toUri());
            this.nativeImage.addPlainImageBuilderArg(this.nativeImage.oHName + jarFileNameBase, origin, false);
        }
        Path finalFilePath = this.nativeImage.useBundle() ? this.nativeImage.bundleSupport.substituteClassPath(jarFilePath) : jarFilePath;
        if (!NativeImage.processJarManifestMainAttributes(finalFilePath, this.nativeImage::handleManifestFileAttributes)) {
            NativeImage.showError("No manifest in " + String.valueOf(finalFilePath));
        }
        this.nativeImage.addCustomImageClasspath(finalFilePath);
    }
}

