/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.agent.configwithorigins;

import com.oracle.svm.agent.configwithorigins.ConfigurationWithOriginsTracer;
import com.oracle.svm.agent.tracing.core.TracingResultWriter;
import com.oracle.svm.configure.config.ConfigurationSet;
import com.oracle.svm.configure.config.conditional.HumanReadableConfigurationWithOrigins;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;

public class ConfigurationWithOriginsWriter
implements TracingResultWriter {
    public static final String CONFIG_WITH_ORIGINS_SUFFIX = "-origins.txt";
    private final ConfigurationWithOriginsTracer tracer;

    public ConfigurationWithOriginsWriter(ConfigurationWithOriginsTracer tracer) {
        this.tracer = tracer;
    }

    @Override
    public boolean supportsPeriodicTraceWriting() {
        return false;
    }

    @Override
    public boolean supportsOnUnloadTraceWriting() {
        return true;
    }

    @Override
    public List<Path> writeToDirectory(Path directoryPath) throws IOException {
        return ConfigurationSet.writeConfiguration(configFile -> directoryPath.resolve(configFile.getFileName(CONFIG_WITH_ORIGINS_SUFFIX)), configFile -> new HumanReadableConfigurationWithOrigins(this.tracer.getRootNode(), configFile));
    }
}

