/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.foreign;

import com.oracle.svm.core.SubstrateTargetDescription;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.foreign.AbiUtils;
import com.oracle.svm.core.foreign.JavaEntryPointInfo;
import com.oracle.svm.core.foreign.NativeEntryPointInfo;
import com.oracle.svm.core.foreign.Target_jdk_internal_foreign_abi_UpcallLinker_CallRegs;
import com.oracle.svm.core.graal.code.AssignedLocation;
import com.oracle.svm.core.headers.LibC;
import com.oracle.svm.core.headers.WindowsAPIs;
import com.oracle.svm.core.util.BasedOnJDKClass;
import com.oracle.svm.core.util.VMError;
import java.lang.foreign.FunctionDescriptor;
import java.lang.foreign.Linker;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.MethodType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import jdk.graal.compiler.asm.amd64.AMD64Address;
import jdk.graal.compiler.asm.amd64.AMD64Assembler;
import jdk.graal.compiler.asm.amd64.AMD64BaseAssembler;
import jdk.internal.foreign.abi.Binding;
import jdk.internal.foreign.abi.CallingSequence;
import jdk.internal.foreign.abi.DowncallLinker;
import jdk.internal.foreign.abi.LinkerOptions;
import jdk.internal.foreign.abi.UpcallLinker;
import jdk.internal.foreign.abi.VMStorage;
import jdk.internal.foreign.abi.x64.X86_64Architecture;
import jdk.internal.foreign.abi.x64.sysv.CallArranger;
import jdk.internal.foreign.abi.x64.sysv.SysVx64Linker;
import jdk.internal.foreign.abi.x64.windows.Windowsx64Linker;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.PlatformKind;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

class ABIs {
    ABIs() {
    }

    @BasedOnJDKClass.List(value={@BasedOnJDKClass(value=Windowsx64Linker.class), @BasedOnJDKClass(value=jdk.internal.foreign.abi.x64.windows.CallArranger.class)})
    static final class Win64
    extends X86_64 {
        Win64() {
        }

        @Override
        protected CallingSequence makeCallingSequence(MethodType type, FunctionDescriptor desc, boolean forUpcall, LinkerOptions options) {
            return jdk.internal.foreign.abi.x64.windows.CallArranger.getBindings(type, desc, forUpcall, options).callingSequence();
        }

        @Override
        protected List<AbiUtils.Adapter.Adaptation> generateAdaptations(NativeEntryPointInfo nep) {
            List<AbiUtils.Adapter.Adaptation> adaptations = super.generateAdaptations(nep);
            AMD64 target = (AMD64)((SubstrateTargetDescription)ImageSingletons.lookup(SubstrateTargetDescription.class)).arch;
            boolean previousMatched = false;
            PlatformKind previousKind = null;
            for (int i = adaptations.size() - 1; i >= 0; --i) {
                PlatformKind kind = target.getPlatformKind(JavaKind.fromJavaClass((Class)nep.methodType().parameterType(i)));
                if ((kind.equals((Object)target.getPlatformKind(JavaKind.Float)) || kind.equals((Object)target.getPlatformKind(JavaKind.Double))) && nep.parametersAssignment()[i].type() == 0) {
                    assert (Objects.equals(previousKind, kind) && previousMatched);
                    assert (adaptations.get(i) == null);
                    adaptations.set(i, AbiUtils.Adapter.reinterpret(JavaKind.Long));
                    previousMatched = false;
                } else {
                    previousMatched = true;
                }
                previousKind = kind;
            }
            return adaptations;
        }

        @Override
        @Platforms(value={Platform.HOSTED_ONLY.class})
        public void checkLibrarySupport() {
            String name = "Win64 (Windows AMD64)";
            VMError.guarantee((boolean)LibC.isSupported(), (String)"Foreign functions feature requires LibC support on %s", (Object)name);
            VMError.guarantee((boolean)WindowsAPIs.isSupported(), (String)"Foreign functions feature requires Windows APIs support on %s", (Object)name);
        }

        @Override
        public Map<String, MemoryLayout> canonicalLayouts() {
            return Win64.canonicalLayouts(ValueLayout.JAVA_INT, ValueLayout.JAVA_LONG, ValueLayout.JAVA_CHAR);
        }
    }

    @BasedOnJDKClass.List(value={@BasedOnJDKClass(value=SysVx64Linker.class), @BasedOnJDKClass(value=CallArranger.class)})
    static final class SysV
    extends X86_64 {
        SysV() {
        }

        @Override
        protected CallingSequence makeCallingSequence(MethodType type, FunctionDescriptor desc, boolean forUpcall, LinkerOptions options) {
            return CallArranger.getBindings(type, desc, forUpcall, options).callingSequence();
        }

        @Override
        protected List<AbiUtils.Adapter.Adaptation> generateAdaptations(NativeEntryPointInfo nep) {
            int last;
            VMStorage lastAssignment;
            List<AbiUtils.Adapter.Adaptation> adaptations = super.generateAdaptations(nep);
            VMStorage[] assignments = nep.parametersAssignment();
            if (assignments.length > 0 && (lastAssignment = assignments[last = assignments.length - 1]) != null && lastAssignment.equals(X86_64Architecture.Regs.rax)) {
                adaptations.set(last, AbiUtils.Adapter.drop());
            }
            return adaptations;
        }

        @Override
        @Platforms(value={Platform.HOSTED_ONLY.class})
        public void checkLibrarySupport() {
            String name = "SystemV (Linux AMD64)";
            VMError.guarantee((boolean)LibC.isSupported(), (String)"Foreign functions feature requires LibC support on %s", (Object)name);
        }

        @Override
        public Map<String, MemoryLayout> canonicalLayouts() {
            return SysV.canonicalLayouts(ValueLayout.JAVA_LONG, ValueLayout.JAVA_LONG, ValueLayout.JAVA_INT);
        }
    }

    @BasedOnJDKClass.List(value={@BasedOnJDKClass(value=X86_64Architecture.class), @BasedOnJDKClass(value=DowncallLinker.class), @BasedOnJDKClass(value=UpcallLinker.class)})
    static abstract class X86_64
    extends AbiUtils {
        X86_64() {
        }

        protected abstract CallingSequence makeCallingSequence(MethodType var1, FunctionDescriptor var2, boolean var3, LinkerOptions var4);

        @Override
        public NativeEntryPointInfo makeNativeEntrypoint(FunctionDescriptor desc, Linker.Option ... options) {
            LinkerOptions optionSet = LinkerOptions.forDowncall(desc, options);
            MethodType type = desc.toMethodType();
            CallingSequence callingSequence = this.makeCallingSequence(type, desc, false, optionSet);
            Binding.Move[] argMoveBindings = (Binding.VMStore[])Downcalls.argMoveBindingsStream(callingSequence).toArray(Binding.VMStore[]::new);
            VMStorage[] argMoves = Downcalls.toStorageArray(argMoveBindings);
            VMStorage[] returnMoves = Downcalls.toStorageArray(Downcalls.retMoveBindings(callingSequence));
            MethodType boundaryType = callingSequence.calleeMethodType();
            boolean needsReturnBuffer = callingSequence.needsReturnBuffer();
            return NativeEntryPointInfo.make(argMoves, returnMoves, boundaryType, needsReturnBuffer, callingSequence.capturedStateMask(), callingSequence.needsTransition(), optionSet.allowsHeapAccess());
        }

        @Override
        public JavaEntryPointInfo makeJavaEntryPoint(FunctionDescriptor desc, Linker.Option ... options) {
            MethodType type = desc.toMethodType();
            LinkerOptions optionSet = LinkerOptions.forUpcall(desc, options);
            CallingSequence callingSequence = this.makeCallingSequence(type, desc, true, optionSet);
            Binding.VMLoad[] argMoves = Upcalls.argMoveBindings(callingSequence);
            Binding.VMStore[] retMoves = Upcalls.retMoveBindings(callingSequence);
            VMStorage[] args = (VMStorage[])Arrays.stream(argMoves).map(Binding.Move::storage).toArray(VMStorage[]::new);
            VMStorage[] rets = (VMStorage[])Arrays.stream(retMoves).map(Binding.Move::storage).toArray(VMStorage[]::new);
            Target_jdk_internal_foreign_abi_UpcallLinker_CallRegs cr = new Target_jdk_internal_foreign_abi_UpcallLinker_CallRegs(args, rets);
            return JavaEntryPointInfo.make(callingSequence.callerMethodType(), cr, callingSequence.needsReturnBuffer(), callingSequence.returnBufferSize());
        }

        @Override
        public AssignedLocation[] toMemoryAssignment(VMStorage[] argMoves, boolean forReturn) {
            block10: for (VMStorage move : argMoves) {
                if (move == null) continue;
                switch (move.type()) {
                    case 2: {
                        throw VMError.unsupportedFeature((String)"Unsupported register kind: X87");
                    }
                    case 3: {
                        if (!forReturn) continue block10;
                        throw VMError.unsupportedFeature((String)"Unsupported register kind for return: STACK");
                    }
                }
            }
            AssignedLocation[] storages = new AssignedLocation[argMoves.length];
            int i = 0;
            for (VMStorage move : argMoves) {
                if (move == null) {
                    storages[i++] = AssignedLocation.placeholder();
                    continue;
                }
                int n = i++;
                storages[n] = switch (move.type()) {
                    case 4 -> AssignedLocation.placeholder();
                    case 0 -> {
                        Register reg = AMD64.cpuRegisters[move.indexOrOffset()];
                        if (!$assertionsDisabled && !reg.name.equals(move.debugName())) {
                            throw new AssertionError();
                        }
                        if (!$assertionsDisabled && !reg.getRegisterCategory().equals((Object)AMD64.CPU)) {
                            throw new AssertionError();
                        }
                        yield AssignedLocation.forRegister((Register)reg, (JavaKind)JavaKind.Long);
                    }
                    case 1 -> {
                        Register reg = AMD64.xmmRegistersSSE[move.indexOrOffset()];
                        if (!$assertionsDisabled && !reg.name.equals(move.debugName())) {
                            throw new AssertionError();
                        }
                        if (!$assertionsDisabled && !reg.getRegisterCategory().equals((Object)AMD64.XMM)) {
                            throw new AssertionError();
                        }
                        yield AssignedLocation.forRegister((Register)reg, (JavaKind)JavaKind.Double);
                    }
                    case 3 -> AssignedLocation.forStack((int)move.indexOrOffset());
                    default -> throw VMError.unsupportedFeature((String)("Unhandled VMStorage: " + String.valueOf(move)));
                };
            }
            assert (i == storages.length);
            return storages;
        }

        protected static Map<String, MemoryLayout> canonicalLayouts(ValueLayout longLayout, ValueLayout sizetLayout, ValueLayout wchartLayout) {
            return Map.ofEntries(Map.entry("bool", ValueLayout.JAVA_BOOLEAN), Map.entry("char", ValueLayout.JAVA_BYTE), Map.entry("short", ValueLayout.JAVA_SHORT), Map.entry("int", ValueLayout.JAVA_INT), Map.entry("float", ValueLayout.JAVA_FLOAT), Map.entry("long", longLayout), Map.entry("long long", ValueLayout.JAVA_LONG), Map.entry("double", ValueLayout.JAVA_DOUBLE), Map.entry("void*", ValueLayout.ADDRESS), Map.entry("size_t", sizetLayout), Map.entry("wchar_t", wchartLayout), Map.entry("int8_t", ValueLayout.JAVA_BYTE), Map.entry("int16_t", ValueLayout.JAVA_SHORT), Map.entry("int32_t", ValueLayout.JAVA_INT), Map.entry("int64_t", ValueLayout.JAVA_LONG), Map.entry("jboolean", ValueLayout.JAVA_BOOLEAN), Map.entry("jchar", ValueLayout.JAVA_CHAR), Map.entry("jbyte", ValueLayout.JAVA_BYTE), Map.entry("jshort", ValueLayout.JAVA_SHORT), Map.entry("jint", ValueLayout.JAVA_INT), Map.entry("jlong", ValueLayout.JAVA_LONG), Map.entry("jfloat", ValueLayout.JAVA_FLOAT), Map.entry("jdouble", ValueLayout.JAVA_DOUBLE));
        }

        @Override
        public AbiUtils.Registers upcallSpecialArgumentsRegisters() {
            return new AbiUtils.Registers(AMD64.r10, AMD64.r11);
        }

        @Override
        public int trampolineSize() {
            return 128;
        }

        @Override
        @Platforms(value={Platform.HOSTED_ONLY.class})
        public AbiUtils.TrampolineTemplate generateTrampolineTemplate() {
            AMD64Assembler asm = new AMD64Assembler((TargetDescription)ConfigurationValues.getTarget());
            ArrayList odas = new ArrayList(3);
            asm.setCodePatchingAnnotationConsumer(ca -> {
                if (ca instanceof AMD64BaseAssembler.OperandDataAnnotation) {
                    AMD64BaseAssembler.OperandDataAnnotation oda = (AMD64BaseAssembler.OperandDataAnnotation)ca;
                    odas.add(oda);
                }
            });
            Register mhRegister = this.upcallSpecialArgumentsRegisters().methodHandle();
            Register isolateRegister = this.upcallSpecialArgumentsRegisters().isolate();
            asm.movq(isolateRegister, 0L, true);
            asm.movq(mhRegister, 0L, true);
            asm.movq(mhRegister, new AMD64Address(mhRegister));
            asm.movq(AMD64.rax, 0L, true);
            asm.jmp(new AMD64Address(AMD64.rax, 0));
            assert (this.trampolineSize() - asm.position() >= 0);
            asm.nop(this.trampolineSize() - asm.position());
            byte[] assembly = asm.close(true);
            assert (assembly.length == this.trampolineSize());
            assert (odas.size() == 3);
            assert (odas.stream().allMatch(oda -> oda.operandSize == 8));
            return new AbiUtils.TrampolineTemplate(assembly, ((AMD64BaseAssembler.OperandDataAnnotation)odas.get((int)0)).operandPosition, ((AMD64BaseAssembler.OperandDataAnnotation)odas.get((int)1)).operandPosition, ((AMD64BaseAssembler.OperandDataAnnotation)odas.get((int)2)).operandPosition);
        }

        @BasedOnJDKClass(value=DowncallLinker.class)
        static class Downcalls {
            Downcalls() {
            }

            protected static Stream<Binding.VMStore> argMoveBindingsStream(CallingSequence callingSequence) {
                return callingSequence.argumentBindings().filter(Binding.VMStore.class::isInstance).map(Binding.VMStore.class::cast);
            }

            protected static Stream<Binding.VMLoad> retMoveBindingsStream(CallingSequence callingSequence) {
                return callingSequence.returnBindings().stream().filter(Binding.VMLoad.class::isInstance).map(Binding.VMLoad.class::cast);
            }

            protected static Binding.VMLoad[] retMoveBindings(CallingSequence callingSequence) {
                return (Binding.VMLoad[])Downcalls.retMoveBindingsStream(callingSequence).toArray(Binding.VMLoad[]::new);
            }

            static VMStorage[] toStorageArray(Binding.Move[] moves) {
                return (VMStorage[])Arrays.stream(moves).map(Binding.Move::storage).toArray(VMStorage[]::new);
            }
        }

        @BasedOnJDKClass(value=UpcallLinker.class)
        static class Upcalls {
            Upcalls() {
            }

            static Binding.VMLoad[] argMoveBindings(CallingSequence callingSequence) {
                return (Binding.VMLoad[])callingSequence.argumentBindings().filter(Binding.VMLoad.class::isInstance).map(Binding.VMLoad.class::cast).toArray(Binding.VMLoad[]::new);
            }

            static Binding.VMStore[] retMoveBindings(CallingSequence callingSequence) {
                return (Binding.VMStore[])callingSequence.returnBindings().stream().filter(Binding.VMStore.class::isInstance).map(Binding.VMStore.class::cast).toArray(Binding.VMStore[]::new);
            }
        }
    }

    static final class Unsupported
    extends AbiUtils {
        private final String name;

        Unsupported(String name) {
            this.name = name;
        }

        private <Z> Z fail() {
            throw VMError.unsupportedFeature((String)this.name());
        }

        private String name() {
            return "Unsupported ABI: " + this.name;
        }

        @Override
        public NativeEntryPointInfo makeNativeEntrypoint(FunctionDescriptor desc, Linker.Option ... options) {
            return (NativeEntryPointInfo)this.fail();
        }

        @Override
        public JavaEntryPointInfo makeJavaEntryPoint(FunctionDescriptor desc, Linker.Option ... options) {
            return (JavaEntryPointInfo)this.fail();
        }

        @Override
        public AssignedLocation[] toMemoryAssignment(VMStorage[] moves, boolean forReturn) {
            return (AssignedLocation[])this.fail();
        }

        @Override
        protected List<AbiUtils.Adapter.Adaptation> generateAdaptations(NativeEntryPointInfo nep) {
            return (List)this.fail();
        }

        @Override
        public void checkLibrarySupport() {
            this.fail();
        }

        @Override
        public Map<String, MemoryLayout> canonicalLayouts() {
            return (Map)this.fail();
        }

        @Override
        public AbiUtils.Registers upcallSpecialArgumentsRegisters() {
            return (AbiUtils.Registers)this.fail();
        }

        @Override
        public int trampolineSize() {
            return (Integer)this.fail();
        }

        @Override
        public AbiUtils.TrampolineTemplate generateTrampolineTemplate() {
            return (AbiUtils.TrampolineTemplate)this.fail();
        }
    }
}

