/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jipher.internal.spi;

import com.oracle.jipher.internal.common.Util;
import com.oracle.jipher.internal.fips.CryptoOp;
import com.oracle.jipher.internal.fips.Fips;
import com.oracle.jipher.internal.key.JceOsslKey;
import com.oracle.jipher.internal.key.JceRsaPrivateKey;
import com.oracle.jipher.internal.key.JceRsaPublicKey;
import com.oracle.jipher.internal.openssl.MdAlg;
import com.oracle.jipher.internal.openssl.PkeyCtx;
import com.oracle.jipher.internal.spi.InternalProvider;
import com.oracle.jipher.internal.spi.InternalTlsSpec;
import com.oracle.jipher.internal.spi.RsaCipherPadding;
import com.oracle.jipher.internal.spi.RsaKeyFactory;
import com.oracle.jipher.internal.spi.WrapUtil;
import java.nio.ByteBuffer;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.MGF1ParameterSpec;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PSource;

public abstract class RsaCipher
extends CipherSpi {
    private final RsaKeyFactory kf = new RsaKeyFactory();
    private final RsaCipherPadding padding;
    private JceOsslKey key;
    private boolean encrypt;
    private int keyBits;
    byte[] buffer;
    int bufOffset;

    RsaCipher(RsaCipherPadding padding) {
        this.padding = padding;
    }

    @Override
    protected void engineSetPadding(String s) throws NoSuchPaddingException {
        if (!this.padding.name().equals(s.toUpperCase())) {
            throw new NoSuchPaddingException();
        }
    }

    @Override
    protected void engineSetMode(String s) throws NoSuchAlgorithmException {
        if (!"ECB".equals(s)) {
            throw new NoSuchAlgorithmException();
        }
    }

    @Override
    protected int engineGetBlockSize() {
        return 0;
    }

    @Override
    protected void engineInit(int cipherMode, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        try {
            this.engineInit(cipherMode, key, (AlgorithmParameterSpec)null, secureRandom);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new InvalidParameterException(e.getMessage());
        }
    }

    @Override
    protected void engineInit(int cipherMode, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.engineInit(cipherMode, key, this.toParamSpec(algorithmParameters), secureRandom);
    }

    AlgorithmParameterSpec toParamSpec(AlgorithmParameters params) throws InvalidAlgorithmParameterException {
        if (params != null) {
            throw new InvalidAlgorithmParameterException("Parameters not expected.");
        }
        return null;
    }

    @Override
    protected void engineInit(int cipherMode, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.initInternal(key, algorithmParameterSpec, cipherMode == 1 || cipherMode == 3);
    }

    void verifyParams(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
        if (params != null) {
            throw new InvalidAlgorithmParameterException("Parameters not expected. " + params);
        }
    }

    private void initInternal(Key key, AlgorithmParameterSpec params, boolean encrypt) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.cleanup();
        if (encrypt) {
            try {
                Fips.enforcement().checkPad(CryptoOp.ENCRYPT_ASYM, "RSA", this.padding == null ? null : this.padding.toString());
            }
            catch (ProviderException e) {
                throw new UnsupportedOperationException(e.getMessage(), e);
            }
            if (!(key instanceof PublicKey)) {
                throw new InvalidKeyException("Expected PublicKey for encryption");
            }
            this.key = (JceOsslKey)this.kf.engineTranslateKey(key);
            Fips.enforcement().checkStrength(CryptoOp.ENCRYPT_ASYM, this.key);
            this.keyBits = ((JceRsaPublicKey)this.key).getModulus().bitLength();
        } else {
            if (!(key instanceof PrivateKey)) {
                throw new InvalidKeyException("Expected PrivateKey for decryption");
            }
            this.key = (JceOsslKey)this.kf.engineTranslateKey(key);
            Fips.enforcement().checkStrength(CryptoOp.DECRYPT_ASYM, this.key);
            this.keyBits = ((JceRsaPrivateKey)this.key).getModulus().bitLength();
        }
        this.verifyParams(params);
        this.encrypt = encrypt;
        this.buffer = new byte[this.keyBits / 8];
        this.bufOffset = 0;
    }

    @Override
    protected int engineUpdate(ByteBuffer byteBuffer, ByteBuffer byteBuffer1) throws ShortBufferException {
        return super.engineUpdate(byteBuffer, byteBuffer1);
    }

    @Override
    protected int engineUpdate(byte[] input, int inOffset, int len, byte[] out, int outOffset) {
        this.engineUpdate(input, inOffset, len);
        return 0;
    }

    @Override
    protected byte[] engineUpdate(byte[] input, int inOffset, int len) {
        this.resetIfNecessary();
        if (len != 0) {
            if (len + this.bufOffset > this.buffer.length) {
                this.bufOffset = this.buffer.length + 1;
            } else {
                System.arraycopy(input, inOffset, this.buffer, this.bufOffset, len);
                this.bufOffset += len;
            }
        }
        return null;
    }

    @Override
    protected byte[] engineDoFinal(byte[] input, int offset, int len) throws IllegalBlockSizeException, BadPaddingException {
        byte[] out = new byte[this.engineGetOutputSize(len)];
        try {
            int outlen = this.engineDoFinal(input, offset, len, out, 0);
            if (outlen == out.length) {
                return out;
            }
            return Arrays.copyOf(out, outlen);
        }
        catch (ShortBufferException e) {
            throw new ProviderException(e);
        }
    }

    void initPkeyCtx(PkeyCtx.Cipher ctx) {
        ctx.init(this.encrypt);
        ctx.setPadding(this.padding.id());
    }

    int cipherOperation(PkeyCtx.Cipher ctx, byte[] output, int outOffset) throws IllegalBlockSizeException, BadPaddingException {
        if (this.bufOffset > this.buffer.length) {
            throw new IllegalBlockSizeException("Data must not be longer than " + this.buffer.length + " bytes");
        }
        if (this.encrypt) {
            return ctx.encrypt(this.buffer, 0, this.bufOffset, output, outOffset);
        }
        return ctx.decrypt(this.buffer, 0, this.bufOffset, output, outOffset);
    }

    @Override
    protected int engineDoFinal(ByteBuffer byteBuffer, ByteBuffer byteBuffer1) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        return super.engineDoFinal(byteBuffer, byteBuffer1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int engineDoFinal(byte[] input, int offset, int len, byte[] output, int outOffset) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        this.resetIfNecessary();
        if (this.keyBits / 8 > output.length - outOffset) {
            throw new ShortBufferException();
        }
        PkeyCtx.Cipher ctx = new PkeyCtx.Cipher(this.key.getPkey());
        try {
            this.engineUpdate(input, offset, len);
            this.initPkeyCtx(ctx);
            int n = this.cipherOperation(ctx, output, outOffset);
            return n;
        }
        finally {
            ctx.free();
            this.cleanup();
        }
    }

    @Override
    protected byte[] engineGetIV() {
        return null;
    }

    @Override
    protected int engineGetOutputSize(int inputLen) {
        return this.keyBits / 8;
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        return null;
    }

    @Override
    protected byte[] engineWrap(Key key) throws InvalidKeyException, IllegalBlockSizeException {
        byte[] encoded = key.getEncoded();
        if (encoded == null || encoded.length == 0) {
            throw new InvalidKeyException("Could not obtain encoded key");
        }
        if (encoded.length > this.buffer.length) {
            throw new InvalidKeyException("Key is too long for wrapping");
        }
        try {
            return this.engineDoFinal(encoded, 0, encoded.length);
        }
        catch (BadPaddingException e) {
            throw new InvalidKeyException("Wrapping failed", e);
        }
    }

    @Override
    protected Key engineUnwrap(byte[] wrappedKey, String keyAlg, int wrappedKeyType) throws InvalidKeyException, NoSuchAlgorithmException {
        Key key;
        byte[] keyBytes = null;
        if (wrappedKey.length > this.buffer.length) {
            throw new InvalidKeyException("Key is too long for unwrapping");
        }
        try {
            keyBytes = this.engineDoFinal(wrappedKey, 0, wrappedKey.length);
            key = WrapUtil.createKey(keyAlg, wrappedKeyType, keyBytes);
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            try {
                throw new InvalidKeyException("Unwrapping failed", e);
            }
            catch (Throwable throwable) {
                Util.clearArray(keyBytes);
                throw throwable;
            }
        }
        Util.clearArray(keyBytes);
        return key;
    }

    @Override
    protected int engineGetKeySize(Key key) {
        return this.keyBits;
    }

    private void cleanup() {
        if (this.buffer != null) {
            Arrays.fill(this.buffer, (byte)0);
            this.buffer = null;
            this.bufOffset = 0;
        }
    }

    private void resetIfNecessary() {
        if (this.buffer == null) {
            try {
                this.initInternal(this.key, null, this.encrypt);
            }
            catch (InvalidAlgorithmParameterException | InvalidKeyException e) {
                throw new ProviderException("Unexpected exception.", e);
            }
        }
    }

    public static class RsaOaepSha512
    extends RsaOaep {
        public RsaOaepSha512() {
            super(MdAlg.SHA512);
        }
    }

    public static class RsaOaepSha384
    extends RsaOaep {
        public RsaOaepSha384() {
            super(MdAlg.SHA384);
        }
    }

    public static class RsaOaepSha256
    extends RsaOaep {
        public RsaOaepSha256() {
            super(MdAlg.SHA256);
        }
    }

    public static class RsaOaepSha224
    extends RsaOaep {
        public RsaOaepSha224() {
            super(MdAlg.SHA224);
        }
    }

    public static class RsaOaepSha1
    extends RsaOaep {
        public RsaOaepSha1() {
            super(MdAlg.SHA1);
        }
    }

    public static class RsaOaep
    extends RsaCipher {
        final boolean hasFixedMd;
        final MdAlg defaultMdAlg;
        OAEPParameterSpec paramSpec;

        private RsaOaep(MdAlg mdAlg, boolean fixed) {
            super(RsaCipherPadding.OAEPPADDING);
            this.hasFixedMd = fixed;
            this.defaultMdAlg = mdAlg;
            this.paramSpec = this.getDefaultParameterSpec();
        }

        RsaOaep(MdAlg mdAlg) {
            this(mdAlg, true);
        }

        public RsaOaep() {
            this(MdAlg.SHA1, false);
        }

        OAEPParameterSpec getDefaultParameterSpec() {
            return new OAEPParameterSpec(this.defaultMdAlg.getAlg(), "MGF1", MGF1ParameterSpec.SHA1, PSource.PSpecified.DEFAULT);
        }

        @Override
        void initPkeyCtx(PkeyCtx.Cipher ctx) {
            super.initPkeyCtx(ctx);
            MdAlg md = MdAlg.byName(this.paramSpec.getDigestAlgorithm());
            MdAlg mgf1Md = MdAlg.byName(((MGF1ParameterSpec)this.paramSpec.getMGFParameters()).getDigestAlgorithm());
            byte[] pSource = ((PSource.PSpecified)this.paramSpec.getPSource()).getValue();
            ctx.setOaepParams(md, mgf1Md, pSource);
        }

        @Override
        void verifyParams(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
            if (params == null) {
                this.paramSpec = this.getDefaultParameterSpec();
            } else {
                if (!(params instanceof OAEPParameterSpec)) {
                    throw new InvalidAlgorithmParameterException("Parameter spec not supported.");
                }
                String algName = ((OAEPParameterSpec)params).getDigestAlgorithm();
                MdAlg mdAlg = MdAlg.byName(algName);
                if (mdAlg == null) {
                    throw new InvalidAlgorithmParameterException("Unsupported Digest algorithm " + algName);
                }
                if (this.hasFixedMd && mdAlg != this.defaultMdAlg) {
                    throw new InvalidAlgorithmParameterException("Digest algorithm in parameter spec does not match digest algorithm in cipher transform string.");
                }
                if (!((OAEPParameterSpec)params).getMGFAlgorithm().equals("MGF1")) {
                    throw new InvalidAlgorithmParameterException("Only MGF1 supported.");
                }
                AlgorithmParameterSpec mgfSpec = ((OAEPParameterSpec)params).getMGFParameters();
                if (!(mgfSpec instanceof MGF1ParameterSpec)) {
                    throw new InvalidAlgorithmParameterException("Only MGF1ParameterSpec supported.");
                }
                algName = ((MGF1ParameterSpec)mgfSpec).getDigestAlgorithm();
                mdAlg = MdAlg.byName(algName);
                if (mdAlg == null) {
                    throw new InvalidAlgorithmParameterException("Unsupported MGF1 digest algorithm " + algName);
                }
                if (!(((OAEPParameterSpec)params).getPSource() instanceof PSource.PSpecified)) {
                    throw new InvalidAlgorithmParameterException("Unsupported PSource, must be PSource.Specified");
                }
                this.paramSpec = (OAEPParameterSpec)params;
            }
        }

        @Override
        AlgorithmParameterSpec toParamSpec(AlgorithmParameters params) throws InvalidAlgorithmParameterException {
            if (params == null) {
                return null;
            }
            if (!params.getAlgorithm().equals("OAEP")) {
                throw new InvalidAlgorithmParameterException("Invalid parameters, expected OAEP.");
            }
            try {
                return params.getParameterSpec(OAEPParameterSpec.class);
            }
            catch (InvalidParameterSpecException e) {
                throw new InvalidAlgorithmParameterException(e);
            }
        }

        @Override
        protected AlgorithmParameters engineGetParameters() {
            if (this.paramSpec != null) {
                try {
                    AlgorithmParameters params = AlgorithmParameters.getInstance("OAEP", InternalProvider.get());
                    params.init(this.paramSpec);
                    return params;
                }
                catch (NoSuchAlgorithmException e) {
                    throw new RuntimeException("Cannot find OAEP AlgorithmParameters implementation in JipherJCE provider");
                }
                catch (InvalidParameterSpecException e) {
                    throw new RuntimeException("OAEPParameterSpec not supported");
                }
            }
            return null;
        }
    }

    public static class RsaNoPad
    extends RsaCipher {
        public RsaNoPad() {
            super(RsaCipherPadding.NOPADDING);
        }

        @Override
        void initPkeyCtx(PkeyCtx.Cipher ctx) {
            super.initPkeyCtx(ctx);
        }

        @Override
        int cipherOperation(PkeyCtx.Cipher ctx, byte[] output, int outOffset) throws IllegalBlockSizeException, BadPaddingException {
            if (this.bufOffset < this.buffer.length) {
                System.arraycopy(this.buffer, 0, this.buffer, this.buffer.length - this.bufOffset, this.bufOffset);
                Arrays.fill(this.buffer, 0, this.bufOffset, (byte)0);
                this.bufOffset = this.buffer.length;
            }
            return super.cipherOperation(ctx, output, outOffset);
        }
    }

    public static class RsaPkcs1
    extends RsaCipher {
        public RsaPkcs1() {
            super(RsaCipherPadding.PKCS1PADDING);
        }

        @Override
        void verifyParams(AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
            if (params == null) {
                return;
            }
            if (InternalTlsSpec.RsaPremasterSecretParamSpec.isInstance(params)) {
                return;
            }
            throw new InvalidAlgorithmParameterException("ParameterSpec not supported");
        }
    }
}

