/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jipher.internal.openssl;

import com.oracle.jipher.internal.common.MultiRelease;
import com.oracle.jipher.internal.openssl.AlgType;
import com.oracle.jipher.internal.openssl.MdAlg;
import com.oracle.jipher.internal.openssl.OpenSsl;
import com.oracle.jipher.internal.openssl.OpenSslException;
import com.oracle.jipher.internal.openssl.OsslFactory;
import com.oracle.jipher.internal.openssl.OsslObject;
import com.oracle.jipher.internal.openssl.Pkey;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.ProviderException;
import java.security.SignatureException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public abstract class MdCtx
extends OsslObject {
    private MdCtx() {
        super(MdCtx.newState());
    }

    static State newState() {
        OpenSsl openssl = OsslFactory.get();
        try {
            return new State(openssl, openssl.evpMdCtxNew());
        }
        catch (OpenSslException e) {
            throw new ProviderException("Failed to create OpenSSL object", e);
        }
    }

    public static final class Signature
    extends MdCtx {
        private static final int PSS_PAD = 6;
        private long pkeyCtx;

        public void signInit(MdAlg alg, Pkey key) throws InvalidKeyException {
            try {
                this.pkeyCtx = this.openssl.evpDigestSignInit(this, alg.getAlg(), key);
            }
            catch (OpenSslException e) {
                throw new InvalidKeyException(e);
            }
        }

        public void setPssPadding() throws InvalidKeyException {
            try {
                this.openssl.evpPkeyCtxSetRsaPadding(this.pkeyCtx, 6);
                MultiRelease.reachabilityFence(this);
            }
            catch (OpenSslException e) {
                throw new InvalidKeyException("Key not valid for PSS Padding", e);
            }
        }

        public void verifyInit(MdAlg alg, Pkey key) throws InvalidKeyException {
            try {
                this.pkeyCtx = this.openssl.evpDigestVerifyInit(this, alg.getAlg(), key);
            }
            catch (OpenSslException e) {
                throw new InvalidKeyException(e);
            }
        }

        public void setPssParams(int saltLen) throws InvalidAlgorithmParameterException {
            try {
                this.openssl.evpPkeyCtxSetRsaPssSaltlen(this.pkeyCtx, saltLen);
                MultiRelease.reachabilityFence(this);
            }
            catch (OpenSslException e) {
                throw new InvalidAlgorithmParameterException(e);
            }
        }

        public void signUpdate(byte[] input, int offset, int len) throws SignatureException {
            try {
                this.openssl.evpDigestSignUpdate(this, input, offset, len);
            }
            catch (OpenSslException e) {
                throw new SignatureException(e);
            }
        }

        public void verifyUpdate(byte[] input, int offset, int len) throws SignatureException {
            try {
                this.openssl.evpDigestVerifyUpdate(this, input, offset, len);
            }
            catch (OpenSslException e) {
                throw new SignatureException(e);
            }
        }

        public byte[] signFinal() throws SignatureException {
            try {
                return this.openssl.evpDigestSignFinal(this);
            }
            catch (OpenSslException e) {
                throw new SignatureException(e);
            }
        }

        public boolean verifyFinal(byte[] signature, int offset, int len) throws SignatureException {
            try {
                return this.openssl.evpDigestVerifyFinal(this, signature, offset, len);
            }
            catch (OpenSslException e) {
                throw new SignatureException(e);
            }
        }

        public Signature copy() {
            try {
                Signature cpy = new Signature();
                this.openssl.evpMdCtxCopy(this, cpy);
                return cpy;
            }
            catch (OpenSslException e) {
                throw new ProviderException(e);
            }
        }
    }

    public static final class Digest
    extends MdCtx {
        private static final ConcurrentMap<String, Long> PREFETCHED_MDS = new ConcurrentHashMap<String, Long>();

        static void clearPrefetchCache() {
            PREFETCHED_MDS.clear();
        }

        long fetch(String mdAlg) {
            try {
                return this.openssl.evpFetch(AlgType.MD.ordinal(), mdAlg);
            }
            catch (OpenSslException e) {
                throw new ProviderException("Internal error", e);
            }
        }

        public void init(MdAlg mdAlg) {
            long evpMd = PREFETCHED_MDS.computeIfAbsent(mdAlg.getAlg(), alg -> this.fetch((String)alg));
            try {
                this.openssl.evpDigestInit(this, evpMd);
            }
            catch (OpenSslException e) {
                throw new ProviderException(e);
            }
        }

        public void update(byte[] in, int off, int len) {
            try {
                this.openssl.evpDigestUpdate(this, in, off, len);
            }
            catch (OpenSslException e) {
                throw new ProviderException(e);
            }
        }

        public void digest(byte[] out, int off) {
            try {
                this.openssl.evpDigestFinal(this, out, off);
            }
            catch (OpenSslException e) {
                throw new ProviderException(e);
            }
        }

        public Digest copy() {
            try {
                Digest cpy = new Digest();
                this.openssl.evpMdCtxCopy(this, cpy);
                return cpy;
            }
            catch (OpenSslException e) {
                throw new ProviderException(e);
            }
        }
    }

    static class State
    extends OsslObject.BaseState {
        State(OpenSsl openssl, long ptr) {
            super(openssl, ptr);
        }

        @Override
        void free(long ptr) {
            this.openssl.evpMdCtxFree(ptr);
        }
    }
}

