/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.jipher.internal.fips;

import com.oracle.jipher.internal.fips.CryptoOp;
import com.oracle.jipher.internal.fips.Fips;
import java.security.Key;
import java.security.ProviderException;
import java.security.interfaces.DSAKey;
import java.security.interfaces.ECKey;
import java.security.interfaces.RSAKey;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import javax.crypto.interfaces.DHKey;

public class Policy {
    private Map<RuleId, Predicate<Object>> rules;
    private String name;

    private Policy(String name, Map<RuleId, Predicate<Object>> map) {
        this.name = name;
        this.rules = map;
    }

    String getPolicyName() {
        return this.name;
    }

    public void checkAlg(CryptoOp op, String alg) {
        Predicate<Object> checker = this.rules.get(new RuleId(op, Type.ALG));
        if (checker != null) {
            Fips.DEBUG.println("Checking " + (Object)((Object)op) + " algorithm parameter " + alg + " against FIPS Policy (" + this.name + ")");
            if (!checker.test(alg)) {
                Fips.DEBUG.println("FIPS alg check failed.");
                throw new ProviderException("FIPS violation: policy " + this.name + " does not allow " + alg + " for operation " + op.toString().toLowerCase());
            }
        }
    }

    public void checkPad(CryptoOp op, String alg, String pad) {
        Predicate<Object> checker = this.rules.get(new RuleId(op, Type.PAD, alg));
        if (checker != null) {
            Fips.DEBUG.println("Checking " + (Object)((Object)op) + " " + alg + " with " + pad + " against FIPS Policy (" + this.name + ")");
            if (!checker.test(pad)) {
                Fips.DEBUG.println("FIPS alg check failed.");
                throw new ProviderException("FIPS violation: policy " + this.name + " does not allow " + alg + " with " + pad + " for operation " + op.toString().toLowerCase());
            }
        }
    }

    public void checkStrength(CryptoOp op, String alg, int ... size) {
        Predicate<Object> checker = this.rules.get(new RuleId(op, Type.STRENGTH, alg));
        if (checker != null) {
            Fips.DEBUG.println("Checking " + (Object)((Object)op) + " " + alg + " size against FIPS Policy (" + this.name + ")");
            if (size.length == 1 && !alg.equals("DSA")) {
                if (!checker.test(size[0])) {
                    Fips.DEBUG.println("FIPS strength check failed.");
                    throw new ProviderException("FIPS violation: policy " + this.name + " does not allow " + alg + " strength/key size " + size[0] + " for operation " + op.toString().toLowerCase());
                }
            } else if (!checker.test(size)) {
                Fips.DEBUG.println("FIPS strength check failed.");
                throw new ProviderException("FIPS violation: policy " + this.name + " does not allow " + alg + " strength/key size " + Arrays.toString(size) + " for operation " + op.toString().toLowerCase());
            }
        }
    }

    public void checkStrength(CryptoOp op, Key key) {
        if (key instanceof RSAKey) {
            this.checkStrength(op, "RSA", ((RSAKey)((Object)key)).getModulus().bitLength());
        } else if (key instanceof DSAKey) {
            this.checkStrength(op, "DSA", ((DSAKey)((Object)key)).getParams().getP().bitLength(), ((DSAKey)((Object)key)).getParams().getQ().bitLength());
        } else if (key instanceof ECKey) {
            this.checkStrength(op, "EC", ((ECKey)((Object)key)).getParams().getOrder().bitLength());
        } else if (key instanceof DHKey) {
            this.checkStrength(op, "DH", ((DHKey)((Object)key)).getParams().getP().bitLength());
        } else {
            throw new IllegalArgumentException("Unexpected key for checking strength");
        }
    }

    private static class RuleId {
        String keyAlg;
        private CryptoOp op;
        private Type type;

        private RuleId(CryptoOp op, Type type) {
            this.type = type;
            this.op = op;
        }

        private RuleId(CryptoOp op, Type type, String keyAlg) {
            this.keyAlg = keyAlg;
            this.type = type;
            this.op = op;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.keyAlg, this.type, this.op});
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof RuleId)) {
                return false;
            }
            RuleId other = (RuleId)obj;
            return other.type == this.type && other.op == this.op && Objects.equals(other.keyAlg, this.keyAlg);
        }
    }

    static class Builder {
        String name;
        Map<RuleId, Predicate<Object>> map = new HashMap<RuleId, Predicate<Object>>();

        Builder(String name) {
            this.name = name;
        }

        Builder strengthRule(String alg, Predicate<Object> checker, CryptoOp ... ops) {
            for (CryptoOp op : ops) {
                this.map.put(new RuleId(op, Type.STRENGTH, alg), checker);
            }
            return this;
        }

        Builder padRule(String alg, Predicate<Object> checker, CryptoOp ... ops) {
            for (CryptoOp op : ops) {
                this.map.put(new RuleId(op, Type.PAD, alg), checker);
            }
            return this;
        }

        Builder algRule(Predicate<Object> checker, CryptoOp ... ops) {
            for (CryptoOp op : ops) {
                this.map.put(new RuleId(op, Type.ALG), checker);
            }
            return this;
        }

        Policy build() {
            return new Policy(this.name, this.map);
        }
    }

    static enum Type {
        STRENGTH,
        ALG,
        PAD;

    }
}

