/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.thirdparty.gson;

import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.util.Optional;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeReflection;

public final class GsonFeature
implements Feature {
    private static Optional<Module> requiredModule() {
        return ModuleLayer.boot().findModule("jdk.unsupported");
    }

    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return GsonFeature.requiredModule().isPresent();
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        Class gsonClass = access.findClassByName("com.google.gson.Gson");
        if (gsonClass != null) {
            access.registerReachabilityHandler(GsonFeature::makeUnsafeReflectivelyAccessible, new Object[]{gsonClass});
        }
    }

    private static void makeUnsafeReflectivelyAccessible(Feature.DuringAnalysisAccess a) {
        Class unsafeClass = a.findClassByName("sun.misc.Unsafe");
        RuntimeReflection.register((Class[])new Class[]{unsafeClass});
        RuntimeReflection.register((Field[])new Field[]{ReflectionUtil.lookupField((Class)unsafeClass, (String)"theUnsafe")});
        RuntimeReflection.register((Executable[])new Executable[]{ReflectionUtil.lookupMethod((Class)unsafeClass, (String)"allocateInstance", (Class[])new Class[]{Class.class})});
    }
}

