// CheckStyle: stop header check
// CheckStyle: stop line length check
// GENERATED CONTENT - DO NOT EDIT
// Source: SpectrePHTMitigations.java
package jdk.graal.compiler.core.common;

import java.util.*;
import jdk.graal.compiler.options.*;
import jdk.graal.compiler.options.OptionType;
import jdk.graal.compiler.options.OptionStability;

public class SpectrePHTMitigations_OptionDescriptors implements OptionDescriptors {
    @Override
    public OptionDescriptor get(String value) {
        switch (value) {
        // CheckStyle: stop line length check
        case "SpectrePHTBarriers": {
            return OptionDescriptor.create(
                /*name*/ "SpectrePHTBarriers",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ jdk.graal.compiler.core.common.SpectrePHTMitigations.class,
                /*help*/ "Selects a strategy to mitigate speculative bounds check bypass (also known as Spectre-PHT or Spectre V1). ",
                /*extraHelp*/ new String[] {
                         "The accepted values are:",
                         "                  None - No mitigations are used in JIT compiled code.",
                         "            AllTargets - Speculative execution on all branch targets is",
                         "                         stopped using speculative execution barrier instructions.",
                         "                         This option is equivalent to setting SpeculativeExecutionBarriers to true.",
                         "          GuardTargets - Branch targets relevant to Java memory safety are instrumented with barrier instructions. ",
                         "                         This option has a lower performance impact than AllTargets. ",
                         "  NonDeoptGuardTargets - Same as GuardTargets, except that branches which deoptimize are not protected because they cannot be ",
                         "                         executed repeatedly and are thus less likely to be successfully exploited in an attack.",
                         "",
                         "                         ",
                         " Note that all modes except \"None\" also instrument branch target blocks containing UNSAFE memory accesses with barrier instructions.",
                              },
                /*declaringClass*/ SpectrePHTMitigations.Options.class,
                /*fieldName*/ "SpectrePHTBarriers",
                /*option*/ SpectrePHTMitigations.Options.SpectrePHTBarriers,
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "SpectrePHTIndexMasking": {
            return OptionDescriptor.create(
                /*name*/ "SpectrePHTIndexMasking",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Masks indices to scope access to allocation size after bounds check.",
                /*declaringClass*/ SpectrePHTMitigations.Options.class,
                /*fieldName*/ "SpectrePHTIndexMasking",
                /*option*/ SpectrePHTMitigations.Options.SpectrePHTIndexMasking,
                /*stability*/ OptionStability.STABLE,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "SpeculativeExecutionBarriers": {
            return OptionDescriptor.create(
                /*name*/ "SpeculativeExecutionBarriers",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Stop speculative execution on all branch targets with execution barrier instructions.",
                /*declaringClass*/ SpectrePHTMitigations.Options.class,
                /*fieldName*/ "SpeculativeExecutionBarriers",
                /*option*/ SpectrePHTMitigations.Options.SpeculativeExecutionBarriers,
                /*stability*/ OptionStability.STABLE,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        // CheckStyle: resume line length check
        }
        return null;
    }

    @Override
    public Iterator<OptionDescriptor> iterator() {
        return new Iterator<>() {
            int i = 0;
            @Override
            public boolean hasNext() {
                return i < 3;
            }
            @Override
            public OptionDescriptor next() {
                switch (i++) {
                    case 0: return get("SpectrePHTBarriers");
                    case 1: return get("SpectrePHTIndexMasking");
                    case 2: return get("SpeculativeExecutionBarriers");
                }
                throw new NoSuchElementException();
            }
        };
    }
}
