/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.aotjs.wasm.codegen;

import com.oracle.svm.core.OS;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.c.libc.TemporaryBuildDirectoryProvider;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.util.InterruptImageBuilding;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.aotjs.wasm.codegen.b;
import com.oracle.svm.hosted.aotjs.wasm.t;
import com.oracle.svm.hosted.c.codegen.CCompilerInvoker;
import com.oracle.svm.hosted.c.util.FileUtils;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import jdk.graal.compiler.debug.DebugOptions;
import jdk.graal.compiler.options.OptionKey;
import jdk.graal.compiler.options.OptionValues;
import org.graalvm.nativeimage.ImageSingletons;

public abstract class d {
    public final Path yL;
    public final a yM;

    protected d(Path path) {
        this.yL = path;
        try {
            this.yM = this.gi();
        }
        catch (UserError.UserException userException) {
            throw this.a(userException);
        }
    }

    public static d fX() {
        return (d)ImageSingletons.lookup(d.class);
    }

    public static void fY() {
        assert (!ImageSingletons.contains(d.class));
        Path path = ((TemporaryBuildDirectoryProvider)ImageSingletons.lookup(TemporaryBuildDirectoryProvider.class)).getTemporaryBuildDirectory();
        d d2 = com.oracle.svm.hosted.aotjs.wasm.codegen.b.fW() ? new b(path) : new e(path);
        ImageSingletons.add(d.class, (Object)d2);
        d2.gg();
    }

    public void a(Path path, Path path2, OptionValues optionValues, Consumer<String> consumer) throws IOException, InterruptedException {
        d d2 = this.a(path, path2);
        List<String> list = d2.go();
        int n2 = d2.yU;
        if (!list.isEmpty() && (n2 != 0 || ((Boolean)DebugOptions.LogVerbose.getValue(optionValues)).booleanValue())) {
            consumer.accept("Output for " + String.valueOf(d2.yS) + ":");
            list.forEach(consumer);
        }
        UserError.guarantee((n2 == 0 ? 1 : 0) != 0, (String)"%s failed with exit code: %s", (Object[])new Object[]{d2.yR.toString(), n2});
    }

    public d a(Path path, Path path2) throws IOException, InterruptedException {
        Path path3 = this.yM.yN;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (((Boolean)t.qM.getValue()).booleanValue()) {
            arrayList.add(this.gb());
        }
        arrayList.addAll(this.gd());
        List<String> list = this.a(arrayList, path2, path);
        return d.a(path3, list);
    }

    private static d a(Path path, List<String> list) throws IOException, InterruptedException {
        ArrayList<String> arrayList = new ArrayList<String>(list.size() + 1);
        arrayList.add(path.toString());
        arrayList.addAll(list);
        Process process = new ProcessBuilder(arrayList).redirectErrorStream(true).start();
        try (InputStream inputStream = process.getInputStream();){
            List list2 = FileUtils.readAllLines((InputStream)inputStream);
            int n2 = process.waitFor();
            d d2 = new d(path, arrayList, list2, n2);
            return d2;
        }
    }

    protected abstract String fZ();

    protected abstract HostedOptionKey<String> ga();

    protected abstract String gb();

    protected abstract List<String> c(Path var1);

    protected abstract List<String> gd();

    protected abstract String ge();

    protected List<String> gf() {
        return List.of("--version");
    }

    public void gg() {
        if (((Boolean)SubstrateOptions.CheckToolchain.getValue()).booleanValue()) {
            try {
                this.gh();
            }
            catch (UserError.UserException userException) {
                throw this.a(userException);
            }
        }
    }

    private UserError.UserException a(UserError.UserException userException) {
        ArrayList<CallSite> arrayList = new ArrayList<CallSite>();
        userException.getMessages().forEach(arrayList::add);
        HostedOptionKey<String> hostedOptionKey = this.ga();
        if (!hostedOptionKey.hasBeenSet()) {
            arrayList.add((CallSite)((Object)("A custom path to the " + this.fZ() + " executable can be set with the " + SubstrateOptionsParser.commandArgument(this.ga(), (String)"<path>") + " command-line option")));
        }
        arrayList.add((CallSite)((Object)("To prevent native-toolchain checking provide command-line option " + SubstrateOptionsParser.commandArgument((OptionKey)SubstrateOptions.CheckToolchain, (String)"-"))));
        return UserError.abort(arrayList);
    }

    private static String a(d d2) {
        return d.a(d2.gn(), d2.gp(), d2.yT);
    }

    private static String a(List<String> list, int n2, List<String> list2) {
        assert (n2 != 0);
        String string2 = "Command '%s' failed with exit code %d. Output:%n%s";
        return string2.formatted(SubstrateUtil.getShellCommandString(list, (boolean)false), n2, list2.stream().map(string -> "  " + string).collect(Collectors.joining(System.lineSeparator())));
    }

    private void gh() {
        String string = this.ge();
        try (InputStream inputStream = d.class.getResourceAsStream(string);){
            VMError.guarantee((inputStream != null ? 1 : 0) != 0, (String)"Couldn't find file (%s) used to verify Wasm assembler", (Object)string);
            Path path = this.yL.resolve(string);
            Path path2 = this.yL.resolve(string + ".wasm");
            Files.copy(inputStream, path, new CopyOption[0]);
            d d2 = this.a(path, path2);
            if (d2.yU != 0) {
                throw UserError.abort((String)"Wasm assembler could not assemble sample Wasm text format file. The chosen assembler may not support all required features.%n%s", (Object[])new Object[]{d.a(d2)});
            }
        }
        catch (InterruptedException interruptedException) {
            throw new InterruptImageBuilding("Interrupted while checking Wasm assembler " + String.valueOf(this.yM.yN));
        }
        catch (IOException iOException) {
            throw UserError.abort((Throwable)iOException, (String)"Assembling sample Wasm text format file failed", (Object[])new Object[0]);
        }
    }

    private a gi() {
        String string;
        Path path = this.gj().toAbsolutePath();
        if (!((Boolean)SubstrateOptions.CheckToolchain.getValue()).booleanValue()) {
            return new a(path, null);
        }
        try {
            List<String> list = this.a(this.gf(), null, null);
            d d2 = d.a(path, list);
            if (d2.gp() != 0) {
                throw UserError.abort((String)"Collecting Wasm assembler info failed.%n%s", (Object[])new Object[]{d.a(d2)});
            }
            string = String.join((CharSequence)System.lineSeparator(), d2.go());
        }
        catch (InterruptedException interruptedException) {
            throw new InterruptImageBuilding("Interrupted while checking Wasm assembler " + String.valueOf(path));
        }
        catch (IOException iOException) {
            throw UserError.abort((Throwable)iOException, (String)"Collecting Wasm assembler info failed", (Object[])new Object[0]);
        }
        return new a(path, string);
    }

    private Path gj() {
        Object object;
        Path path;
        HostedOptionKey<String> hostedOptionKey = this.ga();
        String string = (String)hostedOptionKey.getValue();
        if (string != null) {
            path = Paths.get(string, new String[0]);
        } else {
            object = this.aq(this.fZ());
            Optional optional = CCompilerInvoker.lookupSearchPath((String)object);
            if (optional.isPresent()) {
                path = (Path)optional.get();
            } else {
                throw UserError.abort((String)"'%s' not found on the system path. Please extend the PATH environment variable so that it provides a Wasm assembler executable called '%s'.", (Object[])new Object[]{object, object});
            }
        }
        if (Files.isDirectory(path, new LinkOption[0]) || !Files.isExecutable(path)) {
            object = string != null ? SubstrateOptionsParser.commandArgument(hostedOptionKey, (String)string) : "Default Wasm assembler '" + String.valueOf(path) + "'";
            throw UserError.abort((String)"%s does not specify a path to an executable.", (Object[])new Object[]{object});
        }
        return path;
    }

    protected String aq(String string) {
        String string2;
        if (OS.WINDOWS.isCurrent() && !string.endsWith(string2 = ".exe")) {
            return string + string2;
        }
        return string;
    }

    private List<String> a(List<String> list, Path path, Path path2) {
        ArrayList<String> arrayList = new ArrayList<String>(list);
        if (path != null) {
            arrayList.addAll(this.c(path));
        }
        if (path2 != null) {
            arrayList.add(path2.toString());
        }
        return arrayList;
    }

    public static final class a
    extends Record {
        private final Path yN;
        private final String yO;

        public a(Path path, String string) {
            this.yN = path;
            this.yO = string;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "assemblerPath;versionString", "yN", "yO"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "assemblerPath;versionString", "yN", "yO"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "assemblerPath;versionString", "yN", "yO"}, this, o2);
        }

        public Path gk() {
            return this.yN;
        }

        public String gl() {
            return this.yO;
        }
    }

    public static class b
    extends d {
        protected b(Path path) {
            super(path);
        }

        @Override
        protected String fZ() {
            return "wasm-as";
        }

        @Override
        protected HostedOptionKey<String> ga() {
            return c.yQ;
        }

        @Override
        protected String gb() {
            return "-g";
        }

        @Override
        protected List<String> c(Path path) {
            return Collections.singletonList("--output=" + String.valueOf(path));
        }

        @Override
        protected List<String> gd() {
            return List.of("--enable-exception-handling", "--enable-nontrapping-float-to-int", "--enable-bulk-memory", "--enable-reference-types", "--enable-gc");
        }

        @Override
        protected String ge() {
            return "verify-wasm-as.wast";
        }
    }

    public static class e
    extends d {
        protected e(Path path) {
            super(path);
        }

        @Override
        protected String fZ() {
            return "wat2wasm";
        }

        @Override
        protected HostedOptionKey<String> ga() {
            return c.yP;
        }

        @Override
        protected String gb() {
            return "--debug-names";
        }

        @Override
        protected List<String> c(Path path) {
            return Collections.singletonList("--output=" + String.valueOf(path));
        }

        @Override
        protected List<String> gd() {
            return List.of("--enable-exceptions", "--enable-function-references");
        }

        @Override
        protected String ge() {
            return "verify-wat2wasm.wast";
        }
    }

    public static final class d
    extends Record {
        private final Path yR;
        private final List<String> yS;
        private final List<String> yT;
        private final int yU;

        public d(Path path, List<String> list, List<String> list2, int n2) {
            this.yR = path;
            this.yS = list;
            this.yT = list2;
            this.yU = n2;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{d.class, "executable;commandLine;outputLines;exitCode", "yR", "yS", "yT", "yU"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{d.class, "executable;commandLine;outputLines;exitCode", "yR", "yS", "yT", "yU"}, this);
        }

        @Override
        public final boolean equals(Object o2) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{d.class, "executable;commandLine;outputLines;exitCode", "yR", "yS", "yT", "yU"}, this, o2);
        }

        public Path gm() {
            return this.yR;
        }

        public List<String> gn() {
            return this.yS;
        }

        public List<String> go() {
            return this.yT;
        }

        public int gp() {
            return this.yU;
        }
    }

    public static class c {
        public static final HostedOptionKey<String> yP = new HostedOptionKey(null, c::c);
        public static final HostedOptionKey<String> yQ = new HostedOptionKey(null, c::d);

        private static void c(HostedOptionKey<String> hostedOptionKey) {
            if (hostedOptionKey.hasBeenSet() && com.oracle.svm.hosted.aotjs.wasm.codegen.b.fW()) {
                throw UserError.abort((String)"The option %s cannot be used if Binaryen is enabled (%s)", (Object[])new Object[]{hostedOptionKey.getName(), SubstrateOptionsParser.commandArgument(b.a.yI, (String)"+")});
            }
        }

        private static void d(HostedOptionKey<String> hostedOptionKey) {
            if (hostedOptionKey.hasBeenSet() && !com.oracle.svm.hosted.aotjs.wasm.codegen.b.fW()) {
                throw UserError.abort((String)"The option %s can only be used if Binaryen is enabled (%s)", (Object[])new Object[]{hostedOptionKey.getName(), SubstrateOptionsParser.commandArgument(b.a.yI, (String)"+")});
            }
        }
    }
}

