/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.reflect;

import com.oracle.graal.pointsto.ObjectScanner;
import com.oracle.graal.pointsto.constraints.UnsupportedFeatureException;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.svm.core.MissingRegistrationUtils;
import com.oracle.svm.core.configure.ConditionalRuntimeValue;
import com.oracle.svm.core.configure.ConfigurationFiles;
import com.oracle.svm.core.configure.RuntimeConditionSet;
import com.oracle.svm.core.hub.ClassForNameSupport;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.reflect.SubstrateAccessor;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.ConditionalConfigurationRegistry;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.LinkAtBuildTimeSupport;
import com.oracle.svm.hosted.annotation.AnnotationMemberValue;
import com.oracle.svm.hosted.annotation.AnnotationValue;
import com.oracle.svm.hosted.annotation.SubstrateAnnotationExtractor;
import com.oracle.svm.hosted.annotation.TypeAnnotationValue;
import com.oracle.svm.hosted.reflect.RecordUtils;
import com.oracle.svm.hosted.reflect.ReflectionFeature;
import com.oracle.svm.hosted.reflect.ReflectionHostedSupport;
import com.oracle.svm.hosted.substitute.SubstitutionReflectivityFilter;
import com.oracle.svm.util.LogUtils;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.MalformedParameterizedTypeException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.RecordComponent;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.RuntimeProxyCreation;
import org.graalvm.nativeimage.hosted.RuntimeReflection;
import org.graalvm.nativeimage.impl.ConfigurationCondition;
import org.graalvm.nativeimage.impl.RuntimeReflectionSupport;
import sun.reflect.annotation.ExceptionProxy;

public class ReflectionDataBuilder
extends ConditionalConfigurationRegistry
implements RuntimeReflectionSupport,
ReflectionHostedSupport {
    private AnalysisMetaAccess metaAccess;
    private AnalysisUniverse universe;
    private final SubstrateAnnotationExtractor annotationExtractor;
    private FeatureImpl.BeforeAnalysisAccessImpl analysisAccess;
    private final ClassForNameSupport classForNameSupport;
    private boolean sealed;
    private final Map<Class<?>, RecordComponent[]> registeredRecordComponents = new ConcurrentHashMap();
    private final Map<Class<?>, Set<Class<?>>> innerClasses = new ConcurrentHashMap();
    private final Map<Class<?>, Integer> enabledQueriesFlags = new ConcurrentHashMap();
    private final Map<AnalysisType, Map<AnalysisField, ConditionalRuntimeValue<Field>>> registeredFields = new ConcurrentHashMap<AnalysisType, Map<AnalysisField, ConditionalRuntimeValue<Field>>>();
    private final Set<AnalysisField> hidingFields = ConcurrentHashMap.newKeySet();
    private final Map<AnalysisType, Map<AnalysisMethod, ConditionalRuntimeValue<Executable>>> registeredMethods = new ConcurrentHashMap<AnalysisType, Map<AnalysisMethod, ConditionalRuntimeValue<Executable>>>();
    private final Map<AnalysisMethod, Object> methodAccessors = new ConcurrentHashMap<AnalysisMethod, Object>();
    private final Set<AnalysisMethod> hidingMethods = ConcurrentHashMap.newKeySet();
    private final Set<DynamicHub> heapDynamicHubs = ConcurrentHashMap.newKeySet();
    private final Map<AnalysisField, Field> heapFields = new ConcurrentHashMap<AnalysisField, Field>();
    private final Map<AnalysisMethod, Executable> heapMethods = new ConcurrentHashMap<AnalysisMethod, Executable>();
    private final Map<AnalysisType, Set<String>> negativeFieldLookups = new ConcurrentHashMap<AnalysisType, Set<String>>();
    private final Map<AnalysisType, Set<AnalysisMethod.Signature>> negativeMethodLookups = new ConcurrentHashMap<AnalysisType, Set<AnalysisMethod.Signature>>();
    private final Map<AnalysisType, Set<AnalysisType[]>> negativeConstructorLookups = new ConcurrentHashMap<AnalysisType, Set<AnalysisType[]>>();
    private final Map<Class<?>, Throwable> classLookupExceptions = new ConcurrentHashMap();
    private final Map<Class<?>, Throwable> fieldLookupExceptions = new ConcurrentHashMap();
    private final Map<Class<?>, Throwable> methodLookupExceptions = new ConcurrentHashMap();
    private final Map<Class<?>, Throwable> constructorLookupExceptions = new ConcurrentHashMap();
    private final Map<Type, Set<Integer>> processedTypes = new ConcurrentHashMap<Type, Set<Integer>>();
    private final Map<Class<?>, Set<Method>> pendingRecordClasses;
    private final Set<ConditionalTask> pendingConditionalTasks = ConcurrentHashMap.newKeySet();
    private final Map<AnnotatedElement, AnnotationValue[]> filteredAnnotations = new ConcurrentHashMap<AnnotatedElement, AnnotationValue[]>();
    private final Map<AnalysisMethod, AnnotationValue[][]> filteredParameterAnnotations = new ConcurrentHashMap<AnalysisMethod, AnnotationValue[][]>();
    private final Map<AnnotatedElement, TypeAnnotationValue[]> filteredTypeAnnotations = new ConcurrentHashMap<AnnotatedElement, TypeAnnotationValue[]>();
    private final Method getEnclosingMethod0 = ReflectionUtil.lookupMethod(Class.class, (String)"getEnclosingMethod0", (Class[])new Class[0]);
    private static final AnnotationValue[] NO_ANNOTATIONS = new AnnotationValue[0];
    private static final AnnotationValue[][] NO_PARAMETER_ANNOTATIONS = new AnnotationValue[0][0];
    private static final TypeAnnotationValue[] NO_TYPE_ANNOTATIONS = new TypeAnnotationValue[0];

    ReflectionDataBuilder(SubstrateAnnotationExtractor annotationExtractor) {
        this.annotationExtractor = annotationExtractor;
        this.pendingRecordClasses = !MissingRegistrationUtils.throwMissingRegistrationErrors() ? new ConcurrentHashMap() : null;
        this.classForNameSupport = ClassForNameSupport.singleton();
    }

    public void duringSetup(AnalysisMetaAccess analysisMetaAccess, AnalysisUniverse analysisUniverse) {
        this.metaAccess = analysisMetaAccess;
        this.universe = analysisUniverse;
        for (ConditionalTask conditionalTask : this.pendingConditionalTasks) {
            this.registerConditionalConfiguration(conditionalTask.condition, cnd -> this.universe.getBigbang().postTask(debug -> conditionalTask.task.accept((ConfigurationCondition)cnd)));
        }
        this.pendingConditionalTasks.clear();
    }

    public void beforeAnalysis(FeatureImpl.BeforeAnalysisAccessImpl beforeAnalysisAccess) {
        this.analysisAccess = beforeAnalysisAccess;
    }

    private void runConditionalInAnalysisTask(ConfigurationCondition condition, Consumer<ConfigurationCondition> task) {
        if (this.sealed) {
            throw new UnsupportedFeatureException("Too late to add classes, methods, and fields for reflective access. Registration must happen in a Feature before the analysis has finished.");
        }
        if (this.universe != null) {
            this.registerConditionalConfiguration(condition, cnd -> this.universe.getBigbang().postTask(debug -> task.accept((ConfigurationCondition)cnd)));
        } else {
            this.pendingConditionalTasks.add(new ConditionalTask(condition, task));
            VMError.guarantee(this.universe == null, "There shouldn't be a race condition on Feature.duringSetup.");
        }
    }

    private void setQueryFlag(Class<?> clazz, int flag) {
        this.enabledQueriesFlags.compute(clazz, (key, oldValue) -> oldValue == null ? flag : oldValue | flag);
    }

    private boolean isQueryFlagSet(Class<?> clazz, int flag) {
        return (this.enabledQueriesFlags.getOrDefault(clazz, 0) & flag) != 0;
    }

    public void register(ConfigurationCondition condition, boolean unsafeInstantiated, Class<?> clazz) {
        Objects.requireNonNull(clazz, () -> ReflectionDataBuilder.nullErrorMessage("class"));
        this.runConditionalInAnalysisTask(condition, cnd -> this.registerClass((ConfigurationCondition)cnd, clazz, unsafeInstantiated, true));
    }

    public void registerAllClassesQuery(ConfigurationCondition condition, Class<?> clazz) {
        ReflectionDataBuilder.guaranteeNotRuntimeConditionForQueries(condition, true);
        this.runConditionalInAnalysisTask(condition, cnd -> {
            this.setQueryFlag(clazz, 0x400000);
            try {
                for (Class<?> innerClass : clazz.getClasses()) {
                    if (innerClass.getDeclaringClass() != null) {
                        this.innerClasses.computeIfAbsent(innerClass.getDeclaringClass(), c -> ConcurrentHashMap.newKeySet()).add(innerClass);
                    }
                    this.registerClass((ConfigurationCondition)cnd, innerClass, false, !MissingRegistrationUtils.throwMissingRegistrationErrors());
                }
            }
            catch (LinkageError e) {
                this.registerLinkageError(clazz, e, this.classLookupExceptions);
            }
        });
    }

    private static void guaranteeNotRuntimeConditionForQueries(ConfigurationCondition cnd, boolean queriedOnly) {
        if (!ConfigurationFiles.Options.TreatAllTypeReachableConditionsAsTypeReached.getValue().booleanValue()) {
            VMError.guarantee(!queriedOnly || cnd.isAlwaysTrue() || !cnd.isRuntimeChecked(), "Bulk queries can only be set with 'name' which does not allow run-time conditions.");
        }
    }

    public void registerAllDeclaredClassesQuery(ConfigurationCondition condition, Class<?> clazz) {
        ReflectionDataBuilder.guaranteeNotRuntimeConditionForQueries(condition, true);
        this.runConditionalInAnalysisTask(condition, cnd -> {
            this.setQueryFlag(clazz, 0x800000);
            try {
                for (Class<?> innerClass : clazz.getDeclaredClasses()) {
                    this.innerClasses.computeIfAbsent(clazz, c -> ConcurrentHashMap.newKeySet()).add(innerClass);
                    this.registerClass((ConfigurationCondition)cnd, innerClass, false, !MissingRegistrationUtils.throwMissingRegistrationErrors());
                }
            }
            catch (LinkageError e) {
                this.registerLinkageError(clazz, e, this.classLookupExceptions);
            }
        });
    }

    private void registerClass(ConfigurationCondition condition, Class<?> clazz, boolean unsafeInstantiated, boolean allowForName) {
        if (this.shouldExcludeClass(clazz)) {
            return;
        }
        AnalysisType type = this.metaAccess.lookupJavaType(clazz);
        type.registerAsReachable((Object)"Is registered for reflection.");
        if (unsafeInstantiated) {
            type.registerAsUnsafeAllocated((Object)"Is registered via reflection metadata.");
            this.classForNameSupport.registerUnsafeAllocated(condition, clazz);
        }
        if (allowForName) {
            this.classForNameSupport.registerClass(condition, clazz);
            if (!MissingRegistrationUtils.throwMissingRegistrationErrors()) {
                try {
                    if (clazz.getEnclosingClass() != null) {
                        Class enclosingClass = this.metaAccess.lookupJavaType(clazz.getEnclosingClass()).getJavaClass();
                        this.innerClasses.computeIfAbsent(enclosingClass, enclosingType -> ConcurrentHashMap.newKeySet()).add(clazz);
                    }
                }
                catch (LinkageError e) {
                    ReflectionDataBuilder.reportLinkingErrors(clazz, List.of(e));
                }
            }
        }
    }

    public void registerClassLookupException(ConfigurationCondition condition, String typeName, Throwable t) {
        this.runConditionalInAnalysisTask(condition, cnd -> this.classForNameSupport.registerExceptionForClass((ConfigurationCondition)cnd, typeName, t));
    }

    public void registerClassLookup(ConfigurationCondition condition, String typeName) {
        this.runConditionalInAnalysisTask(condition, cnd -> {
            try {
                this.registerClass((ConfigurationCondition)cnd, Class.forName(typeName, false, ClassLoader.getSystemClassLoader()), false, true);
            }
            catch (ClassNotFoundException e) {
                this.classForNameSupport.registerNegativeQuery((ConfigurationCondition)cnd, typeName);
            }
            catch (Throwable t) {
                this.classForNameSupport.registerExceptionForClass((ConfigurationCondition)cnd, typeName, t);
            }
        });
    }

    public void registerAllRecordComponentsQuery(ConfigurationCondition condition, Class<?> clazz) {
        ReflectionDataBuilder.guaranteeNotRuntimeConditionForQueries(condition, true);
        this.runConditionalInAnalysisTask(condition, cnd -> {
            this.setQueryFlag(clazz, 0x1000000);
            this.registerRecordComponents(clazz);
        });
    }

    public void registerAllPermittedSubclassesQuery(ConfigurationCondition condition, Class<?> clazz) {
        ReflectionDataBuilder.guaranteeNotRuntimeConditionForQueries(condition, true);
        this.runConditionalInAnalysisTask(condition, cnd -> {
            this.setQueryFlag(clazz, 0x2000000);
            if (clazz.isSealed()) {
                for (Class<?> permittedSubclass : clazz.getPermittedSubclasses()) {
                    this.registerClass(condition, permittedSubclass, false, false);
                }
            }
        });
    }

    public void registerAllNestMembersQuery(ConfigurationCondition condition, Class<?> clazz) {
        ReflectionDataBuilder.guaranteeNotRuntimeConditionForQueries(condition, true);
        this.runConditionalInAnalysisTask(condition, cnd -> {
            this.setQueryFlag(clazz, 0x4000000);
            for (Class<?> nestMember : clazz.getNestMembers()) {
                if (nestMember == clazz) continue;
                this.registerClass(condition, nestMember, false, false);
            }
        });
    }

    public void registerAllSignersQuery(ConfigurationCondition condition, Class<?> clazz) {
        ReflectionDataBuilder.guaranteeNotRuntimeConditionForQueries(condition, true);
        this.runConditionalInAnalysisTask(condition, cnd -> {
            this.setQueryFlag(clazz, 0x8000000);
            Object[] signers = clazz.getSigners();
            if (signers != null) {
                for (Object signer : signers) {
                    this.metaAccess.lookupJavaType(signer.getClass()).registerAsInstantiated((Object)"signer");
                }
            }
        });
    }

    public void register(ConfigurationCondition condition, boolean queriedOnly, Executable ... executables) {
        ReflectionDataBuilder.requireNonNull(executables, "executable");
        this.runConditionalInAnalysisTask(condition, cnd -> this.registerMethods((ConfigurationCondition)cnd, queriedOnly, executables));
    }

    public void registerAllMethodsQuery(ConfigurationCondition condition, boolean queriedOnly, Class<?> clazz) {
        ReflectionDataBuilder.guaranteeNotRuntimeConditionForQueries(condition, queriedOnly);
        this.runConditionalInAnalysisTask(condition, cnd -> {
            for (Class current = clazz; current != null; current = current.getSuperclass()) {
                this.setQueryFlag(current, 262144);
            }
            try {
                this.registerMethods((ConfigurationCondition)cnd, queriedOnly, clazz.getMethods());
            }
            catch (LinkageError e) {
                this.registerLinkageError(clazz, e, this.methodLookupExceptions);
            }
        });
    }

    public void registerAllDeclaredMethodsQuery(ConfigurationCondition condition, boolean queriedOnly, Class<?> clazz) {
        ReflectionDataBuilder.guaranteeNotRuntimeConditionForQueries(condition, queriedOnly);
        this.runConditionalInAnalysisTask(condition, cnd -> {
            this.setQueryFlag(clazz, 524288);
            try {
                this.registerMethods((ConfigurationCondition)cnd, queriedOnly, clazz.getDeclaredMethods());
            }
            catch (LinkageError e) {
                this.registerLinkageError(clazz, e, this.methodLookupExceptions);
            }
        });
    }

    public void registerAllConstructorsQuery(ConfigurationCondition condition, boolean queriedOnly, Class<?> clazz) {
        ReflectionDataBuilder.guaranteeNotRuntimeConditionForQueries(condition, queriedOnly);
        this.runConditionalInAnalysisTask(condition, cnd -> {
            for (Class current = clazz; current != null; current = current.getSuperclass()) {
                this.setQueryFlag(current, 0x100000);
            }
            try {
                this.registerMethods((ConfigurationCondition)cnd, queriedOnly, clazz.getConstructors());
            }
            catch (LinkageError e) {
                this.registerLinkageError(clazz, e, this.constructorLookupExceptions);
            }
        });
    }

    public void registerAllDeclaredConstructorsQuery(ConfigurationCondition condition, boolean queriedOnly, Class<?> clazz) {
        ReflectionDataBuilder.guaranteeNotRuntimeConditionForQueries(condition, queriedOnly);
        this.runConditionalInAnalysisTask(condition, cnd -> {
            this.setQueryFlag(clazz, 0x200000);
            try {
                this.registerMethods((ConfigurationCondition)cnd, queriedOnly, clazz.getDeclaredConstructors());
            }
            catch (LinkageError e) {
                this.registerLinkageError(clazz, e, this.constructorLookupExceptions);
            }
        });
    }

    private void registerMethods(ConfigurationCondition cnd, boolean queriedOnly, Executable[] reflectExecutables) {
        for (Executable reflectExecutable : reflectExecutables) {
            this.registerMethod(cnd, queriedOnly, reflectExecutable);
        }
    }

    private void registerMethod(ConfigurationCondition cnd, boolean queriedOnly, Executable reflectExecutable) {
        ConditionalRuntimeValue<Executable> newConditionalValue;
        if (SubstitutionReflectivityFilter.shouldExclude(reflectExecutable, this.metaAccess, this.universe)) {
            return;
        }
        AnalysisMethod analysisMethod = this.metaAccess.lookupJavaMethod(reflectExecutable);
        AnalysisType declaringType = analysisMethod.getDeclaringClass();
        Map classMethods = this.registeredMethods.computeIfAbsent(declaringType, t -> new ConcurrentHashMap());
        boolean shouldRegisterReachabilityHandler = classMethods.isEmpty();
        boolean registered = false;
        ConditionalRuntimeValue<Executable> conditionalValue = (ConditionalRuntimeValue<Executable>)classMethods.get(analysisMethod);
        if (conditionalValue == null && (conditionalValue = classMethods.putIfAbsent(analysisMethod, newConditionalValue = new ConditionalRuntimeValue<Executable>(RuntimeConditionSet.emptySet(), reflectExecutable))) == null) {
            conditionalValue = newConditionalValue;
            registered = true;
        }
        if (!queriedOnly) {
            conditionalValue.getConditions().addCondition(cnd);
        }
        if (registered) {
            this.registerTypesForMethod(analysisMethod, reflectExecutable);
            Class declaringClass = declaringType.getJavaClass();
            if (shouldRegisterReachabilityHandler) {
                this.analysisAccess.registerSubtypeReachabilityHandler((access, subType) -> this.universe.getBigbang().postTask(debug -> this.checkSubtypeForOverridingMethods(this.metaAccess.lookupJavaType(subType), this.registeredMethods.get(declaringType).keySet())), declaringClass);
            } else {
                for (AnalysisType subtype : AnalysisUniverse.reachableSubtypes((AnalysisType)declaringType)) {
                    this.universe.getBigbang().postTask(debug -> this.checkSubtypeForOverridingMethods(subtype, Collections.singleton(analysisMethod)));
                }
            }
            if (declaringType.isAnnotation() && !analysisMethod.isConstructor()) {
                this.processAnnotationMethod(queriedOnly, (Method)reflectExecutable);
            }
            if (!MissingRegistrationUtils.throwMissingRegistrationErrors() && declaringClass.isRecord()) {
                this.pendingRecordClasses.computeIfPresent(declaringClass, (clazz, unregisteredAccessors) -> {
                    if (unregisteredAccessors.remove(reflectExecutable) && unregisteredAccessors.isEmpty()) {
                        this.registerRecordComponents(declaringClass);
                    }
                    return unregisteredAccessors;
                });
            }
        }
        if (!queriedOnly) {
            this.methodAccessors.computeIfAbsent(analysisMethod, aMethod -> {
                SubstrateAccessor accessor = ((ReflectionFeature)ImageSingletons.lookup(ReflectionFeature.class)).getOrCreateAccessor(reflectExecutable);
                this.universe.getHeapScanner().rescanObject((Object)accessor);
                return accessor;
            });
        }
    }

    public void registerMethodLookup(ConfigurationCondition condition, Class<?> declaringClass, String methodName, Class<?> ... parameterTypes) {
        ReflectionDataBuilder.guaranteeNotRuntimeConditionForQueries(condition, true);
        this.runConditionalInAnalysisTask(condition, cnd -> {
            try {
                this.registerMethod((ConfigurationCondition)cnd, true, declaringClass.getDeclaredMethod(methodName, parameterTypes));
            }
            catch (NoSuchMethodException e) {
                this.negativeMethodLookups.computeIfAbsent(this.metaAccess.lookupJavaType(declaringClass), key -> ConcurrentHashMap.newKeySet()).add(new AnalysisMethod.Signature(methodName, this.metaAccess.lookupJavaTypes(parameterTypes)));
            }
        });
    }

    public void registerConstructorLookup(ConfigurationCondition condition, Class<?> declaringClass, Class<?> ... parameterTypes) {
        ReflectionDataBuilder.guaranteeNotRuntimeConditionForQueries(condition, true);
        this.runConditionalInAnalysisTask(condition, cnd -> {
            try {
                this.registerMethod((ConfigurationCondition)cnd, true, declaringClass.getDeclaredConstructor(parameterTypes));
            }
            catch (NoSuchMethodException e) {
                this.negativeConstructorLookups.computeIfAbsent(this.metaAccess.lookupJavaType(declaringClass), key -> ConcurrentHashMap.newKeySet()).add(this.metaAccess.lookupJavaTypes(parameterTypes));
            }
        });
    }

    public void register(ConfigurationCondition condition, boolean finalIsWritable, Field ... fields) {
        ReflectionDataBuilder.requireNonNull(fields, "field");
        this.runConditionalInAnalysisTask(condition, cnd -> this.registerFields((ConfigurationCondition)cnd, false, fields));
    }

    public void registerAllFieldsQuery(ConfigurationCondition condition, Class<?> clazz) {
        this.registerAllFieldsQuery(condition, false, clazz);
    }

    public void registerAllFieldsQuery(ConfigurationCondition condition, boolean queriedOnly, Class<?> clazz) {
        ReflectionDataBuilder.guaranteeNotRuntimeConditionForQueries(condition, queriedOnly);
        this.runConditionalInAnalysisTask(condition, cnd -> {
            for (Class current = clazz; current != null; current = current.getSuperclass()) {
                this.setQueryFlag(current, 65536);
            }
            try {
                this.registerFields((ConfigurationCondition)cnd, queriedOnly, clazz.getFields());
            }
            catch (LinkageError e) {
                this.registerLinkageError(clazz, e, this.fieldLookupExceptions);
            }
        });
    }

    public void registerAllDeclaredFieldsQuery(ConfigurationCondition condition, Class<?> clazz) {
        this.registerAllDeclaredFieldsQuery(condition, false, clazz);
    }

    public void registerAllDeclaredFieldsQuery(ConfigurationCondition condition, boolean queriedOnly, Class<?> clazz) {
        this.runConditionalInAnalysisTask(condition, cnd -> {
            this.setQueryFlag(clazz, 131072);
            try {
                this.registerFields((ConfigurationCondition)cnd, queriedOnly, clazz.getDeclaredFields());
            }
            catch (LinkageError e) {
                this.registerLinkageError(clazz, e, this.fieldLookupExceptions);
            }
        });
    }

    private void registerFields(ConfigurationCondition cnd, boolean queriedOnly, Field[] reflectFields) {
        for (Field reflectField : reflectFields) {
            this.registerField(cnd, queriedOnly, reflectField);
        }
    }

    private void registerField(ConfigurationCondition cnd, boolean queriedOnly, Field reflectField) {
        if (SubstitutionReflectivityFilter.shouldExclude(reflectField, this.metaAccess, this.universe)) {
            return;
        }
        AnalysisField analysisField = this.metaAccess.lookupJavaField(reflectField);
        AnalysisType declaringClass = analysisField.getDeclaringClass();
        Map classFields = this.registeredFields.computeIfAbsent(declaringClass, t -> new ConcurrentHashMap());
        boolean exists = classFields.containsKey(analysisField);
        boolean shouldRegisterReachabilityHandler = classFields.isEmpty();
        ConditionalRuntimeValue cndValue = classFields.computeIfAbsent(analysisField, f -> new ConditionalRuntimeValue<Field>(RuntimeConditionSet.emptySet(), reflectField));
        if (!queriedOnly) {
            cndValue.getConditions().addCondition(cnd);
        }
        if (!exists) {
            this.registerTypesForField(analysisField, reflectField, true);
            if (shouldRegisterReachabilityHandler) {
                this.analysisAccess.registerSubtypeReachabilityHandler((access, subType) -> this.universe.getBigbang().postTask(debug -> this.checkSubtypeForOverridingFields(this.metaAccess.lookupJavaType(subType), this.registeredFields.get(declaringClass).keySet())), declaringClass.getJavaClass());
            } else {
                for (AnalysisType subtype : AnalysisUniverse.reachableSubtypes((AnalysisType)declaringClass)) {
                    this.universe.getBigbang().postTask(debug -> this.checkSubtypeForOverridingFields(subtype, Collections.singleton(analysisField)));
                }
            }
            if (declaringClass.isAnnotation()) {
                this.processAnnotationField(cnd, reflectField);
            }
        }
        if (!queriedOnly) {
            this.registerTypesForField(analysisField, reflectField, false);
        }
    }

    public void registerFieldLookup(ConfigurationCondition condition, Class<?> declaringClass, String fieldName) {
        this.runConditionalInAnalysisTask(condition, cnd -> {
            try {
                this.registerField((ConfigurationCondition)cnd, false, declaringClass.getDeclaredField(fieldName));
            }
            catch (NoSuchFieldException e) {
                this.negativeFieldLookups.computeIfAbsent(this.metaAccess.lookupJavaType(declaringClass), key -> ConcurrentHashMap.newKeySet()).add(fieldName);
            }
        });
    }

    private void processAnnotationMethod(boolean queriedOnly, Method method) {
        Class<?> annotationClass = method.getDeclaringClass();
        Class<?> proxyClass = Proxy.getProxyClass(annotationClass.getClassLoader(), annotationClass);
        try {
            ConfigurationCondition condition = ConfigurationCondition.create(proxyClass, (boolean)false);
            this.register(condition, queriedOnly, proxyClass.getDeclaredMethod(method.getName(), method.getParameterTypes()));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    private void processAnnotationField(ConfigurationCondition cnd, Field field) {
        Class<?> annotationClass = field.getDeclaringClass();
        Class<?> proxyClass = Proxy.getProxyClass(annotationClass.getClassLoader(), annotationClass);
        try {
            this.register(cnd, false, proxyClass.getDeclaredField(field.getName()));
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
    }

    private void checkSubtypeForOverridingFields(AnalysisType subtype, Collection<AnalysisField> superclassFields) {
        if (this.isQueryFlagSet(subtype.getJavaClass(), 131072)) {
            return;
        }
        try {
            HashSet<ResolvedJavaField> subClassFields = new HashSet<ResolvedJavaField>();
            subClassFields.addAll(Arrays.asList(subtype.getInstanceFields(false)));
            subClassFields.addAll(Arrays.asList(subtype.getStaticFields()));
            for (ResolvedJavaField javaField : subClassFields) {
                for (AnalysisField registeredField : superclassFields) {
                    AnalysisField subclassField = (AnalysisField)javaField;
                    if (!subclassField.getName().equals(registeredField.getName())) continue;
                    this.hidingFields.add(subclassField);
                    subclassField.getType().registerAsReachable((Object)"Is the declared type of a hiding Field used by reflection");
                }
            }
        }
        catch (UnsupportedFeatureException | LinkageError throwable) {
            // empty catch block
        }
    }

    private void checkSubtypeForOverridingMethods(AnalysisType subtype, Collection<AnalysisMethod> superclassMethods) {
        if (this.isQueryFlagSet(subtype.getJavaClass(), 524288)) {
            return;
        }
        try {
            for (AnalysisMethod subClassMethod : subtype.getDeclaredMethods(false)) {
                for (AnalysisMethod registeredMethod : superclassMethods) {
                    if (!registeredMethod.getName().equals(subClassMethod.getName()) || !registeredMethod.getSignature().equals((Object)subClassMethod.getSignature())) continue;
                    this.hidingMethods.add(subClassMethod);
                }
            }
        }
        catch (UnsupportedFeatureException | LinkageError throwable) {
            // empty catch block
        }
    }

    private void registerTypesForClass(AnalysisType analysisType, Class<?> clazz) {
        this.registerTypesForGenericSignature(ReflectionDataBuilder.queryGenericInfo(clazz::getTypeParameters));
        this.registerTypesForGenericSignature(ReflectionDataBuilder.queryGenericInfo(clazz::getGenericSuperclass));
        this.registerTypesForGenericSignature(ReflectionDataBuilder.queryGenericInfo(clazz::getGenericInterfaces));
        this.registerTypesForEnclosingMethodInfo(clazz);
        if (!MissingRegistrationUtils.throwMissingRegistrationErrors()) {
            this.maybeRegisterRecordComponents(clazz);
        }
        this.registerTypesForAnnotations((AnnotatedElement)analysisType);
        this.registerTypesForTypeAnnotations((AnnotatedElement)analysisType);
    }

    private void registerRecordComponents(Class<?> clazz) {
        RecordComponent[] recordComponents = clazz.getRecordComponents();
        if (recordComponents == null) {
            return;
        }
        for (RecordComponent recordComponent : recordComponents) {
            this.registerTypesForRecordComponent(recordComponent);
        }
        this.registeredRecordComponents.put(clazz, recordComponents);
    }

    private void registerTypesForEnclosingMethodInfo(Class<?> clazz) {
        Executable enclosingMethodOrConstructor;
        Object[] enclosingMethodInfo = this.getEnclosingMethodInfo(clazz);
        if (enclosingMethodInfo == null) {
            return;
        }
        this.metaAccess.lookupJavaType((Class)enclosingMethodInfo[0]).registerAsReachable((Object)"Is used by the enclosing method info of an element registered for reflection.");
        try {
            enclosingMethodOrConstructor = Optional.ofNullable(clazz.getEnclosingMethod()).orElse((Method)((Object)clazz.getEnclosingConstructor()));
        }
        catch (InternalError | LinkageError | TypeNotPresentException e) {
            return;
        }
        if (enclosingMethodOrConstructor != null) {
            RuntimeReflection.registerAsQueried((Executable[])new Executable[]{enclosingMethodOrConstructor});
        }
    }

    private Object[] getEnclosingMethodInfo(Class<?> clazz) {
        try {
            return (Object[])this.getEnclosingMethod0.invoke(clazz, new Object[0]);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof LinkageError) {
                return null;
            }
            throw VMError.shouldNotReachHere(e);
        }
        catch (IllegalAccessException e) {
            throw VMError.shouldNotReachHere(e);
        }
    }

    private void registerTypesForField(AnalysisField analysisField, Field reflectField, boolean queriedOnly) {
        if (!queriedOnly) {
            analysisField.registerAsUnsafeAccessed((Object)"is registered for reflection.");
        }
        this.metaAccess.lookupJavaType(reflectField.getType()).registerAsReachable((Object)"Is present in a Field object reconstructed by reflection");
        this.registerTypesForGenericSignature(ReflectionDataBuilder.queryGenericInfo(reflectField::getGenericType));
        this.registerTypesForAnnotations((AnnotatedElement)analysisField);
        this.registerTypesForTypeAnnotations((AnnotatedElement)analysisField);
    }

    private void registerTypesForMethod(AnalysisMethod analysisMethod, Executable reflectExecutable) {
        Arrays.stream(reflectExecutable.getParameterTypes()).forEach(clazz -> this.metaAccess.lookupJavaType(clazz).registerAsReachable((Object)"Is present in an Executable object reconstructed by reflection"));
        Arrays.stream(reflectExecutable.getExceptionTypes()).forEach(clazz -> this.metaAccess.lookupJavaType(clazz).registerAsReachable((Object)"Is present in an Executable object reconstructed by reflection"));
        if (reflectExecutable instanceof Method) {
            Method method = (Method)reflectExecutable;
            this.metaAccess.lookupJavaType(method.getReturnType()).registerAsReachable((Object)"Is present in a Method object reconstructed by reflection");
        }
        this.registerTypesForGenericSignature(ReflectionDataBuilder.queryGenericInfo(reflectExecutable::getTypeParameters));
        this.registerTypesForGenericSignature(ReflectionDataBuilder.queryGenericInfo(reflectExecutable::getGenericParameterTypes));
        this.registerTypesForGenericSignature(ReflectionDataBuilder.queryGenericInfo(reflectExecutable::getGenericExceptionTypes));
        if (!analysisMethod.isConstructor()) {
            this.registerTypesForGenericSignature(ReflectionDataBuilder.queryGenericInfo(((Method)reflectExecutable)::getGenericReturnType));
        }
        this.registerTypesForAnnotations((AnnotatedElement)analysisMethod);
        this.registerTypesForParameterAnnotations(analysisMethod);
        this.registerTypesForTypeAnnotations((AnnotatedElement)analysisMethod);
        if (!analysisMethod.isConstructor()) {
            this.registerTypesForAnnotationDefault(analysisMethod);
        }
    }

    private void registerTypesForGenericSignature(Type[] types) {
        this.registerTypesForGenericSignature(types, 0);
    }

    private void registerTypesForGenericSignature(Type[] types, int dimension) {
        if (types != null) {
            for (Type type : types) {
                this.registerTypesForGenericSignature(type, dimension);
            }
        }
    }

    private void registerTypesForGenericSignature(Type type) {
        this.registerTypesForGenericSignature(type, 0);
    }

    private void registerTypesForGenericSignature(Type type, int dimension) {
        try {
            if (type == null || !this.processedTypes.computeIfAbsent(type, t -> ConcurrentHashMap.newKeySet()).add(dimension)) {
                return;
            }
        }
        catch (LinkageError | TypeNotPresentException | MalformedParameterizedTypeException throwable) {
            // empty catch block
        }
        if (type instanceof Class) {
            Class clazz = (Class)type;
            if (this.shouldExcludeClass(clazz)) {
                return;
            }
            if (dimension > 0) {
                this.metaAccess.lookupJavaType(clazz).getArrayClass(dimension).registerAsReachable((Object)"Is used by generic signature of element registered for reflection.");
            }
            this.classForNameSupport.registerClass(clazz);
        } else if (type instanceof TypeVariable) {
            this.registerTypesForGenericSignature(ReflectionDataBuilder.queryGenericInfo(((TypeVariable)type)::getBounds), dimension);
        } else if (type instanceof GenericArrayType) {
            this.registerTypesForGenericSignature(ReflectionDataBuilder.queryGenericInfo(((GenericArrayType)type)::getGenericComponentType), dimension + 1);
        } else if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            this.registerTypesForGenericSignature(ReflectionDataBuilder.queryGenericInfo(parameterizedType::getActualTypeArguments));
            this.registerTypesForGenericSignature(ReflectionDataBuilder.queryGenericInfo(parameterizedType::getRawType), dimension);
            this.registerTypesForGenericSignature(ReflectionDataBuilder.queryGenericInfo(parameterizedType::getOwnerType));
        } else if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            this.registerTypesForGenericSignature(ReflectionDataBuilder.queryGenericInfo(wildcardType::getLowerBounds), dimension);
            this.registerTypesForGenericSignature(ReflectionDataBuilder.queryGenericInfo(wildcardType::getUpperBounds), dimension);
        }
    }

    private void registerTypesForRecordComponent(RecordComponent recordComponent) {
        Method accessorOrNull = recordComponent.getAccessor();
        if (accessorOrNull != null) {
            this.register(ConfigurationCondition.alwaysTrue(), true, accessorOrNull);
        }
        this.registerTypesForAnnotations(recordComponent);
        this.registerTypesForTypeAnnotations(recordComponent);
    }

    private void registerTypesForAnnotations(AnnotatedElement annotatedElement) {
        if (annotatedElement != null && !this.filteredAnnotations.containsKey(annotatedElement)) {
            ArrayList<AnnotationValue> includedAnnotations = new ArrayList<AnnotationValue>();
            for (AnnotationValue annotation : this.annotationExtractor.getDeclaredAnnotationData(annotatedElement)) {
                if (!this.includeAnnotation(annotation)) continue;
                includedAnnotations.add(annotation);
                this.registerTypesForAnnotation(annotation);
            }
            this.filteredAnnotations.put(annotatedElement, includedAnnotations.toArray(new AnnotationValue[0]));
        }
    }

    private void registerTypesForParameterAnnotations(AnalysisMethod method) {
        if (method != null && !this.filteredParameterAnnotations.containsKey(method)) {
            AnnotationValue[][] parameterAnnotations = this.annotationExtractor.getParameterAnnotationData((AnnotatedElement)method);
            AnnotationValue[][] includedParameterAnnotations = new AnnotationValue[parameterAnnotations.length][];
            for (int i = 0; i < includedParameterAnnotations.length; ++i) {
                AnnotationValue[] annotations = parameterAnnotations[i];
                ArrayList<AnnotationValue> includedAnnotations = new ArrayList<AnnotationValue>();
                for (AnnotationValue annotation : annotations) {
                    if (!this.includeAnnotation(annotation)) continue;
                    includedAnnotations.add(annotation);
                    this.registerTypesForAnnotation(annotation);
                }
                includedParameterAnnotations[i] = includedAnnotations.toArray(new AnnotationValue[0]);
            }
            this.filteredParameterAnnotations.put(method, includedParameterAnnotations);
        }
    }

    private void registerTypesForTypeAnnotations(AnnotatedElement annotatedElement) {
        if (annotatedElement != null && !this.filteredTypeAnnotations.containsKey(annotatedElement)) {
            ArrayList<TypeAnnotationValue> includedTypeAnnotations = new ArrayList<TypeAnnotationValue>();
            for (TypeAnnotationValue typeAnnotation : this.annotationExtractor.getTypeAnnotationData(annotatedElement)) {
                if (!this.includeAnnotation(typeAnnotation.getAnnotationData())) continue;
                includedTypeAnnotations.add(typeAnnotation);
                this.registerTypesForAnnotation(typeAnnotation.getAnnotationData());
            }
            this.filteredTypeAnnotations.put(annotatedElement, includedTypeAnnotations.toArray(new TypeAnnotationValue[0]));
        }
    }

    private void registerTypesForAnnotationDefault(AnalysisMethod method) {
        AnnotationMemberValue annotationDefault = this.annotationExtractor.getAnnotationDefaultData((AnnotatedElement)method);
        if (annotationDefault != null) {
            this.registerTypes(annotationDefault.getTypes());
        }
    }

    private boolean includeAnnotation(AnnotationValue annotationValue) {
        if (annotationValue == null) {
            return false;
        }
        for (Class<?> type : annotationValue.getTypes()) {
            if (type != null && !SubstitutionReflectivityFilter.shouldExclude(type, this.metaAccess, this.universe)) continue;
            return false;
        }
        return true;
    }

    private void registerTypesForAnnotation(AnnotationValue annotationValue) {
        this.registerTypes(annotationValue.getTypes());
    }

    private void registerTypes(Collection<Class<?>> types) {
        for (Class<?> type : types) {
            AnalysisType analysisType = this.metaAccess.lookupJavaType(type);
            analysisType.registerAsReachable((Object)"Is used by annotation of element registered for reflection.");
            if (type.isAnnotation()) {
                RuntimeProxyCreation.register((Class[])new Class[]{type});
                RuntimeReflection.registerAllDeclaredMethods(type);
            }
            if (!ExceptionProxy.class.isAssignableFrom(type)) continue;
            analysisType.registerAsInstantiated((Object)"Is used by annotation of element registered for reflection.");
            for (ResolvedJavaField f : analysisType.getInstanceFields(true)) {
                AnalysisField aField = (AnalysisField)f;
                this.universe.getBigbang().injectFieldTypes(aField, List.of(aField.getType()), true);
            }
        }
    }

    private boolean shouldExcludeClass(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            return true;
        }
        return SubstitutionReflectivityFilter.shouldExclude(clazz, this.metaAccess, this.universe);
    }

    private static <T> T queryGenericInfo(Callable<T> callable) {
        try {
            return callable.call();
        }
        catch (LinkageError | TypeNotPresentException | MalformedParameterizedTypeException e) {
            return null;
        }
        catch (Throwable t) {
            throw VMError.shouldNotReachHere(t);
        }
    }

    private void maybeRegisterRecordComponents(Class<?> clazz) {
        if (!clazz.isRecord()) {
            return;
        }
        Method[] accessors = RecordUtils.getRecordComponentAccessorMethods(clazz);
        ConcurrentHashMap.KeySetView unregisteredAccessors = ConcurrentHashMap.newKeySet();
        for (Method accessor2 : accessors) {
            if (SubstitutionReflectivityFilter.shouldExclude(accessor2, this.metaAccess, this.universe)) {
                return;
            }
            unregisteredAccessors.add(accessor2);
        }
        this.pendingRecordClasses.put(clazz, unregisteredAccessors);
        AnalysisType analysisType = this.metaAccess.lookupJavaType(clazz);
        unregisteredAccessors.removeIf(accessor -> this.registeredMethods.getOrDefault(analysisType, Collections.emptyMap()).containsKey(this.metaAccess.lookupJavaMethod((Executable)accessor)));
        if (unregisteredAccessors.isEmpty()) {
            this.registerRecordComponents(clazz);
        }
    }

    private void registerLinkageError(Class<?> clazz, LinkageError error, Map<Class<?>, Throwable> errorMap) {
        if (LinkAtBuildTimeSupport.singleton().linkAtBuildTime(clazz)) {
            throw error;
        }
        Throwable registeredError = errorMap.computeIfAbsent(clazz, k -> {
            this.universe.getHeapScanner().rescanObject((Object)error);
            return error;
        });
        assert (registeredError.toString().equals(error.toString())) : "Attempting to replace " + String.valueOf(registeredError) + " with " + String.valueOf(error);
    }

    private static void reportLinkingErrors(Class<?> clazz, List<Throwable> errors) {
        if (errors.isEmpty()) {
            return;
        }
        String messages = errors.stream().map(e -> e.getClass().getTypeName() + ": " + e.getMessage()).distinct().collect(Collectors.joining(", "));
        LogUtils.warning((String)"Could not register complete reflection metadata for %s. Reason(s): %s.", (Object[])new Object[]{clazz.getTypeName(), messages});
    }

    protected void afterAnalysis() {
        this.sealed = true;
        this.processedTypes.clear();
        if (!MissingRegistrationUtils.throwMissingRegistrationErrors()) {
            this.pendingRecordClasses.clear();
        }
    }

    @Override
    public Map<Class<?>, Set<Class<?>>> getReflectionInnerClasses() {
        assert (this.sealed);
        return Collections.unmodifiableMap(this.innerClasses);
    }

    public int getEnabledReflectionQueries(Class<?> clazz) {
        int enabledQueries = this.enabledQueriesFlags.getOrDefault(clazz, 0);
        if (clazz == Object.class || clazz.isPrimitive() || clazz.isArray()) {
            enabledQueries |= 0xFF0000;
        }
        return enabledQueries;
    }

    @Override
    public Map<AnalysisType, Map<AnalysisField, ConditionalRuntimeValue<Field>>> getReflectionFields() {
        assert (this.sealed);
        return Collections.unmodifiableMap(this.registeredFields);
    }

    @Override
    public Map<AnalysisType, Map<AnalysisMethod, ConditionalRuntimeValue<Executable>>> getReflectionExecutables() {
        assert (this.sealed);
        return Collections.unmodifiableMap(this.registeredMethods);
    }

    @Override
    public Object getAccessor(AnalysisMethod method) {
        assert (this.sealed);
        return this.methodAccessors.get(method);
    }

    public Set<ResolvedJavaField> getHidingReflectionFields() {
        assert (this.sealed);
        return Collections.unmodifiableSet(this.hidingFields);
    }

    public Set<ResolvedJavaMethod> getHidingReflectionMethods() {
        assert (this.sealed);
        return Collections.unmodifiableSet(this.hidingMethods);
    }

    @Override
    public RecordComponent[] getRecordComponents(Class<?> type) {
        assert (this.sealed);
        return this.registeredRecordComponents.get(type);
    }

    @Override
    public void registerHeapDynamicHub(Object object, ObjectScanner.ScanReason reason) {
        DynamicHub hub = (DynamicHub)object;
        Class<?> javaClass = hub.getHostedJavaClass();
        if (this.heapDynamicHubs.add(hub)) {
            if (this.sealed) {
                throw new UnsupportedFeatureException("Registering new class for reflection when the image heap is already sealed: " + String.valueOf(javaClass));
            }
            if (!SubstitutionReflectivityFilter.shouldExclude(javaClass, this.metaAccess, this.universe)) {
                this.registerTypesForClass(this.metaAccess.lookupJavaType(javaClass), javaClass);
            }
        }
    }

    public Set<DynamicHub> getHeapDynamicHubs() {
        assert (this.sealed);
        return Collections.unmodifiableSet(this.heapDynamicHubs);
    }

    @Override
    public void registerHeapReflectionField(Field reflectField, ObjectScanner.ScanReason reason) {
        AnalysisField analysisField = this.metaAccess.lookupJavaField(reflectField);
        if (this.heapFields.put(analysisField, reflectField) == null) {
            if (this.sealed) {
                throw new UnsupportedFeatureException("Registering new field for reflection when the image heap is already sealed: " + String.valueOf(reflectField));
            }
            if (!SubstitutionReflectivityFilter.shouldExclude(reflectField, this.metaAccess, this.universe)) {
                this.registerTypesForField(analysisField, reflectField, false);
                if (analysisField.getDeclaringClass().isAnnotation()) {
                    this.processAnnotationField(ConfigurationCondition.alwaysTrue(), reflectField);
                }
            }
        }
    }

    @Override
    public void registerHeapReflectionExecutable(Executable reflectExecutable, ObjectScanner.ScanReason reason) {
        AnalysisMethod analysisMethod = this.metaAccess.lookupJavaMethod(reflectExecutable);
        if (this.heapMethods.put(analysisMethod, reflectExecutable) == null) {
            if (this.sealed) {
                throw new UnsupportedFeatureException("Registering new method for reflection when the image heap is already sealed: " + String.valueOf(reflectExecutable));
            }
            if (!SubstitutionReflectivityFilter.shouldExclude(reflectExecutable, this.metaAccess, this.universe)) {
                this.registerTypesForMethod(analysisMethod, reflectExecutable);
                if (reflectExecutable instanceof Method && reflectExecutable.getDeclaringClass().isAnnotation()) {
                    this.processAnnotationMethod(false, (Method)reflectExecutable);
                }
            }
        }
    }

    @Override
    public Map<AnalysisField, Field> getHeapReflectionFields() {
        assert (this.sealed);
        return Collections.unmodifiableMap(this.heapFields);
    }

    @Override
    public Map<AnalysisMethod, Executable> getHeapReflectionExecutables() {
        assert (this.sealed);
        return Collections.unmodifiableMap(this.heapMethods);
    }

    @Override
    public Map<AnalysisType, Set<String>> getNegativeFieldQueries() {
        return Collections.unmodifiableMap(this.negativeFieldLookups);
    }

    @Override
    public Map<AnalysisType, Set<AnalysisMethod.Signature>> getNegativeMethodQueries() {
        return Collections.unmodifiableMap(this.negativeMethodLookups);
    }

    @Override
    public Map<AnalysisType, Set<AnalysisType[]>> getNegativeConstructorQueries() {
        return Collections.unmodifiableMap(this.negativeConstructorLookups);
    }

    @Override
    public Map<Class<?>, Throwable> getClassLookupErrors() {
        return Collections.unmodifiableMap(this.classLookupExceptions);
    }

    @Override
    public Map<Class<?>, Throwable> getFieldLookupErrors() {
        return Collections.unmodifiableMap(this.fieldLookupExceptions);
    }

    @Override
    public Map<Class<?>, Throwable> getMethodLookupErrors() {
        return Collections.unmodifiableMap(this.methodLookupExceptions);
    }

    @Override
    public Map<Class<?>, Throwable> getConstructorLookupErrors() {
        return Collections.unmodifiableMap(this.constructorLookupExceptions);
    }

    public AnnotationValue[] getAnnotationData(AnnotatedElement element) {
        assert (this.sealed);
        return this.filteredAnnotations.getOrDefault(element, NO_ANNOTATIONS);
    }

    public AnnotationValue[][] getParameterAnnotationData(AnalysisMethod element) {
        assert (this.sealed);
        return this.filteredParameterAnnotations.getOrDefault(element, NO_PARAMETER_ANNOTATIONS);
    }

    public TypeAnnotationValue[] getTypeAnnotationData(AnnotatedElement element) {
        assert (this.sealed);
        return this.filteredTypeAnnotations.getOrDefault(element, NO_TYPE_ANNOTATIONS);
    }

    public AnnotationMemberValue getAnnotationDefaultData(AnnotatedElement element) {
        return this.annotationExtractor.getAnnotationDefaultData(element);
    }

    @Override
    public int getReflectionMethodsCount() {
        return this.registeredMethods.size();
    }

    @Override
    public int getReflectionFieldsCount() {
        return this.registeredFields.size();
    }

    private static void requireNonNull(Object[] values, String kind) {
        for (Object value : values) {
            Objects.requireNonNull(value, () -> ReflectionDataBuilder.nullErrorMessage(kind));
        }
    }

    private static String nullErrorMessage(String kind) {
        return "Cannot register null value as " + kind + " for reflection. Please ensure that all values you register are not null.";
    }

    record ConditionalTask(ConfigurationCondition condition, Consumer<ConfigurationCondition> task) {
    }

    public static class TestBackdoor {
        public static void registerField(ReflectionDataBuilder reflectionDataBuilder, boolean queriedOnly, Field field) {
            reflectionDataBuilder.runConditionalInAnalysisTask(ConfigurationCondition.alwaysTrue(), cnd -> reflectionDataBuilder.registerField((ConfigurationCondition)cnd, queriedOnly, field));
        }
    }
}

