/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.phases;

import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.phases.ReduceImplicitExceptionStackTraceInformationPhase;
import java.util.ListIterator;
import jdk.graal.compiler.phases.common.FinalCanonicalizerPhase;
import jdk.graal.compiler.phases.tiers.Suites;
import jdk.graal.compiler.phases.util.Providers;

@AutomaticallyRegisteredFeature
class ReduceImplicitExceptionStackTraceInformationFeature
implements InternalFeature {
    ReduceImplicitExceptionStackTraceInformationFeature() {
    }

    @Override
    public void registerGraalPhases(Providers providers, Suites suites, boolean hosted) {
        if (hosted && SubstrateOptions.ReduceImplicitExceptionStackTraceInformation.getValue().booleanValue()) {
            ListIterator finalCanonicalizer = suites.getLowTier().findPhase(FinalCanonicalizerPhase.class);
            if (finalCanonicalizer == null) {
                throw VMError.shouldNotReachHere("In a reduced phase plan without a final canonicalization, the " + SubstrateOptions.ReduceImplicitExceptionStackTraceInformation.getName() + " option must be disabled.");
            }
            finalCanonicalizer.previous();
            finalCanonicalizer.add(new ReduceImplicitExceptionStackTraceInformationPhase());
        }
    }
}

