/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.jni;

import com.oracle.graal.pointsto.infrastructure.SubstitutionProcessor;
import com.oracle.svm.core.jni.JNIJavaCallTrampolineHolder;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.jni.JNIAccessFeature;
import com.oracle.svm.hosted.jni.JNINativeCallWrapperMethod;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;

class JNINativeCallWrapperSubstitutionProcessor
extends SubstitutionProcessor {
    private final MetaAccessProvider originalMetaAccess;
    private final ResolvedJavaType trampolinesType;
    private final Map<ResolvedJavaMethod, JNINativeCallWrapperMethod> callWrappers = new ConcurrentHashMap<ResolvedJavaMethod, JNINativeCallWrapperMethod>();

    JNINativeCallWrapperSubstitutionProcessor(FeatureImpl.DuringSetupAccessImpl access) {
        this.originalMetaAccess = access.getMetaAccess().getWrapped();
        this.trampolinesType = this.originalMetaAccess.lookupJavaType(JNIJavaCallTrampolineHolder.class);
    }

    public ResolvedJavaMethod lookup(ResolvedJavaMethod method) {
        assert (method.isNative()) : "Must have been registered as a native substitution processor";
        if (method instanceof JNINativeCallWrapperMethod) {
            return method;
        }
        if (method.getDeclaringClass().equals((Object)this.trampolinesType)) {
            return JNIAccessFeature.singleton().getOrCreateCallTrampolineMethod(this.originalMetaAccess, method.getName());
        }
        return this.callWrappers.computeIfAbsent(method, JNINativeCallWrapperMethod::new);
    }
}

