/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.jni;

import com.oracle.graal.pointsto.infrastructure.ResolvedSignature;
import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.svm.core.c.function.CEntryPointSetup;
import com.oracle.svm.core.jni.JNIGeneratedMethodSupport;
import com.oracle.svm.core.jni.access.JNIAccessibleMethod;
import com.oracle.svm.core.jni.access.JNIReflectionDictionary;
import com.oracle.svm.core.jni.functions.JNIFunctions;
import com.oracle.svm.core.jni.headers.JNIMethodId;
import com.oracle.svm.hosted.phases.HostedGraphKit;
import jdk.graal.compiler.core.common.type.ObjectStamp;
import jdk.graal.compiler.core.common.type.Stamp;
import jdk.graal.compiler.core.common.type.StampFactory;
import jdk.graal.compiler.core.common.type.TypeReference;
import jdk.graal.compiler.debug.DebugContext;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.CallTargetNode;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.InvokeWithExceptionNode;
import jdk.graal.compiler.nodes.LogicNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.PiNode;
import jdk.graal.compiler.nodes.StructuredGraph;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.calc.ConditionalNode;
import jdk.graal.compiler.nodes.calc.FloatingNode;
import jdk.graal.compiler.nodes.calc.IntegerEqualsNode;
import jdk.graal.compiler.nodes.calc.NarrowNode;
import jdk.graal.compiler.nodes.calc.SignExtendNode;
import jdk.graal.compiler.nodes.calc.ZeroExtendNode;
import jdk.graal.compiler.nodes.extended.BytecodeExceptionNode;
import jdk.graal.compiler.nodes.extended.GuardingNode;
import jdk.graal.compiler.nodes.java.InstanceOfNode;
import jdk.graal.compiler.util.Digest;
import jdk.vm.ci.meta.Assumptions;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;

public class JNIGraphKit
extends HostedGraphKit {
    JNIGraphKit(DebugContext debug, HostedProviders providers, ResolvedJavaMethod method) {
        super(debug, providers, method);
    }

    public static String signatureToIdentifier(ResolvedSignature<?> signature) {
        StringBuilder sb = new StringBuilder();
        boolean digest = false;
        for (ResolvedJavaType type : signature.toParameterList(null)) {
            if (type.getJavaKind().isPrimitive() || type.isJavaLangObject()) {
                sb.append(type.getJavaKind().getTypeChar());
                continue;
            }
            sb.append(type.toClassName());
            digest = true;
        }
        sb.append('_').append(signature.getReturnType().getJavaKind().getTypeChar());
        return digest ? Digest.digest((String)sb.toString()) : sb.toString();
    }

    public ValueNode checkObjectType(ValueNode uncheckedValue, ResolvedJavaType type, boolean checkNonNull) {
        ValueNode value = uncheckedValue;
        if (checkNonNull) {
            value = this.maybeCreateExplicitNullCheck(value);
        }
        if (type.isJavaLangObject()) {
            return value;
        }
        TypeReference typeRef = TypeReference.createTrusted((Assumptions)this.getAssumptions(), (ResolvedJavaType)type);
        LogicNode isInstance = InstanceOfNode.createAllowNull((TypeReference)typeRef, (ValueNode)value, null, null);
        if (!isInstance.isTautology()) {
            this.append((Node)isInstance);
            ConstantNode expectedType = this.createConstant((Constant)this.getConstantReflection().asJavaClass(type), JavaKind.Object);
            GuardingNode guard = this.createCheckThrowingBytecodeException(isInstance, false, BytecodeExceptionNode.BytecodeExceptionKind.CLASS_CAST, new ValueNode[]{value, expectedType});
            Stamp checkedStamp = value.stamp(NodeView.DEFAULT).improveWith((Stamp)StampFactory.object((TypeReference)typeRef));
            value = this.unique((FloatingNode)new PiNode(value, checkedStamp, guard.asNode()));
        }
        return value;
    }

    public ValueNode maskNumericIntBytes(ValueNode value, JavaKind kind) {
        assert (kind.isNumericInteger());
        int bits = kind.getByteCount() * 8;
        ValueNode narrowed = (ValueNode)this.append((Node)NarrowNode.create((ValueNode)value, (int)bits, (NodeView)NodeView.DEFAULT));
        ValueNode widened = this.widenNumericInt(narrowed, kind);
        if (kind == JavaKind.Boolean) {
            LogicNode isZero = IntegerEqualsNode.create((ValueNode)widened, (ValueNode)ConstantNode.forIntegerKind((JavaKind)kind.getStackKind(), (long)0L), (NodeView)NodeView.DEFAULT);
            widened = (ValueNode)this.append((Node)ConditionalNode.create((LogicNode)isZero, (ValueNode)ConstantNode.forBoolean((boolean)false), (ValueNode)ConstantNode.forBoolean((boolean)true), (NodeView)NodeView.DEFAULT));
        }
        return widened;
    }

    public ValueNode widenNumericInt(ValueNode value, JavaKind kind) {
        assert (kind.isNumericInteger());
        int stackBits = kind.getStackKind().getBitCount();
        if (kind.isUnsigned()) {
            return (ValueNode)this.append((Node)ZeroExtendNode.create((ValueNode)value, (int)stackBits, (NodeView)NodeView.DEFAULT));
        }
        return (ValueNode)this.append((Node)SignExtendNode.create((ValueNode)value, (int)stackBits, (NodeView)NodeView.DEFAULT));
    }

    private InvokeWithExceptionNode createStaticInvoke(String name, ValueNode ... args) {
        return this.createInvokeWithExceptionAndUnwind(this.findMethod(JNIGeneratedMethodSupport.class, name, true), CallTargetNode.InvokeKind.Static, this.getFrameState(), this.bci(), args);
    }

    public InvokeWithExceptionNode invokeNativeCallAddress(ValueNode linkage) {
        return this.createStaticInvoke("nativeCallAddress", linkage);
    }

    public InvokeWithExceptionNode invokeNativeCallPrologue() {
        return this.createStaticInvoke("nativeCallPrologue", new ValueNode[0]);
    }

    public void invokeNativeCallEpilogue(ValueNode handleFrame) {
        this.createStaticInvoke("nativeCallEpilogue", handleFrame);
    }

    public InvokeWithExceptionNode invokeEnvironment() {
        return this.createStaticInvoke("environment", new ValueNode[0]);
    }

    public InvokeWithExceptionNode invokeBoxObjectInLocalHandle(ValueNode obj) {
        return this.createStaticInvoke("boxObjectInLocalHandle", obj);
    }

    public InvokeWithExceptionNode invokeUnboxHandle(ValueNode handle) {
        return this.createStaticInvoke("unboxHandle", handle);
    }

    public InvokeWithExceptionNode invokeGetNewObjectAddress(ValueNode methodId) {
        return this.invokeJNIMethodObjectMethod("getNewObjectAddress", methodId);
    }

    public ValueNode invokeGetDeclaringClassForMethod(ValueNode methodId) {
        InvokeWithExceptionNode declaringClass = this.invokeJNIMethodObjectMethod("getDeclaringClassObject", methodId);
        return this.createPiNode((ValueNode)declaringClass, ObjectStamp.pointerNonNull((Stamp)declaringClass.stamp(NodeView.DEFAULT)));
    }

    public InvokeWithExceptionNode invokeGetJavaCallAddress(ValueNode methodId, ValueNode instance, ValueNode nonVirtual) {
        return this.createInvokeWithExceptionAndUnwind(this.findMethod(JNIAccessibleMethod.class, "getJavaCallAddress", new Class[]{Object.class, Boolean.TYPE}), CallTargetNode.InvokeKind.Special, this.getFrameState(), this.bci(), new ValueNode[]{this.invokeGetUncheckedMethodObject(methodId), instance, nonVirtual});
    }

    public InvokeWithExceptionNode invokeGetJavaCallWrapperAddressFromMethodId(ValueNode methodId) {
        return this.invokeJNIMethodObjectMethod("getCallWrapperAddress", methodId);
    }

    public InvokeWithExceptionNode invokeIsStaticMethod(ValueNode methodId) {
        return this.invokeJNIMethodObjectMethod("isStatic", methodId);
    }

    private InvokeWithExceptionNode invokeGetUncheckedMethodObject(ValueNode methodId) {
        return this.createInvokeWithExceptionAndUnwind(this.findMethod(JNIReflectionDictionary.class, "getMethodByID", new Class[]{JNIMethodId.class}), CallTargetNode.InvokeKind.Static, this.getFrameState(), this.bci(), new ValueNode[]{methodId});
    }

    private InvokeWithExceptionNode invokeJNIMethodObjectMethod(String name, ValueNode methodId) {
        return this.createInvokeWithExceptionAndUnwind(this.findMethod(JNIAccessibleMethod.class, name, new Class[0]), CallTargetNode.InvokeKind.Special, this.getFrameState(), this.bci(), new ValueNode[]{this.invokeGetUncheckedMethodObject(methodId)});
    }

    public void invokeSetPendingException(ValueNode obj) {
        this.createStaticInvoke("setPendingException", obj);
    }

    public InvokeWithExceptionNode invokeGetAndClearPendingException() {
        return this.createStaticInvoke("getAndClearPendingException", new ValueNode[0]);
    }

    public void invokeRethrowPendingException() {
        this.createStaticInvoke("rethrowPendingException", new ValueNode[0]);
    }

    public void invokeJNIEnterIsolate(ValueNode env) {
        this.createInvokeWithExceptionAndUnwind(this.findMethod(JNIFunctions.Support.JNIEnvEnterFatalOnFailurePrologue.class, "enter", true), CallTargetNode.InvokeKind.Static, this.getFrameState(), this.bci(), new ValueNode[]{env});
    }

    public void invokeJNILeaveIsolate() {
        this.createInvokeWithExceptionAndUnwind(this.findMethod(CEntryPointSetup.LeaveEpilogue.class, "leave", true), CallTargetNode.InvokeKind.Static, this.getFrameState(), this.bci(), new ValueNode[0]);
    }

    public ConstantNode createWord(long value) {
        return ConstantNode.forIntegerKind((JavaKind)this.getWordTypes().getWordKind(), (long)value, (StructuredGraph)this.graph);
    }
}

