/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.heap;

import com.oracle.graal.pointsto.infrastructure.SubstitutionProcessor;
import com.oracle.svm.core.heap.Pod;
import com.oracle.svm.hosted.annotation.CustomSubstitutionMethod;
import com.oracle.svm.hosted.heap.PodFactorySubstitutionMethod;
import java.lang.reflect.AnnotatedElement;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.nativeimage.AnnotationAccess;

final class PodFactorySubstitutionProcessor
extends SubstitutionProcessor {
    private final ConcurrentMap<ResolvedJavaMethod, PodFactorySubstitutionMethod> substitutions = new ConcurrentHashMap<ResolvedJavaMethod, PodFactorySubstitutionMethod>();

    PodFactorySubstitutionProcessor() {
    }

    public ResolvedJavaMethod lookup(ResolvedJavaMethod method) {
        if (method.isSynthetic() && AnnotationAccess.isAnnotationPresent((AnnotatedElement)method.getDeclaringClass(), Pod.RuntimeSupport.PodFactory.class) && !method.isConstructor()) {
            assert (!(method instanceof CustomSubstitutionMethod));
            return this.substitutions.computeIfAbsent(method, PodFactorySubstitutionMethod::new);
        }
        return method;
    }
}

