/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.fieldfolding;

import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.svm.hosted.ameta.FieldValueInterceptionSupport;
import com.oracle.svm.hosted.fieldfolding.IsStaticFinalFieldInitializedNode;
import com.oracle.svm.hosted.fieldfolding.MarkStaticFinalFieldInitializedNode;
import com.oracle.svm.hosted.fieldfolding.StaticFinalFieldFoldingFeature;
import java.util.Arrays;
import jdk.graal.compiler.graph.Node;
import jdk.graal.compiler.nodes.AbstractMergeNode;
import jdk.graal.compiler.nodes.ConstantNode;
import jdk.graal.compiler.nodes.EndNode;
import jdk.graal.compiler.nodes.FixedNode;
import jdk.graal.compiler.nodes.IfNode;
import jdk.graal.compiler.nodes.LogicNode;
import jdk.graal.compiler.nodes.MergeNode;
import jdk.graal.compiler.nodes.NodeView;
import jdk.graal.compiler.nodes.StateSplit;
import jdk.graal.compiler.nodes.ValueNode;
import jdk.graal.compiler.nodes.ValuePhiNode;
import jdk.graal.compiler.nodes.calc.IntegerEqualsNode;
import jdk.graal.compiler.nodes.extended.BranchProbabilityNode;
import jdk.graal.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import jdk.graal.compiler.nodes.graphbuilderconf.NodePlugin;
import jdk.graal.compiler.nodes.type.StampTool;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;

final class StaticFinalFieldFoldingNodePlugin
implements NodePlugin {
    private final StaticFinalFieldFoldingFeature feature;
    private final FieldValueInterceptionSupport fieldValueInterceptionSupport = FieldValueInterceptionSupport.singleton();

    StaticFinalFieldFoldingNodePlugin(StaticFinalFieldFoldingFeature feature) {
        this.feature = feature;
    }

    public boolean handleLoadStaticField(GraphBuilderContext b, ResolvedJavaField field) {
        assert (field.isStatic());
        if (!field.isFinal()) {
            return false;
        }
        if (b.getMethod().isClassInitializer()) {
            return false;
        }
        AnalysisField aField = StaticFinalFieldFoldingFeature.toAnalysisField(field);
        AnalysisMethod classInitializer = aField.getDeclaringClass().getClassInitializer();
        if (classInitializer == null) {
            return false;
        }
        if (!this.fieldValueInterceptionSupport.isValueAvailable(aField)) {
            return false;
        }
        classInitializer.ensureGraphParsed(this.feature.bb);
        JavaConstant initializedValue = this.feature.foldedFieldValues.get(aField);
        if (initializedValue == null) {
            return false;
        }
        ValueNode fieldCheckStatusNode = (ValueNode)b.add((Node)new IsStaticFinalFieldInitializedNode(field));
        LogicNode isUninitializedNode = (LogicNode)b.add((Node)IntegerEqualsNode.create((ValueNode)fieldCheckStatusNode, (ValueNode)ConstantNode.forBoolean((boolean)false), (NodeView)NodeView.DEFAULT));
        JavaConstant uninitializedValue = aField.getConstantValue();
        if (uninitializedValue == null) {
            uninitializedValue = JavaConstant.defaultForKind((JavaKind)aField.getStorageKind());
        }
        ConstantNode uninitializedValueNode = ConstantNode.forConstant((JavaConstant)uninitializedValue, (MetaAccessProvider)b.getMetaAccess());
        ConstantNode initializedValueNode = ConstantNode.forConstant((JavaConstant)initializedValue, (MetaAccessProvider)b.getMetaAccess());
        EndNode uninitializedEndNode = (EndNode)b.getGraph().add((Node)new EndNode());
        EndNode initializedEndNode = (EndNode)b.getGraph().add((Node)new EndNode());
        b.add((Node)new IfNode(isUninitializedNode, (FixedNode)uninitializedEndNode, (FixedNode)initializedEndNode, BranchProbabilityNode.EXTREMELY_SLOW_PATH_PROFILE));
        MergeNode merge = (MergeNode)b.append((Node)new MergeNode());
        merge.addForwardEnd(uninitializedEndNode);
        merge.addForwardEnd(initializedEndNode);
        ConstantNode[] phiValueNodes = new ConstantNode[]{uninitializedValueNode, initializedValueNode};
        ValuePhiNode phi = new ValuePhiNode(StampTool.meet(Arrays.asList(phiValueNodes)), (AbstractMergeNode)merge, (ValueNode[])phiValueNodes);
        b.addPush(field.getJavaKind(), (ValueNode)phi);
        b.setStateAfter((StateSplit)merge);
        return true;
    }

    public boolean handleStoreStaticField(GraphBuilderContext b, ResolvedJavaField field, ValueNode value) {
        assert (field.isStatic());
        if (!field.isFinal()) {
            return false;
        }
        b.add((Node)new MarkStaticFinalFieldInitializedNode(field));
        return false;
    }
}

