/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.code.aarch64;

import com.oracle.objectfile.ObjectFile;
import com.oracle.svm.core.Uninterruptible;
import com.oracle.svm.core.graal.code.CGlobalDataReference;
import com.oracle.svm.core.meta.MethodPointer;
import com.oracle.svm.core.meta.SubstrateMethodPointerConstant;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.code.HostedPatcher;
import com.oracle.svm.hosted.image.RelocatableBuffer;
import com.oracle.svm.hosted.meta.HostedMethod;
import jdk.graal.compiler.asm.aarch64.AArch64MacroAssembler;
import jdk.graal.compiler.code.CompilationResult;
import jdk.vm.ci.code.site.ConstantReference;
import jdk.vm.ci.code.site.DataSectionReference;
import jdk.vm.ci.code.site.Reference;
import jdk.vm.ci.meta.VMConstant;

class AdrpAddMacroInstructionHostedPatcher
extends CompilationResult.CodeAnnotation
implements HostedPatcher {
    private final AArch64MacroAssembler.AdrpAddMacroInstruction macroInstruction;

    AdrpAddMacroInstructionHostedPatcher(AArch64MacroAssembler.AdrpAddMacroInstruction macroInstruction) {
        super(macroInstruction.instructionPosition);
        this.macroInstruction = macroInstruction;
    }

    @Override
    public void relocate(Reference ref, RelocatableBuffer relocs, int compStart) {
        Object relocVal = ref;
        if (ref instanceof ConstantReference) {
            ConstantReference constantRef = (ConstantReference)ref;
            VMConstant constant = constantRef.getConstant();
            if (constant instanceof SubstrateMethodPointerConstant) {
                SubstrateMethodPointerConstant methodPointerConstant = (SubstrateMethodPointerConstant)constant;
                MethodPointer pointer = methodPointerConstant.pointer();
                HostedMethod hMethod = (HostedMethod)pointer.getMethod();
                VMError.guarantee(!hMethod.isCompiledInPriorLayer(), "Method %s was compiled in a prior layer", hMethod);
                VMError.guarantee(hMethod.isCompiled(), "Method %s is not compiled although there is a method pointer constant created for it.", hMethod);
                relocVal = pointer;
            }
        } else {
            VMError.guarantee(ref instanceof DataSectionReference || ref instanceof CGlobalDataReference, "Unexpected reference: %s", ref);
        }
        int siteOffset = compStart + this.macroInstruction.instructionPosition;
        relocs.addRelocationWithoutAddend(siteOffset, ObjectFile.RelocationKind.AARCH64_R_AARCH64_ADR_PREL_PG_HI21, relocVal);
        relocs.addRelocationWithoutAddend(siteOffset += 4, ObjectFile.RelocationKind.AARCH64_R_AARCH64_ADD_ABS_LO12_NC, relocVal);
    }

    @Override
    @Uninterruptible(reason=".")
    public void patch(int compStart, int relative, byte[] code) {
        long startAddress = (long)compStart + (long)this.macroInstruction.instructionPosition;
        this.macroInstruction.patch(startAddress, relative, code);
    }

    public boolean equals(Object obj) {
        return this == obj;
    }
}

