/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.NativeImageSystemIOWrappers;
import com.oracle.svm.util.ReflectionUtil;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.SecureClassLoader;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Set;
import java.util.WeakHashMap;

public final class NativeImageSystemClassLoader
extends SecureClassLoader {
    public final ClassLoader defaultSystemClassLoader;
    final NativeImageSystemIOWrappers systemIOWrappers;
    private volatile ClassLoader nativeImageClassLoader = null;
    private Set<ClassLoader> disallowedClassLoaders = Collections.newSetFromMap(new WeakHashMap());
    private static final Method loadClass = ReflectionUtil.lookupMethod(ClassLoader.class, (String)"loadClass", (Class[])new Class[]{String.class, Boolean.TYPE});
    private static final Method findResource = ReflectionUtil.lookupMethod(ClassLoader.class, (String)"findResource", (Class[])new Class[]{String.class});
    private static final Method findResources = ReflectionUtil.lookupMethod(ClassLoader.class, (String)"findResources", (Class[])new Class[]{String.class});
    private static final Method defineClass = ReflectionUtil.lookupMethod(ClassLoader.class, (String)"defineClass", (Class[])new Class[]{String.class, byte[].class, Integer.TYPE, Integer.TYPE});

    public NativeImageSystemClassLoader(ClassLoader defaultSystemClassLoader) {
        super(defaultSystemClassLoader);
        this.defaultSystemClassLoader = defaultSystemClassLoader;
        this.systemIOWrappers = new NativeImageSystemIOWrappers();
        this.systemIOWrappers.replaceSystemOutErr();
    }

    public static NativeImageSystemClassLoader singleton() {
        ClassLoader loader = ClassLoader.getSystemClassLoader();
        if (loader instanceof NativeImageSystemClassLoader) {
            return (NativeImageSystemClassLoader)loader;
        }
        throw UserError.abort("NativeImageSystemClassLoader is not the default system class loader. This might create problems when using reflection during class initialization at build-time.To fix this error add -Djava.system.class.loader=%s", NativeImageSystemClassLoader.class.getCanonicalName());
    }

    public void setNativeImageClassLoader(ClassLoader nativeImageClassLoader) {
        if (nativeImageClassLoader == null && this.nativeImageClassLoader != null) {
            this.disallowedClassLoaders.add(this.nativeImageClassLoader);
        }
        this.nativeImageClassLoader = nativeImageClassLoader;
    }

    private boolean matchesClassLoaderOrParent(ClassLoader start, ClassLoader candidate) {
        ClassLoader current = start;
        do {
            if (current != candidate) continue;
            return true;
        } while ((current = current.getParent()) != this.defaultSystemClassLoader);
        return false;
    }

    public boolean isNativeImageClassLoader(ClassLoader c) {
        ClassLoader loader = this.nativeImageClassLoader;
        if (loader == null) {
            return false;
        }
        return this.matchesClassLoaderOrParent(this.nativeImageClassLoader, c);
    }

    public boolean isDisallowedClassLoader(ClassLoader c) {
        for (ClassLoader disallowedClassLoader : this.disallowedClassLoaders) {
            if (!this.matchesClassLoaderOrParent(disallowedClassLoader, c)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        return (Class)ReflectionUtil.invokeMethod((Method)loadClass, (Object)this.getActiveClassLoader(), (Object[])new Object[]{name, resolve});
    }

    @Override
    protected URL findResource(String name) {
        return (URL)ReflectionUtil.invokeMethod((Method)findResource, (Object)this.getActiveClassLoader(), (Object[])new Object[]{name});
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        return (Enumeration)ReflectionUtil.invokeMethod((Method)findResources, (Object)this.getActiveClassLoader(), (Object[])new Object[]{name});
    }

    public Class<?> forNameOrNull(String name, boolean initialize) {
        try {
            return Class.forName(name, initialize, this.getActiveClassLoader());
        }
        catch (ClassNotFoundException | LinkageError ignored) {
            return null;
        }
    }

    public Class<?> predefineClass(String name, byte[] array, int offset, int length) {
        VMError.guarantee(name != null, "The class name must be specified");
        if (this.forNameOrNull(name, false) != null) {
            throw VMError.shouldNotReachHere("The class loader hierarchy already provides a class with the same name as the class submitted for predefinition: " + name);
        }
        return (Class)ReflectionUtil.invokeMethod((Method)defineClass, (Object)this.getActiveClassLoader(), (Object[])new Object[]{name, array, offset, length});
    }

    public String toString() {
        String clString = super.toString();
        return clString + " {delegate=" + String.valueOf(this.nativeImageClassLoader) + ", defaultSystemClassLoader=" + String.valueOf(this.defaultSystemClassLoader) + "}";
    }

    private ClassLoader getActiveClassLoader() {
        ClassLoader activeClassLoader = this.nativeImageClassLoader;
        if (activeClassLoader != null) {
            return activeClassLoader;
        }
        return this.defaultSystemClassLoader;
    }

    private void appendToClassPathForInstrumentation(String classPathEntry) {
        Method method = ReflectionUtil.lookupMethod(this.getParent().getClass(), (String)"appendToClassPathForInstrumentation", (Class[])new Class[]{String.class});
        ReflectionUtil.invokeMethod((Method)method, (Object)this.getParent(), (Object[])new Object[]{classPathEntry});
    }
}

